/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xpathView.search;

import com.intellij.find.FindSettings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import java.util.Collections;
import org.intellij.plugins.xpathView.Config;
import org.intellij.plugins.xpathView.XPathAppComponent;
import org.intellij.plugins.xpathView.XPathBundle;
import org.intellij.plugins.xpathView.XPathEvalAction;
import org.intellij.plugins.xpathView.XPathProjectComponent;
import org.intellij.plugins.xpathView.search.FindByExpressionDialog;
import org.intellij.plugins.xpathView.search.SearchScope;
import org.intellij.plugins.xpathView.search.XPathUsageSearcher;
import org.intellij.plugins.xpathView.support.XPathSupport;
import org.intellij.plugins.xpathView.ui.InputExpressionDialog;
import org.jaxen.JaxenException;
import org.jaxen.XPathSyntaxException;
import org.jetbrains.annotations.NotNull;

public class FindByXPathAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            FindByXPathAction.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        e.getPresentation().setEnabled(project != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            FindByXPathAction.$$$reportNull$$$0(1);
        }
        Project project = e.getProject();
        Module module = (Module)e.getData(PlatformCoreDataKeys.MODULE);
        if (project != null) {
            this.executeSearch(project, module);
        }
    }

    private void executeSearch(final @NotNull Project project, final Module module) {
        XPathProjectComponent projectComponent;
        Config settings;
        FindByExpressionDialog dlg;
        if (project == null) {
            FindByXPathAction.$$$reportNull$$$0(2);
        }
        if (!(dlg = new FindByExpressionDialog(project, settings = XPathAppComponent.getInstance().getConfig(), (projectComponent = XPathProjectComponent.getInstance(project)).getFindHistory(), module)).show(null)) {
            return;
        }
        SearchScope scope = dlg.getScope();
        settings.MATCH_RECURSIVELY = dlg.isMatchRecursively();
        settings.SEARCH_SCOPE = dlg.getScope();
        InputExpressionDialog.Context context = dlg.getContext();
        projectComponent.addFindHistory(context.input);
        String expression = context.input.expression;
        if (!FindByXPathAction.validateExpression(project, expression)) {
            return;
        }
        UsageViewPresentation presentation = new UsageViewPresentation();
        presentation.setTargetsNodeText(settings.MATCH_RECURSIVELY ? XPathBundle.message("list.item.xpath.pattern", new Object[0]) : XPathBundle.message("list.item.xpath.expression", new Object[0]));
        presentation.setCodeUsages(false);
        presentation.setCodeUsagesString(XPathBundle.message("list.item.found.matches.in", scope.getName()));
        presentation.setNonCodeUsagesString(XPathBundle.message("list.item.result", new Object[0]));
        presentation.setUsagesString(XPathBundle.message("results.matching.0", expression));
        presentation.setTabText(StringUtil.shortenTextWithEllipsis((String)XPathBundle.message("tab.title.xpath", expression), (int)60, (int)0, (boolean)true));
        presentation.setScopeText(scope.getName());
        presentation.setOpenInNewTab(FindSettings.getInstance().isShowResultsInSeparateView());
        FindUsagesProcessPresentation processPresentation = new FindUsagesProcessPresentation(presentation);
        processPresentation.setShowPanelIfOnlyOneUsage(true);
        processPresentation.setShowNotFoundMessage(true);
        XPathEvalAction.MyUsageTarget usageTarget = new XPathEvalAction.MyUsageTarget(context.input.expression, null);
        UsageTarget[] usageTargets = new UsageTarget[]{usageTarget};
        Factory searcherFactory = () -> new XPathUsageSearcher(project, context.input, scope, settings.MATCH_RECURSIVELY);
        UsageViewManager.UsageViewStateListener stateListener = new UsageViewManager.UsageViewStateListener(){

            public void usageViewCreated(@NotNull UsageView usageView) {
                if (usageView == null) {
                    1.$$$reportNull$$$0(0);
                }
                usageView.addButtonToLowerPane((Runnable)new MyEditExpressionAction(project, module), XPathBundle.message("button.edit.expression.with.mnemonic", new Object[0]));
            }

            public void findingUsagesFinished(UsageView usageView) {
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageView", "org/intellij/plugins/xpathView/search/FindByXPathAction$1", "usageViewCreated"));
            }
        };
        UsageViewManager.getInstance((Project)project).searchAndShowUsages(usageTargets, searcherFactory, processPresentation, presentation, stateListener);
    }

    private static boolean validateExpression(Project project, String expression) {
        try {
            XPathSupport.getInstance().createXPath(null, expression, Collections.emptyList());
            return true;
        }
        catch (XPathSyntaxException e) {
            Messages.showErrorDialog((Project)project, (String)e.getMultilineMessage(), (String)XPathBundle.message("dialog.title.xpath.syntax.error", new Object[0]));
        }
        catch (JaxenException e) {
            Messages.showErrorDialog((Project)project, (String)e.getMessage(), (String)XPathBundle.message("dialog.title.xpath.error", new Object[0]));
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "org/intellij/plugins/xpathView/search/FindByXPathAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "executeSearch";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyEditExpressionAction
    extends XPathEvalAction.EditExpressionAction {
        private final Project myProject;
        private final Module myModule;

        MyEditExpressionAction(Project project, Module module) {
            this.myProject = project;
            this.myModule = module;
        }

        @Override
        protected void execute() {
            FindByXPathAction.this.executeSearch(this.myProject, this.myModule);
        }
    }
}

