/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.context.functions;

import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import org.intellij.lang.xpath.context.functions.Function;
import org.intellij.lang.xpath.context.functions.Parameter;
import org.intellij.lang.xpath.psi.XPathType;
import org.jetbrains.annotations.NotNull;

public class FunctionImpl
implements Function {
    private final String name;
    private final Parameter[] parameters;
    private final XPathType returnType;
    private final int minArity;

    public FunctionImpl(String name, @NotNull XPathType returnType, Parameter ... parameters) {
        if (returnType == null) {
            FunctionImpl.$$$reportNull$$$0(0);
        }
        this.name = name;
        this.parameters = parameters;
        this.returnType = returnType;
        this.minArity = FunctionImpl.calcArity(parameters);
    }

    private static int calcArity(Parameter[] parameters) {
        int arity = 0;
        boolean stop = false;
        for (Parameter parameter : parameters) {
            assert (!stop);
            if (parameter.kind == Parameter.Kind.REQUIRED) {
                ++arity;
                continue;
            }
            if (parameter.kind == Parameter.Kind.OPTIONAL) {
                stop = true;
                continue;
            }
            if (parameter.kind != Parameter.Kind.VARARG) continue;
            stop = true;
        }
        return arity;
    }

    @Override
    public String buildSignature() {
        return this.getName() + "(" + StringUtil.join(Arrays.asList(this.parameters), (String)", ") + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionImpl function = (FunctionImpl)o;
        return this.name.equals(function.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Parameter @NotNull [] getParameters() {
        if (this.parameters == null) {
            FunctionImpl.$$$reportNull$$$0(1);
        }
        return this.parameters;
    }

    @Override
    @NotNull
    public XPathType getReturnType() {
        XPathType xPathType = this.returnType;
        if (xPathType == null) {
            FunctionImpl.$$$reportNull$$$0(2);
        }
        return xPathType;
    }

    @Override
    public int getMinArity() {
        return this.minArity;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/xpath/context/functions/FunctionImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/xpath/context/functions/FunctionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

