/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.bouncycastle.gpg.keybox;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

class KeyBoxByteBuffer {
    private final ByteBuffer buffer;

    public KeyBoxByteBuffer(ByteBuffer byteBuffer) {
        this.buffer = byteBuffer;
    }

    static KeyBoxByteBuffer wrap(Object object) throws IOException {
        if (object == null) {
            return null;
        }
        if (object instanceof KeyBoxByteBuffer) {
            return (KeyBoxByteBuffer)object;
        }
        if (object instanceof ByteBuffer) {
            return new KeyBoxByteBuffer((ByteBuffer)object);
        }
        if (object instanceof byte[]) {
            return KeyBoxByteBuffer.wrap(ByteBuffer.wrap((byte[])object));
        }
        if (object instanceof ByteArrayOutputStream) {
            return KeyBoxByteBuffer.wrap(((ByteArrayOutputStream)object).toByteArray());
        }
        if (object instanceof InputStream) {
            int n;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[4096];
            while ((n = ((InputStream)object).read(byArray)) >= 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
            return KeyBoxByteBuffer.wrap(byteArrayOutputStream);
        }
        throw new IllegalStateException("Could not convert " + object.getClass().getCanonicalName() + " to KeyBoxByteBuffer");
    }

    public int size() {
        return this.buffer.limit() - 20;
    }

    public byte[] rangeOf(int n, int n2) {
        if (n2 - n < 0 || n < 0) {
            throw new IllegalArgumentException("invalid range " + n + ":" + n2);
        }
        if (n2 > this.buffer.limit()) {
            throw new IllegalArgumentException("range exceeds buffer remaining");
        }
        int n3 = this.buffer.position();
        this.buffer.position(n);
        byte[] byArray = new byte[n2 - n];
        this.buffer.get(byArray);
        this.buffer.position(n3);
        return byArray;
    }

    public boolean hasRemaining() {
        return this.buffer.hasRemaining();
    }

    public int remaining() {
        return this.buffer.remaining();
    }

    public int position() {
        return this.buffer.position();
    }

    public void position(int n) {
        this.buffer.position(n);
    }

    public int u16() {
        return this.u8() << 8 | this.u8();
    }

    public long u32() {
        return this.u8() << 24 | this.u8() << 16 | this.u8() << 8 | this.u8();
    }

    public int u8() {
        return this.buffer.get() & 0xFF;
    }

    public void consume(int n) {
        if (n > this.remaining()) {
            throw new IllegalArgumentException("size exceeds buffer remaining");
        }
        while (--n >= 0) {
            this.buffer.get();
        }
    }

    public byte[] bN(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("size less than 0");
        }
        if (n > this.remaining()) {
            throw new IllegalArgumentException("size exceeds buffer remaining");
        }
        byte[] byArray = new byte[n];
        this.buffer.get(byArray);
        return byArray;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }
}

