/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.amazonaws.client.builder;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.gradle.internal.impldep.com.amazonaws.ClientConfigurationFactory;
import org.gradle.internal.impldep.com.amazonaws.annotation.NotThreadSafe;
import org.gradle.internal.impldep.com.amazonaws.annotation.SdkProtectedApi;
import org.gradle.internal.impldep.com.amazonaws.annotation.SdkTestInternalApi;
import org.gradle.internal.impldep.com.amazonaws.client.AwsAsyncClientParams;
import org.gradle.internal.impldep.com.amazonaws.client.builder.AwsClientBuilder;
import org.gradle.internal.impldep.com.amazonaws.client.builder.ExecutorFactory;
import org.gradle.internal.impldep.com.amazonaws.regions.AwsRegionProvider;

@NotThreadSafe
@SdkProtectedApi
public abstract class AwsAsyncClientBuilder<Subclass extends AwsAsyncClientBuilder, TypeToBuild>
extends AwsClientBuilder<Subclass, TypeToBuild> {
    private ExecutorFactory executorFactory;

    protected AwsAsyncClientBuilder(ClientConfigurationFactory clientConfigFactory) {
        super(clientConfigFactory);
    }

    @SdkTestInternalApi
    protected AwsAsyncClientBuilder(ClientConfigurationFactory clientConfigFactory, AwsRegionProvider regionProvider) {
        super(clientConfigFactory, regionProvider);
    }

    public final ExecutorFactory getExecutorFactory() {
        return this.executorFactory;
    }

    public final void setExecutorFactory(ExecutorFactory executorFactory) {
        this.executorFactory = executorFactory;
    }

    public final Subclass withExecutorFactory(ExecutorFactory executorFactory) {
        this.setExecutorFactory(executorFactory);
        return (Subclass)((AwsAsyncClientBuilder)this.getSubclass());
    }

    @Override
    public final TypeToBuild build() {
        return this.configureMutableProperties(this.build(this.getAsyncClientParams()));
    }

    protected abstract TypeToBuild build(AwsAsyncClientParams var1);

    protected final AwsAsyncClientParams getAsyncClientParams() {
        return new AsyncBuilderParams(this.executorFactory);
    }

    protected class AsyncBuilderParams
    extends AwsClientBuilder.SyncBuilderParams {
        private final ExecutorService _executorService;

        protected AsyncBuilderParams(ExecutorFactory executorFactory) {
            super(AwsAsyncClientBuilder.this);
            this._executorService = executorFactory == null ? this.defaultExecutor() : executorFactory.newExecutor();
        }

        @Override
        public ExecutorService getExecutor() {
            return this._executorService;
        }

        private ExecutorService defaultExecutor() {
            return Executors.newFixedThreadPool(this.getClientConfiguration().getMaxConnections());
        }
    }
}

