/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.java.decompiler.struct.attr.StructGeneralAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructLocalVariableTableAttribute;
import org.jetbrains.java.decompiler.struct.attr.StructLocalVariableTypeTableAttribute;
import org.jetbrains.java.decompiler.struct.consts.ConstantPool;
import org.jetbrains.java.decompiler.util.DataInputFullStream;

public abstract class StructMember {
    private final int accessFlags;
    private final Map<String, StructGeneralAttribute> attributes;

    protected StructMember(int accessFlags, Map<String, StructGeneralAttribute> attributes) {
        this.accessFlags = accessFlags;
        this.attributes = attributes;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public <T extends StructGeneralAttribute> T getAttribute(StructGeneralAttribute.Key<T> attribute) {
        StructGeneralAttribute t = this.attributes.get(attribute.name);
        return (T)t;
    }

    public boolean hasAttribute(StructGeneralAttribute.Key<?> attribute) {
        return this.attributes.containsKey(attribute.name);
    }

    public boolean hasModifier(int modifier) {
        return (this.accessFlags & modifier) == modifier;
    }

    public boolean isSynthetic() {
        return this.hasModifier(4096) || this.hasAttribute(StructGeneralAttribute.ATTRIBUTE_SYNTHETIC);
    }

    public static Map<String, StructGeneralAttribute> readAttributes(DataInputFullStream in, ConstantPool pool) throws IOException {
        int length = in.readUnsignedShort();
        HashMap<String, StructGeneralAttribute> attributes = new HashMap<String, StructGeneralAttribute>(length);
        for (int i = 0; i < length; ++i) {
            StructGeneralAttribute table;
            int nameIndex = in.readUnsignedShort();
            String name = pool.getPrimitiveConstant(nameIndex).getString();
            StructGeneralAttribute attribute = StructGeneralAttribute.createAttribute(name);
            int attLength = in.readInt();
            if (attribute == null) {
                in.discard(attLength);
                continue;
            }
            attribute.initContent(in, pool);
            if (StructGeneralAttribute.ATTRIBUTE_LOCAL_VARIABLE_TABLE.name.equals(name) && attributes.containsKey(name)) {
                table = (StructLocalVariableTableAttribute)attributes.get(name);
                ((StructLocalVariableTableAttribute)table).add((StructLocalVariableTableAttribute)attribute);
                continue;
            }
            if (StructGeneralAttribute.ATTRIBUTE_LOCAL_VARIABLE_TYPE_TABLE.name.equals(name) && attributes.containsKey(name)) {
                table = (StructLocalVariableTypeTableAttribute)attributes.get(name);
                ((StructLocalVariableTypeTableAttribute)table).add((StructLocalVariableTypeTableAttribute)attribute);
                continue;
            }
            attributes.put(name, attribute);
        }
        return attributes;
    }
}

