/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import com.google.common.base.Preconditions;

final class IntVector {
    private int[] contents = ZERO_INTS;
    private int left;
    private int size;
    private static final int[] ZERO_INTS = new int[0];

    IntVector() {
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int get(int i2) {
        return this.contents[(i2 + this.left) % this.contents.length];
    }

    private void makeSpace() {
        int bufsize = this.contents.length;
        if (this.size == bufsize) {
            int[] newContents2 = new int[Math.max(16, bufsize * 2)];
            int i2 = 0;
            int k = this.left;
            while (i2 < this.size) {
                newContents2[i2] = this.contents[k % bufsize];
                ++i2;
                ++k;
            }
            this.left = 0;
            this.contents = newContents2;
        }
    }

    public void add(int value) {
        this.makeSpace();
        this.contents[(this.left + this.size) % this.contents.length] = value;
        ++this.size;
    }

    public int remove(int i2) {
        Preconditions.checkArgument((0 <= i2 && i2 < this.size ? 1 : 0) != 0);
        int bufsize = this.contents.length;
        int idx = (this.left + i2) % bufsize;
        int result = this.contents[idx];
        int nToShiftLeft = this.size - (i2 + 1);
        if (i2 == 0) {
            this.left = (this.left + 1) % bufsize;
        } else if (i2 + 1 != this.size) {
            if (idx + nToShiftLeft < bufsize) {
                System.arraycopy(this.contents, idx + 1, this.contents, idx, nToShiftLeft);
            } else {
                int itemShiftedAround = this.contents[0];
                int right = (this.left + this.size) % bufsize;
                Preconditions.checkState((right <= this.left ? 1 : 0) != 0);
                System.arraycopy(this.contents, 1, this.contents, 0, right);
                System.arraycopy(this.contents, idx + 1, this.contents, idx, bufsize - idx - 1);
                this.contents[bufsize - 1] = itemShiftedAround;
            }
        }
        --this.size;
        return result;
    }

    public int removeLast() {
        return this.remove(this.size - 1);
    }

    public int removeFirst() {
        return this.remove(0);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IntVector)) {
            return false;
        }
        IntVector that = (IntVector)o;
        if (this.size != that.size) {
            return false;
        }
        int thisBufSize = this.contents.length;
        int thatBufSize = that.contents.length;
        int i2 = this.left;
        int j = that.left;
        while (i2 < this.size) {
            if (this.contents[i2 % thisBufSize] != that.contents[j % thatBufSize]) {
                return false;
            }
            ++i2;
            ++j;
        }
        return true;
    }

    public int hashCode() {
        int hc = this.size;
        int bufsize = this.contents.length;
        for (int i2 = 0; i2 < this.size; ++i2) {
            hc = 31 * hc + this.contents[(i2 + this.left) % bufsize];
        }
        return hc;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int bufsize = this.contents.length;
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (i2 != 0) {
                sb.append(", ");
            }
            sb.append(this.contents[(i2 + this.left) % bufsize]);
        }
        return sb.append(']').toString();
    }

    public void clear() {
        this.size = 0;
        this.left = 0;
    }

    public int getLast() {
        return this.get(this.size - 1);
    }

    public int lastIndexOf(int value) {
        if (this.size != 0) {
            int bufsize = this.contents.length;
            int pos = (this.left + this.size) % bufsize;
            do {
                if (--pos < 0) {
                    pos = bufsize - 1;
                }
                if (this.contents[pos] != value) continue;
                return (pos - this.left + bufsize) % bufsize;
            } while (pos != this.left);
        }
        return -1;
    }
}

