/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.references;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.intellij.plugins.markdown.lang.psi.MarkdownElementVisitor;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownLinkDestinationImpl;
import org.intellij.plugins.markdown.lang.references.MarkdownReferenceProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/intellij/plugins/markdown/lang/references/MarkdownUnresolvedFileReferenceInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "checkReference", "", "element", "Lcom/intellij/psi/PsiElement;", "isValidRange", "reference", "Lcom/intellij/psi/PsiReference;", "shouldSkip", "intellij.markdown"})
public final class MarkdownUnresolvedFileReferenceInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new MarkdownElementVisitor(this, holder){
            final /* synthetic */ MarkdownUnresolvedFileReferenceInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            public void visitLinkDestination(@NotNull MarkdownLinkDestinationImpl linkDestination) {
                Intrinsics.checkNotNullParameter((Object)linkDestination, (String)"linkDestination");
                MarkdownUnresolvedFileReferenceInspection.access$checkReference(this.this$0, (PsiElement)linkDestination, this.$holder);
            }
            {
                this.this$0 = this$0;
                this.$holder = $captured_local_variable$1;
            }
        };
    }

    private final void checkReference(PsiElement element2, ProblemsHolder holder) {
        Object[] objectArray = element2.getReferences();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"element.references");
        Sequence $this$forEach$iv = SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])objectArray), (Function1)((Function1)new Function1<PsiReference, Boolean>(this){
            final /* synthetic */ MarkdownUnresolvedFileReferenceInspection this$0;

            public final boolean invoke(PsiReference it) {
                PsiReference psiReference = it;
                Intrinsics.checkNotNullExpressionValue((Object)psiReference, (String)"it");
                return !MarkdownUnresolvedFileReferenceInspection.access$shouldSkip(this.this$0, psiReference) && MarkdownUnresolvedFileReferenceInspection.access$isValidRange(this.this$0, it) && it.resolve() == null;
            }
            {
                this.this$0 = markdownUnresolvedFileReferenceInspection;
                super(1);
            }
        }));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiReference it = (PsiReference)element$iv;
            boolean bl = false;
            holder.registerProblem(it, ProblemsHolder.unresolvedReferenceMessage((PsiReference)it), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
        }
    }

    private final boolean isValidRange(PsiReference reference) {
        PsiElement psiElement = reference.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"reference.element");
        TextRange elementRange = psiElement.getTextRange();
        TextRange textRange = reference.getRangeInElement();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"reference.rangeInElement");
        int n = textRange.getEndOffset();
        TextRange textRange2 = elementRange;
        Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"elementRange");
        return n <= textRange2.getEndOffset() - elementRange.getStartOffset();
    }

    private final boolean shouldSkip(PsiReference reference) {
        return reference instanceof MarkdownReferenceProvider.GithubWikiLocalFileReferenceProvider.GithubWikiLocalFileReferenceWrapper;
    }

    public static final /* synthetic */ void access$checkReference(MarkdownUnresolvedFileReferenceInspection $this, PsiElement element2, ProblemsHolder holder) {
        $this.checkReference(element2, holder);
    }

    public static final /* synthetic */ boolean access$shouldSkip(MarkdownUnresolvedFileReferenceInspection $this, PsiReference reference) {
        return $this.shouldSkip(reference);
    }

    public static final /* synthetic */ boolean access$isValidRange(MarkdownUnresolvedFileReferenceInspection $this, PsiReference reference) {
        return $this.isValidRange(reference);
    }
}

