/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.injection;

import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Regex;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypeSets;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFenceImpl;
import org.intellij.plugins.markdown.util.ASTUtilsKt;
import org.intellij.plugins.markdown.util.MarkdownPsiUtil;
import org.intellij.plugins.markdown.util.PsiUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J \u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0004H\u0007J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0005\u001a\u00020\u0004H\u0007J\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0004H\u0007J\u000e\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0015"}, d2={"Lorg/intellij/plugins/markdown/injection/MarkdownCodeFenceUtils;", "", "()V", "getCodeFence", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownCodeFenceImpl;", "element", "Lcom/intellij/psi/PsiElement;", "getContent", "", "host", "withWhitespaces", "", "getEmptyRange", "Lcom/intellij/openapi/util/TextRange;", "getIndent", "", "inCodeFence", "node", "Lcom/intellij/lang/ASTNode;", "isAbleToAcceptInjections", "isCodeFence", "intellij.markdown"})
public final class MarkdownCodeFenceUtils {
    @NotNull
    public static final MarkdownCodeFenceUtils INSTANCE;

    public final boolean isCodeFence(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        IElementType iElementType = MarkdownTokenTypeSets.CODE_FENCE;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"MarkdownTokenTypeSets.CODE_FENCE");
        return PsiUtilsKt.hasType(node, iElementType);
    }

    public final boolean inCodeFence(@NotNull ASTNode node) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Sequence<ASTNode> $this$any$iv = ASTUtilsKt.parents(node);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                ASTNode it = (ASTNode)element$iv;
                boolean bl2 = false;
                IElementType iElementType = MarkdownTokenTypeSets.CODE_FENCE;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"MarkdownTokenTypeSets.CODE_FENCE");
                if (!PsiUtilsKt.hasType(it, iElementType)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    @JvmStatic
    @Nullable
    public static final List<PsiElement> getContent(@NotNull MarkdownCodeFenceImpl host, boolean withWhitespaces) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        v0 = host.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"host.children");
        $this$filter$iv = v0;
        $i$f$filter = false;
        var5_4 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        var8_8 = $this$filterTo$iv$iv;
        var9_9 = ((void)var8_8).length;
        for (var10_10 = 0; var10_10 < var9_9; ++var10_10) {
            it = element$iv$iv = var8_8[var10_10];
            $i$a$-filter-MarkdownCodeFenceUtils$getContent$elements$1 = false;
            if (it instanceof OuterLanguageElement) ** GOTO lbl-1000
            v1 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
            v2 = v1.getNode();
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it.node");
            if (Intrinsics.areEqual((Object)v2.getElementType(), (Object)MarkdownTokenTypes.CODE_FENCE_CONTENT) || MarkdownPsiUtil.WhiteSpaces.isNewLine((PsiElement)it) || withWhitespaces && MarkdownTokenTypeSets.WHITE_SPACES.contains(PsiTreeUtilKt.getElementType((PsiElement)it))) {
                v3 = true;
            } else lbl-1000:
            // 2 sources

            {
                v3 = false;
            }
            if (!v3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        elements = (List)destination$iv$iv;
        var3_2 = elements;
        var4_3 = false;
        if (var3_2.isEmpty() == false && MarkdownPsiUtil.WhiteSpaces.isNewLine((PsiElement)CollectionsKt.first((List)elements))) {
            elements = CollectionsKt.drop((Iterable)elements, (int)1);
        }
        var3_2 = elements;
        var4_3 = false;
        if (var3_2.isEmpty() == false && MarkdownPsiUtil.WhiteSpaces.isNewLine((PsiElement)CollectionsKt.last((List)elements))) {
            elements = CollectionsKt.dropLast((List)elements, (int)1);
        }
        var3_2 = elements;
        var4_3 = false;
        var5_5 = false;
        it = var3_2;
        $i$a$-takeIf-MarkdownCodeFenceUtils$getContent$1 = false;
        var8_8 = it;
        var9_9 = 0;
        return var8_8.isEmpty() == false != false ? var3_2 : null;
    }

    @JvmStatic
    public static final boolean isAbleToAcceptInjections(@NotNull MarkdownCodeFenceImpl host) {
        block8: {
            block7: {
                boolean bl;
                block6: {
                    boolean bl2;
                    PsiElement it;
                    PsiElement element$iv;
                    int n;
                    int n2;
                    PsiElement[] psiElementArray;
                    boolean $i$f$all;
                    PsiElement[] $this$all$iv;
                    block5: {
                        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
                        PsiElement[] psiElementArray2 = host.getChildren();
                        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray2, (String)"host.children");
                        $this$all$iv = psiElementArray2;
                        $i$f$all = false;
                        psiElementArray = $this$all$iv;
                        n2 = psiElementArray.length;
                        for (n = 0; n < n2; ++n) {
                            it = element$iv = psiElementArray[n];
                            boolean bl3 = false;
                            PsiElement psiElement = it;
                            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"it");
                            IElementType iElementType = MarkdownTokenTypes.CODE_FENCE_END;
                            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"MarkdownTokenTypes.CODE_FENCE_END");
                            if (!PsiUtilsKt.hasType(psiElement, iElementType)) continue;
                            bl2 = false;
                            break block5;
                        }
                        bl2 = true;
                    }
                    if (bl2) break block7;
                    PsiElement[] psiElementArray3 = host.getChildren();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElementArray3, (String)"host.children");
                    $this$all$iv = psiElementArray3;
                    $i$f$all = false;
                    psiElementArray = $this$all$iv;
                    n2 = psiElementArray.length;
                    for (n = 0; n < n2; ++n) {
                        it = element$iv = psiElementArray[n];
                        boolean bl4 = false;
                        PsiElement psiElement = it;
                        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"it");
                        IElementType iElementType = MarkdownTokenTypes.CODE_FENCE_START;
                        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"MarkdownTokenTypes.CODE_FENCE_START");
                        if (!PsiUtilsKt.hasType(psiElement, iElementType)) continue;
                        bl = false;
                        break block6;
                    }
                    bl = true;
                }
                if (!bl) break block8;
            }
            return false;
        }
        PsiElement[] psiElementArray = host.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"host.children");
        PsiElement[] $this$count$iv = psiElementArray;
        boolean $i$f$count = false;
        int count$iv = 0;
        PsiElement[] psiElementArray4 = $this$count$iv;
        int n = psiElementArray4.length;
        for (int j = 0; j < n; ++j) {
            PsiElement element$iv;
            PsiElement it = element$iv = psiElementArray4[j];
            boolean bl = false;
            PsiElement psiElement = it;
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"it");
            if (!MarkdownPsiUtil.WhiteSpaces.isNewLine(psiElement)) continue;
            ++count$iv;
        }
        int newlines = count$iv;
        return newlines >= 2;
    }

    @JvmStatic
    @NotNull
    public static final TextRange getEmptyRange(@NotNull MarkdownCodeFenceImpl host) {
        PsiElement start;
        PsiElement psiElement;
        block4: {
            PsiElement psiElement2;
            PsiElement it;
            PsiElement psiElement3;
            int n;
            int n2;
            PsiElement[] psiElementArray;
            boolean bl;
            PsiElement[] psiElementArray2;
            boolean bl2;
            PsiElement[] psiElementArray3;
            block3: {
                Intrinsics.checkNotNullParameter((Object)host, (String)"host");
                PsiElement[] psiElementArray4 = host.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)psiElementArray4, (String)"host.children");
                psiElementArray3 = psiElementArray4;
                bl2 = false;
                psiElementArray2 = psiElementArray3;
                bl = false;
                psiElementArray = psiElementArray2;
                n2 = psiElementArray.length;
                for (n = 0; n < n2; ++n) {
                    it = psiElement3 = psiElementArray[n];
                    boolean bl3 = false;
                    PsiElement psiElement4 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement4, (String)"it");
                    IElementType iElementType = MarkdownTokenTypes.FENCE_LANG;
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"MarkdownTokenTypes.FENCE_LANG");
                    if (!PsiUtilsKt.hasType(psiElement4, iElementType)) continue;
                    psiElement2 = psiElement3;
                    break block3;
                }
                psiElement2 = psiElement = null;
            }
            if (psiElement2 == null) {
                PsiElement[] psiElementArray5 = host.getChildren();
                Intrinsics.checkNotNullExpressionValue((Object)psiElementArray5, (String)"host.children");
                psiElementArray3 = psiElementArray5;
                bl2 = false;
                psiElementArray2 = psiElementArray3;
                bl = false;
                psiElementArray = psiElementArray2;
                n2 = psiElementArray.length;
                for (n = 0; n < n2; ++n) {
                    it = psiElement3 = psiElementArray[n];
                    boolean bl4 = false;
                    PsiElement psiElement5 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement5, (String)"it");
                    IElementType iElementType = MarkdownTokenTypes.CODE_FENCE_START;
                    Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"MarkdownTokenTypes.CODE_FENCE_START");
                    if (!PsiUtilsKt.hasType(psiElement5, iElementType)) continue;
                    psiElement = psiElement3;
                    break block4;
                }
                psiElement = null;
            }
        }
        PsiElement psiElement6 = start = psiElement;
        Intrinsics.checkNotNull(psiElement6);
        TextRange textRange = TextRange.from((int)(psiElement6.getStartOffsetInParent() + start.getTextLength() + 1), (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"TextRange.from(start!!.s\u2026 start.textLength + 1, 0)");
        return textRange;
    }

    @Nullable
    public final MarkdownCodeFenceImpl getCodeFence(@NotNull PsiElement element2) {
        MarkdownCodeFenceImpl markdownCodeFenceImpl;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        PsiLanguageInjectionHost psiLanguageInjectionHost = InjectedLanguageManager.getInstance((Project)element2.getProject()).getInjectionHost(element2);
        if (!(psiLanguageInjectionHost instanceof MarkdownCodeFenceImpl)) {
            psiLanguageInjectionHost = null;
        }
        if ((markdownCodeFenceImpl = (MarkdownCodeFenceImpl)psiLanguageInjectionHost) == null) {
            markdownCodeFenceImpl = (MarkdownCodeFenceImpl)PsiTreeUtil.getParentOfType((PsiElement)element2, MarkdownCodeFenceImpl.class);
        }
        return markdownCodeFenceImpl;
    }

    @JvmStatic
    @Nullable
    public static final String getIndent(@NotNull MarkdownCodeFenceImpl element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Document document = PsiDocumentManager.getInstance((Project)element2.getProject()).getDocument(element2.getContainingFile());
        if (document == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"PsiDocumentManager.getIn\u2026iningFile) ?: return null");
        Document document2 = document;
        int offset = element2.getTextOffset();
        int lineStartOffset = document2.getLineStartOffset(document2.getLineNumber(offset));
        String string = document2.getText(TextRange.create((int)lineStartOffset, (int)offset));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"document.getText(TextRan\u2026lineStartOffset, offset))");
        CharSequence charSequence = string;
        String string2 = "[^> ]";
        boolean bl = false;
        string2 = new Regex(string2);
        String string3 = " ";
        boolean bl2 = false;
        return string2.replace(charSequence, string3);
    }

    private MarkdownCodeFenceUtils() {
    }

    static {
        MarkdownCodeFenceUtils markdownCodeFenceUtils;
        INSTANCE = markdownCodeFenceUtils = new MarkdownCodeFenceUtils();
    }
}

