/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.fileActions.importFrom.googleDocs;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.drive.Drive;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u001c\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bR\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0014\u0010\f\u001a\u00060\bR\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0016\u0010\u000f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u0011"}, d2={"Lorg/intellij/plugins/markdown/fileActions/importFrom/googleDocs/GoogleDocsFileLoader;", "Lcom/intellij/openapi/Disposable;", "()V", "dispose", "", "exportFileFromDrive", "Lcom/intellij/openapi/vfs/VirtualFile;", "driveFiles", "Lcom/google/api/services/drive/Drive$Files;", "Lcom/google/api/services/drive/Drive;", "docsId", "", "getAllFilesFromDrive", "credential", "Lcom/google/api/client/auth/oauth2/Credential;", "loadFile", "Companion", "intellij.markdown"})
public final class GoogleDocsFileLoader
implements Disposable {
    private static final String mimeType = "application/vnd.openxmlformats-officedocument.wordprocessingml.document";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final VirtualFile loadFile(@NotNull Credential credential, @NotNull String docsId) {
        Intrinsics.checkNotNullParameter((Object)credential, (String)"credential");
        Intrinsics.checkNotNullParameter((Object)docsId, (String)"docsId");
        Drive.Files driveFiles = this.getAllFilesFromDrive(credential);
        return this.exportFileFromDrive(driveFiles, docsId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final VirtualFile exportFileFromDrive(Drive.Files driveFiles, String docsId) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        boolean bl = false;
        boolean bl2 = false;
        Drive.Files $this$with = driveFiles;
        boolean bl3 = false;
        $this$with.export(docsId, mimeType).executeAndDownloadTo(outputStream);
        Object t = $this$with.get(docsId).setFields("id, name").execute();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(docsId).setFields(\"id, name\").execute()");
        String fileName = ((com.google.api.services.drive.model.File)t).getName();
        File tempFile = File.createTempFile(fileName, ".docx");
        Closeable closeable = new FileOutputStream(tempFile);
        boolean bl4 = false;
        boolean bl5 = false;
        Throwable throwable = null;
        try {
            FileOutputStream it = (FileOutputStream)closeable;
            boolean bl6 = false;
            outputStream.writeTo(it);
            it = Unit.INSTANCE;
        }
        catch (Throwable it) {
            throwable = it;
            throw it;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)tempFile, (boolean)true);
        Intrinsics.checkNotNull((Object)virtualFile);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"VfsUtil.findFileByIoFile(tempFile, true)!!");
        closeable = virtualFile;
        bl4 = false;
        boolean bl7 = false;
        Closeable $this$apply = closeable;
        boolean bl8 = false;
        $this$apply.rename($this$apply, fileName + ".docx");
        return closeable;
    }

    private final Drive.Files getAllFilesFromDrive(Credential credential) {
        NetHttpTransport httpTransport = GoogleNetHttpTransport.newTrustedTransport();
        Drive.Files files = new Drive.Builder(httpTransport, GoogleDocsFileLoader.Companion.getJsonFactory(), credential).build().files();
        Intrinsics.checkNotNullExpressionValue((Object)files, (String)"Drive\n      .Builder(htt\u2026  .build()\n      .files()");
        return files;
    }

    public void dispose() {
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/intellij/plugins/markdown/fileActions/importFrom/googleDocs/GoogleDocsFileLoader$Companion;", "", "()V", "jsonFactory", "Lcom/google/api/client/json/JsonFactory;", "getJsonFactory", "()Lcom/google/api/client/json/JsonFactory;", "mimeType", "", "intellij.markdown"})
    public static final class Companion {
        private final JsonFactory getJsonFactory() {
            JacksonFactory jacksonFactory = JacksonFactory.getDefaultInstance();
            Intrinsics.checkNotNullExpressionValue((Object)jacksonFactory, (String)"JacksonFactory.getDefaultInstance()");
            return jacksonFactory;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

