/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.noarg.diagnostic;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.extensions.AnnotationBasedExtension;
import org.jetbrains.kotlin.noarg.diagnostic.ErrorsNoArg;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\f\u0010\u0013\u001a\u00020\u0004*\u00020\u0014H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\u00020\u0007*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/noarg/diagnostic/AbstractNoArgDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "Lorg/jetbrains/kotlin/extensions/AnnotationBasedExtension;", "useIr", "", "(Z)V", "reportTarget", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/psi/KtClass;", "getReportTarget", "(Lorg/jetbrains/kotlin/psi/KtClass;)Lcom/intellij/psi/PsiElement;", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "isNoArgConstructor", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "kotlin-noarg-compiler-plugin"})
public abstract class AbstractNoArgDeclarationChecker
implements DeclarationChecker,
AnnotationBasedExtension {
    private final boolean useIr;

    public AbstractNoArgDeclarationChecker(boolean useIr) {
        this.useIr = useIr;
    }

    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context) {
        boolean bl;
        ClassDescriptor superClass;
        block10: {
            DiagnosticFactory0<PsiElement> diagnostic;
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (!(descriptor instanceof ClassDescriptor) || !(declaration instanceof KtClass)) {
                return;
            }
            if (((ClassDescriptor)descriptor).getKind() != ClassKind.CLASS) {
                return;
            }
            if (!this.hasSpecialAnnotation(descriptor, (KtModifierListOwner)declaration)) {
                return;
            }
            if (((ClassDescriptor)descriptor).isInner()) {
                diagnostic = this.useIr ? ErrorsNoArg.NOARG_ON_INNER_CLASS_ERROR : ErrorsNoArg.NOARG_ON_INNER_CLASS;
                context.getTrace().report((Diagnostic)diagnostic.on(this.getReportTarget((KtClass)declaration)));
            } else if (DescriptorUtils.isLocal((DeclarationDescriptor)descriptor)) {
                diagnostic = this.useIr ? ErrorsNoArg.NOARG_ON_LOCAL_CLASS_ERROR : ErrorsNoArg.NOARG_ON_LOCAL_CLASS;
                context.getTrace().report((Diagnostic)diagnostic.on(this.getReportTarget((KtClass)declaration)));
            }
            superClass = DescriptorUtilsKt.getSuperClassOrAny((ClassDescriptor)((ClassDescriptor)descriptor));
            Collection collection = superClass.getConstructors();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"superClass.constructors");
            Iterable $this$none$iv = collection;
            boolean $i$f$none = false;
            if (((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    ClassConstructorDescriptor it = (ClassConstructorDescriptor)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (!this.isNoArgConstructor((ConstructorDescriptor)it)) continue;
                    bl = false;
                    break block10;
                }
                bl = true;
            }
        }
        if (bl && !this.hasSpecialAnnotation((DeclarationDescriptor)superClass, (KtModifierListOwner)declaration)) {
            context.getTrace().report((Diagnostic)ErrorsNoArg.NO_NOARG_CONSTRUCTOR_IN_SUPERCLASS.on(this.getReportTarget((KtClass)declaration)));
        }
    }

    private final PsiElement getReportTarget(KtClass $this$reportTarget) {
        PsiElement psiElement = $this$reportTarget.getNameIdentifier();
        PsiElement psiElement2 = psiElement == null ? $this$reportTarget.getClassOrInterfaceKeyword() : psiElement;
        return psiElement2 == null ? (PsiElement)$this$reportTarget : psiElement2;
    }

    private final boolean isNoArgConstructor(ConstructorDescriptor $this$isNoArgConstructor) {
        boolean bl;
        block3: {
            List list = $this$isNoArgConstructor.getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"valueParameters");
            Iterable $this$all$iv = list;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ValueParameterDescriptor p0 = (ValueParameterDescriptor)element$iv;
                    boolean bl2 = false;
                    if (p0.declaresDefaultValue()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public boolean hasSpecialAnnotation(@NotNull DeclarationDescriptor $this$hasSpecialAnnotation, @Nullable KtModifierListOwner modifierListOwner) {
        return AnnotationBasedExtension.DefaultImpls.hasSpecialAnnotation((AnnotationBasedExtension)this, (DeclarationDescriptor)$this$hasSpecialAnnotation, (KtModifierListOwner)modifierListOwner);
    }
}

