/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.model;

import com.intellij.execution.JavaExecutionUtil;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.configuration.TestNGConfigurationEditor;
import com.theoryinpractice.testng.model.TestData;
import com.theoryinpractice.testng.model.TestType;
import java.util.LinkedHashSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class TestNGConfigurationModel {
    private static final Logger LOGGER = Logger.getInstance((String)"TestNG Runner");
    private TestNGConfigurationEditor editor;
    private TestType type;
    private final Object[] typeDocuments = new Object[6];
    private final javax.swing.text.Document propertiesFileDocument = new PlainDocument();
    private final javax.swing.text.Document outputDirectoryDocument = new PlainDocument();
    private final Project project;

    public TestNGConfigurationModel(Project project) {
        this.type = TestType.CLASS;
        for (int i = 3; i < this.typeDocuments.length; ++i) {
            this.typeDocuments[i] = new PlainDocument();
        }
        this.project = project;
    }

    public void setDocument(int type, Object doc) {
        this.typeDocuments[type] = doc;
    }

    public void setType(TestType type) {
        this.type = type;
        this.updateEditorType(type);
    }

    private void updateEditorType(TestType type) {
        this.editor.onTypeChanged(type);
    }

    public void setListener(TestNGConfigurationEditor editor) {
        this.editor = editor;
    }

    public Object getDocument(int index) {
        return this.typeDocuments[index];
    }

    public javax.swing.text.Document getPropertiesFileDocument() {
        return this.propertiesFileDocument;
    }

    public javax.swing.text.Document getOutputDirectoryDocument() {
        return this.outputDirectoryDocument;
    }

    public Project getProject() {
        return this.project;
    }

    public void apply(Module module, TestNGConfiguration config) {
        boolean isGenerated = config.isGeneratedName();
        this.apply(config.getPersistantData(), module);
        if (isGenerated && !JavaExecutionUtil.isNewName((String)config.getName())) {
            config.setGeneratedName();
        }
    }

    private void apply(TestData data, Module module) {
        data.TEST_OBJECT = this.type.getType();
        if (TestType.GROUP == this.type) {
            data.GROUP_NAME = this.getText(TestType.GROUP);
            data.PACKAGE_NAME = "";
            data.MAIN_CLASS_NAME = "";
            data.METHOD_NAME = "";
            data.SUITE_NAME = "";
        } else if (TestType.PACKAGE == this.type) {
            data.PACKAGE_NAME = this.getText(TestType.PACKAGE);
            data.GROUP_NAME = "";
            data.MAIN_CLASS_NAME = "";
            data.METHOD_NAME = "";
            data.SUITE_NAME = "";
        } else if (TestType.METHOD == this.type || TestType.CLASS == this.type || TestType.SOURCE == this.type) {
            String className = this.getText(TestType.CLASS);
            data.GROUP_NAME = "";
            data.SUITE_NAME = "";
            if (TestType.METHOD == this.type || TestType.SOURCE == this.type) {
                data.METHOD_NAME = this.getText(TestType.METHOD);
            }
            data.MAIN_CLASS_NAME = className;
            data.PACKAGE_NAME = StringUtil.getPackageName((String)className);
        } else if (TestType.SUITE == this.type) {
            data.SUITE_NAME = this.getText(TestType.SUITE);
            data.PACKAGE_NAME = "";
            data.GROUP_NAME = "";
            data.MAIN_CLASS_NAME = "";
            data.METHOD_NAME = "";
        } else if (TestType.PATTERN == this.type) {
            String[] patterns;
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            for (String pattern : patterns = this.getText(TestType.PATTERN).split("\\|\\|")) {
                if (pattern.length() <= 0) continue;
                set.add(pattern);
            }
            data.setPatterns(set);
        }
        try {
            data.PROPERTIES_FILE = this.propertiesFileDocument.getText(0, this.propertiesFileDocument.getLength());
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
        try {
            data.OUTPUT_DIRECTORY = this.outputDirectoryDocument.getText(0, this.outputDirectoryDocument.getLength());
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    private String getText(TestType type) {
        return this.getText(type, this.typeDocuments);
    }

    private String getText(TestType testType, Object[] documents) {
        Object document = documents[testType.getValue()];
        if (document instanceof PlainDocument) {
            try {
                return ((PlainDocument)document).getText(0, ((PlainDocument)document).getLength());
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        }
        return ((Document)document).getText();
    }

    public void reset(TestNGConfiguration config) {
        TestData data = config.getPersistantData();
        this.setType(data.TEST_OBJECT);
        this.setTypeValue(TestType.PACKAGE, data.getPackageName());
        this.setTypeValue(TestType.CLASS, data.getMainClassName());
        this.setTypeValue(TestType.METHOD, data.getMethodName());
        this.setTypeValue(TestType.GROUP, data.getGroupName());
        this.setTypeValue(TestType.SUITE, data.getSuiteName());
        this.setTypeValue(TestType.PATTERN, StringUtil.join(data.getPatterns(), (String)"||"));
        this.setDocumentText(this.propertiesFileDocument, data.getPropertiesFile());
        this.setDocumentText(this.outputDirectoryDocument, data.getOutputDirectory());
    }

    private void setTypeValue(TestType type, String value) {
        this.setTypeValue(type, value, this.typeDocuments);
    }

    private void setTypeValue(TestType type, String value, Object[] documents) {
        Object document = documents[type.getValue()];
        this.setDocumentText(document, value);
    }

    private void setDocumentText(Object document, String value) {
        if (document instanceof PlainDocument) {
            try {
                ((PlainDocument)document).remove(0, ((PlainDocument)document).getLength());
                ((PlainDocument)document).insertString(0, value, null);
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
        } else {
            WriteCommandAction.runWriteCommandAction((Project)this.project, () -> ((Document)document).replaceString(0, ((Document)document).getTextLength(), (CharSequence)value));
        }
    }

    private void setType(String s) {
        try {
            this.setType(TestType.valueOf(s));
        }
        catch (IllegalArgumentException e) {
            LOGGER.debug("Invalid test type of " + s + " found.");
            this.setType(TestType.CLASS);
        }
    }
}

