/*
 * Decompiled with CFR 0.152.
 */
package jtermios.linux;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import jtermios.FDSet;
import jtermios.JTermios;
import jtermios.Pollfd;
import jtermios.Termios;
import jtermios.TimeVal;
import jtermios.YJPFunctionMapper;

public class JTermiosImpl
implements JTermios.JTermiosInterface {
    private static String DEVICE_DIR_PATH = "/dev/";
    private static final boolean IS64B = NativeLong.SIZE == 8;
    static Linux_C_lib_DirectMapping m_ClibDM = new Linux_C_lib_DirectMapping();
    static Linux_C_lib m_Clib = m_ClibDM;
    private static final int TIOCGSERIAL = 21534;
    private static final int TIOCSSERIAL = 21535;
    private static final int ASYNC_SPD_MASK = 4144;
    private static final int ASYNC_SPD_CUST = 48;
    private static final int[] m_BaudRates = new int[]{50, 1, 75, 2, 110, 3, 134, 4, 150, 5, 200, 6, 300, 7, 600, 8, 1200, 9, 1800, 10, 2400, 11, 4800, 12, 9600, 13, 19200, 14, 38400, 15, 57600, 4097, 115200, 4098, 230400, 4099, 460800, 4100, 500000, 4101, 576000, 4102, 921600, 4103, 1000000, 4104, 1152000, 4105, 1500000, 4106, 2000000, 4107, 2500000, 4108, 3000000, 4109, 3500000, 4110, 4000000, 4111};

    public JTermiosImpl() {
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "instantiating %s\n", this.getClass().getCanonicalName());
        JTermios.FIONREAD = 21531;
        JTermios.O_RDWR = 2;
        JTermios.O_NONBLOCK = 2048;
        JTermios.O_NOCTTY = 256;
        JTermios.O_NDELAY = 2048;
        JTermios.F_GETFL = 3;
        JTermios.F_SETFL = 4;
        JTermios.EAGAIN = 11;
        JTermios.EACCES = 13;
        JTermios.EEXIST = 17;
        JTermios.EINTR = 4;
        JTermios.EINVAL = 22;
        JTermios.EIO = 5;
        JTermios.EISDIR = 21;
        JTermios.ELOOP = 40;
        JTermios.EMFILE = 24;
        JTermios.ENAMETOOLONG = 36;
        JTermios.ENFILE = 23;
        JTermios.ENOENT = 2;
        JTermios.ENOSR = 63;
        JTermios.ENOSPC = 28;
        JTermios.ENOTDIR = 20;
        JTermios.ENXIO = 6;
        JTermios.EOVERFLOW = 75;
        JTermios.EROFS = 30;
        JTermios.ENOTSUP = 95;
        JTermios.TIOCM_RNG = 128;
        JTermios.TIOCM_CAR = 64;
        JTermios.IGNBRK = 1;
        JTermios.BRKINT = 2;
        JTermios.IGNPAR = 4;
        JTermios.PARMRK = 8;
        JTermios.INLCR = 64;
        JTermios.IGNCR = 128;
        JTermios.ICRNL = 256;
        JTermios.ECHONL = 64;
        JTermios.IEXTEN = 32768;
        JTermios.CLOCAL = 2048;
        JTermios.OPOST = 1;
        JTermios.VSTART = 8;
        JTermios.TCSANOW = 0;
        JTermios.VSTOP = 9;
        JTermios.VMIN = 6;
        JTermios.VTIME = 5;
        JTermios.VEOF = 4;
        JTermios.TIOCMGET = 21525;
        JTermios.TIOCM_CTS = 32;
        JTermios.TIOCM_DSR = 256;
        JTermios.TIOCM_RI = 128;
        JTermios.TIOCM_CD = 64;
        JTermios.TIOCM_DTR = 2;
        JTermios.TIOCM_RTS = 4;
        JTermios.ICANON = 2;
        JTermios.ECHO = 8;
        JTermios.ECHOE = 16;
        JTermios.ISIG = 1;
        JTermios.TIOCMSET = 21528;
        JTermios.IXON = 1024;
        JTermios.IXOFF = 4096;
        JTermios.IXANY = 2048;
        JTermios.CRTSCTS = Integer.MIN_VALUE;
        JTermios.TCSADRAIN = 1;
        JTermios.INPCK = 16;
        JTermios.ISTRIP = 32;
        JTermios.CSIZE = 48;
        JTermios.TCIFLUSH = 0;
        JTermios.TCOFLUSH = 1;
        JTermios.TCIOFLUSH = 2;
        JTermios.CS5 = 0;
        JTermios.CS6 = 16;
        JTermios.CS7 = 32;
        JTermios.CS8 = 48;
        JTermios.CSTOPB = 64;
        JTermios.CREAD = 128;
        JTermios.PARENB = 256;
        JTermios.PARODD = 512;
        JTermios.B0 = 0;
        JTermios.B50 = 1;
        JTermios.B75 = 2;
        JTermios.B110 = 3;
        JTermios.B134 = 4;
        JTermios.B150 = 5;
        JTermios.B200 = 6;
        JTermios.B300 = 7;
        JTermios.B600 = 8;
        JTermios.B1200 = 9;
        JTermios.B1800 = 10;
        JTermios.B2400 = 11;
        JTermios.B4800 = 12;
        JTermios.B9600 = 13;
        JTermios.B19200 = 14;
        JTermios.B38400 = 15;
        JTermios.B57600 = 4097;
        JTermios.B115200 = 4098;
        JTermios.B230400 = 4099;
        JTermios.POLLIN = 1;
        JTermios.POLLPRI = (short)2;
        JTermios.POLLOUT = (short)4;
        JTermios.POLLERR = (short)8;
        JTermios.POLLNVAL = (short)32;
        JTermios.POLLIN_IN = JTermiosImpl.pollMask(0, JTermios.POLLIN);
        JTermios.POLLOUT_IN = JTermiosImpl.pollMask(0, JTermios.POLLOUT);
        JTermios.POLLIN_OUT = JTermiosImpl.pollMask(1, JTermios.POLLIN);
        JTermios.POLLOUT_OUT = JTermiosImpl.pollMask(1, JTermios.POLLOUT);
        JTermios.POLLNVAL_OUT = JTermiosImpl.pollMask(1, JTermios.POLLNVAL);
    }

    public static int pollMask(int n, short s) {
        short[] sArray = new short[2];
        int[] nArray = new int[1];
        sArray[n] = s;
        if (IS64B) {
            m_ClibDM.memcpy(nArray, sArray, 4L);
        } else {
            m_ClibDM.memcpy(nArray, sArray, 4);
        }
        return nArray[0];
    }

    @Override
    public int errno() {
        return Native.getLastError();
    }

    @Override
    public void cfmakeraw(Termios termios2) {
        Linux_C_lib.termios termios3 = new Linux_C_lib.termios(termios2);
        m_Clib.cfmakeraw(termios3);
        termios3.update(termios2);
    }

    @Override
    public int fcntl(int n, int n2, int n3) {
        return m_Clib.fcntl(n, n2, n3);
    }

    @Override
    public int tcdrain(int n) {
        return m_Clib.tcdrain(n);
    }

    @Override
    public int cfgetispeed(Termios termios2) {
        return m_Clib.cfgetispeed(new Linux_C_lib.termios(termios2)).intValue();
    }

    @Override
    public int cfgetospeed(Termios termios2) {
        return m_Clib.cfgetospeed(new Linux_C_lib.termios(termios2)).intValue();
    }

    @Override
    public int cfsetispeed(Termios termios2, int n) {
        Linux_C_lib.termios termios3 = new Linux_C_lib.termios(termios2);
        int n2 = m_Clib.cfsetispeed(termios3, new NativeLong((long)n));
        termios3.update(termios2);
        return n2;
    }

    @Override
    public int cfsetospeed(Termios termios2, int n) {
        Linux_C_lib.termios termios3 = new Linux_C_lib.termios(termios2);
        int n2 = m_Clib.cfsetospeed(termios3, new NativeLong((long)n));
        termios3.update(termios2);
        return n2;
    }

    @Override
    public int open(String string, int n) {
        if (string != null && !string.startsWith("/")) {
            string = DEVICE_DIR_PATH + string;
        }
        return m_Clib.open(string, n);
    }

    @Override
    public int read(int n, byte[] byArray, int n2) {
        if (IS64B) {
            return (int)m_Clib.read(n, byArray, (long)n2);
        }
        return m_Clib.read(n, byArray, n2);
    }

    @Override
    public int write(int n, byte[] byArray, int n2) {
        if (IS64B) {
            return (int)m_Clib.write(n, byArray, (long)n2);
        }
        return m_Clib.write(n, byArray, n2);
    }

    @Override
    public int close(int n) {
        return m_Clib.close(n);
    }

    @Override
    public int tcflush(int n, int n2) {
        return m_Clib.tcflush(n, n2);
    }

    @Override
    public int tcgetattr(int n, Termios termios2) {
        Linux_C_lib.termios termios3 = new Linux_C_lib.termios();
        int n2 = m_Clib.tcgetattr(n, termios3);
        termios3.update(termios2);
        return n2;
    }

    @Override
    public void perror(String string) {
        m_Clib.perror(string);
    }

    @Override
    public int tcsendbreak(int n, int n2) {
        return m_Clib.tcsendbreak(n, n2 / 250);
    }

    @Override
    public int tcsetattr(int n, int n2, Termios termios2) {
        return m_Clib.tcsetattr(n, n2, new Linux_C_lib.termios(termios2));
    }

    @Override
    public void FD_CLR(int n, FDSet fDSet) {
        if (fDSet == null) {
            return;
        }
        FDSetImpl fDSetImpl = (FDSetImpl)fDSet;
        int n2 = n / 32;
        fDSetImpl.bits[n2] = fDSetImpl.bits[n2] & ~(1 << n % 32);
    }

    @Override
    public boolean FD_ISSET(int n, FDSet fDSet) {
        if (fDSet == null) {
            return false;
        }
        FDSetImpl fDSetImpl = (FDSetImpl)fDSet;
        return (fDSetImpl.bits[n / 32] & 1 << n % 32) != 0;
    }

    @Override
    public void FD_SET(int n, FDSet fDSet) {
        if (fDSet == null) {
            return;
        }
        FDSetImpl fDSetImpl = (FDSetImpl)fDSet;
        int n2 = n / 32;
        fDSetImpl.bits[n2] = fDSetImpl.bits[n2] | 1 << n % 32;
    }

    @Override
    public void FD_ZERO(FDSet fDSet) {
        if (fDSet == null) {
            return;
        }
        FDSetImpl fDSetImpl = (FDSetImpl)fDSet;
        Arrays.fill(fDSetImpl.bits, 0);
    }

    @Override
    public int select(int n, FDSet fDSet, FDSet fDSet2, FDSet fDSet3, TimeVal timeVal) {
        Linux_C_lib.timeval timeval2 = null;
        if (timeVal != null) {
            timeval2 = new Linux_C_lib.timeval(timeVal);
        }
        int[] nArray = fDSet != null ? ((FDSetImpl)fDSet).bits : null;
        int[] nArray2 = fDSet2 != null ? ((FDSetImpl)fDSet2).bits : null;
        int[] nArray3 = fDSet3 != null ? ((FDSetImpl)fDSet3).bits : null;
        return m_Clib.select(n, nArray, nArray2, nArray3, timeval2);
    }

    @Override
    public int poll(Pollfd[] pollfdArray, int n, int n2) {
        int n3;
        Linux_C_lib.pollfd[] pollfdArray2 = new Linux_C_lib.pollfd[pollfdArray.length];
        for (n3 = 0; n3 < n; ++n3) {
            pollfdArray2[n3] = new Linux_C_lib.pollfd(pollfdArray[n3]);
        }
        n3 = m_Clib.poll(pollfdArray2, n, n2);
        for (int i = 0; i < n; ++i) {
            pollfdArray[i].revents = pollfdArray2[i].revents;
        }
        return n3;
    }

    @Override
    public int poll(int[] nArray, int n, int n2) {
        return m_Clib.poll(nArray, n, n2);
    }

    @Override
    public FDSet newFDSet() {
        return new FDSetImpl();
    }

    @Override
    public int ioctl(int n, int n2, int[] nArray) {
        return m_Clib.ioctl(n, n2, nArray);
    }

    private int ioctl(int n, int n2, Linux_C_lib.serial_struct serial_struct2) {
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(5, "> ioctl(%d,%d,%s)\n", new Object[]{n, n2, serial_struct2});
        int n3 = m_Clib.ioctl(n, n2, serial_struct2);
        JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(3, "< tcsetattr(%d,%d,%s) => %d\n", new Object[]{n, n2, serial_struct2, n3});
        return n3;
    }

    @Override
    public String getPortNamePattern() {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string;
            object = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("/proc/tty/drivers"), "US-ASCII"));
            while ((string = ((BufferedReader)object).readLine()) != null) {
                String[] stringArray = string.split(" +");
                if (stringArray.length != 5 || !"serial".equals(stringArray[4]) || !((String)stringArray[1]).startsWith("/dev/")) continue;
                arrayList.add(((String)stringArray[1]).substring(5));
            }
            ((BufferedReader)object).close();
        }
        catch (IOException iOException) {
            JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "failed to read /proc/tty/drivers\n", new Object[0]);
            arrayList.add("ttyS");
            arrayList.add("ttyUSB");
            arrayList.add("ttyACM");
        }
        object = new StringBuilder();
        ((StringBuilder)object).append('^');
        boolean bl = true;
        for (String string : arrayList) {
            if (bl) {
                bl = false;
            } else {
                ((StringBuilder)object).append('|');
            }
            ((StringBuilder)object).append("(");
            ((StringBuilder)object).append(string);
            ((StringBuilder)object).append(".+)");
        }
        return ((StringBuilder)object).toString();
    }

    @Override
    public List<String> getPortList() {
        File file = new File(DEVICE_DIR_PATH);
        if (!file.isDirectory()) {
            JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "device directory %s does not exist\n", DEVICE_DIR_PATH);
            return null;
        }
        String[] stringArray = file.list();
        LinkedList<String> linkedList = new LinkedList<String>();
        Pattern pattern = JTermios.getPortNamePattern(this);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (!pattern.matcher(string).matches()) continue;
                linkedList.add(string);
            }
        }
        return linkedList;
    }

    @Override
    public void shutDown() {
    }

    @Override
    public int setspeed(int n, Termios termios2, int n2) {
        int n3 = n2;
        for (int i = 0; i < m_BaudRates.length; i += 2) {
            if (m_BaudRates[i] != n2) continue;
            Linux_C_lib.serial_struct serial_struct2 = new Linux_C_lib.serial_struct();
            int n4 = this.ioctl(n, 21534, serial_struct2);
            if (n4 == 0) {
                serial_struct2.flags &= 0xFFFFEFCF;
                n4 = this.ioctl(n, 21535, serial_struct2);
            }
            if ((n4 = JTermios.cfsetispeed(termios2, n3 = m_BaudRates[i + 1])) != 0) {
                return n4;
            }
            n4 = JTermios.cfsetospeed(termios2, n3);
            if (n4 != 0) {
                return n4;
            }
            n4 = JTermios.tcsetattr(n, JTermios.TCSANOW, termios2);
            if (n4 != 0) {
                return n4;
            }
            return 0;
        }
        Linux_C_lib.serial_struct serial_struct3 = new Linux_C_lib.serial_struct();
        int n5 = this.ioctl(n, 21534, serial_struct3);
        if (n5 != 0) {
            return n5;
        }
        serial_struct3.flags = serial_struct3.flags & 0xFFFFEFCF | 0x30;
        if (n2 == 0) {
            JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "unable to set custom baudrate %d \n", n2);
            return -1;
        }
        serial_struct3.custom_divisor = (serial_struct3.baud_base + n2 / 2) / n2;
        if (serial_struct3.custom_divisor == 0) {
            JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "unable to set custom baudrate %d (possible division by zero)\n", n2);
            return -1;
        }
        int n6 = serial_struct3.baud_base / serial_struct3.custom_divisor;
        if (n6 < n2 * 98 / 100 || n6 > n2 * 102 / 100) {
            JTermios.JTermiosLogging.log = JTermios.JTermiosLogging.log && JTermios.JTermiosLogging.log(1, "best available baudrate %d not close enough to requested %d \n", n6, n2);
            return -1;
        }
        n5 = this.ioctl(n, 21535, serial_struct3);
        if (n5 != 0) {
            return n5;
        }
        n5 = JTermios.cfsetispeed(termios2, JTermios.B38400);
        if (n5 != 0) {
            return n5;
        }
        n5 = JTermios.cfsetospeed(termios2, JTermios.B38400);
        if (n5 != 0) {
            return n5;
        }
        n5 = JTermios.tcsetattr(n, JTermios.TCSANOW, termios2);
        if (n5 != 0) {
            return n5;
        }
        return 0;
    }

    @Override
    public int pipe(int[] nArray) {
        return m_Clib.pipe(nArray);
    }

    private static class FDSetImpl
    extends FDSet {
        static final int FD_SET_SIZE = 1024;
        static final int NFBBITS = 32;
        int[] bits = new int[32];

        private FDSetImpl() {
        }

        public String toString() {
            return String.format("%08X%08X", this.bits[0], this.bits[1]);
        }
    }

    public static interface Linux_C_lib
    extends Library {
        public long memcpy(int[] var1, short[] var2, long var3);

        public int memcpy(int[] var1, short[] var2, int var3);

        public int pipe(int[] var1);

        public int tcdrain(int var1);

        public void cfmakeraw(termios var1);

        public int fcntl(int var1, int var2, int var3);

        public int ioctl(int var1, int var2, int[] var3);

        public int ioctl(int var1, int var2, serial_struct var3);

        public int open(String var1, int var2);

        public int close(int var1);

        public int tcgetattr(int var1, termios var2);

        public int tcsetattr(int var1, int var2, termios var3);

        public int cfsetispeed(termios var1, NativeLong var2);

        public int cfsetospeed(termios var1, NativeLong var2);

        public NativeLong cfgetispeed(termios var1);

        public NativeLong cfgetospeed(termios var1);

        public int write(int var1, byte[] var2, int var3);

        public int read(int var1, byte[] var2, int var3);

        public long write(int var1, byte[] var2, long var3);

        public long read(int var1, byte[] var2, long var3);

        public int select(int var1, int[] var2, int[] var3, int[] var4, timeval var5);

        public int poll(pollfd[] var1, int var2, int var3);

        public int poll(int[] var1, int var2, int var3);

        public int tcflush(int var1, int var2);

        public void perror(String var1);

        public int tcsendbreak(int var1, int var2);

        public static class termios
        extends Structure {
            public int c_iflag;
            public int c_oflag;
            public int c_cflag;
            public int c_lflag;
            public byte c_line;
            public byte[] c_cc = new byte[32];
            public int c_ispeed;
            public int c_ospeed;

            protected List getFieldOrder() {
                return Arrays.asList("c_iflag", "c_oflag", "c_cflag", "c_lflag", "c_line", "c_cc", "c_ispeed", "c_ospeed");
            }

            public termios() {
            }

            public termios(Termios termios2) {
                this.c_iflag = termios2.c_iflag;
                this.c_oflag = termios2.c_oflag;
                this.c_cflag = termios2.c_cflag;
                this.c_lflag = termios2.c_lflag;
                System.arraycopy(termios2.c_cc, 0, this.c_cc, 0, termios2.c_cc.length);
                this.c_ispeed = termios2.c_ispeed;
                this.c_ospeed = termios2.c_ospeed;
            }

            public void update(Termios termios2) {
                termios2.c_iflag = this.c_iflag;
                termios2.c_oflag = this.c_oflag;
                termios2.c_cflag = this.c_cflag;
                termios2.c_lflag = this.c_lflag;
                System.arraycopy(this.c_cc, 0, termios2.c_cc, 0, termios2.c_cc.length);
                termios2.c_ispeed = this.c_ispeed;
                termios2.c_ospeed = this.c_ospeed;
            }
        }

        public static class serial_struct
        extends Structure {
            public int type;
            public int line;
            public int port;
            public int irq;
            public int flags;
            public int xmit_fifo_size;
            public int custom_divisor;
            public int baud_base;
            public short close_delay;
            public short io_type;
            public int hub6;
            public short closing_wait;
            public short closing_wait2;
            public Pointer iomem_base;
            public short iomem_reg_shift;
            public int port_high;
            public NativeLong iomap_base;

            protected List getFieldOrder() {
                return Arrays.asList("type", "line", "port", "irq", "flags", "xmit_fifo_size", "custom_divisor", "baud_base", "close_delay", "io_type", "hub6", "closing_wait", "closing_wait2", "iomem_base", "iomem_reg_shift", "port_high", "iomap_base");
            }
        }

        public static class pollfd
        extends Structure {
            public int fd;
            public short events;
            public short revents;

            protected List getFieldOrder() {
                return Arrays.asList("fd", "events", "revents");
            }

            public pollfd(Pollfd pollfd2) {
                this.fd = pollfd2.fd;
                this.events = pollfd2.events;
                this.revents = pollfd2.revents;
            }
        }

        public static class timeval
        extends Structure {
            public NativeLong tv_sec;
            public NativeLong tv_usec;

            protected List getFieldOrder() {
                return Arrays.asList("tv_sec", "tv_usec");
            }

            public timeval(TimeVal timeVal) {
                this.tv_sec = new NativeLong(timeVal.tv_sec);
                this.tv_usec = new NativeLong(timeVal.tv_usec);
            }
        }
    }

    public static class Linux_C_lib_DirectMapping
    implements Linux_C_lib {
        @Override
        public native long memcpy(int[] var1, short[] var2, long var3);

        @Override
        public native int memcpy(int[] var1, short[] var2, int var3);

        @Override
        public native int pipe(int[] var1);

        @Override
        public native int tcdrain(int var1);

        @Override
        public native void cfmakeraw(Linux_C_lib.termios var1);

        @Override
        public native int fcntl(int var1, int var2, int var3);

        @Override
        public native int ioctl(int var1, int var2, int[] var3);

        @Override
        public native int ioctl(int var1, int var2, Linux_C_lib.serial_struct var3);

        @Override
        public native int open(String var1, int var2);

        @Override
        public native int close(int var1);

        @Override
        public native int tcgetattr(int var1, Linux_C_lib.termios var2);

        @Override
        public native int tcsetattr(int var1, int var2, Linux_C_lib.termios var3);

        @Override
        public native int cfsetispeed(Linux_C_lib.termios var1, NativeLong var2);

        @Override
        public native int cfsetospeed(Linux_C_lib.termios var1, NativeLong var2);

        @Override
        public native NativeLong cfgetispeed(Linux_C_lib.termios var1);

        @Override
        public native NativeLong cfgetospeed(Linux_C_lib.termios var1);

        @Override
        public native int write(int var1, byte[] var2, int var3);

        @Override
        public native int read(int var1, byte[] var2, int var3);

        @Override
        public native long write(int var1, byte[] var2, long var3);

        @Override
        public native long read(int var1, byte[] var2, long var3);

        @Override
        public native int select(int var1, int[] var2, int[] var3, int[] var4, Linux_C_lib.timeval var5);

        @Override
        public native int poll(int[] var1, int var2, int var3);

        @Override
        public int poll(Linux_C_lib.pollfd[] pollfdArray, int n, int n2) {
            throw new IllegalArgumentException();
        }

        @Override
        public native int tcflush(int var1, int var2);

        @Override
        public native void perror(String var1);

        @Override
        public native int tcsendbreak(int var1, int var2);

        static {
            try {
                Native.register((NativeLibrary)NativeLibrary.getInstance((String)"c", (Map)YJPFunctionMapper.OPTIONS));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

