/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.unix;

import com.google.common.collect.ImmutableList;
import com.pty4j.PtyProcess;
import com.pty4j.WinSize;
import com.pty4j.unix.PtyExecutor;
import com.pty4j.unix.PtyHelpers;
import com.pty4j.unix.UnixPtyException;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Structure;
import java.io.Serializable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NativePtyExecutor
implements PtyExecutor {
    private final Pty4J myPty4j;

    NativePtyExecutor(@NotNull String libraryName) {
        this.myPty4j = (Pty4J)Native.load((String)libraryName, Pty4J.class);
    }

    @Override
    public int execPty(String full_path, String[] argv, String[] envp, String dirpath, String pts_name, int fdm, String err_pts_name, int err_fdm, boolean console) {
        return this.myPty4j.exec_pty(full_path, argv, envp, dirpath, pts_name, fdm, err_pts_name, err_fdm, console);
    }

    @Override
    public int waitForProcessExitAndGetExitCode(int pid) {
        return this.myPty4j.wait_for_child_process_exit(pid);
    }

    @Override
    @NotNull
    public WinSize getWindowSize(int fd, @Nullable PtyProcess process) throws UnixPtyException {
        WinSizeStructure ws = new WinSizeStructure();
        int errno = this.myPty4j.get_window_size(fd, ws);
        if (errno != 0) {
            throw new UnixPtyException("Failed to get window size: fd=" + fd + (this.myPty4j.is_valid_fd(fd) ? "(valid)" : "(invalid)") + ", " + NativePtyExecutor.getErrorInfo(errno, process), errno);
        }
        return ws.toWinSize();
    }

    @Override
    public void setWindowSize(int fd, @NotNull WinSize winSize, @Nullable PtyProcess process) throws UnixPtyException {
        int errno = this.myPty4j.set_window_size(fd, new WinSizeStructure(winSize));
        if (errno != 0) {
            boolean validFd = this.myPty4j.is_valid_fd(fd);
            String message = "Failed to set window size: [" + winSize + "], fd=" + fd + (validFd ? "(valid)" : "(invalid)") + ", " + NativePtyExecutor.getErrorInfo(errno, process);
            throw new UnixPtyException(message, errno);
        }
    }

    @NotNull
    private static String getErrorInfo(int errno, @Nullable PtyProcess process) {
        String message = "errno=" + errno + "(" + (errno != -1 ? PtyHelpers.getInstance().strerror(errno) : "unknown") + ")";
        if (process != null) {
            Integer exitCode = NativePtyExecutor.getExitCode(process);
            message = message + ", pid:" + process.pid() + ", running:" + process.isAlive() + ", exit code:" + (Serializable)(exitCode != null ? exitCode : "N/A");
        }
        return message;
    }

    @Nullable
    private static Integer getExitCode(@NotNull PtyProcess process) {
        Integer exitCode = null;
        try {
            exitCode = process.exitValue();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
        return exitCode;
    }

    public static class WinSizeStructure
    extends Structure {
        private static final List<String> FIELD_ORDER = ImmutableList.of((Object)"ws_row", (Object)"ws_col", (Object)"ws_xpixel", (Object)"ws_ypixel");
        public short ws_row;
        public short ws_col;
        public short ws_xpixel;
        public short ws_ypixel;

        protected List<String> getFieldOrder() {
            return FIELD_ORDER;
        }

        public WinSizeStructure() {
        }

        public WinSizeStructure(@NotNull WinSize ws) {
            this.ws_row = ws.ws_row;
            this.ws_col = ws.ws_col;
        }

        @NotNull
        public WinSize toWinSize() {
            return new WinSize(this.ws_col, this.ws_row);
        }
    }

    private static interface Pty4J
    extends Library {
        public int exec_pty(String var1, String[] var2, String[] var3, String var4, String var5, int var6, String var7, int var8, boolean var9);

        public int wait_for_child_process_exit(int var1);

        public int get_window_size(int var1, WinSizeStructure var2);

        public int set_window_size(int var1, WinSizeStructure var2);

        public boolean is_valid_fd(int var1);
    }
}

