/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.MacSpi;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.MACOperatorFactory;
import org.bouncycastle.crypto.OutputMACCalculator;
import org.bouncycastle.crypto.PasswordBasedDeriver;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsMACOperatorFactory;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.crypto.general.SecureHash;
import org.bouncycastle.jcajce.PKCS12Key;
import org.bouncycastle.jcajce.provider.MacParametersCreator;
import org.bouncycastle.jcajce.provider.ProvPKCS12;
import org.bouncycastle.jcajce.provider.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BaseHMac
extends MacSpi {
    private static FipsMACOperatorFactory<FipsSHS.AuthParameters> fipsFactory = new FipsSHS.MACOperatorFactory();
    private static MACOperatorFactory<SecureHash.AuthParameters> generalFactory;
    private final Algorithm algorithm;
    private final MACOperatorFactory factory;
    private final MacParametersCreator parametersCreator;
    private OutputMACCalculator macCalculator;
    private UpdateOutputStream macStream;

    protected BaseHMac(FipsAlgorithm fipsAlgorithm, MacParametersCreator macParametersCreator) {
        this.algorithm = fipsAlgorithm;
        this.factory = fipsFactory;
        this.parametersCreator = macParametersCreator;
    }

    protected BaseHMac(GeneralAlgorithm generalAlgorithm, MacParametersCreator macParametersCreator) {
        this.algorithm = generalAlgorithm;
        this.factory = this.getGeneralMACFactory();
        this.parametersCreator = macParametersCreator;
    }

    private MACOperatorFactory<SecureHash.AuthParameters> getGeneralMACFactory() {
        if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            return null;
        }
        if (generalFactory == null) {
            generalFactory = new SecureHash.MACOperatorFactory();
        }
        return generalFactory;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Object t;
        if (algorithmParameterSpec instanceof PBEParameterSpec) {
            try {
                t = this.parametersCreator.createParameters(true, null, null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidAlgorithmParameterException("Invalid algorithm parameter: " + illegalArgumentException.getMessage(), illegalArgumentException);
            }
        } else {
            t = this.parametersCreator.createParameters(true, algorithmParameterSpec, null);
        }
        if (key instanceof PKCS12Key) {
            SecretKey secretKey;
            PBEParameterSpec pBEParameterSpec;
            int n = t.getMACSizeInBits();
            if (algorithmParameterSpec != null) {
                if (!(algorithmParameterSpec instanceof PBEParameterSpec)) throw new InvalidAlgorithmParameterException("PBE algorithms can only take PBEParameterSpec");
                pBEParameterSpec = (PBEParameterSpec)algorithmParameterSpec;
            } else {
                if (!(key instanceof PBEKey)) throw new InvalidKeyException("No algorithm parameters provided when required.");
                secretKey = (PBEKey)key;
                pBEParameterSpec = new PBEParameterSpec(secretKey.getSalt(), secretKey.getIterationCount());
            }
            try {
                secretKey = (SecretKey)key;
            }
            catch (Exception exception) {
                throw new InvalidKeyException("PBE schemes requires a SecretKey/PBEKey");
            }
            if (!(key instanceof PKCS12Key)) throw new InvalidKeyException("Unable to use passed in key for PBE");
            key = new SecretKeySpec(ProvPKCS12.getSecretKey(secretKey, Utils.getUnderlyingDigestAlgorithm(this.algorithm), pBEParameterSpec, PasswordBasedDeriver.KeyType.MAC, n), this.algorithm.getName());
        }
        this.macCalculator = this.factory.createOutputMACCalculator(Utils.convertKey(this.algorithm, key), t);
        this.macStream = this.macCalculator.getMACStream();
    }

    @Override
    protected int engineGetMacLength() {
        return (this.parametersCreator.getBaseParameters().getMACSizeInBits() + 7) / 8;
    }

    @Override
    protected void engineReset() {
        if (this.macCalculator != null) {
            this.macCalculator.reset();
        }
    }

    @Override
    protected void engineUpdate(byte by) {
        this.macStream.update(by);
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) {
        this.macStream.update(byArray, n, n2);
    }

    @Override
    protected byte[] engineDoFinal() {
        return this.macCalculator.getMAC();
    }
}

