/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.validation;

import ca.sqlpower.validation.Status;
import ca.sqlpower.validation.ValidateResult;
import ca.sqlpower.validation.Validator;
import java.io.File;
import java.io.IOException;

public class FileNameValidator
implements Validator {
    private final String desc;

    public FileNameValidator(String desc) {
        this.desc = desc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValidateResult validate(Object contents) {
        String name = (String)contents;
        if (name == null || name.length() == 0) {
            return ValidateResult.createValidateResult(Status.FAIL, this.desc + " file is required.");
        }
        File f = new File(name);
        if (f.exists()) {
            if (!f.isFile()) {
                return ValidateResult.createValidateResult(Status.FAIL, this.desc + " file name is invalid.");
            }
        } else {
            try {
                if (!f.createNewFile()) {
                    ValidateResult validateResult = ValidateResult.createValidateResult(Status.FAIL, this.desc + " file can not be created.");
                    return validateResult;
                }
            }
            catch (IOException e) {
                ValidateResult validateResult = ValidateResult.createValidateResult(Status.FAIL, this.desc + " file can not be created.");
                return validateResult;
            }
            finally {
                f.delete();
            }
        }
        return ValidateResult.createValidateResult(Status.OK, "");
    }
}

