/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui.querypen;

import ca.sqlpower.object.SPVariableHelper;
import ca.sqlpower.swingui.object.InsertVariableAction;
import ca.sqlpower.swingui.object.VariableInserter;
import ca.sqlpower.swingui.object.VariableLabel;
import ca.sqlpower.swingui.querypen.EditablePStyledText;
import ca.sqlpower.swingui.querypen.QueryPen;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;
import java.awt.Paint;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.apache.log4j.Logger;

public class EditablePStyledTextWithOptionBox
extends EditablePStyledText {
    private static final Logger logger = Logger.getLogger(EditablePStyledText.class);
    private static final int ONE_PIXEL_SPACE = 1;
    private PPath whereOptionBox;
    private FocusListener editorFocusListener = new FocusListener(){

        @Override
        public void focusLost(FocusEvent e) {
            if (EditablePStyledTextWithOptionBox.this.boxClicked) {
                EditablePStyledTextWithOptionBox.this.boxClicked = false;
                EditablePStyledTextWithOptionBox.this.getEditorPane().requestFocus();
                return;
            }
            EditablePStyledTextWithOptionBox.this.whereOptionBox.removeFromParent();
            EditablePStyledTextWithOptionBox.this.getStyledTextEventHandler().stopEditing();
        }

        @Override
        public void focusGained(FocusEvent e) {
            EditablePStyledTextWithOptionBox.this.whereOptionBox.translate(EditablePStyledTextWithOptionBox.this.getGlobalFullBounds().getX() - EditablePStyledTextWithOptionBox.this.whereOptionBox.getXOffset() - 1.0, EditablePStyledTextWithOptionBox.this.getGlobalFullBounds().getY() + (double)EditablePStyledTextWithOptionBox.this.getEditorPane().getHeight() - EditablePStyledTextWithOptionBox.this.whereOptionBox.getYOffset());
            if (!EditablePStyledTextWithOptionBox.this.queryPen.getTopLayer().isAncestorOf((PNode)EditablePStyledTextWithOptionBox.this.whereOptionBox)) {
                EditablePStyledTextWithOptionBox.this.queryPen.getTopLayer().addChild((PNode)EditablePStyledTextWithOptionBox.this.whereOptionBox);
            }
            EditablePStyledTextWithOptionBox.this.whereOptionBox.moveToFront();
        }
    };
    private static final int WHERE_OPTION_BOX_WIDTH = 100;
    private static final int WHERE_OPTION_BOX_HIEGHT = 90;
    private boolean boxClicked;
    private final QueryPen queryPen;
    private final SPVariableHelper variablesHelper;
    private static final String[] whereOptions = new String[]{"<", ">", "=", "<>", ">=", "<=", "BETWEEN", "LIKE", "IN", "NOT"};

    public EditablePStyledTextWithOptionBox(String startingText, QueryPen queryPenRef, PCanvas canvas, int minCharCountSize) {
        this(startingText, queryPenRef, canvas, minCharCountSize, null);
    }

    public EditablePStyledTextWithOptionBox(String startingText, QueryPen queryPenRef, PCanvas canvas, int minCharCountSize, SPVariableHelper variables) {
        super(startingText, queryPenRef, canvas, minCharCountSize);
        this.queryPen = queryPenRef;
        this.variablesHelper = variables;
        this.getEditorPane().removeFocusListener(this.getEditorFocusListener());
        this.getEditorPane().addFocusListener(this.editorFocusListener);
        if (this.variablesHelper != null) {
            VariableLabel.insertLabels(this.variablesHelper, (StyledDocument)this.getDocument(), this.getEditorPane());
            this.getEditorPane().getInputMap().put(KeyStroke.getKeyStroke(32, 2), "insertVariable");
            this.getEditorPane().getActionMap().put("insertVariable", new InsertVariableAction("Insert variable", this.variablesHelper, null, new VariableInserter(){

                @Override
                public void insert(String variable) {
                    try {
                        EditablePStyledTextWithOptionBox.this.getEditorPane().setText(EditablePStyledTextWithOptionBox.this.getEditorPane().getText().trim());
                        EditablePStyledTextWithOptionBox.this.getEditorPane().getDocument().insertString(EditablePStyledTextWithOptionBox.this.getEditorPane().getCaretPosition(), variable, null);
                    }
                    catch (BadLocationException e) {
                        throw new IllegalStateException(e);
                    }
                    EditablePStyledTextWithOptionBox.this.syncWithDocument();
                    EditablePStyledTextWithOptionBox.this.getStyledTextEventHandler().stopEditing();
                }
            }, this.getEditorPane()));
        }
        this.whereOptionBox = PPath.createRectangle((float)0.0f, (float)0.0f, (float)100.0f, (float)90.0f);
        this.whereOptionBox.addInputEventListener((PInputEventListener)new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent event) {
                EditablePStyledTextWithOptionBox.this.boxClicked = true;
            }
        });
        int yLoc = 0;
        int xLoc = 0;
        for (String whereOption : whereOptions) {
            final PText newOption = new PText(whereOption);
            final PNode background = new PNode();
            background.setTransparency(0.3f);
            newOption.addAttribute(StyleConstants.FontFamily, (Object)UIManager.getFont("List.font").getFamily());
            newOption.translate((double)(33 * xLoc + 3), (this.getHeight() + 1.0) * (double)yLoc + 5.0);
            background.setBounds(newOption.getBounds().getX(), newOption.getBounds().getY(), newOption.getBounds().getWidth() + 3.0, newOption.getBounds().getHeight() + 3.0);
            newOption.addChild(background);
            background.setPaint((Paint)Color.gray);
            background.setVisible(false);
            newOption.addInputEventListener((PInputEventListener)new PBasicInputEventHandler(){

                public void mouseEntered(PInputEvent event) {
                    background.setVisible(true);
                    newOption.repaint();
                }

                public void mouseExited(PInputEvent event) {
                    background.setVisible(false);
                    newOption.repaint();
                }

                public void mousePressed(PInputEvent event) {
                    JEditorPane whereEditorPane = EditablePStyledTextWithOptionBox.this.getEditorPane();
                    try {
                        whereEditorPane.getDocument().insertString(whereEditorPane.getCaretPosition(), newOption.getText(), null);
                    }
                    catch (BadLocationException e) {
                        logger.debug((Object)"Bad Location when trying to insert whereOption on whereText");
                        throw new IllegalStateException(e);
                    }
                }
            });
            if (++yLoc > 4) {
                yLoc = 0;
                xLoc = 1;
            }
            this.whereOptionBox.addChild((PNode)newOption);
        }
    }

    public PPath getOptionBox() {
        return this.whereOptionBox;
    }
}

