/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.ddl.critic.impl;

import ca.sqlpower.architect.ddl.critic.CriticAndSettings;
import ca.sqlpower.architect.ddl.critic.CriticFix;
import ca.sqlpower.architect.ddl.critic.Criticism;
import ca.sqlpower.architect.ddl.critic.impl.Messages;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLIndex;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLRelationship;
import ca.sqlpower.sqlobject.SQLTable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public abstract class ReservedWordsCritic
extends CriticAndSettings {
    private final Collection<String> reservedWords;

    public ReservedWordsCritic(String platformType, String name, Collection<String> reservedWords) {
        super(platformType, name);
        this.reservedWords = reservedWords;
    }

    @Override
    public List<Criticism> criticize(Object subject) {
        if (subject instanceof SQLTable || subject instanceof SQLIndex || subject instanceof SQLRelationship || subject instanceof SQLColumn) {
            final SQLObject sqlObject = (SQLObject)subject;
            String typeName = sqlObject.getClass().getSimpleName().substring(3);
            if (this.reservedWords.contains(sqlObject.getPhysicalName().toUpperCase())) {
                final String newName = sqlObject.getPhysicalName() + "_1";
                return Collections.singletonList(new Criticism(subject, Messages.getString("ReservedWordsCritic.criticismDesc", Messages.getString(typeName), sqlObject.getPhysicalName() + " (" + sqlObject.getName() + ")"), this, new CriticFix(Messages.getString("ReservedWordsCritic.quickFixDesc", newName), CriticFix.FixType.QUICK_FIX){

                    @Override
                    public void apply() {
                        sqlObject.setPhysicalName(newName);
                    }
                }));
            }
        }
        return Collections.emptyList();
    }
}

