(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/crypto/etc#libcrypto-error::t
    (make-struct-type
     'std/crypto/etc#libcrypto-error::t
     error::t
     '0
     'libcrypto-error
     '()
     ':init!
     '()))
  (define std/crypto/etc#libcrypto-error?
    (make-struct-predicate std/crypto/etc#libcrypto-error::t))
  (define std/crypto/etc#make-libcrypto-error
    (lambda _$args887_
      (apply make-struct-instance
             std/crypto/etc#libcrypto-error::t
             _$args887_)))
  (define std/crypto/etc#libcrypto-error:::init!
    (lambda (_self874_ _errno875_ _irritants876_)
      (if (let ((__tmp4525
                 (let () (declare (not safe)) (##vector-length _self874_))))
            (declare (not safe))
            (##fx< '3 __tmp4525))
          (begin
            (let ((__tmp4526
                   (let ((_$e878_ (std/crypto/libcrypto#ERR_reason_error_string
                                   _errno875_)))
                     (if _$e878_ _$e878_ '"Unknown error"))))
              (declare (not safe))
              (##vector-set! _self874_ '1 __tmp4526))
            (let ((__tmp4527 (cons _errno875_ _irritants876_)))
              (declare (not safe))
              (##vector-set! _self874_ '2 __tmp4527))
            (let ((__tmp4528
                   (string-append
                    (let ((_$e881_ (std/crypto/libcrypto#ERR_lib_error_string
                                    _errno875_)))
                      (if _$e881_ _$e881_ '"?"))
                    '":"
                    (let ((_$e884_ (std/crypto/libcrypto#ERR_func_error_string
                                    _errno875_)))
                      (if _$e884_ _$e884_ '"?")))))
              (declare (not safe))
              (##vector-set! _self874_ '3 __tmp4528)))
          (error '"struct-instance-init!: too many arguments for struct"
                 _self874_))))
  (bind-method!
   std/crypto/etc#libcrypto-error::t
   ':init!
   std/crypto/etc#libcrypto-error:::init!
   '#f)
  (define std/crypto/etc#libcrypto-error::display-exception
    (lambda (_self749_ _port750_)
      (std/format#fprintf
       _port750_
       '"Libcrypto error [~a]: ~a ~a~n"
       (error-trace _self749_)
       (error-message _self749_)
       (error-irritants _self749_))))
  (bind-method!
   std/crypto/etc#libcrypto-error::t
   'display-exception
   std/crypto/etc#libcrypto-error::display-exception
   '#f)
  (define std/crypto/etc#raise-libcrypto-error
    (lambda _irritants625_
      (raise (make-struct-instance
              std/crypto/etc#libcrypto-error::t
              (std/crypto/libcrypto#ERR_get_error)
              _irritants625_))))
  (define std/crypto/etc#call-with-binary-input
    (lambda (_proc621_ _in622_ . _args623_)
      (if (u8vector? _in622_)
          (apply std/crypto/etc#call-with-binary-input-u8vector
                 _proc621_
                 _in622_
                 _args623_)
          (if (string? _in622_)
              (apply std/crypto/etc#call-with-binary-input-string
                     _proc621_
                     _in622_
                     _args623_)
              (if (input-port? _in622_)
                  (apply std/crypto/etc#call-with-binary-input-port
                         _proc621_
                         _in622_
                         _args623_)
                  (error '"Unexpected input source" _in622_))))))
  (define std/crypto/etc#call-with-binary-input-u8vector__0
    (lambda (_proc609_ _in610_)
      (_proc609_
       _in610_
       '0
       (let () (declare (not safe)) (##u8vector-length _in610_)))))
  (define std/crypto/etc#call-with-binary-input-u8vector__1
    (lambda (_proc612_ _in613_ _start614_)
      (_proc612_
       _in613_
       _start614_
       (let () (declare (not safe)) (##u8vector-length _in613_)))))
  (define std/crypto/etc#call-with-binary-input-u8vector__2
    (lambda (_proc616_ _in617_ _start618_ _end619_)
      (_proc616_ _in617_ _start618_ _end619_)))
  (define std/crypto/etc#call-with-binary-input-u8vector
    (lambda _g4530_
      (let ((_g4529_ (let () (declare (not safe)) (##length _g4530_))))
        (cond ((let () (declare (not safe)) (##fx= _g4529_ 2))
               (apply std/crypto/etc#call-with-binary-input-u8vector__0
                      _g4530_))
              ((let () (declare (not safe)) (##fx= _g4529_ 3))
               (apply std/crypto/etc#call-with-binary-input-u8vector__1
                      _g4530_))
              ((let () (declare (not safe)) (##fx= _g4529_ 4))
               (apply std/crypto/etc#call-with-binary-input-u8vector__2
                      _g4530_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/crypto/etc#call-with-binary-input-u8vector
                _g4530_))))))
  (define std/crypto/etc#call-with-binary-input-string__0
    (lambda (_proc597_ _in598_)
      (std/crypto/etc#call-with-binary-input-u8vector__0
       _proc597_
       (std/text/utf8#string->utf8__0 _in598_))))
  (define std/crypto/etc#call-with-binary-input-string__1
    (lambda (_proc600_ _in601_ _start602_)
      (std/crypto/etc#call-with-binary-input-u8vector__0
       _proc600_
       (std/text/utf8#utf8-encode
        _in601_
        _start602_
        (let () (declare (not safe)) (##string-length _in601_))))))
  (define std/crypto/etc#call-with-binary-input-string__2
    (lambda (_proc604_ _in605_ _start606_ _end607_)
      (std/crypto/etc#call-with-binary-input-u8vector__0
       _proc604_
       (std/text/utf8#utf8-encode _in605_ _start606_ _end607_))))
  (define std/crypto/etc#call-with-binary-input-string
    (lambda _g4532_
      (let ((_g4531_ (let () (declare (not safe)) (##length _g4532_))))
        (cond ((let () (declare (not safe)) (##fx= _g4531_ 2))
               (apply std/crypto/etc#call-with-binary-input-string__0 _g4532_))
              ((let () (declare (not safe)) (##fx= _g4531_ 3))
               (apply std/crypto/etc#call-with-binary-input-string__1 _g4532_))
              ((let () (declare (not safe)) (##fx= _g4531_ 4))
               (apply std/crypto/etc#call-with-binary-input-string__2 _g4532_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/crypto/etc#call-with-binary-input-string
                _g4532_))))))
  (define std/crypto/etc#call-with-binary-input-port__%
    (lambda (_proc581_ _in582_ _fill?583_)
      (if (macro-byte-input-port? _in582_)
          (std/crypto/etc#call-with-binary-input-byte-port
           _proc581_
           _in582_
           _fill?583_)
          (if (macro-character-input-port? _in582_)
              (std/crypto/etc#call-with-binary-input-character-port
               _proc581_
               _in582_
               _fill?583_)
              (error '"Unusable input-port; need a character or byte port"
                     _in582_)))))
  (define std/crypto/etc#call-with-binary-input-port__0
    (lambda (_proc588_ _in589_)
      (let ((_fill?591_ '#t))
        (std/crypto/etc#call-with-binary-input-port__%
         _proc588_
         _in589_
         _fill?591_))))
  (define std/crypto/etc#call-with-binary-input-port
    (lambda _g4534_
      (let ((_g4533_ (let () (declare (not safe)) (##length _g4534_))))
        (cond ((let () (declare (not safe)) (##fx= _g4533_ 2))
               (apply std/crypto/etc#call-with-binary-input-port__0 _g4534_))
              ((let () (declare (not safe)) (##fx= _g4533_ 3))
               (apply std/crypto/etc#call-with-binary-input-port__% _g4534_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/crypto/etc#call-with-binary-input-port
                _g4534_))))))
  (define std/crypto/etc#call-with-binary-input-byte-port
    (lambda (_proc566_ _in567_ _fill?568_)
      (let ((_bytes570_ (std/crypto/etc#drain-input-character-buffer _in567_)))
        (if _bytes570_
            (_proc566_
             _bytes570_
             '0
             (let () (declare (not safe)) (##u8vector-length _bytes570_)))
            '#!void))
      (let ((_buf572_ (let () (declare (not safe)) (##make-u8vector '1024)))
            (_need573_ (if _fill?568_ '1 absent-obj)))
        (let _lp575_ ()
          (let ((_rd578_ (let ()
                           (declare (not safe))
                           (##read-subu8vector
                            _buf572_
                            '0
                            '1024
                            _in567_
                            _need573_))))
            (if (let () (declare (not safe)) (##fxzero? _rd578_))
                '#!void
                (begin (_proc566_ _buf572_ '0 _rd578_) (_lp575_))))))))
  (define std/crypto/etc#call-with-binary-input-character-port
    (lambda (_proc552_ _in553_ _fill?554_)
      (let ((_buf556_ (let () (declare (not safe)) (##make-string '512)))
            (_need557_ (if _fill?554_ '1 absent-obj)))
        (let _lp559_ ()
          (let ((_rd562_ (let ()
                           (declare (not safe))
                           (##read-substring
                            _buf556_
                            '0
                            '512
                            _in553_
                            _need557_))))
            (if (let () (declare (not safe)) (##fxzero? _rd562_))
                '#!void
                (let ((_bytes564_
                       (std/text/utf8#utf8-encode _buf556_ '0 _rd562_)))
                  (_proc552_
                   _bytes564_
                   '0
                   (let ()
                     (declare (not safe))
                     (##u8vector-length _bytes564_)))
                  (_lp559_))))))))
  (define std/crypto/etc#drain-input-character-buffer
    (lambda (_port547_)
      (gerbil/gambit/threads#with-lock
       (macro-port-mutex _port547_)
       (lambda ()
         (if (let ((__tmp4536 (macro-character-port-rlo _port547_))
                   (__tmp4535 (macro-character-port-rhi _port547_)))
               (declare (not safe))
               (##fx< __tmp4536 __tmp4535))
             (let ((_buf550_
                    (std/text/utf8#utf8-encode
                     (macro-character-port-rbuf _port547_)
                     (macro-character-port-rlo _port547_)
                     (macro-character-port-rhi _port547_))))
               (macro-character-port-rlo-set!
                _port547_
                (macro-character-port-rhi _port547_))
               _buf550_)
             '#f)))))
  (define std/crypto/etc#*urandom* (open-input-file '"/dev/urandom"))
  (define std/crypto/etc#random-bytes
    (lambda (_len543_)
      (let ((_bytes545_ (make-u8vector _len543_)))
        (std/crypto/etc#random-bytes!__% _bytes545_ '0 _len543_)
        _bytes545_)))
  (define std/crypto/etc#random-bytes!__%
    (lambda (_bytes519_ _start520_ _end521_)
      (let ((_count523_
             (read-subu8vector
              _bytes519_
              _start520_
              _end521_
              std/crypto/etc#*urandom*)))
        (if (eq? _count523_
                 (let () (declare (not safe)) (##fx- _end521_ _start520_)))
            '#!void
            (error '"Could not read enough random bytes"
                   _count523_
                   _start520_
                   _end521_)))))
  (define std/crypto/etc#random-bytes!__0
    (lambda (_bytes528_)
      (let* ((_start530_ '0) (_end532_ (u8vector-length _bytes528_)))
        (std/crypto/etc#random-bytes!__% _bytes528_ _start530_ _end532_))))
  (define std/crypto/etc#random-bytes!__1
    (lambda (_bytes534_ _start535_)
      (let ((_end537_ (u8vector-length _bytes534_)))
        (std/crypto/etc#random-bytes!__% _bytes534_ _start535_ _end537_))))
  (define std/crypto/etc#random-bytes!
    (lambda _g4538_
      (let ((_g4537_ (let () (declare (not safe)) (##length _g4538_))))
        (cond ((let () (declare (not safe)) (##fx= _g4537_ 1))
               (apply std/crypto/etc#random-bytes!__0 _g4538_))
              ((let () (declare (not safe)) (##fx= _g4537_ 2))
               (apply std/crypto/etc#random-bytes!__1 _g4538_))
              ((let () (declare (not safe)) (##fx= _g4537_ 3))
               (apply std/crypto/etc#random-bytes!__% _g4538_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/crypto/etc#random-bytes!
                _g4538_)))))))
