/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.ProjectConfigurationException;
import org.gradle.api.credentials.AwsCredentials;
import org.gradle.api.credentials.Credentials;
import org.gradle.api.credentials.PasswordCredentials;
import org.gradle.api.execution.TaskExecutionGraph;
import org.gradle.api.execution.TaskExecutionGraphListener;
import org.gradle.api.internal.provider.DefaultProvider;
import org.gradle.api.internal.provider.MissingValueException;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.internal.credentials.DefaultAwsCredentials;
import org.gradle.internal.credentials.DefaultPasswordCredentials;
import org.gradle.internal.logging.text.TreeFormatter;

public class CredentialsProviderFactory
implements TaskExecutionGraphListener {
    private final ProviderFactory providerFactory;
    private final Map<String, Provider<PasswordCredentials>> passwordProviders = new ConcurrentHashMap<String, Provider<PasswordCredentials>>();
    private final Map<String, Provider<AwsCredentials>> awsProviders = new ConcurrentHashMap<String, Provider<AwsCredentials>>();
    private final Set<String> missingProviderErrors = ConcurrentHashMap.newKeySet();

    public CredentialsProviderFactory(ProviderFactory providerFactory) {
        this.providerFactory = providerFactory;
    }

    public <T extends Credentials> Provider<T> provide(Class<T> credentialsType, String identity) {
        CredentialsProviderFactory.validateIdentity(identity);
        if (PasswordCredentials.class.isAssignableFrom(credentialsType)) {
            return this.passwordProviders.computeIfAbsent(identity, id -> this.evaluateAtConfigurationTime(new PasswordCredentialsProvider((String)id)));
        }
        if (AwsCredentials.class.isAssignableFrom(credentialsType)) {
            return this.awsProviders.computeIfAbsent(identity, id -> this.evaluateAtConfigurationTime(new AwsCredentialsProvider((String)id)));
        }
        throw new IllegalArgumentException(String.format("Unsupported credentials type: %s", credentialsType));
    }

    public <T extends Credentials> Provider<T> provide(Class<T> credentialsType, Provider<String> identity) {
        return this.evaluateAtConfigurationTime(() -> (Credentials)this.provide(credentialsType, (String)identity.get()).get());
    }

    public void graphPopulated(TaskExecutionGraph graph) {
        if (!this.missingProviderErrors.isEmpty()) {
            throw new ProjectConfigurationException("Credentials required for this build could not be resolved.", (Iterable)this.missingProviderErrors.stream().map(MissingValueException::new).collect(Collectors.toList()));
        }
    }

    private static void validateIdentity(@Nullable String identity) {
        if (identity == null || identity.isEmpty() || !identity.chars().allMatch(Character::isLetterOrDigit)) {
            throw new IllegalArgumentException("Identity may contain only letters and digits, received: " + identity);
        }
    }

    private <T extends Credentials> Provider<T> evaluateAtConfigurationTime(Callable<T> provider) {
        return new InterceptingProvider<T>(provider);
    }

    private class InterceptingProvider<T>
    extends DefaultProvider<T> {
        public InterceptingProvider(Callable<? extends T> value) {
            super(value);
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            this.calculatePresence(ValueSupplier.ValueConsumer.IgnoreUnsafeRead);
            return super.getProducer();
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            try {
                return super.calculatePresence(consumer);
            }
            catch (MissingValueException e) {
                CredentialsProviderFactory.this.missingProviderErrors.add(e.getMessage());
                if (consumer == ValueSupplier.ValueConsumer.IgnoreUnsafeRead) {
                    return false;
                }
                throw e;
            }
        }
    }

    private class AwsCredentialsProvider
    extends CredentialsProvider<AwsCredentials> {
        AwsCredentialsProvider(String identity) {
            super(identity);
        }

        @Override
        public synchronized AwsCredentials call() {
            String accessKey = this.getRequiredProperty("AccessKey");
            String secretKey = this.getRequiredProperty("SecretKey");
            this.assertRequiredValuesPresent();
            DefaultAwsCredentials credentials = new DefaultAwsCredentials();
            credentials.setAccessKey(accessKey);
            credentials.setSecretKey(secretKey);
            credentials.setSessionToken(this.getOptionalProperty("SessionToken"));
            return credentials;
        }
    }

    private class PasswordCredentialsProvider
    extends CredentialsProvider<PasswordCredentials> {
        PasswordCredentialsProvider(String identity) {
            super(identity);
        }

        @Override
        public synchronized PasswordCredentials call() {
            String username = this.getRequiredProperty("Username");
            String password = this.getRequiredProperty("Password");
            this.assertRequiredValuesPresent();
            return new DefaultPasswordCredentials(username, password);
        }
    }

    private abstract class CredentialsProvider<T extends Credentials>
    implements Callable<T> {
        private final String identity;
        private final Set<String> missingProperties = new LinkedHashSet<String>();

        CredentialsProvider(String identity) {
            this.identity = identity;
        }

        @Nullable
        String getRequiredProperty(String property) {
            String identityProperty = this.identityProperty(property);
            Provider propertyProvider = CredentialsProviderFactory.this.providerFactory.gradleProperty(identityProperty).forUseAtConfigurationTime();
            if (!propertyProvider.isPresent()) {
                this.missingProperties.add(identityProperty);
            }
            return (String)propertyProvider.getOrNull();
        }

        @Nullable
        String getOptionalProperty(String property) {
            String identityProperty = this.identityProperty(property);
            return (String)CredentialsProviderFactory.this.providerFactory.gradleProperty(identityProperty).forUseAtConfigurationTime().getOrNull();
        }

        void assertRequiredValuesPresent() {
            if (!this.missingProperties.isEmpty()) {
                TreeFormatter errorBuilder = new TreeFormatter();
                errorBuilder.node("The following Gradle properties are missing for '").append((CharSequence)this.identity).append((CharSequence)"' credentials");
                errorBuilder.startChildren();
                for (String missingProperty : this.missingProperties) {
                    errorBuilder.node(missingProperty);
                }
                errorBuilder.endChildren();
                this.missingProperties.clear();
                throw new MissingValueException(errorBuilder.toString());
            }
        }

        private String identityProperty(String property) {
            return this.identity + property;
        }
    }
}

