(declare (block) (standard-bindings) (extended-bindings))
(begin
  (define std/actor/rpc/server#current-rpc-server (make-parameter '#f))
  (define std/actor/rpc/server#start-rpc-server!__%
    (lambda (_g6500_ _proto12671270_ . _addresses1272_)
      (let ((_proto1274_
             (if (eq? _proto12671270_ absent-value)
                 (std/actor/rpc/proto/null#rpc-null-proto)
                 _proto12671270_)))
        (std/logger#start-logger!__0)
        (gerbil/gambit/threads#spawn/group
         'rpc-server
         std/actor/rpc/server#rpc-server
         _proto1274_
         _addresses1272_))))
  (define std/actor/rpc/server#start-rpc-server!__@
    (lambda (_keys12661279_ . _args1281_)
      (apply std/actor/rpc/server#start-rpc-server!__%
             _keys12661279_
             (table-ref _keys12661279_ 'proto: absent-value)
             _args1281_)))
  (define std/actor/rpc/server#start-rpc-server!
    (lambda _args12681287_
      (apply keyword-dispatch
             '#(proto:)
             std/actor/rpc/server#start-rpc-server!__@
             _args12681287_)))
  (define std/actor/rpc/server#stop-rpc-server!
    (lambda (_rpcd1259_)
      (let ((_tgroup1261_ (thread-thread-group _rpcd1259_)))
        (with-unwind-protect
         (lambda ()
           (std/actor/message#send-message__0
            _rpcd1259_
            (let ((__tmp6501
                   (let ()
                     (declare (not safe))
                     (##structure std/actor/rpc/base#rpc.shutdown::t))))
              (declare (not safe))
              (##structure std/actor/proto#!event::t __tmp6501)))
           (thread-join! _rpcd1259_))
         (lambda () (std/misc/threads#thread-group-kill! _tgroup1261_))))))
  (define std/actor/rpc/server#rpc-connect__%
    (lambda (_rpcd1230_ _id1231_ _address1232_ _proto1233_)
      (let ((_$e1235_
             (std/actor/rpc/server#rpc-canonical-address _address1232_)))
        (if _$e1235_
            ((lambda (_address1238_)
               (let ((_token1240_
                      (let ()
                        (declare (not safe))
                        (##structure std/actor/proto#!token::t)))
                     (_dest1242_ _rpcd1230_))
                 (std/actor/message#send-message__%
                  _dest1242_
                  (let ((__tmp6502
                         (let ()
                           (declare (not safe))
                           (##structure
                            std/actor/rpc/base#rpc.connect::t
                            _id1231_
                            _address1238_
                            _proto1233_))))
                    (declare (not safe))
                    (##structure
                     std/actor/proto#!call::t
                     __tmp6502
                     _token1240_))
                  '#f
                  '#t)
                 (std/actor/proto#!!call-recv _token1240_ _dest1242_)))
             _$e1235_)
            (error '"Bad rpc address" _address1232_)))))
  (define std/actor/rpc/server#rpc-connect__0
    (lambda (_rpcd1248_ _id1249_ _address1250_)
      (let ((_proto1252_ '#f))
        (std/actor/rpc/server#rpc-connect__%
         _rpcd1248_
         _id1249_
         _address1250_
         _proto1252_))))
  (define std/actor/rpc/server#rpc-connect
    (lambda _g6504_
      (let ((_g6503_ (let () (declare (not safe)) (##length _g6504_))))
        (cond ((let () (declare (not safe)) (##fx= _g6503_ 3))
               (apply std/actor/rpc/server#rpc-connect__0 _g6504_))
              ((let () (declare (not safe)) (##fx= _g6503_ 4))
               (apply std/actor/rpc/server#rpc-connect__% _g6504_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/actor/rpc/server#rpc-connect
                _g6504_))))))
  (define std/actor/rpc/server#rpc-register__%
    (lambda (_rpcd1208_ _id1209_ _proto1210_)
      (let ((_token1212_
             (let ()
               (declare (not safe))
               (##structure std/actor/proto#!token::t)))
            (_dest1214_ _rpcd1208_))
        (std/actor/message#send-message__%
         _dest1214_
         (let ((__tmp6505
                (let ()
                  (declare (not safe))
                  (##structure
                   std/actor/rpc/base#rpc.register::t
                   _id1209_
                   _proto1210_))))
           (declare (not safe))
           (##structure std/actor/proto#!call::t __tmp6505 _token1212_))
         '#f
         '#t)
        (std/actor/proto#!!call-recv _token1212_ _dest1214_))))
  (define std/actor/rpc/server#rpc-register__0
    (lambda (_rpcd1220_ _id1221_)
      (let ((_proto1223_ '#f))
        (std/actor/rpc/server#rpc-register__%
         _rpcd1220_
         _id1221_
         _proto1223_))))
  (define std/actor/rpc/server#rpc-register
    (lambda _g6507_
      (let ((_g6506_ (let () (declare (not safe)) (##length _g6507_))))
        (cond ((let () (declare (not safe)) (##fx= _g6506_ 2))
               (apply std/actor/rpc/server#rpc-register__0 _g6507_))
              ((let () (declare (not safe)) (##fx= _g6506_ 3))
               (apply std/actor/rpc/server#rpc-register__% _g6507_))
              (else
               (##raise-wrong-number-of-arguments-exception
                std/actor/rpc/server#rpc-register
                _g6507_))))))
  (define std/actor/rpc/server#rpc-unregister
    (lambda (_rpcd1199_ _id1200_)
      (let ((_token1202_
             (let ()
               (declare (not safe))
               (##structure std/actor/proto#!token::t)))
            (_dest1204_ _rpcd1199_))
        (std/actor/message#send-message__%
         _dest1204_
         (let ((__tmp6508
                (let ()
                  (declare (not safe))
                  (##structure
                   std/actor/rpc/base#rpc.unregister::t
                   _id1200_))))
           (declare (not safe))
           (##structure std/actor/proto#!call::t __tmp6508 _token1202_))
         '#f
         '#t)
        (std/actor/proto#!!call-recv _token1202_ _dest1204_))))
  (define std/actor/rpc/server#rpc-canonical-address
    (lambda (_address1194_)
      (if (std/net/address#resolved-address? _address1194_)
          _address1194_
          (if (or (std/net/address#inet-address? _address1194_)
                  (std/net/address#inet-address-string? _address1194_))
              (std/net/address#resolve-address _address1194_)
              (if (string? _address1194_) _address1194_ '#f)))))
  (define std/actor/rpc/server#rpc-server
    (lambda (_proto1177_ _addresses1178_)
      (let* ((_sas1180_ (map std/os/socket#socket-address _addresses1178_))
             (_g6509_ (for-each
                       std/actor/rpc/server#rpc-unlink-unix-socket
                       _sas1180_))
             (_socks1183_ (map std/net/socket/api#ssocket-listen _sas1180_)))
        (call-with-parameters
         (lambda ()
           (with-exception-catcher
            (lambda (_g11861188_)
              (if '#t
                  (let ((_e1191_ _g11861188_))
                    (if (eq? _e1191_ 'shutdown)
                        '#!void
                        (begin
                          (std/logger#log-error '"unhandled exception" _e1191_)
                          (raise _e1191_))))
                  (raise _g11861188_)))
            (lambda ()
              (std/actor/rpc/server#rpc-server-loop
               _socks1183_
               _sas1180_
               _proto1177_))))
         std/actor/rpc/server#current-rpc-server
         (current-thread)))))
  (define std/actor/rpc/server#rpc-unlink-unix-socket
    (lambda (_sa1174_)
      (if (eq? (std/os/_socket#sockaddr_family _sa1174_)
               std/os/_socket#AF_UNIX)
          (with-exception-catcher
           void
           (lambda ()
             (delete-file (std/os/socket#socket-address->string _sa1174_))))
          '#!void)))
  (define std/actor/rpc/server#rpc-server-loop
    (lambda (_socks471_ _sas472_ _proto473_)
      (letrec* ((_connect-e475_
                 (##structure-ref
                  _proto473_
                  '1
                  std/actor/rpc/base#!rpc-protocol::t
                  '#f))
                (_accept-e476_
                 (##structure-ref
                  _proto473_
                  '2
                  std/actor/rpc/base#!rpc-protocol::t
                  '#f))
                (_actors477_ (std/actor/rpc/base#make-actor-table))
                (_actor-threads478_ (make-table 'test: eq?))
                (_conns479_ (make-table))
                (_threads480_ (make-table 'test: eq?))
                (_monitors481_ (make-table 'test: eq?))
                (_acceptors482_
                 (map (lambda (_sock1171_ _sa1172_)
                        (gerbil/gambit/threads#spawn/name
                         'rpc-server-accept
                         std/actor/rpc/server#rpc-server-accept
                         (current-thread)
                         _sock1171_
                         (std/os/_socket#sockaddr_family _sa1172_)))
                      _socks471_
                      _sas472_))
                (_server-connection483_ '0)
                (_accept-connection484_
                 (lambda (_cli1161_ _clisa1162_)
                   (let* ((_cliaddr1164_
                           (std/os/socket#socket-address->address _clisa1162_))
                          (_address1166_
                           (list _cliaddr1164_ _server-connection483_))
                          (_thr1168_
                           (gerbil/gambit/threads#spawn/name
                            'rpc-connection
                            std/actor/rpc/connection#rpc-server-connection
                            (current-thread)
                            _actors477_
                            _cli1161_
                            _clisa1162_
                            _address1166_
                            _accept-e476_)))
                     (set! _server-connection483_
                           (+ _server-connection483_ '1))
                     (table-set! _conns479_ _address1166_ _thr1168_)
                     (table-set! _threads480_ _thr1168_ _address1166_)
                     (std/actor/rpc/base#rpc-monitor__0 _thr1168_))))
                (_open-connection485_
                 (lambda (_address1149_)
                   (let ((_$e1151_ (table-ref _conns479_ _address1149_ '#f)))
                     (if _$e1151_
                         (values _$e1151_)
                         (if (list? _address1149_)
                             '#f
                             (let ((_address1154_
                                    (std/actor/rpc/server#rpc-canonical-address
                                     _address1149_)))
                               (if (not _address1154_)
                                   '#f
                                   (let ((_$e1156_
                                          (table-ref
                                           _conns479_
                                           _address1154_
                                           '#f)))
                                     (if _$e1156_
                                         (values _$e1156_)
                                         (let ((_thr1159_
                                                (gerbil/gambit/threads#spawn/name
                                                 'rpc-connection
                                                 std/actor/rpc/connection#rpc-client-connection
                                                 (current-thread)
                                                 _actors477_
                                                 _address1154_
                                                 _connect-e475_)))
                                           (table-set!
                                            _conns479_
                                            _address1154_
                                            _thr1159_)
                                           (table-set!
                                            _threads480_
                                            _thr1159_
                                            _address1154_)
                                           (std/actor/rpc/base#rpc-monitor__0
                                            _thr1159_)
                                           _thr1159_))))))))))
                (_handle-protocol-action486_
                 (lambda (_msg740_)
                   (let* ((_msg741750_ _msg740_)
                          (_E743754_
                           (lambda ()
                             (error '"No clause matching" _msg741750_)))
                          (_K7441126_
                           (lambda (_opt757_ _dest758_ _src759_ _content760_)
                             (let* ((_content761811_ _content760_)
                                    (_else772819_
                                     (lambda ()
                                       (std/logger#warning
                                        '"Unexpected message ~a"
                                        _msg740_))))
                               (let ((_K8061110_
                                      (lambda (_cliaddr1107_ _cli1108_)
                                        (_accept-connection484_
                                         _cli1108_
                                         _cliaddr1107_)))
                                     (_K8041098_
                                      (lambda ()
                                        (let ((_$e1093_
                                               (table-ref
                                                _threads480_
                                                _src759_
                                                '#f)))
                                          (if _$e1093_
                                              ((lambda (_address1096_)
                                                 (std/actor/message#send-message__0
                                                  _src759_
                                                  (let ((__tmp6510
                                                         (let ()
                                                           (declare (not safe))
                                                           (##structure
                                                            std/actor/rpc/base#rpc.connection-close::t))))
                                                    (declare (not safe))
                                                    (##structure
                                                     std/actor/proto#!event::t
                                                     __tmp6510)))
                                                 (_remove-thread!488_
                                                  _src759_))
                                               _$e1093_)
                                              (std/logger#warning
                                               '"Unexpected protocol mesage ~a"
                                               _msg740_)))))
                                     (_K7981062_
                                      (lambda (_k1047_
                                               _proto1048_
                                               _address1049_
                                               _id1050_)
                                        (let* ((_uuid1052_
                                                (std/misc/uuid#UUID _id1050_))
                                               (_proto1057_
                                                (let ((_$e1054_ _proto1048_))
                                                  (if _$e1054_
                                                      _$e1054_
                                                      (std/actor/rpc/base#lookup-protocol
                                                       _uuid1052_)))))
                                          (if (let ()
                                                (declare (not safe))
                                                (##structure-direct-instance-of?
                                                 _proto1057_
                                                 'std/actor/proto#!protocol::t))
                                              (let ((_handler1060_
                                                     (_open-connection485_
                                                      _address1049_)))
                                                (if _handler1060_
                                                    (std/actor/message#send-message__%
                                                     _src759_
                                                     (let ((__tmp6511
                                                            (let ((__obj6499
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                           (make-object std/actor/proto#remote::t '4)))
                      (std/actor/proto#remote:::init!
                       __obj6499
                       _handler1060_
                       _id1050_
                       _address1049_
                       _proto1057_)
                      __obj6499)))
               (declare (not safe))
               (##structure std/actor/proto#!value::t __tmp6511 _k1047_))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                     '#f
                                                     '#f)
                                                    (std/actor/message#send-message__%
                                                     _src759_
                                                     (let ((__tmp6512
                                                            (make-struct-instance
                                                             std/actor/proto#rpc-error::t
                                                             'rpc-server
                                                             '"invalid address")))
                                                       (declare (not safe))
                                                       (##structure
                                                        std/actor/proto#!error::t
                                                        __tmp6512
                                                        _k1047_))
                                                     '#f
                                                     '#f)))
                                              (std/actor/message#send-message__%
                                               _src759_
                                               (let ()
                                                 (declare (not safe))
                                                 (##structure
                                                  std/actor/proto#!error::t
                                                  '"bad protocol"
                                                  _k1047_))
                                               '#f
                                               '#f)))))
                                     (_K7931022_
                                      (lambda (_k1005_ _proto1006_ _id1007_)
                                        (let ((_uuid1009_
                                               (std/misc/uuid#UUID _id1007_)))
                                          (if (std/misc/sync#sync-hash-key?
                                               _actors477_
                                               _uuid1009_)
                                              (std/actor/message#send-message__%
                                               _src759_
                                               (let ()
                                                 (declare (not safe))
                                                 (##structure
                                                  std/actor/proto#!error::t
                                                  '"duplicate registration"
                                                  _k1005_))
                                               '#f
                                               '#f)
                                              (let ((_proto1014_
                                                     (let ((_$e1011_
                                                            _proto1006_))
                                                       (if _$e1011_
                                                           _$e1011_
                                                           (std/actor/rpc/base#lookup-protocol
                                                            _uuid1009_)))))
                                                (if (let ()
                                                      (declare (not safe))
                                                      (##structure-direct-instance-of?
                                                       _proto1014_
                                                       'std/actor/proto#!protocol::t))
                                                    (let ((_thread1016_
                                                           (_actor-thread-e487_
                                                            _src759_)))
                                                      (std/actor/rpc/base#actor-table-put!
                                                       _actors477_
                                                       _uuid1009_
                                                       _src759_
                                                       _proto1014_)
                                                      (hash-update!
                                                       _actor-threads478_
                                                       _thread1016_
                                                       (lambda (_g10171019_)
                                                         (cons _uuid1009_
                                                               _g10171019_))
                                                       '())
                                                      (std/actor/rpc/base#rpc-monitor__0
                                                       _thread1016_)
                                                      (std/actor/message#send-message__%
                                                       _src759_
                                                       (let ()
                                                         (declare (not safe))
                                                         (##structure
                                                          std/actor/proto#!value::t
                                                          _uuid1009_
                                                          _k1005_))
                                                       '#f
                                                       '#f))
                                                    (std/actor/message#send-message__%
                                                     _src759_
                                                     (let ()
                                                       (declare (not safe))
                                                       (##structure
                                                        std/actor/proto#!error::t
                                                        '"bad protocol"
                                                        _k1005_))
                                                     '#f
                                                     '#f)))))))
                                     (_K789985_
                                      (lambda (_k971_ _id972_)
                                        (let* ((_uuid974_
                                                (std/misc/uuid#UUID _id972_))
                                               (_thread976_
                                                (_actor-thread-e487_
                                                 _src759_)))
                                          (std/misc/sync#sync-hash-remove!
                                           _actors477_
                                           _uuid974_)
                                          (let ((_actor-rest983_
                                                 (remf (lambda (_g978980_)
                                                         (std/misc/uuid#uuid=?
                                                          _g978980_
                                                          _uuid974_))
                                                       (table-ref
                                                        _actor-threads478_
                                                        _thread976_
                                                        '()))))
                                            (if (null? _actor-rest983_)
                                                (table-set!
                                                 _actor-threads478_
                                                 _thread976_)
                                                (table-set!
                                                 _actor-threads478_
                                                 _thread976_
                                                 _actor-rest983_)))
                                          (std/actor/message#send-message__%
                                           _src759_
                                           (let ()
                                             (declare (not safe))
                                             (##structure
                                              std/actor/proto#!value::t
                                              '#!void
                                              _k971_))
                                           '#f
                                           '#f))))
                                     (_K785951_
                                      (lambda (_k910_ _id911_)
                                        (let* ((_uuid913_
                                                (std/misc/uuid#UUID _id911_))
                                               (_actor948_
                                                (let ((_$e915_ (std/misc/sync#sync-hash-get
                                                                _actors477_
                                                                _uuid913_)))
                                                  (if _$e915_
                                                      ((lambda (_e917919_)
                                                         (let* ((_g921928_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                         _e917919_)
                        (_E923932_
                         (lambda () (error '"No clause matching" _g921928_)))
                        (_K924937_ (lambda (_actor935_) _actor935_)))
                   (if (let ((__tmp6513
                              (if (let ()
                                    (declare (not safe))
                                    (##values? _g921928_))
                                  (let ()
                                    (declare (not safe))
                                    (##vector-length _g921928_))
                                  '1)))
                         (declare (not safe))
                         (##fx= __tmp6513 '2))
                       (let* ((_e925940_
                               (let ()
                                 (declare (not safe))
                                 (##vector-ref _g921928_ '0)))
                              (_actor943_ _e925940_)
                              (_e926945_
                               (let ()
                                 (declare (not safe))
                                 (##vector-ref _g921928_ '1))))
                         (_K924937_ _actor943_))
                       (_E923932_))))
               _$e915_)
              '#f))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                          (std/actor/message#send-message__%
                                           _src759_
                                           (let ()
                                             (declare (not safe))
                                             (##structure
                                              std/actor/proto#!value::t
                                              _actor948_
                                              _k910_))
                                           '#f
                                           '#f))))
                                     (_K782895_
                                      (lambda (_k891_)
                                        (let ((_addresses893_
                                               (map std/os/socket#socket-address->address
                                                    _sas472_)))
                                          (std/actor/message#send-message__%
                                           _src759_
                                           (let ()
                                             (declare (not safe))
                                             (##structure
                                              std/actor/proto#!value::t
                                              _addresses893_
                                              _k891_))
                                           '#f
                                           '#f))))
                                     (_K779876_
                                      (lambda (_remote863_)
                                        (let* ((_address865_
                                                (##direct-structure-ref
                                                 _remote863_
                                                 '3
                                                 std/actor/proto#remote::t
                                                 '#f))
                                               (_$e867_ (table-ref
                                                         _conns479_
                                                         _address865_
                                                         '#f)))
                                          (if _$e867_
                                              ((lambda (_thread870_)
                                                 (hash-update!
                                                  _monitors481_
                                                  _thread870_
                                                  (lambda (_g871873_)
                                                    (cons (cons _src759_
                                                                _remote863_)
                                                          _g871873_))
                                                  '()))
                                               _$e867_)
                                              (std/actor/message#send-message__0
                                               _src759_
                                               (let ((__tmp6514
                                                      (let ()
                                                        (declare (not safe))
                                                        (##structure
                                                         std/actor/rpc/base#rpc.disconnect::t
                                                         _remote863_))))
                                                 (declare (not safe))
                                                 (##structure
                                                  std/actor/proto#!event::t
                                                  __tmp6514)))))))
                                     (_K776848_
                                      (lambda (_remote834_)
                                        (let* ((_address836_
                                                (##direct-structure-ref
                                                 _remote834_
                                                 '3
                                                 std/actor/proto#remote::t
                                                 '#f))
                                               (_thread837839_
                                                (table-ref
                                                 _conns479_
                                                 _address836_
                                                 '#f)))
                                          (if _thread837839_
                                              (let ((_thread842_
                                                     _thread837839_))
                                                (hash-update!
                                                 _monitors481_
                                                 _thread842_
                                                 (lambda (_g843845_)
                                                   (remove (cons _src759_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                         _remote834_)
                   _g843845_))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                 '()))
                                              '#f))))
                                     (_K774824_ (lambda () (raise 'shutdown))))
                                 (let ((_try-match7641088_
                                        (lambda ()
                                          (if (let ()
                                                (declare (not safe))
                                                (##structure-direct-instance-of?
                                                 _content761811_
                                                 'std/actor/proto#!call::t))
                                              (let ((_e7991065_
                                                     (let ()
                                                       (declare (not safe))
                                                       (##vector-ref
                                                        _content761811_
                                                        '1))))
                                                (if (let ()
                                                      (declare (not safe))
                                                      (##structure-direct-instance-of?
                                                       _e7991065_
                                                       'std/actor#rpc.connect::t))
                                                    (let* ((_e8011068_
                                                            (let ()
                                                              (declare
                                                                (not safe))
                                                              (##vector-ref
                                                               _e7991065_
                                                               '1)))
                                                           (_e8021073_
                                                            (let ()
                                                              (declare
                                                                (not safe))
                                                              (##vector-ref
                                                               _e7991065_
                                                               '2)))
                                                           (_e8031078_
                                                            (let ()
                                                              (declare
                                                                (not safe))
                                                              (##vector-ref
                                                               _e7991065_
                                                               '3)))
                                                           (_e8001083_
                                                            (let ()
                                                              (declare
                                                                (not safe))
                                                              (##vector-ref
                                                               _content761811_
                                                               '2))))
                                                      (let ((_id1071_
                                                             _e8011068_)
                                                            (_address1076_
                                                             _e8021073_)
                                                            (_proto1081_
                                                             _e8031078_)
                                                            (_k1086_ _e8001083_))
                                                        (_K7981062_
                                                         _k1086_
                                                         _proto1081_
                                                         _address1076_
                                                         _id1071_)))
                                                    (if (let ()
                                                          (declare (not safe))
                                                          (##structure-direct-instance-of?
                                                           _e7991065_
                                                           'std/actor#rpc.register::t))
                                                        (let* ((_e7961028_
                                                                (let ()
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                          (declare (not safe))
                          (##vector-ref _e7991065_ '1)))
                       (_e7971033_
                        (let ()
                          (declare (not safe))
                          (##vector-ref _e7991065_ '2)))
                       (_e7951038_
                        (let ()
                          (declare (not safe))
                          (##vector-ref _content761811_ '2))))
                  (let ((_id1031_ _e7961028_)
                        (_proto1036_ _e7971033_)
                        (_k1041_ _e7951038_))
                    (_K7931022_ _k1041_ _proto1036_ _id1031_)))
                (if (let ()
                      (declare (not safe))
                      (##structure-direct-instance-of?
                       _e7991065_
                       'std/actor#rpc.unregister::t))
                    (let* ((_e792991_
                            (let ()
                              (declare (not safe))
                              (##vector-ref _e7991065_ '1)))
                           (_e791996_
                            (let ()
                              (declare (not safe))
                              (##vector-ref _content761811_ '2))))
                      (let ((_id994_ _e792991_) (_k999_ _e791996_))
                        (_K789985_ _k999_ _id994_)))
                    (if (let ()
                          (declare (not safe))
                          (##structure-direct-instance-of?
                           _e7991065_
                           'std/actor#rpc.resolve::t))
                        (let* ((_e788957_
                                (let ()
                                  (declare (not safe))
                                  (##vector-ref _e7991065_ '1)))
                               (_e787962_
                                (let ()
                                  (declare (not safe))
                                  (##vector-ref _content761811_ '2))))
                          (let ((_id960_ _e788957_) (_k965_ _e787962_))
                            (_K785951_ _k965_ _id960_)))
                        (if (let ()
                              (declare (not safe))
                              (##structure-direct-instance-of?
                               _e7991065_
                               'std/actor#rpc.server-address::t))
                            (let* ((_e784901_
                                    (let ()
                                      (declare (not safe))
                                      (##vector-ref _content761811_ '2)))
                                   (_k904_ _e784901_))
                              (_K782895_ _k904_))
                            (_else772819_)))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                              (_else772819_)))))
                                   (if (let ()
                                         (declare (not safe))
                                         (##structure-direct-instance-of?
                                          _content761811_
                                          'std/actor/proto#!event::t))
                                       (let ((_e8071113_
                                              (let ()
                                                (declare (not safe))
                                                (##vector-ref
                                                 _content761811_
                                                 '1))))
                                         (if (let ()
                                               (declare (not safe))
                                               (##structure-direct-instance-of?
                                                _e8071113_
                                                'std/actor#rpc.connection-accept::t))
                                             (let* ((_e8081116_
                                                     (let ()
                                                       (declare (not safe))
                                                       (##vector-ref
                                                        _e8071113_
                                                        '1)))
                                                    (_e8091121_
                                                     (let ()
                                                       (declare (not safe))
                                                       (##vector-ref
                                                        _e8071113_
                                                        '2))))
                                               (let ((_cli1119_ _e8081116_)
                                                     (_cliaddr1124_
                                                      _e8091121_))
                                                 (_K8061110_
                                                  _cliaddr1124_
                                                  _cli1119_)))
                                             (if (let ()
                                                   (declare (not safe))
                                                   (##structure-direct-instance-of?
                                                    _e8071113_
                                                    'std/actor#rpc.connection-shutdown::t))
                                                 (_K8041098_)
                                                 (if (let ()
                                                       (declare (not safe))
                                                       (##structure-direct-instance-of?
                                                        _e8071113_
                                                        'std/actor#rpc.monitor::t))
                                                     (let* ((_e781882_
                                                             (let ()
                                                               (declare
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                         (not safe))
                       (##vector-ref _e8071113_ '1)))
                    (_remote885_ _e781882_))
               (_K779876_ _remote885_))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                     (if (let ()
                                                           (declare (not safe))
                                                           (##structure-direct-instance-of?
                                                            _e8071113_
                                                            'std/actor#rpc.unmonitor::t))
                                                         (let* ((_e778854_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                         (let ()
                           (declare (not safe))
                           (##vector-ref _e8071113_ '1)))
                        (_remote857_ _e778854_))
                   (_K776848_ _remote857_))
                 (if (let ()
                       (declare (not safe))
                       (##structure-direct-instance-of?
                        _e8071113_
                        'std/actor#rpc.shutdown::t))
                     (_K774824_)
                     (_else772819_)))))))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                       (_try-match7641088_))))))))
                     (if (let ()
                           (declare (not safe))
                           (##structure-direct-instance-of?
                            _msg741750_
                            'std/actor/message#message::t))
                         (let* ((_e7451129_
                                 (let ()
                                   (declare (not safe))
                                   (##vector-ref _msg741750_ '1)))
                                (_content1132_ _e7451129_)
                                (_e7461134_
                                 (let ()
                                   (declare (not safe))
                                   (##vector-ref _msg741750_ '2)))
                                (_src1137_ _e7461134_)
                                (_e7471139_
                                 (let ()
                                   (declare (not safe))
                                   (##vector-ref _msg741750_ '3)))
                                (_dest1142_ _e7471139_)
                                (_e7481144_
                                 (let ()
                                   (declare (not safe))
                                   (##vector-ref _msg741750_ '4)))
                                (_opt1147_ _e7481144_))
                           (_K7441126_
                            _opt1147_
                            _dest1142_
                            _src1137_
                            _content1132_))
                         (_E743754_)))))
                (_actor-thread-e487_
                 (lambda (_actor738_)
                   (if (thread? _actor738_)
                       _actor738_
                       (if (let ()
                             (declare (not safe))
                             (##structure-instance-of?
                              _actor738_
                              'std/actor/message#proxy::t))
                           (##structure-ref
                            _actor738_
                            '1
                            std/actor/message#proxy::t
                            '#f)
                           (error '"Bad actor" _actor738_)))))
                (_remove-thread!488_
                 (lambda (_thread690_)
                   (let ((_$e692_ (table-ref _threads480_ _thread690_ '#f)))
                     (if _$e692_
                         ((lambda (_address695_)
                            (for-each
                             (lambda (_e696698_)
                               (let* ((_g700707_ _e696698_)
                                      (_E702711_
                                       (lambda ()
                                         (error '"No clause matching"
                                                _g700707_)))
                                      (_K703717_
                                       (lambda (_remote714_ _actor715_)
                                         (std/actor/message#send-message__0
                                          _actor715_
                                          (let ((__tmp6515
                                                 (let ()
                                                   (declare (not safe))
                                                   (##structure
                                                    std/actor/rpc/base#rpc.disconnect::t
                                                    _remote714_))))
                                            (declare (not safe))
                                            (##structure
                                             std/actor/proto#!event::t
                                             __tmp6515))))))
                                 (if (let ()
                                       (declare (not safe))
                                       (##pair? _g700707_))
                                     (let ((_hd704720_
                                            (let ()
                                              (declare (not safe))
                                              (##car _g700707_)))
                                           (_tl705722_
                                            (let ()
                                              (declare (not safe))
                                              (##cdr _g700707_))))
                                       (let* ((_actor725_ _hd704720_)
                                              (_remote727_ _tl705722_))
                                         (_K703717_ _remote727_ _actor725_)))
                                     (_E702711_))))
                             (table-ref _monitors481_ _thread690_ '()))
                            (table-set! _conns479_ _address695_)
                            (table-set! _threads480_ _thread690_)
                            (table-set! _monitors481_ _thread690_))
                          _$e692_)
                         '#!void))
                   (let ((_$e729_ (table-ref
                                   _actor-threads478_
                                   _thread690_
                                   '#f)))
                     (if _$e729_
                         ((lambda (_uuids732_)
                            (for-each
                             (lambda (_g733735_)
                               (std/misc/sync#sync-hash-remove!
                                _actors477_
                                _g733735_))
                             _uuids732_)
                            (table-set! _actor-threads478_ _thread690_))
                          _$e729_)
                         '#!void))))
                (_loop489_
                 (lambda ()
                   (let _loop551553_ ()
                     (let ((_next557_ (thread-mailbox-next)))
                       ((lambda (_msg560_)
                          (let* ((_msg562580_ _msg560_)
                                 (_else568588_ (lambda () (_loop551553_))))
                            (let ((_K578685_
                                   (lambda (_msg642_)
                                     (thread-mailbox-extract-and-rewind)
                                     (let ((_dest644_
                                            (##direct-structure-ref
                                             _msg642_
                                             '3
                                             std/actor/message#message::t
                                             '#f)))
                                       (if (eq? (current-thread) _dest644_)
                                           (_handle-protocol-action486_
                                            _msg642_)
                                           (if (let ()
                                                 (declare (not safe))
                                                 (##structure-direct-instance-of?
                                                  _dest644_
                                                  'std/actor/proto#remote::t))
                                               (let* ((_address646_
                                                       (##direct-structure-ref
                                                        _dest644_
                                                        '3
                                                        std/actor/proto#remote::t
                                                        '#f))
                                                      (_handler648_
                                                       (_open-connection485_
                                                        _address646_)))
                                                 (if _handler648_
                                                     (thread-send
                                                      _handler648_
                                                      _msg642_)
                                                     (std/actor/rpc/connection#rpc-send-error-response
                                                      _msg642_
                                                      '"ivalid address")))
                                               (if (let ()
                                                     (declare (not safe))
                                                     (##structure-instance-of?
                                                      _dest644_
                                                      'std/actor/proto#handle::t))
                                                   (let* ((_uuid650_
                                                           (##structure-ref
                                                            _dest644_
                                                            '2
                                                            std/actor/proto#handle::t
                                                            '#f))
                                                          (_$e652_ (std/misc/sync#sync-hash-get
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                            _actors477_
                            _uuid650_)))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                     (if _$e652_
                                                         ((lambda (_e654656_)
                                                            (let* ((_g658665_
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                            _e654656_)
                           (_E660669_
                            (lambda ()
                              (error '"No clause matching" _g658665_)))
                           (_K661674_
                            (lambda (_actor672_)
                              (std/actor/message#send__0
                               _actor672_
                               _msg642_))))
                      (if (let ((__tmp6516
                                 (if (let ()
                                       (declare (not safe))
                                       (##values? _g658665_))
                                     (let ()
                                       (declare (not safe))
                                       (##vector-length _g658665_))
                                     '1)))
                            (declare (not safe))
                            (##fx= __tmp6516 '2))
                          (let* ((_e662677_
                                  (let ()
                                    (declare (not safe))
                                    (##vector-ref _g658665_ '0)))
                                 (_actor680_ _e662677_)
                                 (_e663682_
                                  (let ()
                                    (declare (not safe))
                                    (##vector-ref _g658665_ '1))))
                            (_K661674_ _actor680_))
                          (_E660669_))))
                  _$e652_)
                 (std/actor/rpc/connection#rpc-send-error-response
                  _msg642_
                  '"unknown actor")))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                   (begin
                                                     (std/logger#warning
                                                      '"bad destination ~a"
                                                      _dest644_)
                                                     (std/actor/rpc/connection#rpc-send-error-response
                                                      _msg642_
                                                      '"bad destination"))))))))
                                  (_K577634_
                                   (lambda (_thread632_)
                                     (thread-mailbox-extract-and-rewind)
                                     (if (memq _thread632_ _acceptors482_)
                                         (std/logger#warning
                                          '"acceptor thread has exited abnormally ~a"
                                          _thread632_)
                                         (_remove-thread!488_ _thread632_))))
                                  (_K576625_
                                   (lambda ()
                                     (thread-mailbox-extract-and-rewind)
                                     (_dump!490_ (current-error-port))))
                                  (_K571605_
                                   (lambda (_port603_)
                                     (thread-mailbox-extract-and-rewind)
                                     (_dump!490_ _port603_)))
                                  (_K570594_
                                   (lambda (_value592_)
                                     (thread-mailbox-extract-and-rewind)
                                     (std/logger#warning
                                      '"unexepected message ~a"
                                      _value592_))))
                              (let* ((_try-match566620_
                                      (lambda ()
                                        (if (let ()
                                              (declare (not safe))
                                              (##pair? _msg562580_))
                                            (let ((_tl573610_
                                                   (let ()
                                                     (declare (not safe))
                                                     (##cdr _msg562580_)))
                                                  (_hd572608_
                                                   (let ()
                                                     (declare (not safe))
                                                     (##car _msg562580_))))
                                              (if (let ()
                                                    (declare (not safe))
                                                    (##eq? _hd572608_ 'dump))
                                                  (if (let ()
                                                        (declare (not safe))
                                                        (##pair? _tl573610_))
                                                      (let ((_tl575615_
                                                             (let ()
                                                               (declare
;;<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
                         (not safe))
                       (##cdr _tl573610_)))
                    (_hd574613_
                     (let () (declare (not safe)) (##car _tl573610_))))
                (if (let () (declare (not safe)) (##null? _tl575615_))
                    (let ((_port618_ _hd574613_)) (_K571605_ _port618_))
                    (let ((_value597_ _msg562580_)) (_K570594_ _value597_))))
              (let ((_value597_ _msg562580_)) (_K570594_ _value597_)))
;;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
                                                  (let ((_value597_
                                                         _msg562580_))
                                                    (_K570594_ _value597_))))
                                            (let ((_value597_ _msg562580_))
                                              (_K570594_ _value597_)))))
                                     (_try-match565628_
                                      (lambda ()
                                        (if (let ()
                                              (declare (not safe))
                                              (##eq? _msg562580_ 'dump))
                                            (_K576625_)
                                            (_try-match566620_))))
                                     (_try-match564639_
                                      (lambda ()
                                        (if (thread? _msg562580_)
                                            (let ((_thread637_ _msg562580_))
                                              (_K577634_ _thread637_))
                                            (_try-match565628_)))))
                                (if (let ()
                                      (declare (not safe))
                                      (##structure-direct-instance-of?
                                       _msg562580_
                                       'std/actor/message#message::t))
                                    (let ((_msg688_ _msg562580_))
                                      (_K578685_ _msg688_))
                                    (_try-match564639_))))))
                        _next557_)))
                   (_loop489_)))
                (_dump!490_
                 (lambda (_port505_)
                   (call-with-parameters
                    (lambda ()
                      (displayln '"=== rpc-server ===")
                      (std/misc/sync#sync-hash-do
                       _actors477_
                       (lambda (_ht508_)
                         (displayln '"actors: " (table-length _ht508_))
                         (table-for-each
                          (lambda (_uuid510_ _actor-state511_)
                            (let* ((_actor-state512519_ _actor-state511_)
                                   (_E514523_
                                    (lambda ()
                                      (error '"No clause matching"
                                             _actor-state512519_)))
                                   (_K515529_
                                    (lambda (_proto526_ _actor527_)
                                      (displayln
                                       (std/misc/uuid#uuid->string _uuid510_)
                                       '" -> "
                                       (cons _actor527_
                                             (cons _proto526_ '()))))))
                              (if (let ((__tmp6517
                                         (if (let ()
                                               (declare (not safe))
                                               (##values? _actor-state512519_))
                                             (let ()
                                               (declare (not safe))
                                               (##vector-length
                                                _actor-state512519_))
                                             '1)))
                                    (declare (not safe))
                                    (##fx= __tmp6517 '2))
                                  (let* ((_e516532_
                                          (let ()
                                            (declare (not safe))
                                            (##vector-ref
                                             _actor-state512519_
                                             '0)))
                                         (_actor535_ _e516532_)
                                         (_e517537_
                                          (let ()
                                            (declare (not safe))
                                            (##vector-ref
                                             _actor-state512519_
                                             '1)))
                                         (_proto540_ _e517537_))
                                    (_K515529_ _proto540_ _actor535_))
                                  (_E514523_))))
                          _ht508_)))
                      (displayln
                       '"actor-threads: "
                       (table-length _actor-threads478_))
                      (table-for-each
                       (lambda (_thread542_ _uuids543_)
                         (displayln
                          _thread542_
                          '" -> "
                          (map std/misc/uuid#uuid->string _uuids543_)))
                       _actor-threads478_)
                      (displayln '"connections: " (table-length _conns479_))
                      (table-for-each
                       (lambda (_address545_ _conn546_)
                         (displayln _address545_ '" -> " _conn546_))
                       _conns479_)
                      (displayln '"monitors: " (table-length _monitors481_))
                      (table-for-each
                       (lambda (_conn548_ _mons549_)
                         (displayln _conn548_ '" -> " _mons549_))
                       _monitors481_))
                    current-output-port
                    _port505_))))
        (for-each std/actor/rpc/base#rpc-monitor _acceptors482_)
        (with-exception-catcher
         (lambda (_g491493_)
           (if '#t
               (let ((_e496_ _g491493_))
                 (for-each
                  (lambda (_g497499_)
                    (std/actor/message#send-message__0
                     _g497499_
                     (let ((__tmp6518
                            (let ()
                              (declare (not safe))
                              (##structure
                               std/actor/rpc/base#rpc.shutdown::t))))
                       (declare (not safe))
                       (##structure std/actor/proto#!event::t __tmp6518))))
                  (hash-keys _actor-threads478_))
                 (for-each std/net/socket/api#ssocket-close _socks471_)
                 (for-each
                  (lambda (_thread502_)
                    (thread-send _thread502_ 'shutdown)
                    (std/actor/message#send-message__0
                     _thread502_
                     (let ((__tmp6519
                            (let ()
                              (declare (not safe))
                              (##structure
                               std/actor/rpc/base#rpc.connection-close::t))))
                       (declare (not safe))
                       (##structure std/actor/proto#!event::t __tmp6519))))
                  (hash-keys _threads480_))
                 (for-each thread-join! (hash-keys _threads480_))
                 (std/actor/rpc/connection#rpc-send-error-responses
                  '"server shutdown")
                 (raise _e496_))
               (raise _g491493_)))
         (lambda () (_loop489_))))))
  (define std/actor/rpc/server#rpc-server-accept
    (lambda (_rpc-server444_ _sock445_ _safamily446_)
      (letrec ((_loop448_
                (lambda ()
                  (let* ((_cliaddr464_
                          (std/os/socket#make-socket-address _safamily446_))
                         (_clisock466_
                          (std/net/socket/api#ssocket-accept__1
                           _sock445_
                           _cliaddr464_)))
                    (std/logger#debug
                     '"accepted connection from ~a"
                     (let ((_clistr469_
                            (std/os/socket#socket-address->string
                             _cliaddr464_)))
                       (if (string-empty? _clistr469_) '"?" _clistr469_)))
                    (std/actor/message#send-message__0
                     _rpc-server444_
                     (let ((__tmp6520
                            (let ()
                              (declare (not safe))
                              (##structure
                               std/actor/rpc/base#rpc.connection-accept::t
                               _clisock466_
                               _cliaddr464_))))
                       (declare (not safe))
                       (##structure std/actor/proto#!event::t __tmp6520)))
                    (_loop448_)))))
        (let _again450_ ()
          (with-exception-catcher
           (lambda (_g452454_)
             (if ((lambda (_$obj457_) (os-exception? _$obj457_)) _g452454_)
                 (let ((_e460_ _g452454_))
                   (std/logger#log-error '"error accepting connection" _e460_)
                   (_again450_))
                 (raise _g452454_)))
           (lambda () (_loop448_))))))))
