/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildQueue;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.BuildingType;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.Consumer;
import net.sf.freecol.common.model.Disaster;
import net.sf.freecol.common.model.ExportData;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Nameable;
import net.sf.freecol.common.model.Occupation;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ProductionCache;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.RandomRange;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Stance;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.TradeLocation;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.RandomChoice;

public class Colony
extends Settlement
implements Nameable,
TradeLocation {
    private static final Logger logger = Logger.getLogger(Colony.class.getName());
    public static final String REARRANGE_WORKERS = "rearrangeWorkers";
    public static final int LIBERTY_PER_REBEL = 200;
    public static final int FAMINE_TURNS = 3;
    protected final Map<String, Building> buildingMap = new HashMap<String, Building>();
    protected final List<ColonyTile> colonyTiles = new ArrayList<ColonyTile>();
    protected final Map<String, ExportData> exportData = new HashMap<String, ExportData>();
    protected int liberty;
    protected int sonsOfLiberty;
    protected int oldSonsOfLiberty;
    protected int tories;
    protected int oldTories;
    protected int productionBonus;
    protected int immigration;
    protected Turn established = new Turn(0);
    protected final BuildQueue<BuildableType> buildQueue = new BuildQueue(this, BuildQueue.CompletionAction.REMOVE_EXCEPT_LAST, 500);
    protected final BuildQueue<UnitType> populationQueue = new BuildQueue(this, BuildQueue.CompletionAction.SHUFFLE, 300);
    protected int displayUnitCount = -1;
    private final ProductionCache productionCache = new ProductionCache(this);
    private boolean traceOccupation = false;
    private static final String BUILD_QUEUE_TAG = "buildQueueItem";
    private static final String ESTABLISHED_TAG = "established";
    private static final String IMMIGRATION_TAG = "immigration";
    private static final String LIBERTY_TAG = "liberty";
    private static final String PRODUCTION_BONUS_TAG = "productionBonus";
    private static final String NAME_TAG = "name";
    private static final String OLD_SONS_OF_LIBERTY_TAG = "oldSonsOfLiberty";
    private static final String OLD_TORIES_TAG = "oldTories";
    private static final String POPULATION_QUEUE_TAG = "populationQueueItem";
    private static final String SONS_OF_LIBERTY_TAG = "sonsOfLiberty";
    private static final String TORIES_TAG = "tories";
    private static final String UNIT_COUNT_TAG = "unitCount";

    protected Colony(Game game, Player owner, String name, Tile tile) {
        super(game, owner, name, tile);
    }

    public Colony(Game game, String id) {
        super(game, id);
    }

    public List<Building> getBuildings() {
        return new ArrayList<Building>(this.buildingMap.values());
    }

    public Building getBuilding(BuildingType type) {
        return this.buildingMap.get(type.getFirstLevel().getId());
    }

    public List<ColonyTile> getColonyTiles() {
        return this.colonyTiles;
    }

    public ColonyTile getColonyTile(Tile t) {
        return CollectionUtils.find(this.colonyTiles, ct -> ct.getWorkTile() == t);
    }

    public ExportData getExportData(GoodsType goodsType) {
        ExportData result = this.exportData.get(goodsType.getId());
        if (result == null) {
            result = new ExportData(goodsType);
            this.setExportData(result);
        }
        return result;
    }

    public final void setExportData(ExportData newExportData) {
        this.exportData.put(newExportData.getId(), newExportData);
    }

    public int getLiberty() {
        return this.liberty;
    }

    public int getProductionBonus() {
        return this.productionBonus;
    }

    public int getImmigration() {
        return this.immigration;
    }

    public void modifyImmigration(int amount) {
        this.immigration += amount;
    }

    public Turn getEstablished() {
        return this.established;
    }

    public void setEstablished(Turn newEstablished) {
        this.established = newEstablished;
    }

    public List<BuildableType> getBuildQueue() {
        return this.buildQueue.getValues();
    }

    public void setBuildQueue(List<BuildableType> newBuildQueue) {
        this.buildQueue.setValues(newBuildQueue);
    }

    public boolean getOccupationTrace() {
        return this.traceOccupation;
    }

    public boolean setOccupationTrace(boolean trace) {
        boolean ret = this.traceOccupation;
        this.traceOccupation = trace;
        return ret;
    }

    private void accumulateChoices(Collection<GoodsType> workTypes, Collection<GoodsType> tried, List<Collection<GoodsType>> result) {
        workTypes.removeAll(tried);
        if (!workTypes.isEmpty()) {
            result.add(workTypes);
            tried.addAll(workTypes);
        }
    }

    private void accumulateChoice(GoodsType workType, Collection<GoodsType> tried, List<Collection<GoodsType>> result) {
        if (workType == null) {
            return;
        }
        this.accumulateChoices(workType.getEquivalentTypes(), tried, result);
    }

    public List<Collection<GoodsType>> getWorkTypeChoices(Unit unit, boolean userMode) {
        Specification spec = this.getSpecification();
        ArrayList<Collection<GoodsType>> result = new ArrayList<Collection<GoodsType>>();
        HashSet<GoodsType> tried = new HashSet<GoodsType>();
        HashSet<GoodsType> food = new HashSet<GoodsType>();
        HashSet<GoodsType> nonFood = new HashSet<GoodsType>();
        for (AbstractGoods ag : unit.getType().getConsumedGoods()) {
            if (this.productionCache.getNetProductionOf(ag.getType()) >= ag.getAmount()) continue;
            if (ag.getType().isFoodType()) {
                food.addAll(ag.getType().getEquivalentTypes());
                continue;
            }
            nonFood.addAll(ag.getType().getEquivalentTypes());
        }
        if (userMode) {
            this.accumulateChoice(unit.getWorkType(), tried, result);
            this.accumulateChoice(unit.getType().getExpertProduction(), tried, result);
            this.accumulateChoice(unit.getExperienceType(), tried, result);
            this.accumulateChoices(food, tried, result);
            this.accumulateChoices(nonFood, tried, result);
        } else {
            this.accumulateChoices(food, tried, result);
            this.accumulateChoices(nonFood, tried, result);
            this.accumulateChoice(unit.getWorkType(), tried, result);
            this.accumulateChoice(unit.getType().getExpertProduction(), tried, result);
            this.accumulateChoice(unit.getExperienceType(), tried, result);
        }
        this.accumulateChoices(spec.getFoodGoodsTypeList(), tried, result);
        this.accumulateChoices(spec.getNewWorldLuxuryGoodsTypeList(), tried, result);
        this.accumulateChoices(spec.getGoodsTypeList(), tried, result);
        return result;
    }

    private Occupation getOccupationFor(Unit unit, Collection<GoodsType> workTypes, LogBuilder lb) {
        if (workTypes.isEmpty()) {
            return null;
        }
        Occupation best = new Occupation(null, null, null);
        int bestAmount = 0;
        for (WorkLocation wl : this.getCurrentWorkLocations()) {
            bestAmount = best.improve(unit, wl, bestAmount, workTypes, lb);
        }
        if (best.workLocation != null) {
            lb.add("\n  => ", best, " = ", bestAmount);
        }
        return best.workLocation == null ? null : best;
    }

    private Occupation getOccupationFor(Unit unit, boolean userMode, LogBuilder lb) {
        for (Collection<GoodsType> types : this.getWorkTypeChoices(unit, userMode)) {
            lb.add("\n  ");
            FreeColObject.logFreeColObjects(types, lb);
            Occupation occupation = this.getOccupationFor(unit, types, lb);
            if (occupation == null) continue;
            return occupation;
        }
        lb.add("\n  => FAILED");
        return null;
    }

    private Occupation getOccupationFor(Unit unit, Collection<GoodsType> workTypes) {
        LogBuilder lb = new LogBuilder(this.getOccupationTrace() ? 64 : 0);
        lb.add(this.getName(), ".getOccupationFor(", unit, ", ");
        FreeColObject.logFreeColObjects(workTypes, lb);
        lb.add(")");
        Occupation occupation = this.getOccupationFor(unit, workTypes, lb);
        lb.log(logger, Level.WARNING);
        return occupation;
    }

    private Occupation getOccupationFor(Unit unit, boolean userMode) {
        LogBuilder lb = new LogBuilder(this.getOccupationTrace() ? 64 : 0);
        lb.add(this.getName(), ".getOccupationFor(", unit, ")");
        Occupation occupation = this.getOccupationFor(unit, userMode, lb);
        lb.log(logger, Level.WARNING);
        return occupation;
    }

    private Stream<WorkLocation> getAllWorkLocationsStream() {
        return Stream.concat(this.colonyTiles.stream(), this.buildingMap.values().stream());
    }

    public List<WorkLocation> getAllWorkLocations() {
        return this.getAllWorkLocationsStream().collect(Collectors.toList());
    }

    public List<WorkLocation> getAvailableWorkLocations() {
        return this.getAllWorkLocationsStream().filter(WorkLocation::isAvailable).collect(Collectors.toList());
    }

    public List<WorkLocation> getCurrentWorkLocations() {
        return this.getAllWorkLocationsStream().filter(WorkLocation::isCurrent).collect(Collectors.toList());
    }

    public boolean addBuilding(Building building) {
        if (building == null || building.getType() == null) {
            return false;
        }
        BuildingType buildingType = building.getType().getFirstLevel();
        if (buildingType == null || buildingType.getId() == null) {
            return false;
        }
        this.buildingMap.put(buildingType.getId(), building);
        this.addFeatures(building.getType());
        return true;
    }

    protected boolean removeBuilding(Building building) {
        BuildingType buildingType = building.getType().getFirstLevel();
        if (this.buildingMap.remove(buildingType.getId()) == null) {
            return false;
        }
        this.removeFeatures(building.getType());
        return true;
    }

    public Building getBuildingForProducing(GoodsType goodsType) {
        for (Building b : this.buildingMap.values()) {
            if (AbstractGoods.findByType(goodsType, b.getOutputs()) == null) continue;
            return b;
        }
        return null;
    }

    public WorkLocation getWorkLocationWithAbility(String ability) {
        for (WorkLocation wl : this.getCurrentWorkLocations()) {
            if (!wl.hasAbility(ability)) continue;
            return wl;
        }
        return null;
    }

    public <T extends WorkLocation> T getWorkLocationWithAbility(String ability, Class<T> returnClass) {
        WorkLocation wl = this.getWorkLocationWithAbility(ability);
        if (wl != null) {
            try {
                return (T)((WorkLocation)returnClass.cast(wl));
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return null;
    }

    public WorkLocation getWorkLocationWithModifier(String modifier) {
        for (WorkLocation wl : this.getCurrentWorkLocations()) {
            if (!wl.hasModifier(modifier)) continue;
            return wl;
        }
        return null;
    }

    public <T extends WorkLocation> T getWorkLocationWithModifier(String modifier, Class<T> returnClass) {
        WorkLocation wl = this.getWorkLocationWithModifier(modifier);
        if (wl != null) {
            try {
                return (T)((WorkLocation)returnClass.cast(wl));
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return null;
    }

    public List<WorkLocation> getWorkLocationsForConsuming(GoodsType goodsType) {
        return this.getCurrentWorkLocations().stream().filter(wl -> CollectionUtils.any(wl.getInputs(), ag -> ag.getType() == goodsType)).collect(Collectors.toList());
    }

    public List<WorkLocation> getWorkLocationsForProducing(GoodsType goodsType) {
        return this.getCurrentWorkLocations().stream().filter(wl -> CollectionUtils.any(wl.getOutputs(), ag -> ag.getType() == goodsType)).collect(Collectors.toList());
    }

    public WorkLocation getWorkLocationForProducing(GoodsType goodsType) {
        List<WorkLocation> wls = this.getWorkLocationsForProducing(goodsType);
        return wls.isEmpty() ? null : wls.get(0);
    }

    public WorkLocation getWorkLocationFor(Unit unit, GoodsType goodsType) {
        if (goodsType == null) {
            return this.getWorkLocationFor(unit);
        }
        Occupation occupation = this.getOccupationFor(unit, goodsType.getEquivalentTypes());
        return occupation == null ? null : occupation.workLocation;
    }

    public WorkLocation getWorkLocationFor(Unit unit) {
        Occupation occupation = this.getOccupationFor(unit, false);
        return occupation == null ? null : occupation.workLocation;
    }

    public boolean isTileInUse(Tile tile) {
        ColonyTile colonyTile = this.getColonyTile(tile);
        return colonyTile != null && !colonyTile.isEmpty();
    }

    public Building getWarehouse() {
        return this.getWorkLocationWithModifier("model.modifier.warehouseStorage", Building.class);
    }

    public boolean hasStockade() {
        return this.getStockade() != null;
    }

    public Building getStockade() {
        return this.getWorkLocationWithModifier("model.modifier.defence", Building.class);
    }

    public String getStockadeKey() {
        Building stockade = this.getStockade();
        return stockade == null ? null : stockade.getType().getSuffix();
    }

    public List<RandomChoice<Disaster>> getDisasters() {
        ArrayList<RandomChoice<Disaster>> disasters = new ArrayList<RandomChoice<Disaster>>();
        for (ColonyTile tile : this.colonyTiles) {
            disasters.addAll(tile.getWorkTile().getDisasters());
        }
        return disasters;
    }

    public boolean isAutomaticBuild(BuildingType buildingType) {
        float value = this.owner.applyModifiers(100.0f, this.getGame().getTurn(), "model.modifier.buildingPriceBonus", buildingType);
        return value == 0.0f && this.canBuild(buildingType);
    }

    public List<UnitType> getBuildableUnits() {
        return this.getSpecification().getUnitTypeList().stream().filter(ut -> ut.needsGoodsToBuild() && this.canBuild((BuildableType)ut)).collect(Collectors.toList());
    }

    public int getTurnsToComplete(BuildableType buildable) {
        return this.getTurnsToComplete(buildable, null);
    }

    public int getTurnsToComplete(BuildableType buildable, AbstractGoods needed) {
        List<AbstractGoods> required = buildable.getRequiredGoods();
        int turns = 0;
        int satisfied = 0;
        int failing = 0;
        int underway = 0;
        ProductionInfo info = this.productionCache.getProductionInfo(this.buildQueue);
        for (AbstractGoods ag : required) {
            AbstractGoods consumption;
            GoodsType type = ag.getType();
            int amountNeeded = ag.getAmount();
            int amountAvailable = this.getGoodsCount(type);
            if (amountAvailable >= amountNeeded) {
                ++satisfied;
                continue;
            }
            int production = this.productionCache.getNetProductionOf(type);
            if (info != null && (consumption = AbstractGoods.findByType(type, info.getConsumption())) != null) {
                production += consumption.getAmount();
            }
            if (production <= 0) {
                ++failing;
                if (needed == null) continue;
                needed.setType(type);
                needed.setAmount(amountNeeded - amountAvailable);
                continue;
            }
            ++underway;
            int amountRemaining = amountNeeded - amountAvailable;
            int eta = amountRemaining / production;
            if (amountRemaining % production != 0) {
                ++eta;
            }
            turns = Math.max(turns, eta);
        }
        return satisfied + underway == required.size() ? turns : (failing == required.size() ? Integer.MIN_VALUE : -(turns + 1));
    }

    public boolean canBreed(GoodsType goodsType) {
        int breedingNumber = goodsType.getBreedingNumber();
        return breedingNumber < Integer.MAX_VALUE && breedingNumber <= this.getGoodsCount(goodsType);
    }

    public BuildableType getCurrentlyBuilding() {
        return this.buildQueue.getCurrentlyBuilding();
    }

    public void setCurrentlyBuilding(BuildableType buildable) {
        this.buildQueue.setCurrentlyBuilding(buildable);
    }

    public boolean canBuild() {
        return this.canBuild(this.getCurrentlyBuilding());
    }

    public boolean canBuild(BuildableType buildableType) {
        return this.getNoBuildReason(buildableType, null) == NoBuildReason.NONE;
    }

    public NoBuildReason getNoBuildReason(BuildableType buildableType, List<BuildableType> assumeBuilt) {
        if (buildableType == null) {
            return NoBuildReason.NOT_BUILDING;
        }
        if (!buildableType.needsGoodsToBuild()) {
            return NoBuildReason.NOT_BUILDABLE;
        }
        if (buildableType.getRequiredPopulation() > this.getUnitCount()) {
            return NoBuildReason.POPULATION_TOO_SMALL;
        }
        if (buildableType.hasAbility("model.ability.coastalOnly") && !this.getTile().isCoastland()) {
            return NoBuildReason.COASTAL;
        }
        if (!CollectionUtils.all(buildableType.getRequiredAbilities().entrySet(), e -> ((Boolean)e.getValue()).booleanValue() == this.hasAbility((String)e.getKey()))) {
            return NoBuildReason.MISSING_ABILITY;
        }
        if (!CollectionUtils.all(buildableType.getLimits(), l -> l.evaluate(this))) {
            return NoBuildReason.LIMIT_EXCEEDED;
        }
        if (assumeBuilt == null) {
            assumeBuilt = Collections.emptyList();
        }
        if (buildableType instanceof BuildingType) {
            BuildingType from;
            BuildingType newBuildingType = (BuildingType)buildableType;
            Building colonyBuilding = this.getBuilding(newBuildingType);
            if (colonyBuilding == null ? (from = newBuildingType.getUpgradesFrom()) != null && !assumeBuilt.contains(from) : (from = colonyBuilding.getType().getUpgradesTo()) != newBuildingType && !assumeBuilt.contains(from)) {
                return NoBuildReason.WRONG_UPGRADE;
            }
        } else if (buildableType instanceof UnitType && !buildableType.hasAbility("model.ability.person") && !this.hasAbility("model.ability.build", buildableType) && CollectionUtils.none(assumeBuilt, bt -> bt.hasAbility("model.ability.build", buildableType))) {
            return NoBuildReason.MISSING_BUILD_ABILITY;
        }
        return NoBuildReason.NONE;
    }

    public int getPriceForBuilding() {
        return this.getPriceForBuilding(this.getCurrentlyBuilding());
    }

    public int getPriceForBuilding(BuildableType type) {
        return this.priceGoodsForBuilding(this.getRequiredGoods(type));
    }

    public int priceGoodsForBuilding(List<AbstractGoods> required) {
        Market market = this.getOwner().getMarket();
        return required.stream().mapToInt(ag -> ag.getType().isStorable() ? market.getBidPrice(ag.getType(), ag.getAmount()) * 110 / 100 : ag.getType().getPrice() * ag.getAmount()).sum();
    }

    public List<AbstractGoods> getRequiredGoods(BuildableType type) {
        ArrayList<AbstractGoods> result = new ArrayList<AbstractGoods>();
        for (AbstractGoods goods : type.getRequiredGoods()) {
            GoodsType goodsType = goods.getType();
            int remaining = goods.getAmount() - this.getGoodsCount(goodsType);
            if (remaining <= 0) continue;
            result.add(new AbstractGoods(goodsType, remaining));
        }
        return result;
    }

    public List<AbstractGoods> getFullRequiredGoods(BuildableType buildable) {
        if (buildable == null) {
            return Collections.emptyList();
        }
        ArrayList<AbstractGoods> required = new ArrayList<AbstractGoods>();
        for (AbstractGoods ag : buildable.getRequiredGoods()) {
            int amount = ag.getAmount();
            for (GoodsType type = ag.getType(); type != null && amount > this.getGoodsCount(type); type = type.getInputType()) {
                required.add(0, new AbstractGoods(type, amount - this.getGoodsCount(type)));
            }
        }
        return required;
    }

    public boolean canPayToFinishBuilding() {
        return this.canPayToFinishBuilding(this.getCurrentlyBuilding());
    }

    public boolean canPayToFinishBuilding(BuildableType buildableType) {
        return buildableType != null && this.getOwner().checkGold(this.getPriceForBuilding(buildableType));
    }

    public void addLiberty(int amount) {
        List<GoodsType> libertyTypeList = this.getSpecification().getLibertyGoodsTypeList();
        int uc = this.getUnitCount();
        if (Colony.calculateRebels(uc, this.sonsOfLiberty) <= uc + 1 && amount > 0 && !libertyTypeList.isEmpty()) {
            this.addGoods(libertyTypeList.get(0), amount);
        }
        this.updateSoL();
        this.updateProductionBonus();
    }

    public void modifyLiberty(int amount) {
        this.getOwner().modifyLiberty(amount);
        this.liberty += amount;
        this.liberty = Math.max(0, this.liberty);
        this.updateSoL();
        this.updateProductionBonus();
        boolean capped = this.getSpecification().getBoolean("model.option.bellAccumulationCapped");
        if (capped && this.sonsOfLiberty >= 100) {
            this.liberty = 200 * this.getUnitCount();
        }
    }

    public void updateSoL() {
        int uc = this.getUnitCount();
        this.oldSonsOfLiberty = this.sonsOfLiberty;
        this.oldTories = this.tories;
        this.sonsOfLiberty = this.calculateSoLPercentage(uc, this.getLiberty());
        this.tories = uc - Colony.calculateRebels(uc, this.sonsOfLiberty);
    }

    private int calculateSoLPercentage(int uc, int liberty) {
        if (uc <= 0) {
            return -1;
        }
        float membership = (float)liberty * 100.0f / (float)(200 * uc);
        if ((membership = Colony.applyModifiers(membership, this.getGame().getTurn(), this.getOwner().getModifiers("model.modifier.SoL"))) < 0.0f) {
            membership = 0.0f;
        } else if (membership > 100.0f) {
            membership = 100.0f;
        }
        return (int)membership;
    }

    public int getSoLPercentage() {
        return this.calculateSoLPercentage(this.getUnitCount(), this.getLiberty());
    }

    public static int calculateRebels(int uc, int solPercent) {
        return (int)Math.floor(0.01 * (double)solPercent * (double)uc);
    }

    public int getTory() {
        return 100 - this.getSoL();
    }

    protected boolean updateProductionBonus() {
        int newBonus;
        Specification spec = this.getSpecification();
        int veryBadGovernment = spec.getInteger("model.option.veryBadGovernmentLimit");
        int badGovernment = spec.getInteger("model.option.badGovernmentLimit");
        int veryGoodGovernment = spec.getInteger("model.option.veryGoodGovernmentLimit");
        int goodGovernment = spec.getInteger("model.option.goodGovernmentLimit");
        int n = this.sonsOfLiberty >= veryGoodGovernment ? 2 : (this.sonsOfLiberty >= goodGovernment ? 1 : (this.tories > veryBadGovernment ? -2 : (newBonus = this.tories > badGovernment ? -1 : 0)));
        if (this.productionBonus != newBonus) {
            this.invalidateCache();
            this.productionBonus = newBonus;
            return true;
        }
        return false;
    }

    public int getPreferredSizeChange() {
        int i;
        int pop = this.getUnitCount();
        if (this.productionBonus < 0) {
            int i2;
            int limit = pop;
            for (i2 = 1; i2 < limit && this.governmentChange(pop - i2) != 1; ++i2) {
            }
            return -i2;
        }
        Specification spec = this.getSpecification();
        int limit = spec.getInteger("model.option.badGovernmentLimit");
        for (i = 1; i < limit && this.governmentChange(pop + i) != -1; ++i) {
        }
        return i - 1;
    }

    public boolean joinColony(Unit unit) {
        Occupation occupation = this.getOccupationFor(unit, false);
        if (occupation == null) {
            if (!this.traceOccupation) {
                LogBuilder lb = new LogBuilder(64);
                this.getOccupationFor(unit, false, lb);
                lb.log(logger, Level.WARNING);
            }
            return false;
        }
        return occupation.install(unit);
    }

    public boolean canReducePopulation() {
        return (float)this.getUnitCount() > this.applyModifiers(0.0f, this.getGame().getTurn(), "model.modifier.minimumColonySize");
    }

    public StringTemplate getReducePopulationMessage() {
        if (this.canReducePopulation()) {
            return null;
        }
        Set<Modifier> modifierSet = this.getModifiers("model.modifier.minimumColonySize");
        if (modifierSet.isEmpty()) {
            return null;
        }
        Modifier modifier = modifierSet.iterator().next();
        FreeColObject source = modifier.getSource();
        if (source instanceof BuildingType) {
            source = this.getBuilding((BuildingType)source).getType();
        }
        return StringTemplate.template("model.colony.minimumColonySize").addName("%object%", source);
    }

    public ModelMessage getUnbuildableMessage(BuildableType buildable) {
        return new ModelMessage(ModelMessage.MessageType.WARNING, "model.colony.unbuildable", this, buildable).addName("%colony%", this.getName()).addNamed("%object%", buildable);
    }

    public int governmentChange(int unitCount) {
        Specification spec = this.getSpecification();
        int veryBadGovernment = spec.getInteger("model.option.veryBadGovernmentLimit");
        int badGovernment = spec.getInteger("model.option.badGovernmentLimit");
        int veryGoodGovernment = spec.getInteger("model.option.veryGoodGovernmentLimit");
        int goodGovernment = spec.getInteger("model.option.goodGovernmentLimit");
        int rebelPercent = this.calculateSoLPercentage(unitCount, this.getLiberty());
        int rebelCount = Colony.calculateRebels(unitCount, rebelPercent);
        int loyalistCount = unitCount - rebelCount;
        int result = 0;
        if (rebelPercent >= veryGoodGovernment) {
            if (this.sonsOfLiberty < veryGoodGovernment) {
                result = 1;
            }
        } else if (rebelPercent >= goodGovernment) {
            if (this.sonsOfLiberty >= veryGoodGovernment) {
                result = -1;
            } else if (this.sonsOfLiberty < goodGovernment) {
                result = 1;
            }
        } else if (this.sonsOfLiberty >= goodGovernment) {
            result = -1;
        } else if (loyalistCount > veryBadGovernment) {
            if (this.tories <= veryBadGovernment) {
                result = -1;
            }
        } else if (loyalistCount > badGovernment) {
            if (this.tories <= badGovernment) {
                result = -1;
            } else if (this.tories > veryBadGovernment) {
                result = 1;
            }
        } else if (this.tories > badGovernment) {
            result = 1;
        }
        return result;
    }

    public ModelMessage checkForGovMgtChangeMessage() {
        Specification spec = this.getSpecification();
        int veryBadGovernment = spec.getInteger("model.option.veryBadGovernmentLimit");
        int badGovernment = spec.getInteger("model.option.badGovernmentLimit");
        int veryGoodGovernment = spec.getInteger("model.option.veryGoodGovernmentLimit");
        int goodGovernment = spec.getInteger("model.option.goodGovernmentLimit");
        String msgId = null;
        int number = 0;
        ModelMessage.MessageType msgType = ModelMessage.MessageType.GOVERNMENT_EFFICIENCY;
        if (this.sonsOfLiberty >= veryGoodGovernment) {
            if (this.oldSonsOfLiberty < veryGoodGovernment) {
                msgId = "model.colony.veryGoodGovernment";
                msgType = ModelMessage.MessageType.SONS_OF_LIBERTY;
                number = veryGoodGovernment;
            }
        } else if (this.sonsOfLiberty >= goodGovernment) {
            if (this.oldSonsOfLiberty == veryGoodGovernment) {
                msgId = "model.colony.lostVeryGoodGovernment";
                msgType = ModelMessage.MessageType.SONS_OF_LIBERTY;
                number = veryGoodGovernment;
            } else if (this.oldSonsOfLiberty < goodGovernment) {
                msgId = "model.colony.goodGovernment";
                msgType = ModelMessage.MessageType.SONS_OF_LIBERTY;
                number = goodGovernment;
            }
        } else {
            if (this.oldSonsOfLiberty >= goodGovernment) {
                msgId = "model.colony.lostGoodGovernment";
                msgType = ModelMessage.MessageType.SONS_OF_LIBERTY;
                number = goodGovernment;
            }
            if (this.tories > veryBadGovernment) {
                if (this.oldTories <= veryBadGovernment) {
                    msgId = "model.colony.veryBadGovernment";
                }
            } else if (this.tories > badGovernment) {
                if (this.oldTories <= badGovernment) {
                    msgId = "model.colony.badGovernment";
                } else if (this.oldTories > veryBadGovernment) {
                    msgId = "model.colony.governmentImproved1";
                }
            } else if (this.oldTories > badGovernment) {
                msgId = "model.colony.governmentImproved2";
            }
        }
        GoodsType bells = this.getSpecification().getGoodsType("model.goods.bells");
        return msgId == null ? null : new ModelMessage(msgType, msgId, this, bells).addName("%colony%", this.getName()).addAmount("%number%", number);
    }

    public void updatePopulation() {
        this.updateSoL();
        this.updateProductionBonus();
        if (this.getOwner().isAI()) {
            this.firePropertyChange(REARRANGE_WORKERS, true, false);
        }
    }

    public void updateEducation(Unit unit, boolean enable) {
        WorkLocation wl = unit.getWorkLocation();
        if (wl == null) {
            throw new RuntimeException("updateEducation(" + unit + ") unit not at work location.");
        }
        if (wl.getColony() != this) {
            throw new RuntimeException("updateEducation(" + unit + ") unit not at work location in this colony.");
        }
        if (enable) {
            if (wl.canTeach()) {
                Unit student = unit.getStudent();
                if (student == null && (student = this.findStudent(unit)) != null) {
                    unit.setStudent(student);
                    student.setTeacher(unit);
                    unit.setTurnsOfTraining(0);
                    unit.changeWorkType(null);
                }
            } else {
                Unit teacher = unit.getTeacher();
                if (teacher == null && (teacher = this.findTeacher(unit)) != null) {
                    unit.setTeacher(teacher);
                    teacher.setStudent(unit);
                }
            }
        } else if (wl.canTeach()) {
            Unit student = unit.getStudent();
            if (student != null) {
                student.setTeacher(null);
                unit.setStudent(null);
                unit.setTurnsOfTraining(0);
            }
        } else {
            Unit teacher = unit.getTeacher();
            if (teacher != null) {
                teacher.setStudent(null);
                unit.setTeacher(null);
            }
        }
    }

    public boolean isUndead() {
        Unit u = this.getFirstUnit();
        return u != null && u.isUndead();
    }

    public int getDisplayUnitCount() {
        return this.displayUnitCount > 0 ? this.displayUnitCount : this.getUnitCount();
    }

    public void setDisplayUnitCount(int count) {
        this.displayUnitCount = count;
    }

    public UnitType getBestDefenderType() {
        UnitType bestDefender = null;
        for (UnitType unitType : this.getSpecification().getUnitTypeList()) {
            if (!(unitType.getDefence() > 0.0) || bestDefender != null && !(bestDefender.getDefence() < unitType.getDefence()) || unitType.hasAbility("model.ability.navalUnit") || !unitType.isAvailableTo(this.getOwner())) continue;
            bestDefender = unitType;
        }
        return bestDefender;
    }

    public double getTotalDefencePower() {
        CombatModel cm = this.getGame().getCombatModel();
        return this.getTile().getUnitList().stream().filter(Unit::isDefensiveUnit).mapToDouble(u -> cm.getDefencePower(null, (FreeColGameObject)u)).sum();
    }

    public boolean canBePillaged(Unit attacker) {
        return !this.hasStockade() && attacker.hasAbility("model.ability.pillageUnprotectedColony") && (!this.getBurnableBuildings().isEmpty() || !this.getTile().getNavalUnits().isEmpty() || !this.getLootableGoodsList().isEmpty() && attacker.getType().canCarryGoods() && attacker.hasSpaceLeft() || this.canBePlundered());
    }

    public boolean canBePlundered() {
        return this.owner.checkGold(1);
    }

    public List<Building> getBurnableBuildings() {
        return this.getBuildings().stream().filter(Building::canBeDamaged).collect(Collectors.toList());
    }

    public List<Goods> getLootableGoodsList() {
        return this.getGoodsContainer().getGoods().stream().filter(g -> g.getType().isStorable()).collect(Collectors.toList());
    }

    public boolean isUnderSiege() {
        int friendlyUnits = 0;
        int enemyUnits = 0;
        for (ColonyTile colonyTile : this.colonyTiles) {
            for (Unit unit : colonyTile.getWorkTile().getUnitList()) {
                if (unit.getOwner() == this.getOwner()) {
                    if (!unit.isDefensiveUnit()) continue;
                    ++friendlyUnits;
                    continue;
                }
                if (!this.getOwner().atWarWith(unit.getOwner()) || !unit.isOffensiveUnit()) continue;
                ++enemyUnits;
            }
        }
        return enemyUnits > friendlyUnits;
    }

    public int evaluateFor(Player player) {
        int result;
        if (player.isAI() && player.getNumberOfSettlements() < 5) {
            return Integer.MIN_VALUE;
        }
        if (player.owns(this)) {
            result = this.getAvailableWorkLocations().stream().mapToInt(wl -> wl.evaluateFor(player)).sum() + this.getTile().getUnitList().stream().mapToInt(u -> u.evaluateFor(player)).sum() + this.getCompactGoods().stream().mapToInt(g -> g.evaluateFor(player)).sum();
        } else {
            result = this.getDisplayUnitCount() * 1000 + 500 + 200 * (int)this.getTile().getSurroundingTiles(0, 1).stream().filter(t -> t.getOwningSettlement() == this).count();
            Building stockade = this.getStockade();
            if (stockade != null) {
                result *= stockade.getLevel();
            }
        }
        return result;
    }

    public boolean canTrain(Unit unit) {
        return this.canTrain(unit.getType());
    }

    public boolean canTrain(UnitType unitType) {
        return this.hasAbility("model.ability.teach") && CollectionUtils.any(this.buildingMap.values(), b -> b.canTeach() && b.canAddType(unitType));
    }

    public List<Unit> getTeachers() {
        ArrayList<Unit> teachers = new ArrayList<Unit>();
        for (Building building : this.buildingMap.values()) {
            if (!building.canTeach()) continue;
            teachers.addAll(building.getUnitList());
        }
        return teachers;
    }

    public Unit findTeacher(Unit student) {
        if (this.getSpecification().getBoolean("model.option.allowStudentSelection")) {
            return null;
        }
        for (Building building : this.getBuildings()) {
            if (!building.canTeach()) continue;
            for (Unit unit : building.getUnitList()) {
                if (unit.getStudent() != null || !student.canBeStudent(unit)) continue;
                return unit;
            }
        }
        return null;
    }

    public Unit findStudent(Unit teacher) {
        if (this.getSpecification().getBoolean("model.option.allowStudentSelection")) {
            return null;
        }
        Unit student = null;
        GoodsType expertProduction = teacher.getType().getExpertProduction();
        int skillLevel = Integer.MAX_VALUE;
        for (Unit potentialStudent : this.getUnitList()) {
            if (potentialStudent.getTeacher() != null || !potentialStudent.canBeStudent(teacher) || student != null && potentialStudent.getSkillLevel() >= skillLevel && (potentialStudent.getSkillLevel() != skillLevel || potentialStudent.getWorkType() != expertProduction)) continue;
            student = potentialStudent;
            skillLevel = student.getSkillLevel();
        }
        return student;
    }

    public boolean isProducing(GoodsType goodsType) {
        return this.productionCache.isProducing(goodsType);
    }

    public boolean isConsuming(GoodsType goodsType) {
        return this.productionCache.isConsuming(goodsType);
    }

    public List<Consumer> getConsumers() {
        ArrayList<Consumer> result = new ArrayList<Consumer>();
        result.addAll(this.getUnitList());
        result.addAll(this.buildingMap.values());
        result.add(this.buildQueue);
        result.add(this.populationQueue);
        Collections.sort(result, Consumer.COMPARATOR);
        return result;
    }

    @Override
    public int getConsumptionOf(GoodsType goodsType) {
        Specification spec = this.getSpecification();
        int result = super.getConsumptionOf(goodsType);
        if (spec.getGoodsType("model.goods.bells").equals(goodsType)) {
            result -= spec.getInteger("model.option.unitsThatUseNoBells");
        }
        return Math.max(0, result);
    }

    public int getFoodProduction() {
        return this.getSpecification().getFoodGoodsTypeList().stream().mapToInt(ft -> this.getTotalProductionOf((GoodsType)ft)).sum();
    }

    public int getStarvationTurns() {
        GoodsType foodType = this.getSpecification().getPrimaryFoodType();
        int food = this.getGoodsCount(foodType);
        int newFood = this.getAdjustedNetProductionOf(foodType);
        return newFood >= 0 ? -1 : food / -newFood;
    }

    public int getNewColonistTurns() {
        int newFood;
        GoodsType foodType = this.getSpecification().getPrimaryFoodType();
        int food = this.getGoodsCount(foodType);
        return food + (newFood = this.getAdjustedNetProductionOf(foodType)) >= 200 ? 1 : (newFood <= 0 ? -1 : (200 - food) / newFood + 1);
    }

    public List<Modifier> getProductionModifiers(GoodsType goodsType) {
        if (this.productionBonus == 0) {
            return Collections.emptyList();
        }
        Modifier mod = new Modifier(goodsType.getId(), this.productionBonus, Modifier.ModifierType.ADDITIVE, Specification.SOL_MODIFIER_SOURCE);
        mod.setModifierIndex(20);
        ArrayList<Modifier> result = new ArrayList<Modifier>();
        result.add(mod);
        return result;
    }

    public int getNetProductionOf(GoodsType goodsType) {
        return this.productionCache.getNetProductionOf(goodsType);
    }

    public boolean isProductive(WorkLocation workLocation) {
        ProductionInfo info = this.productionCache.getProductionInfo(workLocation);
        return info != null && info.getProduction() != null && !info.getProduction().isEmpty() && info.getProduction().get(0).getAmount() > 0;
    }

    public int getAdjustedNetProductionOf(GoodsType goodsType) {
        int result = this.productionCache.getNetProductionOf(goodsType);
        for (BuildQueue queue : new BuildQueue[]{this.buildQueue, this.populationQueue}) {
            ProductionInfo info = this.productionCache.getProductionInfo(queue);
            if (info == null) continue;
            result += AbstractGoods.getCount(goodsType, info.getConsumption());
        }
        return result;
    }

    protected TypeCountMap<GoodsType> getProductionMap() {
        return this.productionCache.getProductionMap();
    }

    public ProductionInfo getProductionInfo(Object object) {
        return this.productionCache.getProductionInfo(object);
    }

    public void invalidateCache() {
        this.productionCache.invalidate();
    }

    public boolean canProduce(GoodsType goodsType) {
        return this.getNetProductionOf(goodsType) > 0 ? true : (goodsType.isBreedable() ? this.getGoodsCount(goodsType) >= goodsType.getBreedingNumber() : CollectionUtils.any(this.getWorkLocationsForProducing(goodsType), wl -> wl.getGenericPotential(goodsType) > 0 && CollectionUtils.all(wl.getInputs(), ag -> this.canProduce(ag.getType()))));
    }

    public List<TileImprovementSuggestion> getTileImprovementSuggestions() {
        Specification spec = this.getSpecification();
        ArrayList<TileImprovementSuggestion> result = new ArrayList<TileImprovementSuggestion>();
        for (Tile tile : this.getTile().getSurroundingTiles(1)) {
            if (!tile.hasLostCityRumour()) continue;
            result.add(new TileImprovementSuggestion(tile, null, Integer.MAX_VALUE));
        }
        for (ColonyTile ct : this.getColonyTiles()) {
            Tile tile = ct.getWorkTile();
            if (tile == null || tile.getOwningSettlement() != this) continue;
            for (TileImprovementType t : spec.getTileImprovementTypeList()) {
                int improvement;
                if (t.isNatural() || (improvement = ct.improvedBy(t)) <= 0) continue;
                result.add(new TileImprovementSuggestion(tile, t, improvement));
            }
        }
        Collections.sort(result, TileImprovementSuggestion.descendingAmountComparator);
        return result;
    }

    public Unit getBetterExpert(Unit expert) {
        GoodsType production = expert.getWorkType();
        UnitType expertType = expert.getType();
        GoodsType expertise = expertType.getExpertProduction();
        Unit bestExpert = null;
        int bestImprovement = 0;
        if (production == null || expertise == null || production == expertise) {
            return null;
        }
        for (Unit nonExpert : this.getUnitList()) {
            int improvement;
            ColonyTile nwl;
            if (nonExpert.getWorkType() != expertise || nonExpert.getType() == expertType) continue;
            int expertProductionNow = 0;
            int nonExpertProductionNow = 0;
            int expertProductionPotential = 0;
            int nonExpertProductionPotential = 0;
            WorkLocation ewl = expert.getWorkLocation();
            if (ewl != null) {
                expertProductionNow = ewl.getPotentialProduction(expertise, expert.getType());
                nonExpertProductionPotential = ewl.getPotentialProduction(expertise, nonExpert.getType());
            }
            if ((nwl = nonExpert.getWorkTile()) != null) {
                nonExpertProductionNow = nwl.getPotentialProduction(expertise, nonExpert.getType());
                expertProductionPotential = nwl.getPotentialProduction(expertise, expertType);
            }
            if ((improvement = expertProductionPotential + nonExpertProductionPotential - expertProductionNow - nonExpertProductionNow) <= bestImprovement) continue;
            bestImprovement = improvement;
            bestExpert = nonExpert;
        }
        return bestExpert;
    }

    public Collection<StringTemplate> getProductionWarnings(GoodsType goodsType) {
        BuildableType currentlyBuilding;
        ArrayList<StringTemplate> result = new ArrayList<StringTemplate>();
        int amount = this.getGoodsCount(goodsType);
        int production = this.getNetProductionOf(goodsType);
        if (goodsType.isStorable()) {
            int waste;
            if (goodsType.limitIgnored()) {
                if (goodsType.isFoodType()) {
                    int starve = this.getStarvationTurns();
                    if (starve == 0) {
                        result.add(StringTemplate.template("model.colony.starving").addName("%colony%", this.getName()));
                    } else if (starve <= 3) {
                        result.add(StringTemplate.template("model.colony.famineFeared").addName("%colony%", this.getName()).addAmount("%number%", starve));
                    }
                }
            } else if (!this.getExportData(goodsType).getExported() && (waste = amount + production - this.getWarehouseCapacity()) > 0) {
                result.add(StringTemplate.template("model.building.warehouseSoonFull").addNamed("%goods%", goodsType).addName("%colony%", this.getName()).addAmount("%amount%", waste));
            }
        }
        if ((currentlyBuilding = this.getCurrentlyBuilding()) != null) {
            for (AbstractGoods goods : currentlyBuilding.getRequiredGoods()) {
                if (!goods.getType().equals(goodsType) || amount >= goods.getAmount()) continue;
                int needsAmount = goods.getAmount() - amount;
                result.add(StringTemplate.template("model.colony.buildableNeedsGoods").addName("%colony%", this.getName()).addNamed("%buildable%", currentlyBuilding).addAmount("%amount%", needsAmount).addNamed("%goodsType%", goodsType));
            }
        }
        for (WorkLocation wl : this.getWorkLocationsForProducing(goodsType)) {
            StringTemplate t;
            ProductionInfo info = this.getProductionInfo(wl);
            if (info == null || (t = this.getInsufficientProductionMessage(info, AbstractGoods.findByType(goodsType, info.getProductionDeficit()))) == null) continue;
            result.add(t);
        }
        for (WorkLocation wl : this.getWorkLocationsForConsuming(goodsType)) {
            List<AbstractGoods> deficit;
            ProductionInfo info = this.getProductionInfo(wl);
            if (info == null || (deficit = info.getProductionDeficit()).isEmpty()) continue;
            for (AbstractGoods ag : wl.getOutputs()) {
                StringTemplate t;
                if (ag.getType().isStorable() || (t = this.getInsufficientProductionMessage(info, AbstractGoods.findByType(ag.getType(), deficit))) == null) continue;
                result.add(t);
            }
        }
        return result;
    }

    private StringTemplate getInsufficientProductionMessage(ProductionInfo info, AbstractGoods deficit) {
        if (info == null || deficit == null) {
            return null;
        }
        List<AbstractGoods> input = info.getConsumptionDeficit();
        if (input.isEmpty()) {
            return null;
        }
        StringTemplate label = StringTemplate.label(", ");
        for (AbstractGoods ag : input) {
            label.addStringTemplate(ag.getLabel());
        }
        return StringTemplate.template("model.colony.insufficientProduction").addName("%colony%", this.getName()).addNamed("%outputType%", deficit.getType()).addAmount("%outputAmount%", deficit.getAmount()).addStringTemplate("%consumptionDeficit%", label);
    }

    public boolean goodsUseful(GoodsType goodsType) {
        return this.getOwner().getPlayerType() != Player.PlayerType.INDEPENDENT || (!goodsType.isLibertyType() || this.getSoLPercentage() < 100) && !goodsType.isImmigrationType();
    }

    private void modifySpecialGoods(GoodsType goodsType, int amount) {
        Turn turn = this.getGame().getTurn();
        Set<Modifier> mods = goodsType.getModifiers("model.modifier.liberty");
        if (!mods.isEmpty()) {
            int liberty = (int)Colony.applyModifiers(amount, turn, mods);
            this.modifyLiberty(liberty);
        }
        if (!(mods = goodsType.getModifiers("model.modifier.immigration")).isEmpty()) {
            int migration = (int)Colony.applyModifiers(amount, turn, mods);
            this.modifyImmigration(migration);
            this.getOwner().modifyImmigration(migration);
        }
    }

    public Colony copyColony() {
        Game game = this.getGame();
        Tile tile = this.getTile();
        Tile tileCopy = (Tile)tile.copy(game, tile.getClass());
        Colony colony = tileCopy.getColony();
        for (ColonyTile ct : colony.getColonyTiles()) {
            Tile wt;
            if (ct.isColonyCenterTile()) {
                wt = tileCopy;
            } else {
                wt = ct.getWorkTile();
                if ((wt = (Tile)wt.copy(game, wt.getClass())).getOwningSettlement() == this) {
                    wt.setOwningSettlement(colony);
                }
            }
            ct.setWorkTile(wt);
        }
        return colony;
    }

    public <T extends FreeColObject> T getCorresponding(T fco) {
        block6: {
            String id;
            block7: {
                block5: {
                    id = fco.getId();
                    if (!(fco instanceof WorkLocation)) break block5;
                    for (WorkLocation t : this.getAllWorkLocations()) {
                        if (!t.getId().equals(id)) continue;
                        return (T)t;
                    }
                    break block6;
                }
                if (!(fco instanceof Tile)) break block7;
                if (this.getTile().getId().equals(id)) {
                    return (T)this.getTile();
                }
                for (ColonyTile ct : this.getColonyTiles()) {
                    if (!ct.getWorkTile().getId().equals(id)) continue;
                    return (T)ct.getWorkTile();
                }
                break block6;
            }
            if (!(fco instanceof Unit)) break block6;
            for (Unit t : this.getUnitList()) {
                if (!t.getId().equals(id)) continue;
                return (T)t;
            }
            for (Unit t : this.getTile().getUnitList()) {
                if (!t.getId().equals(id)) continue;
                return (T)t;
            }
        }
        return null;
    }

    @Override
    public Set<Ability> getAbilities(String id, FreeColGameObjectType type, Turn turn) {
        if (turn == null) {
            turn = this.getGame().getTurn();
        }
        Set<Ability> result = super.getAbilities(id, type, turn);
        if (this.owner != null) {
            result.addAll(this.owner.getAbilities(id, type, turn));
        }
        return result;
    }

    @Override
    public List<FreeColGameObject> getDisposeList() {
        ArrayList<FreeColGameObject> objects = new ArrayList<FreeColGameObject>();
        for (WorkLocation workLocation : this.getAllWorkLocations()) {
            objects.addAll(workLocation.getDisposeList());
        }
        objects.addAll(super.getDisposeList());
        return objects;
    }

    @Override
    public StringTemplate getLocationLabelFor(Player player) {
        return StringTemplate.name(this.getName());
    }

    @Override
    public boolean add(Locatable locatable) {
        if (locatable instanceof Unit) {
            return this.joinColony((Unit)locatable);
        }
        return super.add(locatable);
    }

    @Override
    public boolean remove(Locatable locatable) {
        if (locatable instanceof Unit) {
            WorkLocation wl;
            Location loc = locatable.getLocation();
            if (loc instanceof WorkLocation && (wl = (WorkLocation)loc).getColony() == this) {
                return wl.remove(locatable);
            }
            return false;
        }
        return super.remove(locatable);
    }

    @Override
    public boolean contains(Locatable locatable) {
        if (locatable instanceof Unit) {
            return CollectionUtils.any(this.getAvailableWorkLocations(), wl -> wl.contains(locatable));
        }
        return super.contains(locatable);
    }

    @Override
    public int getUnitCount() {
        return this.getCurrentWorkLocations().stream().mapToInt(wl -> wl.getUnitCount()).sum();
    }

    @Override
    public List<Unit> getUnitList() {
        ArrayList<Unit> units = new ArrayList<Unit>();
        for (WorkLocation wl : this.getCurrentWorkLocations()) {
            units.addAll(wl.getUnitList());
        }
        return units;
    }

    @Override
    public Location up() {
        return this;
    }

    @Override
    public String toShortString() {
        return this.getName();
    }

    @Override
    public int getGoodsCapacity() {
        return (int)this.applyModifiers(0.0f, this.getGame().getTurn(), "model.modifier.warehouseStorage");
    }

    @Override
    public boolean addGoods(GoodsType type, int amount) {
        super.addGoods(type, amount);
        this.productionCache.invalidate(type);
        this.modifySpecialGoods(type, amount);
        return true;
    }

    @Override
    public Goods removeGoods(GoodsType type, int amount) {
        Goods removed = super.removeGoods(type, amount);
        this.productionCache.invalidate(type);
        if (removed != null) {
            this.modifySpecialGoods(type, -removed.getAmount());
        }
        return removed;
    }

    @Override
    public String getImageKey() {
        String key;
        if (this.isUndead()) {
            key = ".undead";
        } else {
            int count = this.getDisplayUnitCount();
            key = count <= 3 ? ".small" : (count <= 7 ? ".medium" : ".large");
            String stockade = this.getStockadeKey();
            if (stockade != null) {
                key = key + "." + stockade;
            }
        }
        return "image.tileitem." + this.getType().getId() + key;
    }

    @Override
    public Unit getDefendingUnit(Unit attacker) {
        if (this.displayUnitCount > 0) {
            return null;
        }
        List<Unit> unitList = this.getUnitList();
        Unit defender = null;
        double defencePower = -1.0;
        for (Unit nextUnit : unitList) {
            double unitPower;
            if (!Unit.betterDefender(defender, defencePower, nextUnit, unitPower = this.getGame().getCombatModel().getDefencePower(attacker, nextUnit))) continue;
            defender = nextUnit;
            defencePower = unitPower;
        }
        if (defender == null) {
            throw new IllegalStateException("Colony " + this.getName() + " contains no units!");
        }
        return defender;
    }

    @Override
    public double getDefenceRatio() {
        return this.getTotalDefencePower() / (double)(1 + this.getUnitCount());
    }

    @Override
    public boolean isBadlyDefended() {
        return this.getTotalDefencePower() < 0.95 * (double)this.getUnitCount() - 2.5;
    }

    @Override
    public RandomRange getPlunderRange(Unit attacker) {
        int upper;
        if (this.canBePlundered() && (upper = this.owner.getGold() * (this.getUnitCount() + 1) / (this.owner.getColoniesPopulation() + 1)) > 0) {
            return new RandomRange(100, 1, upper + 1, 1);
        }
        return null;
    }

    @Override
    public int getSoL() {
        return this.sonsOfLiberty;
    }

    @Override
    public int getUpkeep() {
        return this.buildingMap.values().stream().mapToInt(b -> b.getType().getUpkeep()).sum();
    }

    @Override
    public int getTotalProductionOf(GoodsType goodsType) {
        return this.getCurrentWorkLocations().stream().mapToInt(wl -> wl.getTotalProductionOf(goodsType)).sum();
    }

    @Override
    public boolean canProvideGoods(List<AbstractGoods> requiredGoods) {
        BuildableType buildable = this.getCurrentlyBuilding();
        for (AbstractGoods goods : requiredGoods) {
            int available = this.getGoodsCount(goods.getType());
            int breedingNumber = goods.getType().getBreedingNumber();
            if (breedingNumber != Integer.MAX_VALUE) {
                available -= breedingNumber;
            }
            if (buildable != null) {
                available -= AbstractGoods.getCount(goods.getType(), buildable.getRequiredGoods());
            }
            if (available >= goods.getAmount()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasContacted(Player player) {
        return player != null && (player.isEuropean() || this.getOwner().getStance(player) != Stance.UNCONTACTED);
    }

    @Override
    public StringTemplate getAlarmLevelLabel(Player player) {
        Stance stance = this.getOwner().getStance(player);
        return StringTemplate.template("model.colony." + stance.getKey()).addStringTemplate("%nation%", this.getOwner().getNationLabel());
    }

    @Override
    public int getExportAmount(GoodsType goodsType, int turns) {
        int present = Math.max(0, this.getGoodsCount(goodsType) + turns * this.getNetProductionOf(goodsType));
        ExportData ed = this.getExportData(goodsType);
        return Math.max(0, present - ed.getExportLevel());
    }

    @Override
    public int getImportAmount(GoodsType goodsType, int turns) {
        if (goodsType.limitIgnored()) {
            return 10000;
        }
        int present = Math.max(0, this.getGoodsCount(goodsType) + turns * this.getNetProductionOf(goodsType));
        int capacity = this.getWarehouseCapacity();
        return Math.max(0, capacity - present);
    }

    protected void addPortAbility() {
        this.addAbility(new Ability("model.ability.hasPort"));
    }

    public int checkBuildQueueIntegrity(boolean fix) {
        int result = 1;
        List<BuildableType> buildables = this.buildQueue.getValues();
        ArrayList<BuildableType> assumeBuilt = new ArrayList<BuildableType>();
        for (int i = 0; i < buildables.size(); ++i) {
            BuildableType bt = buildables.get(i);
            NoBuildReason reason = this.getNoBuildReason(bt, assumeBuilt);
            if (reason == NoBuildReason.NONE) {
                assumeBuilt.add(bt);
                continue;
            }
            if (fix) {
                this.buildQueue.remove(i);
                result = Math.min(result, 0);
                continue;
            }
            result = -1;
        }
        List<UnitType> unitTypes = this.populationQueue.getValues();
        assumeBuilt.clear();
        for (int i = 0; i < unitTypes.size(); ++i) {
            UnitType ut = unitTypes.get(i);
            NoBuildReason reason = this.getNoBuildReason(ut, assumeBuilt);
            if (reason == NoBuildReason.NONE) {
                assumeBuilt.add(ut);
                continue;
            }
            if (fix) {
                this.populationQueue.remove(i);
                result = Math.min(result, 0);
                continue;
            }
            result = -1;
        }
        return result;
    }

    @Override
    public int checkIntegrity(boolean fix) {
        int result = super.checkIntegrity(fix);
        if (!this.isLandLocked() && !this.hasAbility("model.ability.hasPort")) {
            if (fix) {
                this.addPortAbility();
                result = Math.min(result, 0);
            } else {
                result = -1;
            }
        }
        return Math.min(result, this.checkBuildQueueIntegrity(fix));
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(NAME_TAG, this.getName());
        xw.writeAttribute(ESTABLISHED_TAG, this.established.getNumber());
        xw.writeAttribute(SONS_OF_LIBERTY_TAG, this.sonsOfLiberty);
        if (xw.validFor(this.getOwner())) {
            xw.writeAttribute(OLD_SONS_OF_LIBERTY_TAG, this.oldSonsOfLiberty);
            xw.writeAttribute(TORIES_TAG, this.tories);
            xw.writeAttribute(OLD_TORIES_TAG, this.oldTories);
            xw.writeAttribute(LIBERTY_TAG, this.liberty);
            xw.writeAttribute(IMMIGRATION_TAG, this.immigration);
            xw.writeAttribute(PRODUCTION_BONUS_TAG, this.productionBonus);
        } else {
            int uc = this.getDisplayUnitCount();
            if (uc <= 0) {
                logger.warning("Unit count fail: " + uc + " id=" + this.getId() + " unitCount=" + this.getUnitCount() + " scope=" + (Object)((Object)xw.getWriteScope()) + " player=" + xw.getWriteScope().getClient() + "\n" + FreeColDebugger.stackTraceToString());
            }
            xw.writeAttribute(UNIT_COUNT_TAG, uc);
        }
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        if (xw.validFor(this.getOwner())) {
            for (Map.Entry<String, ExportData> entry : CollectionUtils.mapEntriesByKey(this.exportData)) {
                entry.getValue().toXML(xw);
            }
            for (WorkLocation workLocation : Colony.getSortedCopy(this.getAllWorkLocations())) {
                workLocation.toXML(xw);
            }
            for (BuildableType buildableType : this.buildQueue.getValues()) {
                xw.writeStartElement(BUILD_QUEUE_TAG);
                xw.writeAttribute("id", buildableType);
                xw.writeEndElement();
            }
            for (BuildableType buildableType : this.populationQueue.getValues()) {
                xw.writeStartElement(POPULATION_QUEUE_TAG);
                xw.writeAttribute("id", buildableType);
                xw.writeEndElement();
            }
        } else {
            Building stockade = this.getStockade();
            if (stockade != null) {
                stockade.toXML(xw);
            }
        }
    }

    @Override
    public void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.established = new Turn(xr.getAttribute(ESTABLISHED_TAG, 0));
        this.sonsOfLiberty = xr.getAttribute(SONS_OF_LIBERTY_TAG, 0);
        this.oldSonsOfLiberty = xr.getAttribute(OLD_SONS_OF_LIBERTY_TAG, 0);
        this.tories = xr.getAttribute(TORIES_TAG, 0);
        this.oldTories = xr.getAttribute(OLD_TORIES_TAG, 0);
        this.liberty = xr.getAttribute(LIBERTY_TAG, 0);
        this.immigration = xr.getAttribute(IMMIGRATION_TAG, 0);
        this.productionBonus = xr.getAttribute(PRODUCTION_BONUS_TAG, 0);
        this.displayUnitCount = xr.getAttribute(UNIT_COUNT_TAG, -1);
    }

    @Override
    public void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        this.colonyTiles.clear();
        this.buildingMap.clear();
        this.exportData.clear();
        this.buildQueue.clear();
        this.populationQueue.clear();
        super.readChildren(xr);
        this.invalidateCache();
    }

    @Override
    public void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        Game game = this.getGame();
        String tag = xr.getLocalName();
        if (BUILD_QUEUE_TAG.equals(tag)) {
            BuildableType bt = xr.getType(spec, "id", BuildableType.class, null);
            if (bt != null) {
                this.buildQueue.add(bt);
            }
            xr.closeTag(BUILD_QUEUE_TAG);
        } else if (POPULATION_QUEUE_TAG.equals(xr.getLocalName())) {
            UnitType ut = xr.getType(spec, "id", UnitType.class, null);
            if (ut != null) {
                this.populationQueue.add(ut);
            }
            xr.closeTag(POPULATION_QUEUE_TAG);
        } else if (Building.getXMLElementTagName().equals(tag)) {
            this.addBuilding(xr.readFreeColGameObject(game, Building.class));
        } else if (ColonyTile.getXMLElementTagName().equals(tag)) {
            this.colonyTiles.add(xr.readFreeColGameObject(game, ColonyTile.class));
        } else if (ExportData.getXMLElementTagName().equals(tag)) {
            ExportData data = new ExportData(xr);
            this.exportData.put(data.getId(), data);
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public String getXMLTagName() {
        return Colony.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "colony";
    }

    public static class TileImprovementSuggestion {
        public static final Comparator<TileImprovementSuggestion> descendingAmountComparator = new Comparator<TileImprovementSuggestion>(){

            @Override
            public int compare(TileImprovementSuggestion tis1, TileImprovementSuggestion tis2) {
                int cmp = tis2.amount - tis1.amount;
                if (cmp == 0) {
                    cmp = tis2.tile.compareTo(tis1.tile);
                }
                return cmp;
            }
        };
        public Tile tile;
        public TileImprovementType tileImprovementType;
        public int amount;

        public TileImprovementSuggestion(Tile tile, TileImprovementType t, int amount) {
            this.tile = tile;
            this.tileImprovementType = t;
            this.amount = amount;
        }

        public boolean isExploration() {
            return this.tileImprovementType == null;
        }
    }

    public static enum NoBuildReason {
        NONE,
        NOT_BUILDING,
        NOT_BUILDABLE,
        POPULATION_TOO_SMALL,
        MISSING_BUILD_ABILITY,
        MISSING_ABILITY,
        WRONG_UPGRADE,
        COASTAL,
        LIMIT_EXCEEDED;

    }

    public static enum ColonyChangeEvent {
        POPULATION_CHANGE,
        PRODUCTION_CHANGE,
        BONUS_CHANGE,
        WAREHOUSE_CHANGE,
        BUILD_QUEUE_CHANGE,
        UNIT_TYPE_CHANGE;

    }
}

