/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.math.BigInteger;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.KDFCalculator;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.fips.ConcatenationKDFGenerator;
import org.bouncycastle.crypto.fips.FipsAES;
import org.bouncycastle.crypto.fips.FipsAgreementParameters;
import org.bouncycastle.crypto.fips.FipsAlgorithm;
import org.bouncycastle.crypto.fips.FipsEngineProvider;
import org.bouncycastle.crypto.fips.FipsKDFOperatorFactory;
import org.bouncycastle.crypto.fips.FipsParameters;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.fips.FipsTripleDES;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.crypto.fips.KDF2BytesGenerator;
import org.bouncycastle.crypto.fips.KDFCounterBytesGenerator;
import org.bouncycastle.crypto.fips.KDFDoublePipelineIterationBytesGenerator;
import org.bouncycastle.crypto.fips.KDFFeedbackBytesGenerator;
import org.bouncycastle.crypto.fips.MD5Digest;
import org.bouncycastle.crypto.fips.SelfTestExecutor;
import org.bouncycastle.crypto.fips.Utils;
import org.bouncycastle.crypto.fips.VariantKatTest;
import org.bouncycastle.crypto.internal.BlockCipher;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.EngineProvider;
import org.bouncycastle.crypto.internal.ExtendedDigest;
import org.bouncycastle.crypto.internal.Mac;
import org.bouncycastle.crypto.internal.StreamCipher;
import org.bouncycastle.crypto.internal.macs.HMac;
import org.bouncycastle.crypto.internal.modes.SICBlockCipher;
import org.bouncycastle.crypto.internal.params.KDFCounterParameters;
import org.bouncycastle.crypto.internal.params.KDFDoublePipelineIterationParameters;
import org.bouncycastle.crypto.internal.params.KDFFeedbackParameters;
import org.bouncycastle.crypto.internal.params.KDFParameters;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.crypto.internal.params.ParametersWithIV;
import org.bouncycastle.crypto.internal.test.BasicKatTest;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FipsKDF {
    private static final byte[] ZERO_BYTE = new byte[1];
    public static final CounterModeParametersBuilder COUNTER_MODE = new CounterModeParametersBuilder(new FipsAlgorithm("CounterMode"));
    public static final FeedbackModeParametersBuilder FEEDBACK_MODE = new FeedbackModeParametersBuilder(new FipsAlgorithm("FeedbackMode"));
    public static final DoublePipelineModeParametersBuilder DOUBLE_PIPELINE_ITERATION_MODE = new DoublePipelineModeParametersBuilder(new FipsAlgorithm("DoublePipelineIterationMode"));
    public static final SSHParametersBuilder SSH = new SSHParametersBuilder(new FipsAlgorithm("SSH"), SSHPRF.SHA1);
    public static final IKEv2ParametersBuilder IKEv2 = new IKEv2ParametersBuilder(new FipsAlgorithm("IKEv2"), IKEv2PRF.SHA1);
    public static final SRTPParametersBuilder SRTP = new SRTPParametersBuilder(new FipsAlgorithm("SRTP"), SRTPPRF.AES_CM);
    public static final TLSParametersBuilder TLS1_0 = new TLSParametersBuilder(new FipsAlgorithm("TLS1.0"));
    public static final TLSParametersBuilder TLS1_1 = new TLSParametersBuilder(new FipsAlgorithm("TLS1.1"));
    public static final TLSParametersWithPRFBuilder TLS1_2 = new TLSParametersWithPRFBuilder(new FipsAlgorithm("TLS1.2"), TLSPRF.SHA256_HMAC);
    public static final AgreementKDFParametersBuilder X963 = new AgreementKDFParametersBuilder(new FipsAlgorithm("X9.63"), AgreementKDFPRF.SHA1);
    public static final AgreementKDFParametersBuilder CONCATENATION = new AgreementKDFParametersBuilder(new FipsAlgorithm("Concatenation"), AgreementKDFPRF.SHA1);
    private static EngineProvider<Digest> md5Provider;

    private FipsKDF() {
    }

    private static byte[] buildFixedInput(byte[] byArray, byte[] byArray2, int n) {
        return Arrays.concatenate(byArray, ZERO_BYTE, byArray2, Pack.intToBigEndian(n));
    }

    private static FipsEngineProvider<Mac> createPRF(PRF pRF) {
        FipsEngineProvider<Mac> fipsEngineProvider = pRF == PRF.TRIPLEDES_CMAC ? FipsTripleDES.getMacProvider(FipsTripleDES.CMAC.getAlgorithm()) : (pRF == PRF.AES_CMAC ? FipsAES.getMacProvider(FipsAES.CMAC.getAlgorithm()) : FipsSHS.getMacProvider(pRF.algorithm));
        if (fipsEngineProvider == null) {
            throw new IllegalArgumentException("Unknown algorithm passed to FipsKDF.createPRF: " + (Object)((Object)pRF));
        }
        return fipsEngineProvider;
    }

    static byte[] processZBytes(byte[] byArray, FipsAgreementParameters fipsAgreementParameters) {
        PRF pRF = fipsAgreementParameters.getPrfAlgorithm();
        byte[] byArray2 = fipsAgreementParameters.salt;
        FipsAlgorithm fipsAlgorithm = fipsAgreementParameters.digestAlgorithm;
        AgreementOperatorFactory agreementOperatorFactory = new AgreementOperatorFactory();
        AgreementKDFParametersBuilder agreementKDFParametersBuilder = fipsAgreementParameters.kdfType;
        if (pRF == PRF.TRIPLEDES_CMAC && CryptoServicesRegistrar.isInApprovedOnlyMode()) {
            throw new FipsUnapprovedOperationError("Requested PRF has insufficient security level for approved mode: " + pRF.name());
        }
        if (pRF != null) {
            Mac mac = (Mac)FipsKDF.createPRF(pRF).createEngine();
            if (byArray2 == null) {
                if (mac instanceof HMac) {
                    mac.init(new KeyParameterImpl(new byte[((HMac)mac).getUnderlyingDigest().getByteLength()]));
                } else {
                    mac.init(new KeyParameterImpl(new byte[16]));
                }
            } else {
                mac.init(new KeyParameterImpl(Arrays.clone(byArray2)));
            }
            byte[] byArray3 = new byte[mac.getMacSize()];
            mac.update(byArray, 0, byArray.length);
            mac.doFinal(byArray3, 0);
            Arrays.fill(byArray, (byte)0);
            return byArray3;
        }
        if (fipsAlgorithm != null) {
            ExtendedDigest extendedDigest = FipsSHS.createDigest(fipsAlgorithm);
            byte[] byArray4 = new byte[extendedDigest.getDigestSize()];
            extendedDigest.update(byArray, 0, byArray.length);
            extendedDigest.doFinal(byArray4, 0);
            Arrays.fill(byArray, (byte)0);
            return byArray4;
        }
        if (agreementKDFParametersBuilder != null) {
            KDFCalculator<AgreementKDFParameters> kDFCalculator = agreementOperatorFactory.createKDFCalculator(agreementKDFParametersBuilder.using(byArray).withIV(byArray2));
            Arrays.fill(byArray, (byte)0);
            byte[] byArray5 = new byte[fipsAgreementParameters.outputSize];
            kDFCalculator.generateBytes(byArray5);
            return byArray5;
        }
        return byArray;
    }

    private static byte[] PRF(TLSParameters tLSParameters, TLSPRF tLSPRF, byte[] byArray, String string, int n) {
        byte[] byArray2 = Strings.toByteArray(string);
        byte[] byArray3 = Arrays.concatenate(byArray2, tLSParameters.seed);
        Mac mac = FipsSHS.createHMac(tLSPRF.algorithm);
        byte[] byArray4 = new byte[n];
        FipsKDF.hmac_hash(mac, byArray, byArray3, byArray4);
        return byArray4;
    }

    private static byte[] PRF_legacy(TLSParameters tLSParameters, byte[] byArray, String string, int n, Mac mac, Mac mac2) {
        byte[] byArray2 = Strings.toByteArray(string);
        byte[] byArray3 = Arrays.concatenate(byArray2, tLSParameters.seed);
        int n2 = (byArray.length + 1) / 2;
        byte[] byArray4 = new byte[n2];
        byte[] byArray5 = new byte[n2];
        System.arraycopy(byArray, 0, byArray4, 0, n2);
        System.arraycopy(byArray, byArray.length - n2, byArray5, 0, n2);
        byte[] byArray6 = new byte[n];
        byte[] byArray7 = new byte[n];
        FipsKDF.hmac_hash(mac, byArray4, byArray3, byArray6);
        FipsKDF.hmac_hash(mac2, byArray5, byArray3, byArray7);
        for (int i = 0; i < n; ++i) {
            int n3 = i;
            byArray6[n3] = (byte)(byArray6[n3] ^ byArray7[i]);
        }
        return byArray6;
    }

    private static void hmac_hash(Mac mac, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        mac.init(new KeyParameterImpl(byArray));
        byte[] byArray4 = byArray2;
        int n = mac.getMacSize();
        int n2 = (byArray3.length + n - 1) / n;
        byte[] byArray5 = new byte[mac.getMacSize()];
        byte[] byArray6 = new byte[mac.getMacSize()];
        for (int i = 0; i < n2; ++i) {
            mac.update(byArray4, 0, byArray4.length);
            mac.doFinal(byArray5, 0);
            byArray4 = byArray5;
            mac.update(byArray4, 0, byArray4.length);
            mac.update(byArray2, 0, byArray2.length);
            mac.doFinal(byArray6, 0);
            System.arraycopy(byArray6, 0, byArray3, n * i, Math.min(n, byArray3.length - n * i));
        }
    }

    private static KDFCalculator<AgreementKDFParameters> createX963KDFCalculator(boolean bl, final AgreementKDFParameters agreementKDFParameters) {
        Utils.approvedModeCheck(bl, agreementKDFParameters.getAlgorithm());
        final KDF2BytesGenerator kDF2BytesGenerator = new KDF2BytesGenerator(FipsSHS.createDigest(((AgreementKDFPRF)agreementKDFParameters.getAlgorithm().basicVariation()).algorithm));
        kDF2BytesGenerator.init(new KDFParameters(agreementKDFParameters.shared, agreementKDFParameters.iv));
        return new MonitoringKDFCalculator<AgreementKDFParameters>(bl, new BaseKDFCalculator<AgreementKDFParameters>(){

            @Override
            public AgreementKDFParameters getParameters() {
                return agreementKDFParameters;
            }

            @Override
            public void generateBytes(byte[] byArray, int n, int n2) {
                kDF2BytesGenerator.generateBytes(byArray, n, n2);
            }
        });
    }

    private static KDFCalculator<AgreementKDFParameters> createConcatenationKDFCalculator(boolean bl, final AgreementKDFParameters agreementKDFParameters) {
        Utils.approvedModeCheck(bl, agreementKDFParameters.getAlgorithm());
        final ConcatenationKDFGenerator concatenationKDFGenerator = new ConcatenationKDFGenerator(FipsSHS.createDigest(((AgreementKDFPRF)agreementKDFParameters.getAlgorithm().basicVariation()).algorithm));
        concatenationKDFGenerator.init(new KDFParameters(agreementKDFParameters.shared, agreementKDFParameters.iv));
        return new MonitoringKDFCalculator<AgreementKDFParameters>(bl, new BaseKDFCalculator<AgreementKDFParameters>(){

            @Override
            public AgreementKDFParameters getParameters() {
                return agreementKDFParameters;
            }

            @Override
            public void generateBytes(byte[] byArray, int n, int n2) {
                concatenationKDFGenerator.generateBytes(byArray, n, n2);
            }
        });
    }

    static {
        new CounterModeProvider(PRF.AES_CMAC).createEngine();
        new CounterModeProvider(PRF.TRIPLEDES_CMAC).createEngine();
        new CounterModeProvider(PRF.SHA1_HMAC).createEngine();
        new CounterModeProvider(PRF.SHA224_HMAC).createEngine();
        new CounterModeProvider(PRF.SHA256_HMAC).createEngine();
        new CounterModeProvider(PRF.SHA384_HMAC).createEngine();
        new CounterModeProvider(PRF.SHA512_HMAC).createEngine();
        new CounterModeProvider(PRF.SHA512_224_HMAC).createEngine();
        new CounterModeProvider(PRF.SHA512_256_HMAC).createEngine();
        new FeedbackModeProvider(PRF.AES_CMAC).createEngine();
        new FeedbackModeProvider(PRF.TRIPLEDES_CMAC).createEngine();
        new FeedbackModeProvider(PRF.SHA1_HMAC).createEngine();
        new FeedbackModeProvider(PRF.SHA224_HMAC).createEngine();
        new FeedbackModeProvider(PRF.SHA256_HMAC).createEngine();
        new FeedbackModeProvider(PRF.SHA384_HMAC).createEngine();
        new FeedbackModeProvider(PRF.SHA512_HMAC).createEngine();
        new FeedbackModeProvider(PRF.SHA512_224_HMAC).createEngine();
        new FeedbackModeProvider(PRF.SHA512_256_HMAC).createEngine();
        new DoublePipelineModeProvider(PRF.AES_CMAC).createEngine();
        new DoublePipelineModeProvider(PRF.TRIPLEDES_CMAC).createEngine();
        new DoublePipelineModeProvider(PRF.SHA1_HMAC).createEngine();
        new DoublePipelineModeProvider(PRF.SHA224_HMAC).createEngine();
        new DoublePipelineModeProvider(PRF.SHA256_HMAC).createEngine();
        new DoublePipelineModeProvider(PRF.SHA384_HMAC).createEngine();
        new DoublePipelineModeProvider(PRF.SHA512_HMAC).createEngine();
        new DoublePipelineModeProvider(PRF.SHA512_224_HMAC).createEngine();
        new DoublePipelineModeProvider(PRF.SHA512_256_HMAC).createEngine();
        md5Provider = new EngineProvider<Digest>(){

            @Override
            public Digest createEngine() {
                return SelfTestExecutor.validate(TLS1_0.getAlgorithm(), new MD5Digest(), new Md5KatTest());
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AgreementKDFPRF {
        SHA1(FipsSHS.Algorithm.SHA1),
        SHA224(FipsSHS.Algorithm.SHA224),
        SHA256(FipsSHS.Algorithm.SHA256),
        SHA384(FipsSHS.Algorithm.SHA384),
        SHA512(FipsSHS.Algorithm.SHA512),
        SHA512_224(FipsSHS.Algorithm.SHA512_224),
        SHA512_256(FipsSHS.Algorithm.SHA512_256),
        SHA3_224(FipsSHS.Algorithm.SHA3_224),
        SHA3_256(FipsSHS.Algorithm.SHA3_256),
        SHA3_384(FipsSHS.Algorithm.SHA3_384),
        SHA3_512(FipsSHS.Algorithm.SHA3_512);

        private final FipsAlgorithm algorithm;

        private AgreementKDFPRF(FipsAlgorithm fipsAlgorithm) {
            this.algorithm = fipsAlgorithm;
        }

        public FipsAlgorithm getAlgorithm() {
            return this.algorithm;
        }
    }

    public static final class AgreementKDFParameters
    extends FipsParameters {
        private final byte[] shared;
        private final byte[] iv;

        AgreementKDFParameters(FipsAlgorithm fipsAlgorithm, byte[] byArray) {
            this(fipsAlgorithm, byArray, null);
        }

        AgreementKDFParameters(FipsAlgorithm fipsAlgorithm, byte[] byArray, byte[] byArray2) {
            super(fipsAlgorithm);
            this.shared = byArray;
            this.iv = byArray2;
        }

        public AgreementKDFParameters withIV(byte[] byArray) {
            return new AgreementKDFParameters(this.getAlgorithm(), this.shared, Arrays.clone(byArray));
        }
    }

    public static final class AgreementKDFParametersBuilder
    extends FipsParameters {
        AgreementKDFPRF prf;

        AgreementKDFParametersBuilder(FipsAlgorithm fipsAlgorithm, AgreementKDFPRF agreementKDFPRF) {
            super(fipsAlgorithm);
            this.prf = agreementKDFPRF;
        }

        public AgreementKDFParametersBuilder withPRF(AgreementKDFPRF agreementKDFPRF) {
            return new AgreementKDFParametersBuilder(this.getAlgorithm(), agreementKDFPRF);
        }

        public AgreementKDFParameters using(byte[] byArray) {
            return new AgreementKDFParameters(new FipsAlgorithm(this.getAlgorithm(), (Enum)this.prf), Arrays.clone(byArray));
        }

        public AgreementKDFPRF getPRF() {
            return this.prf;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class AgreementOperatorFactory
    extends FipsKDFOperatorFactory<AgreementKDFParameters> {
        @Override
        public KDFCalculator<AgreementKDFParameters> createKDFCalculator(AgreementKDFParameters agreementKDFParameters) {
            if (agreementKDFParameters.getAlgorithm().getName().startsWith(X963.getAlgorithm().getName())) {
                return FipsKDF.createX963KDFCalculator(this.approvedModeOnly, agreementKDFParameters);
            }
            return FipsKDF.createConcatenationKDFCalculator(this.approvedModeOnly, agreementKDFParameters);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface BaseKDFCalculator<T extends Parameters> {
        public T getParameters();

        public void generateBytes(byte[] var1, int var2, int var3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CounterLocation {
        AFTER_ITERATION_DATA(1),
        AFTER_FIXED_INPUT(2),
        BEFORE_ITERATION_DATA(0);

        private final int code;

        private CounterLocation(int n2) {
            this.code = n2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CounterModeFactory
    extends FipsKDFOperatorFactory<CounterModeParameters> {
        @Override
        public KDFCalculator<CounterModeParameters> createKDFCalculator(final CounterModeParameters counterModeParameters) {
            Utils.approvedModeCheck(this.approvedModeOnly, counterModeParameters.getAlgorithm());
            final KDFCounterBytesGenerator kDFCounterBytesGenerator = new CounterModeProvider(counterModeParameters.getAlgorithm()).createEngine();
            kDFCounterBytesGenerator.init(new KDFCounterParameters(counterModeParameters.ki, counterModeParameters.fixedInputPrefix, counterModeParameters.fixedInputSuffix, counterModeParameters.r));
            return new MonitoringKDFCalculator<CounterModeParameters>(this.approvedModeOnly, new BaseKDFCalculator<CounterModeParameters>(){

                @Override
                public CounterModeParameters getParameters() {
                    return counterModeParameters;
                }

                @Override
                public void generateBytes(byte[] byArray, int n, int n2) {
                    kDFCounterBytesGenerator.generateBytes(byArray, n, n2);
                }
            });
        }
    }

    public static final class CounterModeParameters
    extends FipsParameters {
        final int r;
        final byte[] ki;
        final byte[] fixedInputPrefix;
        final byte[] fixedInputSuffix;

        private CounterModeParameters(FipsAlgorithm fipsAlgorithm, int n, byte[] byArray, byte[] byArray2, byte[] byArray3) {
            super(fipsAlgorithm);
            this.r = n;
            this.ki = byArray;
            this.fixedInputPrefix = byArray2;
            this.fixedInputSuffix = byArray3;
        }
    }

    public static final class CounterModeParametersBuilder
    extends FipsParameters {
        private final PRF prf;
        private final int r;

        CounterModeParametersBuilder(FipsAlgorithm fipsAlgorithm) {
            this(fipsAlgorithm, PRF.SHA1_HMAC, 8);
        }

        private CounterModeParametersBuilder(FipsAlgorithm fipsAlgorithm, PRF pRF, int n) {
            super(fipsAlgorithm);
            this.prf = pRF;
            this.r = n;
        }

        public CounterModeParametersBuilder withPRFAndR(PRF pRF, int n) {
            return new CounterModeParametersBuilder(this.getAlgorithm(), pRF, n);
        }

        public CounterModeParameters using(byte[] byArray, byte[] byArray2) {
            return new CounterModeParameters(new FipsAlgorithm(this.getAlgorithm(), (Enum)this.prf), this.r, Arrays.clone(byArray), Arrays.clone(byArray2), null);
        }

        public CounterModeParameters using(byte[] byArray, byte[] byArray2, byte[] byArray3) {
            return new CounterModeParameters(new FipsAlgorithm(this.getAlgorithm(), (Enum)this.prf), this.r, Arrays.clone(byArray), Arrays.clone(byArray2), Arrays.clone(byArray3));
        }

        public CounterModeParameters using(byte[] byArray, boolean bl, byte[] byArray2, byte[] byArray3, int n) {
            return new CounterModeParameters(new FipsAlgorithm(this.getAlgorithm(), (Enum)this.prf), this.r, Arrays.clone(byArray), bl ? FipsKDF.buildFixedInput(byArray2, byArray3, n) : null, bl ? null : FipsKDF.buildFixedInput(byArray2, byArray3, n));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CounterModeProvider
    extends FipsEngineProvider<KDFCounterBytesGenerator> {
        private static final byte[] KI = Hex.decode("dff1e50ac0b69dc40f1051d46c2b069c");
        private static final byte[] FIP = new byte[]{1};
        private static final byte[] FIS = new byte[]{2};
        private static final byte[] aes_cmac_vec = Hex.decode("53023e21d00cc5046b15");
        private static final byte[] tripleDes_vec = Hex.decode("d4e062f13b0baefa4943");
        private static final byte[] sha1_vec = Hex.decode("76f881b780e4939d485a");
        private static final byte[] sha224_vec = Hex.decode("66db824abdf2b4e85de2");
        private static final byte[] sha256_vec = Hex.decode("3a46d9be7ab8ea092558");
        private static final byte[] sha384_vec = Hex.decode("d209b2f985ff77301fd1");
        private static final byte[] sha512_vec = Hex.decode("0c51da7c89503acc0050");
        private static final byte[] sha512_224_vec = Hex.decode("86e14446abd90b94c828");
        private static final byte[] sha512_256_vec = Hex.decode("26593c9ef9b39d94bafc");
        private final FipsAlgorithm algorithm;

        public CounterModeProvider(FipsAlgorithm fipsAlgorithm) {
            this.algorithm = fipsAlgorithm;
        }

        public CounterModeProvider(PRF pRF) {
            this.algorithm = new FipsAlgorithm(COUNTER_MODE.getAlgorithm(), (Enum)pRF);
        }

        @Override
        public KDFCounterBytesGenerator createEngine() {
            final PRF pRF = (PRF)this.algorithm.basicVariation();
            FipsEngineProvider fipsEngineProvider = FipsKDF.createPRF(pRF);
            return SelfTestExecutor.validate(this.algorithm, new KDFCounterBytesGenerator((Mac)fipsEngineProvider.createEngine()), new VariantKatTest<KDFCounterBytesGenerator>(){

                @Override
                public void evaluate(KDFCounterBytesGenerator kDFCounterBytesGenerator) {
                    kDFCounterBytesGenerator.init(new KDFCounterParameters(KI, FIP, FIS, 8));
                    byte[] byArray = new byte[10];
                    kDFCounterBytesGenerator.generateBytes(byArray, 0, byArray.length);
                    if (!Arrays.areEqual(CounterModeProvider.expectedOutput(pRF), byArray)) {
                        this.fail("failed self test on generation: " + Hex.toHexString(byArray));
                    }
                }
            });
        }

        private static byte[] expectedOutput(PRF pRF) {
            switch (pRF) {
                case AES_CMAC: {
                    return aes_cmac_vec;
                }
                case TRIPLEDES_CMAC: {
                    return tripleDes_vec;
                }
                case SHA1_HMAC: {
                    return sha1_vec;
                }
                case SHA224_HMAC: {
                    return sha224_vec;
                }
                case SHA256_HMAC: {
                    return sha256_vec;
                }
                case SHA384_HMAC: {
                    return sha384_vec;
                }
                case SHA512_HMAC: {
                    return sha512_vec;
                }
                case SHA512_224_HMAC: {
                    return sha512_224_vec;
                }
                case SHA512_256_HMAC: {
                    return sha512_256_vec;
                }
            }
            throw new SelfTestExecutor.TestFailedException("unknown PRF");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DoublePipelineModeFactory
    extends FipsKDFOperatorFactory<DoublePipelineModeParameters> {
        @Override
        public KDFCalculator<DoublePipelineModeParameters> createKDFCalculator(final DoublePipelineModeParameters doublePipelineModeParameters) {
            Utils.approvedModeCheck(this.approvedModeOnly, doublePipelineModeParameters.getAlgorithm());
            final KDFDoublePipelineIterationBytesGenerator kDFDoublePipelineIterationBytesGenerator = new DoublePipelineModeProvider(doublePipelineModeParameters.getAlgorithm()).createEngine();
            CounterLocation counterLocation = doublePipelineModeParameters.counterLocation;
            int n = doublePipelineModeParameters.r;
            if (n > 0) {
                kDFDoublePipelineIterationBytesGenerator.init(KDFDoublePipelineIterationParameters.createWithCounter(counterLocation.code, doublePipelineModeParameters.ki, doublePipelineModeParameters.fixedInputData, n));
            } else {
                kDFDoublePipelineIterationBytesGenerator.init(KDFDoublePipelineIterationParameters.createWithoutCounter(doublePipelineModeParameters.ki, doublePipelineModeParameters.fixedInputData));
            }
            return new MonitoringKDFCalculator<DoublePipelineModeParameters>(this.approvedModeOnly, new BaseKDFCalculator<DoublePipelineModeParameters>(){

                @Override
                public DoublePipelineModeParameters getParameters() {
                    return doublePipelineModeParameters;
                }

                @Override
                public void generateBytes(byte[] byArray, int n, int n2) {
                    kDFDoublePipelineIterationBytesGenerator.generateBytes(byArray, n, n2);
                }
            });
        }
    }

    public static final class DoublePipelineModeParameters
    extends FipsParameters {
        private final int r;
        private final CounterLocation counterLocation;
        private final byte[] ki;
        private final byte[] fixedInputData;

        private DoublePipelineModeParameters(FipsAlgorithm fipsAlgorithm, int n, CounterLocation counterLocation, byte[] byArray, byte[] byArray2) {
            super(fipsAlgorithm);
            this.r = n;
            this.counterLocation = counterLocation;
            this.ki = byArray;
            this.fixedInputData = byArray2;
        }
    }

    public static final class DoublePipelineModeParametersBuilder
    extends FipsParameters {
        private final PRF prf;
        private final int r;
        private final CounterLocation counterLocation;

        DoublePipelineModeParametersBuilder(FipsAlgorithm fipsAlgorithm) {
            this(fipsAlgorithm, PRF.SHA1_HMAC, -1, null);
        }

        private DoublePipelineModeParametersBuilder(FipsAlgorithm fipsAlgorithm, PRF pRF, int n, CounterLocation counterLocation) {
            super(fipsAlgorithm);
            this.prf = pRF;
            this.r = n;
            this.counterLocation = counterLocation;
        }

        public DoublePipelineModeParametersBuilder withPRF(PRF pRF) {
            return new DoublePipelineModeParametersBuilder(this.getAlgorithm(), pRF, -1, null);
        }

        public DoublePipelineModeParametersBuilder withR(int n) {
            return new DoublePipelineModeParametersBuilder(this.getAlgorithm(), this.prf, n, CounterLocation.AFTER_ITERATION_DATA);
        }

        public DoublePipelineModeParametersBuilder withRAndLocation(int n, CounterLocation counterLocation) {
            return new DoublePipelineModeParametersBuilder(this.getAlgorithm(), this.prf, n, counterLocation);
        }

        public DoublePipelineModeParameters using(byte[] byArray, byte[] byArray2) {
            return new DoublePipelineModeParameters(new FipsAlgorithm(this.getAlgorithm(), (Enum)this.prf), this.r, this.counterLocation, Arrays.clone(byArray), Arrays.clone(byArray2));
        }

        public DoublePipelineModeParameters using(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) {
            return new DoublePipelineModeParameters(new FipsAlgorithm(this.getAlgorithm(), (Enum)this.prf), this.r, this.counterLocation, Arrays.clone(byArray), FipsKDF.buildFixedInput(byArray2, byArray3, n));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class DoublePipelineModeProvider
    extends FipsEngineProvider<KDFDoublePipelineIterationBytesGenerator> {
        private static final byte[] KI = Hex.decode("dff1e50ac0b69dc40f1051d46c2b069c");
        private static final byte[] FID = new byte[]{2};
        private static final byte[] aes_cmac_vec = Hex.decode("ace76ed103e31681ed03");
        private static final byte[] tripleDes_vec = Hex.decode("41d79be29b5c34ffa40d");
        private static final byte[] sha1_vec = Hex.decode("e5e5666cb2a73b8ce638");
        private static final byte[] sha224_vec = Hex.decode("c4c12b540e51d106abd8");
        private static final byte[] sha256_vec = Hex.decode("b6c232a28b4b450210ee");
        private static final byte[] sha384_vec = Hex.decode("48268b8bf87297a5ce8f");
        private static final byte[] sha512_vec = Hex.decode("52d86063e22a84188285");
        private static final byte[] sha512_224_vec = Hex.decode("d1f521fbc7e736685709");
        private static final byte[] sha512_256_vec = Hex.decode("dca0e9d25e22ca54c0ca");
        private final FipsAlgorithm algorithm;

        public DoublePipelineModeProvider(FipsAlgorithm fipsAlgorithm) {
            this.algorithm = fipsAlgorithm;
        }

        public DoublePipelineModeProvider(PRF pRF) {
            this.algorithm = new FipsAlgorithm(DOUBLE_PIPELINE_ITERATION_MODE.getAlgorithm(), (Enum)pRF);
        }

        @Override
        public KDFDoublePipelineIterationBytesGenerator createEngine() {
            final PRF pRF = (PRF)this.algorithm.basicVariation();
            FipsEngineProvider fipsEngineProvider = FipsKDF.createPRF(pRF);
            return SelfTestExecutor.validate(this.algorithm, new KDFDoublePipelineIterationBytesGenerator((Mac)fipsEngineProvider.createEngine()), new VariantKatTest<KDFDoublePipelineIterationBytesGenerator>(){

                @Override
                public void evaluate(KDFDoublePipelineIterationBytesGenerator kDFDoublePipelineIterationBytesGenerator) {
                    kDFDoublePipelineIterationBytesGenerator.init(KDFDoublePipelineIterationParameters.createWithCounter(0, KI, FID, 8));
                    byte[] byArray = new byte[10];
                    kDFDoublePipelineIterationBytesGenerator.generateBytes(byArray, 0, byArray.length);
                    if (!Arrays.areEqual(DoublePipelineModeProvider.expectedOutput(pRF), byArray)) {
                        this.fail("failed self test on generation: " + Hex.toHexString(byArray));
                    }
                }
            });
        }

        private static byte[] expectedOutput(PRF pRF) {
            switch (pRF) {
                case AES_CMAC: {
                    return aes_cmac_vec;
                }
                case TRIPLEDES_CMAC: {
                    return tripleDes_vec;
                }
                case SHA1_HMAC: {
                    return sha1_vec;
                }
                case SHA224_HMAC: {
                    return sha224_vec;
                }
                case SHA256_HMAC: {
                    return sha256_vec;
                }
                case SHA384_HMAC: {
                    return sha384_vec;
                }
                case SHA512_HMAC: {
                    return sha512_vec;
                }
                case SHA512_224_HMAC: {
                    return sha512_224_vec;
                }
                case SHA512_256_HMAC: {
                    return sha512_256_vec;
                }
            }
            throw new SelfTestExecutor.TestFailedException("unknown PRF");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class FeedbackModeFactory
    extends FipsKDFOperatorFactory<FeedbackModeParameters> {
        @Override
        public KDFCalculator<FeedbackModeParameters> createKDFCalculator(final FeedbackModeParameters feedbackModeParameters) {
            Utils.approvedModeCheck(this.approvedModeOnly, feedbackModeParameters.getAlgorithm());
            final KDFFeedbackBytesGenerator kDFFeedbackBytesGenerator = new FeedbackModeProvider(feedbackModeParameters.getAlgorithm()).createEngine();
            CounterLocation counterLocation = feedbackModeParameters.counterLocation;
            int n = feedbackModeParameters.r;
            if (n > 0) {
                kDFFeedbackBytesGenerator.init(KDFFeedbackParameters.createWithCounter(counterLocation.code, feedbackModeParameters.ki, feedbackModeParameters.iv, feedbackModeParameters.fixedInputData, n));
            } else {
                kDFFeedbackBytesGenerator.init(KDFFeedbackParameters.createWithoutCounter(feedbackModeParameters.ki, feedbackModeParameters.iv, feedbackModeParameters.fixedInputData));
            }
            return new MonitoringKDFCalculator<FeedbackModeParameters>(this.approvedModeOnly, new BaseKDFCalculator<FeedbackModeParameters>(){

                @Override
                public FeedbackModeParameters getParameters() {
                    return feedbackModeParameters;
                }

                @Override
                public void generateBytes(byte[] byArray, int n, int n2) {
                    kDFFeedbackBytesGenerator.generateBytes(byArray, n, n2);
                }
            });
        }
    }

    public static final class FeedbackModeParameters
    extends FipsParameters {
        private final int r;
        private final CounterLocation counterLocation;
        private final byte[] ki;
        private final byte[] iv;
        private final byte[] fixedInputData;

        private FeedbackModeParameters(FipsAlgorithm fipsAlgorithm, int n, CounterLocation counterLocation, byte[] byArray, byte[] byArray2, byte[] byArray3) {
            super(fipsAlgorithm);
            this.r = n;
            this.counterLocation = counterLocation;
            this.ki = byArray;
            this.iv = byArray2;
            this.fixedInputData = byArray3;
        }
    }

    public static final class FeedbackModeParametersBuilder
    extends FipsParameters {
        private final PRF prf;
        private final int r;
        private final CounterLocation counterLocation;

        FeedbackModeParametersBuilder(FipsAlgorithm fipsAlgorithm) {
            this(fipsAlgorithm, PRF.SHA1_HMAC, -1, null);
        }

        private FeedbackModeParametersBuilder(FipsAlgorithm fipsAlgorithm, PRF pRF, int n, CounterLocation counterLocation) {
            super(fipsAlgorithm);
            this.prf = pRF;
            this.r = n;
            this.counterLocation = counterLocation;
        }

        public FeedbackModeParametersBuilder withPRF(PRF pRF) {
            return new FeedbackModeParametersBuilder(this.getAlgorithm(), pRF, -1, null);
        }

        public FeedbackModeParametersBuilder withR(int n) {
            return new FeedbackModeParametersBuilder(this.getAlgorithm(), this.prf, n, CounterLocation.AFTER_ITERATION_DATA);
        }

        public FeedbackModeParametersBuilder withRAndLocation(int n, CounterLocation counterLocation) {
            return new FeedbackModeParametersBuilder(this.getAlgorithm(), this.prf, n, counterLocation);
        }

        public FeedbackModeParameters using(byte[] byArray, byte[] byArray2, byte[] byArray3) {
            return new FeedbackModeParameters(new FipsAlgorithm(this.getAlgorithm(), (Enum)this.prf), this.r, this.counterLocation, Arrays.clone(byArray), Arrays.clone(byArray2), Arrays.clone(byArray3));
        }

        public FeedbackModeParameters using(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n) {
            return new FeedbackModeParameters(new FipsAlgorithm(this.getAlgorithm(), (Enum)this.prf), this.r, this.counterLocation, Arrays.clone(byArray), Arrays.clone(byArray2), FipsKDF.buildFixedInput(byArray3, byArray4, n));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FeedbackModeProvider
    extends FipsEngineProvider<KDFFeedbackBytesGenerator> {
        private static final byte[] KI = Hex.decode("dff1e50ac0b69dc40f1051d46c2b069c");
        private static final byte[] IV = new byte[]{1};
        private static final byte[] FID = new byte[]{2};
        private static final byte[] aes_cmac_vec = Hex.decode("af7eb5b9a3eb72a1a0cb");
        private static final byte[] tripleDes_vec = Hex.decode("cf65681ac0d3c4f65ce0");
        private static final byte[] sha1_vec = Hex.decode("bfe9d9a6cd8b7befe0fb");
        private static final byte[] sha224_vec = Hex.decode("71d5790138202ab1edc9");
        private static final byte[] sha256_vec = Hex.decode("650d3f9da0f4a8bcf602");
        private static final byte[] sha384_vec = Hex.decode("2a9375ae10e75a9a5ba2");
        private static final byte[] sha512_vec = Hex.decode("e0f3f35c27358f3d0dda");
        private static final byte[] sha512_224_vec = Hex.decode("5fd1372077522505be4a");
        private static final byte[] sha512_256_vec = Hex.decode("ae930bec79b81ee15c67");
        private final FipsAlgorithm algorithm;

        public FeedbackModeProvider(FipsAlgorithm fipsAlgorithm) {
            this.algorithm = fipsAlgorithm;
        }

        public FeedbackModeProvider(PRF pRF) {
            this.algorithm = new FipsAlgorithm(FEEDBACK_MODE.getAlgorithm(), (Enum)pRF);
        }

        @Override
        public KDFFeedbackBytesGenerator createEngine() {
            final PRF pRF = (PRF)this.algorithm.basicVariation();
            FipsEngineProvider fipsEngineProvider = FipsKDF.createPRF(pRF);
            return SelfTestExecutor.validate(this.algorithm, new KDFFeedbackBytesGenerator((Mac)fipsEngineProvider.createEngine()), new VariantKatTest<KDFFeedbackBytesGenerator>(){

                @Override
                public void evaluate(KDFFeedbackBytesGenerator kDFFeedbackBytesGenerator) {
                    kDFFeedbackBytesGenerator.init(KDFFeedbackParameters.createWithCounter(2, KI, IV, FID, 8));
                    byte[] byArray = new byte[10];
                    kDFFeedbackBytesGenerator.generateBytes(byArray, 0, byArray.length);
                    if (!Arrays.areEqual(FeedbackModeProvider.expectedOutput(pRF), byArray)) {
                        this.fail("failed self test on generation: " + Hex.toHexString(byArray));
                    }
                }
            });
        }

        private static byte[] expectedOutput(PRF pRF) {
            switch (pRF) {
                case AES_CMAC: {
                    return aes_cmac_vec;
                }
                case TRIPLEDES_CMAC: {
                    return tripleDes_vec;
                }
                case SHA1_HMAC: {
                    return sha1_vec;
                }
                case SHA224_HMAC: {
                    return sha224_vec;
                }
                case SHA256_HMAC: {
                    return sha256_vec;
                }
                case SHA384_HMAC: {
                    return sha384_vec;
                }
                case SHA512_HMAC: {
                    return sha512_vec;
                }
                case SHA512_224_HMAC: {
                    return sha512_224_vec;
                }
                case SHA512_256_HMAC: {
                    return sha512_256_vec;
                }
            }
            throw new SelfTestExecutor.TestFailedException("unknown PRF");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IKEv2OperatorFactory
    extends FipsKDFOperatorFactory<IKEv2Parameters> {
        @Override
        public KDFCalculator<IKEv2Parameters> createKDFCalculator(final IKEv2Parameters iKEv2Parameters) {
            Utils.approvedModeCheck(this.approvedModeOnly, iKEv2Parameters.getAlgorithm());
            final Mac mac = FipsSHS.createHMac(((IKEv2PRF)iKEv2Parameters.getAlgorithm().basicVariation()).algorithm);
            return new MonitoringKDFCalculator<IKEv2Parameters>(this.approvedModeOnly, new BaseKDFCalculator<IKEv2Parameters>(){

                @Override
                public IKEv2Parameters getParameters() {
                    return iKEv2Parameters;
                }

                @Override
                public void generateBytes(byte[] byArray, int n, int n2) {
                    IKEv2OperatorFactory.prf(mac, iKEv2Parameters, byArray, n, n2);
                }
            });
        }

        private static void prf(Mac mac, IKEv2Parameters iKEv2Parameters, byte[] byArray, int n, int n2) {
            int n3 = mac.getMacSize();
            int n4 = (n2 + n3 - 1) / n3;
            byte[] byArray2 = new byte[n3];
            if (!iKEv2Parameters.isPlus) {
                mac.init(new KeyParameterImpl(iKEv2Parameters.shared));
                mac.update(iKEv2Parameters.keyPad, 0, iKEv2Parameters.keyPad.length);
                mac.doFinal(byArray2, 0);
                System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
            } else {
                mac.init(new KeyParameterImpl(iKEv2Parameters.shared));
                mac.update(iKEv2Parameters.keyPad, 0, iKEv2Parameters.keyPad.length);
                mac.update((byte)1);
                mac.doFinal(byArray2, 0);
                System.arraycopy(byArray2, 0, byArray, n, Math.min(n3, n2));
                for (int i = 1; i < n4; ++i) {
                    mac.update(byArray2, 0, byArray2.length);
                    mac.update(iKEv2Parameters.keyPad, 0, iKEv2Parameters.keyPad.length);
                    mac.update((byte)(i + 1));
                    mac.doFinal(byArray2, 0);
                    System.arraycopy(byArray2, 0, byArray, n + n3 * i, Math.min(n3, byArray.length - n3 * i));
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IKEv2PRF {
        SHA1(FipsSHS.Algorithm.SHA1_HMAC),
        SHA224(FipsSHS.Algorithm.SHA224_HMAC),
        SHA256(FipsSHS.Algorithm.SHA256_HMAC),
        SHA384(FipsSHS.Algorithm.SHA384_HMAC),
        SHA512(FipsSHS.Algorithm.SHA512_HMAC);

        private final FipsAlgorithm algorithm;

        private IKEv2PRF(FipsAlgorithm fipsAlgorithm) {
            this.algorithm = fipsAlgorithm;
        }

        public FipsAlgorithm getAlgorithm() {
            return this.algorithm;
        }
    }

    public static class IKEv2Parameters
    extends FipsParameters {
        private final boolean isPlus;
        private final byte[] shared;
        private final byte[] keyPad;

        IKEv2Parameters(FipsAlgorithm fipsAlgorithm, boolean bl, byte[] byArray, byte[] byArray2) {
            super(fipsAlgorithm);
            this.isPlus = bl;
            this.shared = byArray;
            this.keyPad = byArray2;
        }
    }

    public static class IKEv2ParametersBuilder
    extends FipsParameters {
        private final IKEv2PRF prf;

        IKEv2ParametersBuilder(FipsAlgorithm fipsAlgorithm, IKEv2PRF iKEv2PRF) {
            super(fipsAlgorithm);
            this.prf = iKEv2PRF;
        }

        public IKEv2ParametersBuilder withPRF(IKEv2PRF iKEv2PRF) {
            return new IKEv2ParametersBuilder(this.getAlgorithm(), iKEv2PRF);
        }

        public IKEv2PRF getPRF() {
            return this.prf;
        }

        public IKEv2Parameters createForPrf(byte[] byArray, byte[] ... byArray2) {
            return new IKEv2Parameters(new FipsAlgorithm(this.getAlgorithm(), (Enum)this.prf), false, Arrays.clone(byArray), Arrays.concatenate(byArray2));
        }

        public IKEv2Parameters createForPrfPlus(byte[] byArray, byte[] ... byArray2) {
            return new IKEv2Parameters(new FipsAlgorithm(this.getAlgorithm(), (Enum)this.prf), true, Arrays.clone(byArray), Arrays.concatenate(byArray2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Md5KatTest
    implements BasicKatTest<Digest> {
        private static final byte[] stdShaVector = Strings.toByteArray("abc");
        private static final byte[] kat = Hex.decode("900150983cd24fb0d6963f7d28e17f72");

        private Md5KatTest() {
        }

        @Override
        public boolean hasTestPassed(Digest digest) {
            digest.update(stdShaVector, 0, stdShaVector.length);
            byte[] byArray = new byte[digest.getDigestSize()];
            digest.doFinal(byArray, 0);
            return Arrays.areEqual(byArray, kat);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MonitoringKDFCalculator<T extends Parameters>
    implements KDFCalculator<T> {
        private final boolean approvedModeOnly;
        private final BaseKDFCalculator<T> kdf;
        private final FipsAlgorithm algorithm;

        MonitoringKDFCalculator(boolean bl, BaseKDFCalculator<T> baseKDFCalculator) {
            this.approvedModeOnly = bl;
            this.kdf = baseKDFCalculator;
            this.algorithm = (FipsAlgorithm)baseKDFCalculator.getParameters().getAlgorithm();
        }

        @Override
        public T getParameters() {
            Utils.approvedModeCheck(this.approvedModeOnly, this.algorithm);
            return this.kdf.getParameters();
        }

        @Override
        public void generateBytes(byte[] byArray) {
            this.generateBytes(byArray, 0, byArray.length);
        }

        @Override
        public void generateBytes(byte[] byArray, int n, int n2) {
            Utils.approvedModeCheck(this.approvedModeOnly, this.algorithm);
            this.kdf.generateBytes(byArray, n, n2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PRF {
        AES_CMAC(FipsAES.CMAC.getAlgorithm()),
        TRIPLEDES_CMAC(FipsTripleDES.CMAC.getAlgorithm()),
        SHA1_HMAC(FipsSHS.Algorithm.SHA1_HMAC),
        SHA224_HMAC(FipsSHS.Algorithm.SHA224_HMAC),
        SHA256_HMAC(FipsSHS.Algorithm.SHA256_HMAC),
        SHA384_HMAC(FipsSHS.Algorithm.SHA384_HMAC),
        SHA512_HMAC(FipsSHS.Algorithm.SHA512_HMAC),
        SHA512_224_HMAC(FipsSHS.Algorithm.SHA512_224_HMAC),
        SHA512_256_HMAC(FipsSHS.Algorithm.SHA512_256_HMAC);

        private final FipsAlgorithm algorithm;

        private PRF(FipsAlgorithm fipsAlgorithm) {
            this.algorithm = fipsAlgorithm;
        }

        public FipsAlgorithm getAlgorithm() {
            return this.algorithm;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SRTPOperatorFactory
    extends FipsKDFOperatorFactory<SRTPParameters> {
        @Override
        public KDFCalculator<SRTPParameters> createKDFCalculator(final SRTPParameters sRTPParameters) {
            Utils.approvedModeCheck(this.approvedModeOnly, sRTPParameters.getAlgorithm());
            final SICBlockCipher sICBlockCipher = new SICBlockCipher((BlockCipher)((SRTPPRF)sRTPParameters.getAlgorithm().basicVariation()).engineProvider.createEngine());
            byte[] byArray = new byte[sICBlockCipher.getBlockSize()];
            System.arraycopy(sRTPParameters.masterSalt, 0, byArray, 0, sRTPParameters.masterSalt.length);
            int n = sRTPParameters.masterSalt.length - (sRTPParameters.div.length + 1);
            byArray[n] = (byte)(byArray[n] ^ sRTPParameters.label);
            for (int i = 0; i != sRTPParameters.div.length; ++i) {
                int n2 = i + (sRTPParameters.masterSalt.length - sRTPParameters.div.length);
                byArray[n2] = (byte)(byArray[n2] ^ sRTPParameters.div[i]);
            }
            sICBlockCipher.init(true, new ParametersWithIV(new KeyParameterImpl(sRTPParameters.kMaster), byArray));
            return new MonitoringKDFCalculator<SRTPParameters>(this.approvedModeOnly, new BaseKDFCalculator<SRTPParameters>(){

                @Override
                public SRTPParameters getParameters() {
                    return sRTPParameters;
                }

                @Override
                public void generateBytes(byte[] byArray, int n, int n2) {
                    SRTPOperatorFactory.prf(sICBlockCipher, byArray, n, n2);
                }
            });
        }

        private static void prf(StreamCipher streamCipher, byte[] byArray, int n, int n2) {
            for (int i = n; i != n + n2; ++i) {
                byArray[i] = 0;
            }
            streamCipher.processBytes(byArray, n, n2, byArray, n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SRTPPRF {
        AES_CM(FipsAES.CTR.getAlgorithm(), FipsAES.ENGINE_PROVIDER);

        private final FipsAlgorithm algorithm;
        private final EngineProvider<BlockCipher> engineProvider;

        private SRTPPRF(FipsAlgorithm fipsAlgorithm, EngineProvider<BlockCipher> engineProvider) {
            this.algorithm = fipsAlgorithm;
            this.engineProvider = engineProvider;
        }

        public FipsAlgorithm getAlgorithm() {
            return this.algorithm;
        }
    }

    public static class SRTPParameters
    extends FipsParameters {
        private final byte label;
        private final byte[] kMaster;
        private final byte[] masterSalt;
        private final int kdr;
        private final byte[] index;
        private final byte[] div;

        SRTPParameters(FipsAlgorithm fipsAlgorithm, byte by, byte[] byArray, byte[] byArray2, int n, byte[] byArray3) {
            super(fipsAlgorithm);
            this.label = by;
            this.kMaster = byArray;
            this.masterSalt = byArray2;
            this.kdr = n;
            this.index = byArray3;
            this.div = new byte[byArray3.length];
            if (n != 0) {
                byte[] byArray4;
                if (byArray3.length <= 7) {
                    byte[] byArray5 = new byte[8];
                    System.arraycopy(byArray3, 0, byArray5, byArray5.length - byArray3.length, byArray3.length);
                    long l = Pack.bigEndianToLong(byArray5, 0) / (long)n;
                    byArray4 = Pack.longToBigEndian(l);
                } else {
                    BigInteger bigInteger = new BigInteger(1, byArray3).divide(BigInteger.valueOf(n));
                    byArray4 = bigInteger.toByteArray();
                }
                if (byArray4.length < this.div.length) {
                    System.arraycopy(byArray4, 0, this.div, this.div.length - byArray4.length, byArray4.length);
                } else {
                    System.arraycopy(byArray4, byArray4.length - this.div.length, this.div, 0, this.div.length);
                }
            }
        }

        public SRTPParameters withLabel(byte by) {
            return new SRTPParameters(this.getAlgorithm(), by, this.kMaster, this.masterSalt, this.kdr, this.index);
        }
    }

    public static class SRTPParametersBuilder
    extends FipsParameters {
        private final SRTPPRF prf;

        SRTPParametersBuilder(FipsAlgorithm fipsAlgorithm, SRTPPRF sRTPPRF) {
            super(fipsAlgorithm);
            this.prf = sRTPPRF;
        }

        public SRTPParametersBuilder withPRF(SRTPPRF sRTPPRF) {
            return new SRTPParametersBuilder(this.getAlgorithm(), sRTPPRF);
        }

        public SRTPParameters using(byte[] byArray, byte[] byArray2, int n, byte[] byArray3) {
            return new SRTPParameters(new FipsAlgorithm(this.getAlgorithm(), (Enum)this.prf), 0, Arrays.clone(byArray), Arrays.clone(byArray2), n, Arrays.clone(byArray3));
        }

        public SRTPPRF getPRF() {
            return this.prf;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SSHOperatorFactory
    extends FipsKDFOperatorFactory<SSHParameters> {
        @Override
        public KDFCalculator<SSHParameters> createKDFCalculator(final SSHParameters sSHParameters) {
            Utils.approvedModeCheck(this.approvedModeOnly, sSHParameters.getAlgorithm());
            final ExtendedDigest extendedDigest = FipsSHS.createDigest(((SSHPRF)sSHParameters.getAlgorithm().basicVariation()).algorithm);
            return new MonitoringKDFCalculator<SSHParameters>(this.approvedModeOnly, new BaseKDFCalculator<SSHParameters>(){

                @Override
                public SSHParameters getParameters() {
                    return sSHParameters;
                }

                @Override
                public void generateBytes(byte[] byArray, int n, int n2) {
                    SSHOperatorFactory.hash(extendedDigest, sSHParameters, byArray, n, n2);
                }
            });
        }

        private static void hash(Digest digest, SSHParameters sSHParameters, byte[] byArray, int n, int n2) {
            int n3 = digest.getDigestSize();
            int n4 = (n2 + n3 - 1) / n3;
            byte[] byArray2 = new byte[digest.getDigestSize()];
            digest.update(sSHParameters.sharedKey, 0, sSHParameters.sharedKey.length);
            digest.update(sSHParameters.exchangeHash, 0, sSHParameters.exchangeHash.length);
            digest.update((byte)sSHParameters.x);
            digest.update(sSHParameters.sessionID, 0, sSHParameters.sessionID.length);
            digest.doFinal(byArray2, 0);
            System.arraycopy(byArray2, 0, byArray, n, Math.min(n3, n2));
            for (int i = 1; i < n4; ++i) {
                digest.update(sSHParameters.sharedKey, 0, sSHParameters.sharedKey.length);
                digest.update(sSHParameters.exchangeHash, 0, sSHParameters.exchangeHash.length);
                digest.update(byArray, n, n3 * i);
                digest.doFinal(byArray2, 0);
                System.arraycopy(byArray2, 0, byArray, n + n3 * i, Math.min(n3, byArray.length - n3 * i));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SSHPRF {
        SHA1(FipsSHS.Algorithm.SHA1),
        SHA224(FipsSHS.Algorithm.SHA224),
        SHA256(FipsSHS.Algorithm.SHA256),
        SHA384(FipsSHS.Algorithm.SHA384),
        SHA512(FipsSHS.Algorithm.SHA512);

        private final FipsAlgorithm algorithm;

        private SSHPRF(FipsAlgorithm fipsAlgorithm) {
            this.algorithm = fipsAlgorithm;
        }

        public FipsAlgorithm getAlgorithm() {
            return this.algorithm;
        }
    }

    public static final class SSHParameters
    extends FipsParameters {
        private final char x;
        private final byte[] sharedKey;
        private final byte[] exchangeHash;
        private final byte[] sessionID;

        SSHParameters(FipsAlgorithm fipsAlgorithm, char c, byte[] byArray, byte[] byArray2, byte[] byArray3) {
            super(fipsAlgorithm);
            this.x = c;
            this.sharedKey = byArray;
            this.exchangeHash = byArray2;
            this.sessionID = byArray3;
        }

        SSHParameters(SSHParameters sSHParameters, SSHPRF sSHPRF) {
            this(new FipsAlgorithm(sSHParameters.getAlgorithm(), (Enum)sSHPRF), sSHParameters.x, sSHParameters.sharedKey, sSHParameters.exchangeHash, sSHParameters.sessionID);
        }

        public SSHParameters withX(char c) {
            return new SSHParameters(this.getAlgorithm(), c, this.sharedKey, this.exchangeHash, this.sessionID);
        }
    }

    public static final class SSHParametersBuilder
    extends FipsParameters {
        SSHPRF prf;

        SSHParametersBuilder(FipsAlgorithm fipsAlgorithm, SSHPRF sSHPRF) {
            super(fipsAlgorithm);
            this.prf = sSHPRF;
        }

        public SSHParametersBuilder withPRF(SSHPRF sSHPRF) {
            return new SSHParametersBuilder(this.getAlgorithm(), sSHPRF);
        }

        public SSHParameters using(char c, byte[] byArray, byte[] byArray2, byte[] byArray3) {
            return new SSHParameters(new FipsAlgorithm(this.getAlgorithm(), (Enum)this.prf), c, Arrays.clone(byArray), Arrays.clone(byArray2), Arrays.clone(byArray3));
        }

        public SSHPRF getPRF() {
            return this.prf;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class TLSOperatorFactory
    extends FipsKDFOperatorFactory<TLSParameters> {
        @Override
        public KDFCalculator<TLSParameters> createKDFCalculator(final TLSParameters tLSParameters) {
            final TLSPRF tLSPRF = (TLSPRF)tLSParameters.getAlgorithm().basicVariation();
            Utils.approvedModeCheck(this.approvedModeOnly, tLSParameters.getAlgorithm());
            if (tLSPRF == null) {
                final HMac hMac = new HMac((Digest)md5Provider.createEngine());
                final Mac mac = FipsSHS.createHMac(FipsSHS.Algorithm.SHA1_HMAC);
                return new MonitoringKDFCalculator<TLSParameters>(this.approvedModeOnly, new BaseKDFCalculator<TLSParameters>(){

                    @Override
                    public TLSParameters getParameters() {
                        return tLSParameters;
                    }

                    @Override
                    public void generateBytes(byte[] byArray, int n, int n2) {
                        byte[] byArray2 = FipsKDF.PRF_legacy(tLSParameters, tLSParameters.secret, tLSParameters.label, n2, hMac, mac);
                        System.arraycopy(byArray2, 0, byArray, n, n2);
                    }
                });
            }
            return new MonitoringKDFCalculator<TLSParameters>(this.approvedModeOnly, new BaseKDFCalculator<TLSParameters>(){

                @Override
                public TLSParameters getParameters() {
                    return tLSParameters;
                }

                @Override
                public void generateBytes(byte[] byArray, int n, int n2) {
                    byte[] byArray2 = FipsKDF.PRF(tLSParameters, tLSPRF, tLSParameters.secret, tLSParameters.label, n2);
                    System.arraycopy(byArray2, 0, byArray, n, n2);
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TLSPRF {
        SHA256_HMAC(FipsSHS.Algorithm.SHA256_HMAC),
        SHA384_HMAC(FipsSHS.Algorithm.SHA384_HMAC),
        SHA512_HMAC(FipsSHS.Algorithm.SHA512_HMAC);

        private final FipsAlgorithm algorithm;

        private TLSPRF(FipsAlgorithm fipsAlgorithm) {
            this.algorithm = fipsAlgorithm;
        }

        public FipsAlgorithm getAlgorithm() {
            return this.algorithm;
        }
    }

    public static final class TLSParameters
    extends FipsParameters {
        private final byte[] secret;
        private final String label;
        private final byte[] seed;

        TLSParameters(FipsAlgorithm fipsAlgorithm, byte[] byArray, String string, byte[] byArray2) {
            super(fipsAlgorithm);
            this.secret = byArray;
            this.label = string;
            this.seed = byArray2;
        }
    }

    public static class TLSParametersBuilder
    extends FipsParameters {
        TLSParametersBuilder(FipsAlgorithm fipsAlgorithm) {
            super(fipsAlgorithm);
        }

        public TLSParameters using(byte[] byArray, String string, byte[] ... byArray2) {
            return new TLSParameters(this.getAlgorithm(), Arrays.clone(byArray), string, Arrays.concatenate(byArray2));
        }
    }

    public static final class TLSParametersWithPRFBuilder
    extends TLSParametersBuilder {
        private final TLSPRF prf;

        TLSParametersWithPRFBuilder(FipsAlgorithm fipsAlgorithm, TLSPRF tLSPRF) {
            super(fipsAlgorithm);
            this.prf = tLSPRF;
        }

        public TLSParametersWithPRFBuilder withPRF(TLSPRF tLSPRF) {
            return new TLSParametersWithPRFBuilder(this.getAlgorithm(), tLSPRF);
        }

        public TLSParameters using(byte[] byArray, String string, byte[] ... byArray2) {
            return new TLSParameters(new FipsAlgorithm(this.getAlgorithm(), (Enum)this.prf), Arrays.clone(byArray), string, Arrays.concatenate(byArray2));
        }
    }

    public static final class TLSStage {
        public static final String MASTER_SECRET = "master secret";
        public static final String KEY_EXPANSION = "key expansion";
        public static final String EXTENDED_MASTER_SECRET = "extended master secret";

        private TLSStage() {
        }
    }
}

