/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.action;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.painless.lookup.PainlessConstructor;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;

public class PainlessContextConstructorInfo
implements Writeable,
ToXContentObject {
    public static final ParseField DECLARING = new ParseField("declaring", new String[0]);
    public static final ParseField PARAMETERS = new ParseField("parameters", new String[0]);
    private final String declaring;
    private final List<String> parameters;
    private static final ConstructingObjectParser<PainlessContextConstructorInfo, Void> PARSER = new ConstructingObjectParser(PainlessContextConstructorInfo.class.getCanonicalName(), v -> new PainlessContextConstructorInfo((String)v[0], (List)v[1]));

    public PainlessContextConstructorInfo(PainlessConstructor painlessConstructor) {
        this(painlessConstructor.javaConstructor.getDeclaringClass().getName(), painlessConstructor.typeParameters.stream().map(Class::getName).collect(Collectors.toList()));
    }

    public PainlessContextConstructorInfo(String declaring, List<String> parameters) {
        this.declaring = Objects.requireNonNull(declaring);
        this.parameters = Collections.unmodifiableList(Objects.requireNonNull(parameters));
    }

    public PainlessContextConstructorInfo(StreamInput in) throws IOException {
        this.declaring = in.readString();
        this.parameters = Collections.unmodifiableList(in.readStringList());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.declaring);
        out.writeStringCollection(this.parameters);
    }

    public static PainlessContextConstructorInfo fromXContent(XContentParser parser) {
        return (PainlessContextConstructorInfo)PARSER.apply(parser, null);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(DECLARING.getPreferredName(), this.declaring);
        builder.field(PARAMETERS.getPreferredName(), this.parameters);
        builder.endObject();
        return builder;
    }

    public String getSortValue() {
        return PainlessLookupUtility.buildPainlessConstructorKey(this.parameters.size());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PainlessContextConstructorInfo that = (PainlessContextConstructorInfo)o;
        return Objects.equals(this.declaring, that.declaring) && Objects.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.declaring, this.parameters);
    }

    public String toString() {
        return "PainlessContextConstructorInfo{declaring='" + this.declaring + '\'' + ", parameters=" + this.parameters + '}';
    }

    public String getDeclaring() {
        return this.declaring;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), DECLARING);
        PARSER.declareStringArray(ConstructingObjectParser.constructorArg(), PARAMETERS);
    }
}

