/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.geometry.S1Angle;
import com.google.common.geometry.S2;
import com.google.common.geometry.S2CellId;
import com.google.common.geometry.S2Edge;
import com.google.common.geometry.S2Loop;
import com.google.common.geometry.S2Point;
import com.google.common.geometry.S2Polygon;
import com.google.common.geometry.S2Projections;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Logger;

public strictfp class S2PolygonBuilder {
    private static final Logger log = Logger.getLogger(S2PolygonBuilder.class.getCanonicalName());
    private Options options;
    private Map<S2Point, List<S2Point>> edges;

    public S2PolygonBuilder() {
        this(Options.DIRECTED_XOR);
    }

    public S2PolygonBuilder(Options options) {
        this.options = options;
        this.edges = new HashMap<S2Point, List<S2Point>>();
    }

    public Options options() {
        return this.options;
    }

    public void addEdge(S2Point v0, S2Point v1) {
        List<S2Point> candidates;
        if (v0.equals(v1)) {
            return;
        }
        if (this.options.getXorEdges() && (candidates = this.edges.get(v1)) != null && candidates.contains(v0)) {
            this.eraseEdge(v1, v0);
            return;
        }
        if (this.edges.get(v0) == null) {
            this.edges.put(v0, new ArrayList());
        }
        this.edges.get(v0).add(v1);
        if (this.options.getUndirectedEdges()) {
            if (this.edges.get(v1) == null) {
                this.edges.put(v1, new ArrayList());
            }
            this.edges.get(v1).add(v0);
        }
    }

    public void addLoop(S2Loop loop) {
        int sign = loop.sign();
        for (int i = loop.numVertices(); i > 0; --i) {
            this.addEdge(loop.vertex(i), loop.vertex(i + sign));
        }
    }

    public void addPolygon(S2Polygon polygon) {
        for (int i = 0; i < polygon.numLoops(); ++i) {
            this.addLoop(polygon.loop(i));
        }
    }

    public boolean assembleLoops(List<S2Loop> loops, List<S2Edge> unusedEdges) {
        if (this.options.getMergeDistance().radians() > 0.0) {
            this.mergeVertices();
        }
        ArrayList<S2Edge> dummyUnusedEdges = new ArrayList<S2Edge>();
        if (unusedEdges == null) {
            unusedEdges = dummyUnusedEdges;
        }
        unusedEdges.clear();
        while (!this.edges.isEmpty()) {
            S2Point v1;
            Map.Entry<S2Point, List<S2Point>> edge = this.edges.entrySet().iterator().next();
            S2Point v0 = edge.getKey();
            S2Loop loop = this.assembleLoop(v0, v1 = edge.getValue().iterator().next(), unusedEdges);
            if (loop == null) continue;
            while (this.options.getUndirectedEdges() && !loop.isNormalized()) {
                loop = this.assembleLoop(loop.vertex(1), loop.vertex(0), unusedEdges);
            }
            loops.add(loop);
            this.eraseLoop(loop, loop.numVertices());
        }
        return unusedEdges.isEmpty();
    }

    public boolean assemblePolygon(S2Polygon polygon, List<S2Edge> unusedEdges) {
        ArrayList<S2Loop> loops = new ArrayList<S2Loop>();
        boolean success = this.assembleLoops(loops, unusedEdges);
        if (!this.options.getUndirectedEdges()) {
            for (int i = 0; i < loops.size(); ++i) {
                ((S2Loop)loops.get(i)).normalize();
            }
        }
        if (this.options.getValidate() && !S2Polygon.isValid(loops)) {
            if (unusedEdges != null) {
                for (S2Loop loop : loops) {
                    S2PolygonBuilder.rejectLoop(loop, loop.numVertices(), unusedEdges);
                }
            }
            return false;
        }
        polygon.init(loops);
        return success;
    }

    public S2Polygon assemblePolygon() {
        S2Polygon polygon = new S2Polygon();
        ArrayList<S2Edge> unusedEdges = new ArrayList<S2Edge>();
        this.assemblePolygon(polygon, unusedEdges);
        return polygon;
    }

    protected void dumpEdges(S2Point v0) {
        log.info(v0.toString());
        List<S2Point> vset = this.edges.get(v0);
        if (vset != null) {
            for (S2Point v : vset) {
                log.info("    " + v.toString());
            }
        }
    }

    protected void dump() {
        for (S2Point v : this.edges.keySet()) {
            this.dumpEdges(v);
        }
    }

    private void eraseEdge(S2Point v0, S2Point v1) {
        List<S2Point> vset = this.edges.get(v0);
        vset.remove(v1);
        if (vset.isEmpty()) {
            this.edges.remove(v0);
        }
        if (this.options.getUndirectedEdges()) {
            vset = this.edges.get(v1);
            vset.remove(v0);
            if (vset.isEmpty()) {
                this.edges.remove(v1);
            }
        }
    }

    private void eraseLoop(List<S2Point> v, int n) {
        int i = n - 1;
        int j = 0;
        while (j < n) {
            this.eraseEdge(v.get(i), v.get(j));
            i = j++;
        }
    }

    private void eraseLoop(S2Loop v, int n) {
        int i = n - 1;
        int j = 0;
        while (j < n) {
            this.eraseEdge(v.vertex(i), v.vertex(j));
            i = j++;
        }
    }

    private S2Loop assembleLoop(S2Point v0, S2Point v1, List<S2Edge> unusedEdges) {
        List<S2Point> path = new ArrayList<S2Point>();
        HashMap<S2Point, Integer> index = new HashMap<S2Point, Integer>();
        path.add(v0);
        path.add(v1);
        index.put(v1, 1);
        while (path.size() >= 2) {
            v0 = (S2Point)path.get(path.size() - 2);
            v1 = (S2Point)path.get(path.size() - 1);
            S2Point v2 = null;
            boolean v2Found = false;
            List<S2Point> vset = this.edges.get(v1);
            if (vset != null) {
                for (S2Point v : vset) {
                    if (v.equals(v0)) continue;
                    if (!v2Found || S2.orderedCCW(v0, v2, v, v1)) {
                        v2 = v;
                    }
                    v2Found = true;
                }
            }
            if (!v2Found) {
                unusedEdges.add(new S2Edge(v0, v1));
                this.eraseEdge(v0, v1);
                index.remove(v1);
                path.remove(path.size() - 1);
                continue;
            }
            if (index.get(v2) == null) {
                index.put(v2, path.size());
                path.add(v2);
                continue;
            }
            path = path.subList((Integer)index.get(v2), path.size());
            if (this.options.getValidate() && !S2Loop.isValid(path)) {
                S2PolygonBuilder.rejectLoop(path, path.size(), unusedEdges);
                this.eraseLoop(path, path.size());
                return null;
            }
            return new S2Loop(path);
        }
        return null;
    }

    private static void rejectLoop(S2Loop v, int n, List<S2Edge> unusedEdges) {
        int i = n - 1;
        int j = 0;
        while (j < n) {
            unusedEdges.add(new S2Edge(v.vertex(i), v.vertex(j)));
            i = j++;
        }
    }

    private static void rejectLoop(List<S2Point> v, int n, List<S2Edge> unusedEdges) {
        int i = n - 1;
        int j = 0;
        while (j < n) {
            unusedEdges.add(new S2Edge(v.get(i), v.get(j)));
            i = j++;
        }
    }

    private void moveVertices(Map<S2Point, S2Point> mergeMap) {
        if (mergeMap.isEmpty()) {
            return;
        }
        ArrayList<S2Edge> edgesCopy = new ArrayList<S2Edge>();
        for (Map.Entry<S2Point, List<S2Point>> edge : this.edges.entrySet()) {
            S2Point v0 = edge.getKey();
            List<S2Point> vset = edge.getValue();
            for (S2Point v1 : vset) {
                if (mergeMap.get(v0) == null && mergeMap.get(v1) == null || this.options.getUndirectedEdges() && !v0.lessThan(v1)) continue;
                edgesCopy.add(new S2Edge(v0, v1));
            }
        }
        for (int i = 0; i < edgesCopy.size(); ++i) {
            S2Point v0 = ((S2Edge)edgesCopy.get(i)).getStart();
            S2Point v1 = ((S2Edge)edgesCopy.get(i)).getEnd();
            this.eraseEdge(v0, v1);
            if (mergeMap.get(v0) != null) {
                v0 = mergeMap.get(v0);
            }
            if (mergeMap.get(v1) != null) {
                v1 = mergeMap.get(v1);
            }
            this.addEdge(v0, v1);
        }
    }

    private void mergeVertices() {
        PointIndex index = new PointIndex(this.options.getMergeDistance().radians());
        for (Map.Entry<S2Point, List<S2Point>> edge : this.edges.entrySet()) {
            index.add(edge.getKey());
            List<S2Point> vset = edge.getValue();
            for (S2Point s2Point : vset) {
                index.add(s2Point);
            }
        }
        HashMap<S2Point, S2Point> mergeMap = new HashMap<S2Point, S2Point>();
        Stack<S2Point> frontier = new Stack<S2Point>();
        ArrayList<S2Point> mergeable = new ArrayList<S2Point>();
        for (Map.Entry entry : index.entries()) {
            MarkedS2Point point = (MarkedS2Point)entry.getValue();
            if (point.isMarked()) continue;
            point.mark();
            S2Point vstart = point.getPoint();
            frontier.push(vstart);
            while (!frontier.isEmpty()) {
                S2Point v0 = (S2Point)frontier.pop();
                index.query(v0, mergeable);
                for (S2Point v1 : mergeable) {
                    frontier.push(v1);
                    mergeMap.put(v1, vstart);
                }
            }
        }
        this.moveVertices(mergeMap);
    }

    private strictfp class MarkedS2Point {
        private S2Point point;
        private boolean mark;

        public MarkedS2Point(S2Point point) {
            this.point = point;
            this.mark = false;
        }

        public boolean isMarked() {
            return this.mark;
        }

        public S2Point getPoint() {
            return this.point;
        }

        public void mark() {
            this.mark = true;
        }
    }

    private strictfp class PointIndex
    extends HashMap<S2CellId, Collection<MarkedS2Point>> {
        private static final long serialVersionUID = -91465284468504495L;
        private double searchRadius;
        private int level;

        public PointIndex(double searchRadius) {
            this.searchRadius = searchRadius;
            this.level = Math.min(S2Projections.MIN_WIDTH.getMaxLevel(2.0 * searchRadius), 29);
        }

        public void add(S2Point p) {
            S2CellId id = S2CellId.fromPoint(p).parent(this.level);
            HashSet<MarkedS2Point> pointSet = (HashSet<MarkedS2Point>)this.get(id);
            if (pointSet == null) {
                pointSet = new HashSet<MarkedS2Point>();
            }
            for (MarkedS2Point point : pointSet) {
                if (!point.getPoint().equals(p)) continue;
                return;
            }
            this.put(id, pointSet);
            pointSet.add(new MarkedS2Point(p));
        }

        public void query(S2Point center, List<S2Point> output) {
            output.clear();
            ArrayList<S2CellId> neighbors = new ArrayList<S2CellId>();
            S2CellId.fromPoint(center).getVertexNeighbors(this.level, neighbors);
            for (S2CellId id : neighbors) {
                Collection points = (Collection)this.get(id);
                if (points == null) continue;
                for (MarkedS2Point mp : points) {
                    S2Point p;
                    if (mp.isMarked() || !(center.angle(p = mp.getPoint()) <= this.searchRadius)) continue;
                    output.add(p);
                    mp.mark();
                }
            }
        }

        public Collection<Map.Entry<S2CellId, MarkedS2Point>> entries() {
            HashSet<Map.Entry<S2CellId, MarkedS2Point>> result = new HashSet<Map.Entry<S2CellId, MarkedS2Point>>();
            for (Map.Entry entry : this.entrySet()) {
                S2CellId key = (S2CellId)entry.getKey();
                for (MarkedS2Point value : (Collection)entry.getValue()) {
                    result.add(new AbstractMap.SimpleEntry<S2CellId, MarkedS2Point>(key, value));
                }
            }
            return result;
        }
    }

    public strictfp static enum Options {
        DIRECTED_XOR(false, true),
        UNDIRECTED_XOR(true, true),
        UNDIRECTED_UNION(true, false),
        DIRECTED_UNION(false, false);

        private boolean undirectedEdges;
        private boolean xorEdges;
        private boolean validate;
        private S1Angle mergeDistance;

        private Options(boolean undirectedEdges, boolean xorEdges) {
            this.undirectedEdges = undirectedEdges;
            this.xorEdges = xorEdges;
            this.validate = false;
            this.mergeDistance = S1Angle.radians(0.0);
        }

        public boolean getUndirectedEdges() {
            return this.undirectedEdges;
        }

        public boolean getXorEdges() {
            return this.xorEdges;
        }

        public boolean getValidate() {
            return this.validate;
        }

        public S1Angle getMergeDistance() {
            return this.mergeDistance;
        }

        public void setValidate(boolean validate) {
            this.validate = validate;
        }

        public void setMergeDistance(S1Angle mergeDistance) {
            this.mergeDistance = mergeDistance;
        }

        void setUndirectedEdges(boolean undirectedEdges) {
            this.undirectedEdges = undirectedEdges;
        }

        void setXorEdges(boolean xorEdges) {
            this.xorEdges = xorEdges;
        }
    }
}

