/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.util.BeanUtil;
import org.apache.solr.common.annotation.JsonProperty;

public class SolrJacksonAnnotationInspector
extends AnnotationIntrospector {
    public static final SolrJacksonAnnotationInspector INSTANCE = new SolrJacksonAnnotationInspector();

    public Version version() {
        return Version.unknownVersion();
    }

    public PropertyName findNameForSerialization(Annotated a) {
        if (a instanceof AnnotatedMethod) {
            AnnotatedMethod am = (AnnotatedMethod)a;
            JsonProperty prop = (JsonProperty)am.getAnnotation(JsonProperty.class);
            if (prop == null) {
                return null;
            }
            if (prop.value().isEmpty()) {
                return new PropertyName(BeanUtil.okNameForGetter((AnnotatedMethod)am, (boolean)true));
            }
            return new PropertyName(prop.value());
        }
        if (a instanceof AnnotatedField) {
            AnnotatedField af = (AnnotatedField)a;
            JsonProperty prop = (JsonProperty)af.getAnnotation(JsonProperty.class);
            if (prop == null) {
                return null;
            }
            return prop.value().isEmpty() ? new PropertyName(af.getName()) : new PropertyName(prop.value());
        }
        return null;
    }

    public Boolean hasRequiredMarker(AnnotatedMember m) {
        JsonProperty prop = (JsonProperty)m.getAnnotation(JsonProperty.class);
        if (prop == null) {
            return Boolean.FALSE;
        }
        return prop.required();
    }

    public String findPropertyDefaultValue(Annotated m) {
        JsonProperty prop = (JsonProperty)m.getAnnotation(JsonProperty.class);
        if (prop == null) {
            return "";
        }
        return prop.defaultValue();
    }

    public PropertyName findNameForDeserialization(Annotated a) {
        return this.findNameForSerialization(a);
    }

    public static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setAnnotationIntrospector((AnnotationIntrospector)INSTANCE);
        return mapper;
    }
}

