/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.stats;

import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.stats.CollectionStats;
import org.apache.solr.search.stats.ExactStatsCache;
import org.apache.solr.search.stats.StatsSource;
import org.apache.solr.search.stats.StatsUtil;
import org.apache.solr.search.stats.TermStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExactSharedStatsCache
extends ExactStatsCache {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<String, Map<String, TermStats>> perShardTermStats = new ConcurrentHashMap<String, Map<String, TermStats>>();
    private final Map<String, Map<String, CollectionStats>> perShardColStats = new ConcurrentHashMap<String, Map<String, CollectionStats>>();
    private final Map<String, TermStats> currentGlobalTermStats = new ConcurrentHashMap<String, TermStats>();
    private final Map<String, CollectionStats> currentGlobalColStats = new ConcurrentHashMap<String, CollectionStats>();

    @Override
    protected StatsSource doGet(SolrQueryRequest req) {
        if (log.isDebugEnabled()) {
            log.debug("total={}, cache {}", this.currentGlobalColStats, (Object)this.currentGlobalTermStats.size());
        }
        return new ExactStatsCache.ExactStatsSource(this.statsCacheMetrics, this.currentGlobalTermStats, this.currentGlobalColStats);
    }

    @Override
    public void clear() {
        super.clear();
        this.perShardTermStats.clear();
        this.perShardColStats.clear();
        this.currentGlobalTermStats.clear();
        this.currentGlobalColStats.clear();
    }

    @Override
    protected void addToPerShardColStats(SolrQueryRequest req, String shard, Map<String, CollectionStats> colStats) {
        this.perShardColStats.put(shard, colStats);
    }

    @Override
    protected void printStats(SolrQueryRequest req) {
        log.debug("perShardColStats={}, perShardTermStats={}", this.perShardColStats, this.perShardTermStats);
    }

    @Override
    protected void addToPerShardTermStats(SolrQueryRequest req, String shard, String termStatsString) {
        Map<String, TermStats> termStats = StatsUtil.termStatsMapFromString(termStatsString);
        if (termStats != null) {
            this.perShardTermStats.put(shard, termStats);
        }
    }

    @Override
    protected Map<String, CollectionStats> getPerShardColStats(ResponseBuilder rb, String shard) {
        return this.perShardColStats.get(shard);
    }

    @Override
    protected TermStats getPerShardTermStats(SolrQueryRequest req, String t, String shard) {
        Map<String, TermStats> cache = this.perShardTermStats.get(shard);
        return cache != null ? cache.get(t) : null;
    }

    @Override
    protected void addToGlobalColStats(SolrQueryRequest req, Map.Entry<String, CollectionStats> e) {
        this.currentGlobalColStats.put(e.getKey(), e.getValue());
    }

    @Override
    protected void addToGlobalTermStats(SolrQueryRequest req, Map.Entry<String, TermStats> e) {
        this.currentGlobalTermStats.put(e.getKey(), e.getValue());
    }
}

