/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttleImpl;
import org.apache.calcite.rel.core.Correlate;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.rules.PushProjector;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.BitSets;
import org.apache.calcite.util.ImmutableBeans;
import org.apache.calcite.util.ImmutableBitSet;

public class ProjectCorrelateTransposeRule
extends RelRule<Config>
implements TransformationRule {
    protected ProjectCorrelateTransposeRule(Config config) {
        super(config);
    }

    @Deprecated
    public ProjectCorrelateTransposeRule(PushProjector.ExprCondition preserveExprCondition, RelBuilderFactory relBuilderFactory) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).as(Config.class).withPreserveExprCondition(preserveExprCondition));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Project origProject = (Project)call.rel(0);
        Correlate correlate = (Correlate)call.rel(1);
        PushProjector pushProjector = new PushProjector(origProject, call.builder().literal(true), correlate, ((Config)this.config).preserveExprCondition(), call.builder());
        if (pushProjector.locateAllRefs()) {
            return;
        }
        Project leftProject = pushProjector.createProjectRefsAndExprs(correlate.getLeft(), true, false);
        RelNode rightProject = pushProjector.createProjectRefsAndExprs(correlate.getRight(), true, true);
        HashMap<Integer, Integer> requiredColsMap = new HashMap<Integer, Integer>();
        int[] adjustments = pushProjector.getAdjustments();
        BitSet updatedBits = new BitSet();
        for (Integer col : correlate.getRequiredColumns()) {
            int newCol = col + adjustments[col];
            updatedBits.set(newCol);
            requiredColsMap.put(col, newCol);
        }
        RexBuilder rexBuilder = call.builder().getRexBuilder();
        CorrelationId correlationId = correlate.getCluster().createCorrel();
        RexCorrelVariable rexCorrel = (RexCorrelVariable)rexBuilder.makeCorrel(leftProject.getRowType(), correlationId);
        rightProject = rightProject.accept(new RelNodesExprsHandler(new RexFieldAccessReplacer(correlate.getCorrelationId(), rexCorrel, rexBuilder, requiredColsMap)));
        Correlate newCorrelate = correlate.copy(correlate.getTraitSet(), leftProject, rightProject, correlationId, ImmutableBitSet.of(BitSets.toIter(updatedBits)), correlate.getJoinType());
        RelNode topProject = pushProjector.createNewProject(newCorrelate, adjustments);
        call.transformTo(topProject);
    }

    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = EMPTY.as(Config.class).withOperandFor(Project.class, Correlate.class).withPreserveExprCondition(expr -> !(expr instanceof RexOver));

        @Override
        default public ProjectCorrelateTransposeRule toRule() {
            return new ProjectCorrelateTransposeRule(this);
        }

        @ImmutableBeans.Property
        public PushProjector.ExprCondition preserveExprCondition();

        public Config withPreserveExprCondition(PushProjector.ExprCondition var1);

        default public Config withOperandFor(Class<? extends Project> projectClass, Class<? extends Correlate> correlateClass) {
            return this.withOperandSupplier(b0 -> b0.operand(projectClass).oneInput(b1 -> b1.operand(correlateClass).anyInputs())).as(Config.class);
        }
    }

    public static class RelNodesExprsHandler
    extends RelShuttleImpl {
        private final RexShuttle rexVisitor;

        public RelNodesExprsHandler(RexShuttle rexVisitor) {
            this.rexVisitor = rexVisitor;
        }

        @Override
        protected RelNode visitChild(RelNode parent, int i, RelNode child) {
            if (child instanceof HepRelVertex) {
                child = ((HepRelVertex)child).getCurrentRel();
            } else if (child instanceof RelSubset) {
                RelSubset subset = (RelSubset)child;
                child = subset.getBestOrOriginal();
            }
            return super.visitChild(parent, i, child).accept(this.rexVisitor);
        }
    }

    public static class RexFieldAccessReplacer
    extends RexShuttle {
        private final RexBuilder builder;
        private final CorrelationId rexCorrelVariableToReplace;
        private final RexCorrelVariable rexCorrelVariable;
        private final Map<Integer, Integer> requiredColsMap;

        public RexFieldAccessReplacer(CorrelationId rexCorrelVariableToReplace, RexCorrelVariable rexCorrelVariable, RexBuilder builder, Map<Integer, Integer> requiredColsMap) {
            this.rexCorrelVariableToReplace = rexCorrelVariableToReplace;
            this.rexCorrelVariable = rexCorrelVariable;
            this.builder = builder;
            this.requiredColsMap = requiredColsMap;
        }

        @Override
        public RexNode visitCorrelVariable(RexCorrelVariable variable) {
            if (variable.id.equals(this.rexCorrelVariableToReplace)) {
                return this.rexCorrelVariable;
            }
            return variable;
        }

        @Override
        public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
            RexNode refExpr = fieldAccess.getReferenceExpr().accept(this);
            if (refExpr == this.rexCorrelVariable) {
                int fieldIndex = fieldAccess.getField().getIndex();
                return this.builder.makeFieldAccess(refExpr, Objects.requireNonNull(this.requiredColsMap.get(fieldIndex), () -> "no entry for field " + fieldIndex + " in " + this.requiredColsMap));
            }
            return super.visitFieldAccess(fieldAccess);
        }
    }
}

