/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.lucene.util.SuppressForbidden;
import org.apache.solr.analytics.AnalyticsRequestManager;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.BinaryQueryResponseWriter;
import org.apache.solr.response.SolrQueryResponse;

public class AnalyticsShardResponseWriter
implements BinaryQueryResponseWriter {
    public static final String NAME = "analytics_shard_stream";
    public static final String ANALYTICS_MANGER = "analyticsManager";

    public void write(OutputStream out, SolrQueryRequest req, SolrQueryResponse response) throws IOException {
        ((AnalyticsResponse)response.getResponse()).write(new DataOutputStream(out));
    }

    public void write(Writer writer, SolrQueryRequest request, SolrQueryResponse response) throws IOException {
        throw new RuntimeException("This is a binary writer , Cannot write to a characterstream");
    }

    public String getContentType(SolrQueryRequest request, SolrQueryResponse response) {
        return "application/octet-stream";
    }

    public void init(NamedList args) {
    }

    public static class AnalyticsResponse {
        private final AnalyticsRequestManager manager;
        private final SolrException exception;
        private final boolean requestSuccessful;

        public AnalyticsResponse(AnalyticsRequestManager manager) {
            this.manager = manager;
            this.exception = null;
            this.requestSuccessful = true;
        }

        public AnalyticsResponse(SolrException exception) {
            this.manager = null;
            this.exception = exception;
            this.requestSuccessful = false;
        }

        @SuppressForbidden(reason="XXX: security hole")
        public void write(DataOutputStream output) throws IOException {
            output.writeBoolean(this.requestSuccessful);
            if (this.requestSuccessful) {
                this.manager.exportShardData(output);
            } else {
                new ObjectOutputStream(output).writeObject((Object)this.exception);
            }
        }
    }
}

