/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.util;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.Row;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;

public abstract class RowFilter {
    public abstract boolean matches(Row var1);

    public Iterable<Row> apply(Iterable<? extends Row> iterable) {
        return new FilterIterable(iterable);
    }

    public static RowFilter matchPattern(final Map<String, ?> rowPattern) {
        return new RowFilter(){

            @Override
            public boolean matches(Row row) {
                for (Map.Entry e : rowPattern.entrySet()) {
                    if (Objects.equals(e.getValue(), row.get(e.getKey()))) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static RowFilter matchPattern(final Column columnPattern, final Object valuePattern) {
        return new RowFilter(){

            @Override
            public boolean matches(Row row) {
                return Objects.equals(valuePattern, columnPattern.getRowValue(row));
            }
        };
    }

    public static RowFilter invert(final RowFilter filter) {
        return new RowFilter(){

            @Override
            public boolean matches(Row row) {
                return !filter.matches(row);
            }
        };
    }

    public static Iterable<Row> apply(RowFilter rowFilter, Iterable<? extends Row> iterable) {
        return rowFilter != null ? rowFilter.apply(iterable) : iterable;
    }

    private class FilterIterable
    implements Iterable<Row> {
        private final Iterable<? extends Row> _iterable;

        private FilterIterable(Iterable<? extends Row> iterable) {
            this._iterable = iterable;
        }

        @Override
        public Iterator<Row> iterator() {
            return new Iterator<Row>(){
                private final Iterator<? extends Row> _iter;
                private Row _next;
                {
                    this._iter = FilterIterable.this._iterable.iterator();
                }

                @Override
                public boolean hasNext() {
                    while (this._iter.hasNext()) {
                        this._next = this._iter.next();
                        if (!RowFilter.this.matches(this._next)) continue;
                        return true;
                    }
                    this._next = null;
                    return false;
                }

                @Override
                public Row next() {
                    if (this._next == null) {
                        throw new NoSuchElementException();
                    }
                    return this._next;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

