/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Message;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.ipc.ResponseBuffer;

@InterfaceAudience.Private
public abstract class RpcWritable
implements Writable {
    static RpcWritable wrap(Object o) {
        if (o instanceof RpcWritable) {
            return (RpcWritable)o;
        }
        if (o instanceof Message) {
            return new ProtobufWrapper((Message)o);
        }
        if (o instanceof Writable) {
            return new WritableWrapper((Writable)o);
        }
        throw new IllegalArgumentException("Cannot wrap " + o.getClass());
    }

    @Override
    public final void readFields(DataInput in) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void write(DataOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }

    abstract void writeTo(ResponseBuffer var1) throws IOException;

    abstract <T> T readFrom(ByteBuffer var1) throws IOException;

    public static class Buffer
    extends RpcWritable {
        private ByteBuffer bb;

        public static Buffer wrap(ByteBuffer bb) {
            return new Buffer(bb);
        }

        Buffer() {
        }

        Buffer(ByteBuffer bb) {
            this.bb = bb;
        }

        ByteBuffer getByteBuffer() {
            return this.bb;
        }

        @Override
        void writeTo(ResponseBuffer out) throws IOException {
            out.ensureCapacity(this.bb.remaining());
            out.write(this.bb.array(), this.bb.position() + this.bb.arrayOffset(), this.bb.remaining());
        }

        @Override
        <T> T readFrom(ByteBuffer bb) throws IOException {
            this.bb = bb.slice();
            bb.limit(bb.position());
            return (T)this;
        }

        public <T> T newInstance(Class<T> valueClass, Configuration conf) throws IOException {
            T instance;
            try {
                instance = valueClass.newInstance();
                if (instance instanceof Configurable) {
                    ((Configurable)instance).setConf(conf);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return this.getValue(instance);
        }

        public <T> T getValue(T value) throws IOException {
            return RpcWritable.wrap(value).readFrom(this.bb);
        }

        public int remaining() {
            return this.bb.remaining();
        }
    }

    static class ProtobufWrapper
    extends RpcWritable {
        private Message message;

        ProtobufWrapper(Message message) {
            this.message = message;
        }

        Message getMessage() {
            return this.message;
        }

        @Override
        void writeTo(ResponseBuffer out) throws IOException {
            int length = this.message.getSerializedSize();
            length += CodedOutputStream.computeRawVarint32Size((int)length);
            out.ensureCapacity(length);
            this.message.writeDelimitedTo((OutputStream)out);
        }

        @Override
        <T> T readFrom(ByteBuffer bb) throws IOException {
            CodedInputStream cis = CodedInputStream.newInstance((byte[])bb.array(), (int)(bb.position() + bb.arrayOffset()), (int)bb.remaining());
            try {
                cis.pushLimit(cis.readRawVarint32());
                this.message = (Message)this.message.getParserForType().parseFrom(cis);
                cis.checkLastTagWas(0);
            }
            finally {
                bb.position(bb.position() + cis.getTotalBytesRead());
            }
            return (T)this.message;
        }
    }

    static class WritableWrapper
    extends RpcWritable {
        private final Writable writable;

        WritableWrapper(Writable writable) {
            this.writable = writable;
        }

        @Override
        public void writeTo(ResponseBuffer out) throws IOException {
            this.writable.write(out);
        }

        @Override
        <T> T readFrom(ByteBuffer bb) throws IOException {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(bb.array(), bb.position() + bb.arrayOffset(), bb.remaining()));
            try {
                this.writable.readFields(in);
            }
            finally {
                bb.position(bb.limit() - in.available());
            }
            return (T)this.writable;
        }
    }
}

