/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.io.IOException;
import java.util.Collections;
import opennlp.tools.ml.model.AbstractModel;
import opennlp.tools.ml.model.Event;
import opennlp.tools.ml.model.Sequence;
import opennlp.tools.ml.model.SequenceStream;
import opennlp.tools.namefind.BioCodec;
import opennlp.tools.namefind.DefaultNameContextGenerator;
import opennlp.tools.namefind.NameContextGenerator;
import opennlp.tools.namefind.NameFinderEventStream;
import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.SequenceCodec;
import opennlp.tools.util.featuregen.AdaptiveFeatureGenerator;

public class NameSampleSequenceStream
implements SequenceStream {
    private NameContextGenerator pcg;
    private final boolean useOutcomes;
    private ObjectStream<NameSample> psi;
    private SequenceCodec<String> seqCodec;

    public NameSampleSequenceStream(ObjectStream<NameSample> psi) throws IOException {
        this(psi, new DefaultNameContextGenerator(new AdaptiveFeatureGenerator[]{null}), true);
    }

    public NameSampleSequenceStream(ObjectStream<NameSample> psi, AdaptiveFeatureGenerator featureGen) throws IOException {
        this(psi, new DefaultNameContextGenerator(featureGen), true);
    }

    public NameSampleSequenceStream(ObjectStream<NameSample> psi, AdaptiveFeatureGenerator featureGen, boolean useOutcomes) throws IOException {
        this(psi, new DefaultNameContextGenerator(featureGen), useOutcomes);
    }

    public NameSampleSequenceStream(ObjectStream<NameSample> psi, NameContextGenerator pcg) throws IOException {
        this(psi, pcg, true);
    }

    public NameSampleSequenceStream(ObjectStream<NameSample> psi, NameContextGenerator pcg, boolean useOutcomes) throws IOException {
        this(psi, pcg, useOutcomes, new BioCodec());
    }

    public NameSampleSequenceStream(ObjectStream<NameSample> psi, NameContextGenerator pcg, boolean useOutcomes, SequenceCodec<String> seqCodec) throws IOException {
        this.psi = psi;
        this.useOutcomes = useOutcomes;
        this.pcg = pcg;
        this.seqCodec = seqCodec;
    }

    @Override
    public Event[] updateContext(Sequence sequence, AbstractModel model) {
        NameFinderME tagger = new NameFinderME(new TokenNameFinderModel("x-unspecified", model, Collections.emptyMap(), null));
        String[] sentence = ((NameSample)sequence.getSource()).getSentence();
        String[] tags = this.seqCodec.encode(tagger.find(sentence), sentence.length);
        Event[] events = new Event[sentence.length];
        NameFinderEventStream.generateEvents(sentence, tags, this.pcg).toArray(events);
        return events;
    }

    @Override
    public Sequence read() throws IOException {
        NameSample sample = this.psi.read();
        if (sample != null) {
            String[] sentence = sample.getSentence();
            String[] tags = this.seqCodec.encode(sample.getNames(), sentence.length);
            Event[] events = new Event[sentence.length];
            for (int i = 0; i < sentence.length; ++i) {
                String[] context = this.useOutcomes ? this.pcg.getContext(i, sentence, tags, null) : this.pcg.getContext(i, sentence, null, null);
                events[i] = new Event(tags[i], context);
            }
            return new Sequence<NameSample>(events, sample);
        }
        return null;
    }

    @Override
    public void reset() throws IOException, UnsupportedOperationException {
        this.psi.reset();
    }

    @Override
    public void close() throws IOException {
        this.psi.close();
    }
}

