function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import PropTypes from 'prop-types';
import React from 'react';
import classNames from 'classnames';
export function KuiToolBarSearchBox(_ref) {
  var defaultValue = _ref.defaultValue,
      filter = _ref.filter,
      onFilter = _ref.onFilter,
      placeholder = _ref.placeholder,
      className = _ref.className,
      rest = _objectWithoutProperties(_ref, ["defaultValue", "filter", "onFilter", "placeholder", "className"]);

  function onChange(event) {
    onFilter(event.target.value);
  }

  var classes = classNames('kuiToolBarSearch', className);
  return /*#__PURE__*/React.createElement("div", _extends({
    className: classes
  }, rest), /*#__PURE__*/React.createElement("div", {
    className: "kuiToolBarSearchBox"
  }, /*#__PURE__*/React.createElement("div", {
    className: "kuiToolBarSearchBox__icon kuiIcon fa-search"
  }), /*#__PURE__*/React.createElement("input", {
    defaultValue: defaultValue,
    className: "kuiToolBarSearchBox__input",
    type: "text",
    placeholder: placeholder,
    "aria-label": "Filter",
    value: filter,
    onChange: onChange
  })));
}
KuiToolBarSearchBox.propTypes = {
  defaultValue: PropTypes.string,
  filter: PropTypes.string,
  onFilter: PropTypes.func.isRequired
};
KuiToolBarSearchBox.defaultProps = {
  placeholder: 'Search...'
};
