/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.timescale;

import com.projectlibre1.strings.Messages;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class ExtendedDateFormat
extends SimpleDateFormat {
    protected boolean quarter;
    protected boolean half;
    protected boolean normal;
    protected String text;

    public ExtendedDateFormat() {
    }

    public ExtendedDateFormat(String string, DateFormatSymbols dateFormatSymbols) {
        super(string, dateFormatSymbols);
    }

    public ExtendedDateFormat(String string, Locale locale) {
        super(string, locale);
    }

    public ExtendedDateFormat(String string) {
        super(string);
    }

    @Override
    public void applyPattern(String string) {
        this.quarter = false;
        this.half = false;
        this.normal = false;
        if (string.startsWith("Q")) {
            int n = string.startsWith("QQ") ? 2 : 1;
            this.text = Messages.getString("Date.Quarter" + n);
            if (n == 2) {
                this.text = this.text + " ";
            }
            string = string.substring(n);
            this.quarter = true;
        } else if (string.startsWith("L")) {
            int n = string.startsWith("LL") ? 2 : 1;
            this.text = Messages.getString("Date.Half" + n);
            if (n == 2) {
                this.text = this.text + " ";
            }
            string = string.substring(n);
            this.half = true;
        }
        if (string.length() > 0) {
            super.applyPattern(string);
            this.normal = true;
        }
    }

    @Override
    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (this.quarter || this.half) {
            this.calendar.setTime(date);
            int n = this.calendar.get(2);
            stringBuffer.append(this.text).append(n / (this.quarter ? 3 : 6) + 1);
        }
        if (this.normal) {
            super.format(date, stringBuffer, fieldPosition);
        }
        return stringBuffer;
    }
}

