/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (12 & abs(- ivec4(-64, 72, 88, -76))) => ivec4(0, 8, 8, 12)
 * (12 & abs(- ivec4(64, 72, 88, 76))) => ivec4(0, 8, 8, 12)
 * (12 & abs(- ivec4(-24, 40, -23, 64))) => ivec4(8, 8, 4, 0)
 * (12 & abs(- ivec4(24, 40, 23, 64))) => ivec4(8, 8, 4, 0)
 * (-6 & abs(- ivec4(-64, 72, 88, -76))) => ivec4(64, 72, 88, 72)
 * (-6 & abs(- ivec4(64, 72, 88, 76))) => ivec4(64, 72, 88, 72)
 * (-6 & abs(- ivec4(-24, 40, -23, 64))) => ivec4(24, 40, 18, 64)
 * (-6 & abs(- ivec4(24, 40, 23, 64))) => ivec4(24, 40, 18, 64)
 * (76 & abs(- ivec4(-64, 72, 88, -76))) => ivec4(64, 72, 72, 76)
 * (76 & abs(- ivec4(64, 72, 88, 76))) => ivec4(64, 72, 72, 76)
 * (76 & abs(- ivec4(-24, 40, -23, 64))) => ivec4(8, 8, 4, 64)
 * (76 & abs(- ivec4(24, 40, 23, 64))) => ivec4(8, 8, 4, 64)
 * (-32 & abs(- ivec4(-64, 72, 88, -76))) => ivec4(64, 64, 64, 64)
 * (-32 & abs(- ivec4(64, 72, 88, 76))) => ivec4(64, 64, 64, 64)
 * (-32 & abs(- ivec4(-24, 40, -23, 64))) => ivec4(0, 32, 0, 64)
 * (-32 & abs(- ivec4(24, 40, 23, 64))) => ivec4(0, 32, 0, 64)
 * (0 & abs(- ivec4(-64, 72, 88, -76))) => ivec4(0, 0, 0, 0)
 * (0 & abs(- ivec4(64, 72, 88, 76))) => ivec4(0, 0, 0, 0)
 * (0 & abs(- ivec4(-24, 40, -23, 64))) => ivec4(0, 0, 0, 0)
 * (0 & abs(- ivec4(24, 40, 23, 64))) => ivec4(0, 0, 0, 0)
 */
#version 130

void main()
{
  float[all(equal((12 & abs(- ivec4(-64, 72, 88, -76))), ivec4(0, 8, 8, 12))) ? 1 : -1] array0;
  float[all(equal((12 & abs(- ivec4(64, 72, 88, 76))), ivec4(0, 8, 8, 12))) ? 1 : -1] array1;
  float[all(equal((12 & abs(- ivec4(-24, 40, -23, 64))), ivec4(8, 8, 4, 0))) ? 1 : -1] array2;
  float[all(equal((12 & abs(- ivec4(24, 40, 23, 64))), ivec4(8, 8, 4, 0))) ? 1 : -1] array3;
  float[all(equal((-6 & abs(- ivec4(-64, 72, 88, -76))), ivec4(64, 72, 88, 72))) ? 1 : -1] array4;
  float[all(equal((-6 & abs(- ivec4(64, 72, 88, 76))), ivec4(64, 72, 88, 72))) ? 1 : -1] array5;
  float[all(equal((-6 & abs(- ivec4(-24, 40, -23, 64))), ivec4(24, 40, 18, 64))) ? 1 : -1] array6;
  float[all(equal((-6 & abs(- ivec4(24, 40, 23, 64))), ivec4(24, 40, 18, 64))) ? 1 : -1] array7;
  float[all(equal((76 & abs(- ivec4(-64, 72, 88, -76))), ivec4(64, 72, 72, 76))) ? 1 : -1] array8;
  float[all(equal((76 & abs(- ivec4(64, 72, 88, 76))), ivec4(64, 72, 72, 76))) ? 1 : -1] array9;
  float[all(equal((76 & abs(- ivec4(-24, 40, -23, 64))), ivec4(8, 8, 4, 64))) ? 1 : -1] array10;
  float[all(equal((76 & abs(- ivec4(24, 40, 23, 64))), ivec4(8, 8, 4, 64))) ? 1 : -1] array11;
  float[all(equal((-32 & abs(- ivec4(-64, 72, 88, -76))), ivec4(64, 64, 64, 64))) ? 1 : -1] array12;
  float[all(equal((-32 & abs(- ivec4(64, 72, 88, 76))), ivec4(64, 64, 64, 64))) ? 1 : -1] array13;
  float[all(equal((-32 & abs(- ivec4(-24, 40, -23, 64))), ivec4(0, 32, 0, 64))) ? 1 : -1] array14;
  float[all(equal((-32 & abs(- ivec4(24, 40, 23, 64))), ivec4(0, 32, 0, 64))) ? 1 : -1] array15;
  float[all(equal((0 & abs(- ivec4(-64, 72, 88, -76))), ivec4(0, 0, 0, 0))) ? 1 : -1] array16;
  float[all(equal((0 & abs(- ivec4(64, 72, 88, 76))), ivec4(0, 0, 0, 0))) ? 1 : -1] array17;
  float[all(equal((0 & abs(- ivec4(-24, 40, -23, 64))), ivec4(0, 0, 0, 0))) ? 1 : -1] array18;
  float[all(equal((0 & abs(- ivec4(24, 40, 23, 64))), ivec4(0, 0, 0, 0))) ? 1 : -1] array19;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length());
}
