/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openvr;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct InputBindingInfo_t")
public class InputBindingInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RCHDEVICEPATHNAME;
    public static final int RCHINPUTPATHNAME;
    public static final int RCHMODENAME;
    public static final int RCHSLOTNAME;

    public InputBindingInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), InputBindingInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char[128]")
    public ByteBuffer rchDevicePathName() {
        return InputBindingInfo.nrchDevicePathName(this.address());
    }

    @NativeType(value="char[128]")
    public String rchDevicePathNameString() {
        return InputBindingInfo.nrchDevicePathNameString(this.address());
    }

    @NativeType(value="char[128]")
    public ByteBuffer rchInputPathName() {
        return InputBindingInfo.nrchInputPathName(this.address());
    }

    @NativeType(value="char[128]")
    public String rchInputPathNameString() {
        return InputBindingInfo.nrchInputPathNameString(this.address());
    }

    @NativeType(value="char[128]")
    public ByteBuffer rchModeName() {
        return InputBindingInfo.nrchModeName(this.address());
    }

    @NativeType(value="char[128]")
    public String rchModeNameString() {
        return InputBindingInfo.nrchModeNameString(this.address());
    }

    @NativeType(value="char[128]")
    public ByteBuffer rchSlotName() {
        return InputBindingInfo.nrchSlotName(this.address());
    }

    @NativeType(value="char[128]")
    public String rchSlotNameString() {
        return InputBindingInfo.nrchSlotNameString(this.address());
    }

    public static InputBindingInfo malloc() {
        return (InputBindingInfo)InputBindingInfo.wrap(InputBindingInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static InputBindingInfo calloc() {
        return (InputBindingInfo)InputBindingInfo.wrap(InputBindingInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static InputBindingInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (InputBindingInfo)InputBindingInfo.wrap(InputBindingInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static InputBindingInfo create(long address) {
        return (InputBindingInfo)InputBindingInfo.wrap(InputBindingInfo.class, (long)address);
    }

    @Nullable
    public static InputBindingInfo createSafe(long address) {
        return address == 0L ? null : (InputBindingInfo)InputBindingInfo.wrap(InputBindingInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)InputBindingInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)InputBindingInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)InputBindingInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = InputBindingInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)InputBindingInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)InputBindingInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)InputBindingInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static InputBindingInfo mallocStack() {
        return InputBindingInfo.mallocStack(MemoryStack.stackGet());
    }

    public static InputBindingInfo callocStack() {
        return InputBindingInfo.callocStack(MemoryStack.stackGet());
    }

    public static InputBindingInfo mallocStack(MemoryStack stack) {
        return (InputBindingInfo)InputBindingInfo.wrap(InputBindingInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static InputBindingInfo callocStack(MemoryStack stack) {
        return (InputBindingInfo)InputBindingInfo.wrap(InputBindingInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return InputBindingInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return InputBindingInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)InputBindingInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)InputBindingInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static ByteBuffer nrchDevicePathName(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)RCHDEVICEPATHNAME), (int)128);
    }

    public static String nrchDevicePathNameString(long struct) {
        return MemoryUtil.memASCII((long)(struct + (long)RCHDEVICEPATHNAME));
    }

    public static ByteBuffer nrchInputPathName(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)RCHINPUTPATHNAME), (int)128);
    }

    public static String nrchInputPathNameString(long struct) {
        return MemoryUtil.memASCII((long)(struct + (long)RCHINPUTPATHNAME));
    }

    public static ByteBuffer nrchModeName(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)RCHMODENAME), (int)128);
    }

    public static String nrchModeNameString(long struct) {
        return MemoryUtil.memASCII((long)(struct + (long)RCHMODENAME));
    }

    public static ByteBuffer nrchSlotName(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)RCHSLOTNAME), (int)128);
    }

    public static String nrchSlotNameString(long struct) {
        return MemoryUtil.memASCII((long)(struct + (long)RCHSLOTNAME));
    }

    static {
        Struct.Layout layout = InputBindingInfo.__struct((Struct.Member[])new Struct.Member[]{InputBindingInfo.__array((int)1, (int)128), InputBindingInfo.__array((int)1, (int)128), InputBindingInfo.__array((int)1, (int)128), InputBindingInfo.__array((int)1, (int)128)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        RCHDEVICEPATHNAME = layout.offsetof(0);
        RCHINPUTPATHNAME = layout.offsetof(1);
        RCHMODENAME = layout.offsetof(2);
        RCHSLOTNAME = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<InputBindingInfo, Buffer>
    implements NativeResource {
        private static final InputBindingInfo ELEMENT_FACTORY = InputBindingInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected InputBindingInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char[128]")
        public ByteBuffer rchDevicePathName() {
            return InputBindingInfo.nrchDevicePathName(this.address());
        }

        @NativeType(value="char[128]")
        public String rchDevicePathNameString() {
            return InputBindingInfo.nrchDevicePathNameString(this.address());
        }

        @NativeType(value="char[128]")
        public ByteBuffer rchInputPathName() {
            return InputBindingInfo.nrchInputPathName(this.address());
        }

        @NativeType(value="char[128]")
        public String rchInputPathNameString() {
            return InputBindingInfo.nrchInputPathNameString(this.address());
        }

        @NativeType(value="char[128]")
        public ByteBuffer rchModeName() {
            return InputBindingInfo.nrchModeName(this.address());
        }

        @NativeType(value="char[128]")
        public String rchModeNameString() {
            return InputBindingInfo.nrchModeNameString(this.address());
        }

        @NativeType(value="char[128]")
        public ByteBuffer rchSlotName() {
            return InputBindingInfo.nrchSlotName(this.address());
        }

        @NativeType(value="char[128]")
        public String rchSlotNameString() {
            return InputBindingInfo.nrchSlotNameString(this.address());
        }
    }
}

