/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkConformanceVersion;

public class VkPhysicalDeviceVulkan12Properties
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int DRIVERID;
    public static final int DRIVERNAME;
    public static final int DRIVERINFO;
    public static final int CONFORMANCEVERSION;
    public static final int DENORMBEHAVIORINDEPENDENCE;
    public static final int ROUNDINGMODEINDEPENDENCE;
    public static final int SHADERSIGNEDZEROINFNANPRESERVEFLOAT16;
    public static final int SHADERSIGNEDZEROINFNANPRESERVEFLOAT32;
    public static final int SHADERSIGNEDZEROINFNANPRESERVEFLOAT64;
    public static final int SHADERDENORMPRESERVEFLOAT16;
    public static final int SHADERDENORMPRESERVEFLOAT32;
    public static final int SHADERDENORMPRESERVEFLOAT64;
    public static final int SHADERDENORMFLUSHTOZEROFLOAT16;
    public static final int SHADERDENORMFLUSHTOZEROFLOAT32;
    public static final int SHADERDENORMFLUSHTOZEROFLOAT64;
    public static final int SHADERROUNDINGMODERTEFLOAT16;
    public static final int SHADERROUNDINGMODERTEFLOAT32;
    public static final int SHADERROUNDINGMODERTEFLOAT64;
    public static final int SHADERROUNDINGMODERTZFLOAT16;
    public static final int SHADERROUNDINGMODERTZFLOAT32;
    public static final int SHADERROUNDINGMODERTZFLOAT64;
    public static final int MAXUPDATEAFTERBINDDESCRIPTORSINALLPOOLS;
    public static final int SHADERUNIFORMBUFFERARRAYNONUNIFORMINDEXINGNATIVE;
    public static final int SHADERSAMPLEDIMAGEARRAYNONUNIFORMINDEXINGNATIVE;
    public static final int SHADERSTORAGEBUFFERARRAYNONUNIFORMINDEXINGNATIVE;
    public static final int SHADERSTORAGEIMAGEARRAYNONUNIFORMINDEXINGNATIVE;
    public static final int SHADERINPUTATTACHMENTARRAYNONUNIFORMINDEXINGNATIVE;
    public static final int ROBUSTBUFFERACCESSUPDATEAFTERBIND;
    public static final int QUADDIVERGENTIMPLICITLOD;
    public static final int MAXPERSTAGEDESCRIPTORUPDATEAFTERBINDSAMPLERS;
    public static final int MAXPERSTAGEDESCRIPTORUPDATEAFTERBINDUNIFORMBUFFERS;
    public static final int MAXPERSTAGEDESCRIPTORUPDATEAFTERBINDSTORAGEBUFFERS;
    public static final int MAXPERSTAGEDESCRIPTORUPDATEAFTERBINDSAMPLEDIMAGES;
    public static final int MAXPERSTAGEDESCRIPTORUPDATEAFTERBINDSTORAGEIMAGES;
    public static final int MAXPERSTAGEDESCRIPTORUPDATEAFTERBINDINPUTATTACHMENTS;
    public static final int MAXPERSTAGEUPDATEAFTERBINDRESOURCES;
    public static final int MAXDESCRIPTORSETUPDATEAFTERBINDSAMPLERS;
    public static final int MAXDESCRIPTORSETUPDATEAFTERBINDUNIFORMBUFFERS;
    public static final int MAXDESCRIPTORSETUPDATEAFTERBINDUNIFORMBUFFERSDYNAMIC;
    public static final int MAXDESCRIPTORSETUPDATEAFTERBINDSTORAGEBUFFERS;
    public static final int MAXDESCRIPTORSETUPDATEAFTERBINDSTORAGEBUFFERSDYNAMIC;
    public static final int MAXDESCRIPTORSETUPDATEAFTERBINDSAMPLEDIMAGES;
    public static final int MAXDESCRIPTORSETUPDATEAFTERBINDSTORAGEIMAGES;
    public static final int MAXDESCRIPTORSETUPDATEAFTERBINDINPUTATTACHMENTS;
    public static final int SUPPORTEDDEPTHRESOLVEMODES;
    public static final int SUPPORTEDSTENCILRESOLVEMODES;
    public static final int INDEPENDENTRESOLVENONE;
    public static final int INDEPENDENTRESOLVE;
    public static final int FILTERMINMAXSINGLECOMPONENTFORMATS;
    public static final int FILTERMINMAXIMAGECOMPONENTMAPPING;
    public static final int MAXTIMELINESEMAPHOREVALUEDIFFERENCE;
    public static final int FRAMEBUFFERINTEGERCOLORSAMPLECOUNTS;

    public VkPhysicalDeviceVulkan12Properties(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkPhysicalDeviceVulkan12Properties.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkPhysicalDeviceVulkan12Properties.nsType(this.address());
    }

    @NativeType(value="void *")
    public long pNext() {
        return VkPhysicalDeviceVulkan12Properties.npNext(this.address());
    }

    @NativeType(value="VkDriverId")
    public int driverID() {
        return VkPhysicalDeviceVulkan12Properties.ndriverID(this.address());
    }

    @NativeType(value="char[VK_MAX_DRIVER_NAME_SIZE]")
    public ByteBuffer driverName() {
        return VkPhysicalDeviceVulkan12Properties.ndriverName(this.address());
    }

    @NativeType(value="char[VK_MAX_DRIVER_NAME_SIZE]")
    public String driverNameString() {
        return VkPhysicalDeviceVulkan12Properties.ndriverNameString(this.address());
    }

    @NativeType(value="char[VK_MAX_DRIVER_INFO_SIZE]")
    public ByteBuffer driverInfo() {
        return VkPhysicalDeviceVulkan12Properties.ndriverInfo(this.address());
    }

    @NativeType(value="char[VK_MAX_DRIVER_INFO_SIZE]")
    public String driverInfoString() {
        return VkPhysicalDeviceVulkan12Properties.ndriverInfoString(this.address());
    }

    public VkConformanceVersion conformanceVersion() {
        return VkPhysicalDeviceVulkan12Properties.nconformanceVersion(this.address());
    }

    @NativeType(value="VkShaderFloatControlsIndependence")
    public int denormBehaviorIndependence() {
        return VkPhysicalDeviceVulkan12Properties.ndenormBehaviorIndependence(this.address());
    }

    @NativeType(value="VkShaderFloatControlsIndependence")
    public int roundingModeIndependence() {
        return VkPhysicalDeviceVulkan12Properties.nroundingModeIndependence(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean shaderSignedZeroInfNanPreserveFloat16() {
        return VkPhysicalDeviceVulkan12Properties.nshaderSignedZeroInfNanPreserveFloat16(this.address()) != 0;
    }

    @NativeType(value="VkBool32")
    public boolean shaderSignedZeroInfNanPreserveFloat32() {
        return VkPhysicalDeviceVulkan12Properties.nshaderSignedZeroInfNanPreserveFloat32(this.address()) != 0;
    }

    @NativeType(value="VkBool32")
    public boolean shaderSignedZeroInfNanPreserveFloat64() {
        return VkPhysicalDeviceVulkan12Properties.nshaderSignedZeroInfNanPreserveFloat64(this.address()) != 0;
    }

    @NativeType(value="VkBool32")
    public boolean shaderDenormPreserveFloat16() {
        return VkPhysicalDeviceVulkan12Properties.nshaderDenormPreserveFloat16(this.address()) != 0;
    }

    @NativeType(value="VkBool32")
    public boolean shaderDenormPreserveFloat32() {
        return VkPhysicalDeviceVulkan12Properties.nshaderDenormPreserveFloat32(this.address()) != 0;
    }

    @NativeType(value="VkBool32")
    public boolean shaderDenormPreserveFloat64() {
        return VkPhysicalDeviceVulkan12Properties.nshaderDenormPreserveFloat64(this.address()) != 0;
    }

    @NativeType(value="VkBool32")
    public boolean shaderDenormFlushToZeroFloat16() {
        return VkPhysicalDeviceVulkan12Properties.nshaderDenormFlushToZeroFloat16(this.address()) != 0;
    }

    @NativeType(value="VkBool32")
    public boolean shaderDenormFlushToZeroFloat32() {
        return VkPhysicalDeviceVulkan12Properties.nshaderDenormFlushToZeroFloat32(this.address()) != 0;
    }

    @NativeType(value="VkBool32")
    public boolean shaderDenormFlushToZeroFloat64() {
        return VkPhysicalDeviceVulkan12Properties.nshaderDenormFlushToZeroFloat64(this.address()) != 0;
    }

    @NativeType(value="VkBool32")
    public boolean shaderRoundingModeRTEFloat16() {
        return VkPhysicalDeviceVulkan12Properties.nshaderRoundingModeRTEFloat16(this.address()) != 0;
    }

    @NativeType(value="VkBool32")
    public boolean shaderRoundingModeRTEFloat32() {
        return VkPhysicalDeviceVulkan12Properties.nshaderRoundingModeRTEFloat32(this.address()) != 0;
    }

    @NativeType(value="VkBool32")
    public boolean shaderRoundingModeRTEFloat64() {
        return VkPhysicalDeviceVulkan12Properties.nshaderRoundingModeRTEFloat64(this.address()) != 0;
    }

    @NativeType(value="VkBool32")
    public boolean shaderRoundingModeRTZFloat16() {
        return VkPhysicalDeviceVulkan12Properties.nshaderRoundingModeRTZFloat16(this.address()) != 0;
    }

    @NativeType(value="VkBool32")
    public boolean shaderRoundingModeRTZFloat32() {
        return VkPhysicalDeviceVulkan12Properties.nshaderRoundingModeRTZFloat32(this.address()) != 0;
    }

    @NativeType(value="VkBool32")
    public boolean shaderRoundingModeRTZFloat64() {
        return VkPhysicalDeviceVulkan12Properties.nshaderRoundingModeRTZFloat64(this.address()) != 0;
    }

    @NativeType(value="uint32_t")
    public int maxUpdateAfterBindDescriptorsInAllPools() {
        return VkPhysicalDeviceVulkan12Properties.nmaxUpdateAfterBindDescriptorsInAllPools(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean shaderUniformBufferArrayNonUniformIndexingNative() {
        return VkPhysicalDeviceVulkan12Properties.nshaderUniformBufferArrayNonUniformIndexingNative(this.address()) != 0;
    }

    @NativeType(value="VkBool32")
    public boolean shaderSampledImageArrayNonUniformIndexingNative() {
        return VkPhysicalDeviceVulkan12Properties.nshaderSampledImageArrayNonUniformIndexingNative(this.address()) != 0;
    }

    @NativeType(value="VkBool32")
    public boolean shaderStorageBufferArrayNonUniformIndexingNative() {
        return VkPhysicalDeviceVulkan12Properties.nshaderStorageBufferArrayNonUniformIndexingNative(this.address()) != 0;
    }

    @NativeType(value="VkBool32")
    public boolean shaderStorageImageArrayNonUniformIndexingNative() {
        return VkPhysicalDeviceVulkan12Properties.nshaderStorageImageArrayNonUniformIndexingNative(this.address()) != 0;
    }

    @NativeType(value="VkBool32")
    public boolean shaderInputAttachmentArrayNonUniformIndexingNative() {
        return VkPhysicalDeviceVulkan12Properties.nshaderInputAttachmentArrayNonUniformIndexingNative(this.address()) != 0;
    }

    @NativeType(value="VkBool32")
    public boolean robustBufferAccessUpdateAfterBind() {
        return VkPhysicalDeviceVulkan12Properties.nrobustBufferAccessUpdateAfterBind(this.address()) != 0;
    }

    @NativeType(value="VkBool32")
    public boolean quadDivergentImplicitLod() {
        return VkPhysicalDeviceVulkan12Properties.nquadDivergentImplicitLod(this.address()) != 0;
    }

    @NativeType(value="uint32_t")
    public int maxPerStageDescriptorUpdateAfterBindSamplers() {
        return VkPhysicalDeviceVulkan12Properties.nmaxPerStageDescriptorUpdateAfterBindSamplers(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxPerStageDescriptorUpdateAfterBindUniformBuffers() {
        return VkPhysicalDeviceVulkan12Properties.nmaxPerStageDescriptorUpdateAfterBindUniformBuffers(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxPerStageDescriptorUpdateAfterBindStorageBuffers() {
        return VkPhysicalDeviceVulkan12Properties.nmaxPerStageDescriptorUpdateAfterBindStorageBuffers(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxPerStageDescriptorUpdateAfterBindSampledImages() {
        return VkPhysicalDeviceVulkan12Properties.nmaxPerStageDescriptorUpdateAfterBindSampledImages(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxPerStageDescriptorUpdateAfterBindStorageImages() {
        return VkPhysicalDeviceVulkan12Properties.nmaxPerStageDescriptorUpdateAfterBindStorageImages(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxPerStageDescriptorUpdateAfterBindInputAttachments() {
        return VkPhysicalDeviceVulkan12Properties.nmaxPerStageDescriptorUpdateAfterBindInputAttachments(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxPerStageUpdateAfterBindResources() {
        return VkPhysicalDeviceVulkan12Properties.nmaxPerStageUpdateAfterBindResources(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxDescriptorSetUpdateAfterBindSamplers() {
        return VkPhysicalDeviceVulkan12Properties.nmaxDescriptorSetUpdateAfterBindSamplers(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxDescriptorSetUpdateAfterBindUniformBuffers() {
        return VkPhysicalDeviceVulkan12Properties.nmaxDescriptorSetUpdateAfterBindUniformBuffers(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxDescriptorSetUpdateAfterBindUniformBuffersDynamic() {
        return VkPhysicalDeviceVulkan12Properties.nmaxDescriptorSetUpdateAfterBindUniformBuffersDynamic(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxDescriptorSetUpdateAfterBindStorageBuffers() {
        return VkPhysicalDeviceVulkan12Properties.nmaxDescriptorSetUpdateAfterBindStorageBuffers(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxDescriptorSetUpdateAfterBindStorageBuffersDynamic() {
        return VkPhysicalDeviceVulkan12Properties.nmaxDescriptorSetUpdateAfterBindStorageBuffersDynamic(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxDescriptorSetUpdateAfterBindSampledImages() {
        return VkPhysicalDeviceVulkan12Properties.nmaxDescriptorSetUpdateAfterBindSampledImages(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxDescriptorSetUpdateAfterBindStorageImages() {
        return VkPhysicalDeviceVulkan12Properties.nmaxDescriptorSetUpdateAfterBindStorageImages(this.address());
    }

    @NativeType(value="uint32_t")
    public int maxDescriptorSetUpdateAfterBindInputAttachments() {
        return VkPhysicalDeviceVulkan12Properties.nmaxDescriptorSetUpdateAfterBindInputAttachments(this.address());
    }

    @NativeType(value="VkResolveModeFlags")
    public int supportedDepthResolveModes() {
        return VkPhysicalDeviceVulkan12Properties.nsupportedDepthResolveModes(this.address());
    }

    @NativeType(value="VkResolveModeFlags")
    public int supportedStencilResolveModes() {
        return VkPhysicalDeviceVulkan12Properties.nsupportedStencilResolveModes(this.address());
    }

    @NativeType(value="VkBool32")
    public boolean independentResolveNone() {
        return VkPhysicalDeviceVulkan12Properties.nindependentResolveNone(this.address()) != 0;
    }

    @NativeType(value="VkBool32")
    public boolean independentResolve() {
        return VkPhysicalDeviceVulkan12Properties.nindependentResolve(this.address()) != 0;
    }

    @NativeType(value="VkBool32")
    public boolean filterMinmaxSingleComponentFormats() {
        return VkPhysicalDeviceVulkan12Properties.nfilterMinmaxSingleComponentFormats(this.address()) != 0;
    }

    @NativeType(value="VkBool32")
    public boolean filterMinmaxImageComponentMapping() {
        return VkPhysicalDeviceVulkan12Properties.nfilterMinmaxImageComponentMapping(this.address()) != 0;
    }

    @NativeType(value="uint64_t")
    public long maxTimelineSemaphoreValueDifference() {
        return VkPhysicalDeviceVulkan12Properties.nmaxTimelineSemaphoreValueDifference(this.address());
    }

    @NativeType(value="VkSampleCountFlags")
    public int framebufferIntegerColorSampleCounts() {
        return VkPhysicalDeviceVulkan12Properties.nframebufferIntegerColorSampleCounts(this.address());
    }

    public VkPhysicalDeviceVulkan12Properties sType(@NativeType(value="VkStructureType") int value) {
        VkPhysicalDeviceVulkan12Properties.nsType(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties pNext(@NativeType(value="void *") long value) {
        VkPhysicalDeviceVulkan12Properties.npNext(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties driverID(@NativeType(value="VkDriverId") int value) {
        VkPhysicalDeviceVulkan12Properties.ndriverID(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties driverName(@NativeType(value="char[VK_MAX_DRIVER_NAME_SIZE]") ByteBuffer value) {
        VkPhysicalDeviceVulkan12Properties.ndriverName(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties driverInfo(@NativeType(value="char[VK_MAX_DRIVER_INFO_SIZE]") ByteBuffer value) {
        VkPhysicalDeviceVulkan12Properties.ndriverInfo(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties conformanceVersion(VkConformanceVersion value) {
        VkPhysicalDeviceVulkan12Properties.nconformanceVersion(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties conformanceVersion(Consumer<VkConformanceVersion> consumer) {
        consumer.accept(this.conformanceVersion());
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties denormBehaviorIndependence(@NativeType(value="VkShaderFloatControlsIndependence") int value) {
        VkPhysicalDeviceVulkan12Properties.ndenormBehaviorIndependence(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties roundingModeIndependence(@NativeType(value="VkShaderFloatControlsIndependence") int value) {
        VkPhysicalDeviceVulkan12Properties.nroundingModeIndependence(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties shaderSignedZeroInfNanPreserveFloat16(@NativeType(value="VkBool32") boolean value) {
        VkPhysicalDeviceVulkan12Properties.nshaderSignedZeroInfNanPreserveFloat16(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties shaderSignedZeroInfNanPreserveFloat32(@NativeType(value="VkBool32") boolean value) {
        VkPhysicalDeviceVulkan12Properties.nshaderSignedZeroInfNanPreserveFloat32(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties shaderSignedZeroInfNanPreserveFloat64(@NativeType(value="VkBool32") boolean value) {
        VkPhysicalDeviceVulkan12Properties.nshaderSignedZeroInfNanPreserveFloat64(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties shaderDenormPreserveFloat16(@NativeType(value="VkBool32") boolean value) {
        VkPhysicalDeviceVulkan12Properties.nshaderDenormPreserveFloat16(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties shaderDenormPreserveFloat32(@NativeType(value="VkBool32") boolean value) {
        VkPhysicalDeviceVulkan12Properties.nshaderDenormPreserveFloat32(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties shaderDenormPreserveFloat64(@NativeType(value="VkBool32") boolean value) {
        VkPhysicalDeviceVulkan12Properties.nshaderDenormPreserveFloat64(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties shaderDenormFlushToZeroFloat16(@NativeType(value="VkBool32") boolean value) {
        VkPhysicalDeviceVulkan12Properties.nshaderDenormFlushToZeroFloat16(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties shaderDenormFlushToZeroFloat32(@NativeType(value="VkBool32") boolean value) {
        VkPhysicalDeviceVulkan12Properties.nshaderDenormFlushToZeroFloat32(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties shaderDenormFlushToZeroFloat64(@NativeType(value="VkBool32") boolean value) {
        VkPhysicalDeviceVulkan12Properties.nshaderDenormFlushToZeroFloat64(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties shaderRoundingModeRTEFloat16(@NativeType(value="VkBool32") boolean value) {
        VkPhysicalDeviceVulkan12Properties.nshaderRoundingModeRTEFloat16(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties shaderRoundingModeRTEFloat32(@NativeType(value="VkBool32") boolean value) {
        VkPhysicalDeviceVulkan12Properties.nshaderRoundingModeRTEFloat32(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties shaderRoundingModeRTEFloat64(@NativeType(value="VkBool32") boolean value) {
        VkPhysicalDeviceVulkan12Properties.nshaderRoundingModeRTEFloat64(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties shaderRoundingModeRTZFloat16(@NativeType(value="VkBool32") boolean value) {
        VkPhysicalDeviceVulkan12Properties.nshaderRoundingModeRTZFloat16(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties shaderRoundingModeRTZFloat32(@NativeType(value="VkBool32") boolean value) {
        VkPhysicalDeviceVulkan12Properties.nshaderRoundingModeRTZFloat32(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties shaderRoundingModeRTZFloat64(@NativeType(value="VkBool32") boolean value) {
        VkPhysicalDeviceVulkan12Properties.nshaderRoundingModeRTZFloat64(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties maxUpdateAfterBindDescriptorsInAllPools(@NativeType(value="uint32_t") int value) {
        VkPhysicalDeviceVulkan12Properties.nmaxUpdateAfterBindDescriptorsInAllPools(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties shaderUniformBufferArrayNonUniformIndexingNative(@NativeType(value="VkBool32") boolean value) {
        VkPhysicalDeviceVulkan12Properties.nshaderUniformBufferArrayNonUniformIndexingNative(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties shaderSampledImageArrayNonUniformIndexingNative(@NativeType(value="VkBool32") boolean value) {
        VkPhysicalDeviceVulkan12Properties.nshaderSampledImageArrayNonUniformIndexingNative(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties shaderStorageBufferArrayNonUniformIndexingNative(@NativeType(value="VkBool32") boolean value) {
        VkPhysicalDeviceVulkan12Properties.nshaderStorageBufferArrayNonUniformIndexingNative(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties shaderStorageImageArrayNonUniformIndexingNative(@NativeType(value="VkBool32") boolean value) {
        VkPhysicalDeviceVulkan12Properties.nshaderStorageImageArrayNonUniformIndexingNative(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties shaderInputAttachmentArrayNonUniformIndexingNative(@NativeType(value="VkBool32") boolean value) {
        VkPhysicalDeviceVulkan12Properties.nshaderInputAttachmentArrayNonUniformIndexingNative(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties robustBufferAccessUpdateAfterBind(@NativeType(value="VkBool32") boolean value) {
        VkPhysicalDeviceVulkan12Properties.nrobustBufferAccessUpdateAfterBind(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties quadDivergentImplicitLod(@NativeType(value="VkBool32") boolean value) {
        VkPhysicalDeviceVulkan12Properties.nquadDivergentImplicitLod(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties maxPerStageDescriptorUpdateAfterBindSamplers(@NativeType(value="uint32_t") int value) {
        VkPhysicalDeviceVulkan12Properties.nmaxPerStageDescriptorUpdateAfterBindSamplers(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties maxPerStageDescriptorUpdateAfterBindUniformBuffers(@NativeType(value="uint32_t") int value) {
        VkPhysicalDeviceVulkan12Properties.nmaxPerStageDescriptorUpdateAfterBindUniformBuffers(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties maxPerStageDescriptorUpdateAfterBindStorageBuffers(@NativeType(value="uint32_t") int value) {
        VkPhysicalDeviceVulkan12Properties.nmaxPerStageDescriptorUpdateAfterBindStorageBuffers(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties maxPerStageDescriptorUpdateAfterBindSampledImages(@NativeType(value="uint32_t") int value) {
        VkPhysicalDeviceVulkan12Properties.nmaxPerStageDescriptorUpdateAfterBindSampledImages(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties maxPerStageDescriptorUpdateAfterBindStorageImages(@NativeType(value="uint32_t") int value) {
        VkPhysicalDeviceVulkan12Properties.nmaxPerStageDescriptorUpdateAfterBindStorageImages(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties maxPerStageDescriptorUpdateAfterBindInputAttachments(@NativeType(value="uint32_t") int value) {
        VkPhysicalDeviceVulkan12Properties.nmaxPerStageDescriptorUpdateAfterBindInputAttachments(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties maxPerStageUpdateAfterBindResources(@NativeType(value="uint32_t") int value) {
        VkPhysicalDeviceVulkan12Properties.nmaxPerStageUpdateAfterBindResources(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties maxDescriptorSetUpdateAfterBindSamplers(@NativeType(value="uint32_t") int value) {
        VkPhysicalDeviceVulkan12Properties.nmaxDescriptorSetUpdateAfterBindSamplers(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties maxDescriptorSetUpdateAfterBindUniformBuffers(@NativeType(value="uint32_t") int value) {
        VkPhysicalDeviceVulkan12Properties.nmaxDescriptorSetUpdateAfterBindUniformBuffers(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties maxDescriptorSetUpdateAfterBindUniformBuffersDynamic(@NativeType(value="uint32_t") int value) {
        VkPhysicalDeviceVulkan12Properties.nmaxDescriptorSetUpdateAfterBindUniformBuffersDynamic(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties maxDescriptorSetUpdateAfterBindStorageBuffers(@NativeType(value="uint32_t") int value) {
        VkPhysicalDeviceVulkan12Properties.nmaxDescriptorSetUpdateAfterBindStorageBuffers(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties maxDescriptorSetUpdateAfterBindStorageBuffersDynamic(@NativeType(value="uint32_t") int value) {
        VkPhysicalDeviceVulkan12Properties.nmaxDescriptorSetUpdateAfterBindStorageBuffersDynamic(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties maxDescriptorSetUpdateAfterBindSampledImages(@NativeType(value="uint32_t") int value) {
        VkPhysicalDeviceVulkan12Properties.nmaxDescriptorSetUpdateAfterBindSampledImages(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties maxDescriptorSetUpdateAfterBindStorageImages(@NativeType(value="uint32_t") int value) {
        VkPhysicalDeviceVulkan12Properties.nmaxDescriptorSetUpdateAfterBindStorageImages(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties maxDescriptorSetUpdateAfterBindInputAttachments(@NativeType(value="uint32_t") int value) {
        VkPhysicalDeviceVulkan12Properties.nmaxDescriptorSetUpdateAfterBindInputAttachments(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties supportedDepthResolveModes(@NativeType(value="VkResolveModeFlags") int value) {
        VkPhysicalDeviceVulkan12Properties.nsupportedDepthResolveModes(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties supportedStencilResolveModes(@NativeType(value="VkResolveModeFlags") int value) {
        VkPhysicalDeviceVulkan12Properties.nsupportedStencilResolveModes(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties independentResolveNone(@NativeType(value="VkBool32") boolean value) {
        VkPhysicalDeviceVulkan12Properties.nindependentResolveNone(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties independentResolve(@NativeType(value="VkBool32") boolean value) {
        VkPhysicalDeviceVulkan12Properties.nindependentResolve(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties filterMinmaxSingleComponentFormats(@NativeType(value="VkBool32") boolean value) {
        VkPhysicalDeviceVulkan12Properties.nfilterMinmaxSingleComponentFormats(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties filterMinmaxImageComponentMapping(@NativeType(value="VkBool32") boolean value) {
        VkPhysicalDeviceVulkan12Properties.nfilterMinmaxImageComponentMapping(this.address(), value ? 1 : 0);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties maxTimelineSemaphoreValueDifference(@NativeType(value="uint64_t") long value) {
        VkPhysicalDeviceVulkan12Properties.nmaxTimelineSemaphoreValueDifference(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties framebufferIntegerColorSampleCounts(@NativeType(value="VkSampleCountFlags") int value) {
        VkPhysicalDeviceVulkan12Properties.nframebufferIntegerColorSampleCounts(this.address(), value);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties set(int sType, long pNext, int driverID, ByteBuffer driverName, ByteBuffer driverInfo, VkConformanceVersion conformanceVersion, int denormBehaviorIndependence, int roundingModeIndependence, boolean shaderSignedZeroInfNanPreserveFloat16, boolean shaderSignedZeroInfNanPreserveFloat32, boolean shaderSignedZeroInfNanPreserveFloat64, boolean shaderDenormPreserveFloat16, boolean shaderDenormPreserveFloat32, boolean shaderDenormPreserveFloat64, boolean shaderDenormFlushToZeroFloat16, boolean shaderDenormFlushToZeroFloat32, boolean shaderDenormFlushToZeroFloat64, boolean shaderRoundingModeRTEFloat16, boolean shaderRoundingModeRTEFloat32, boolean shaderRoundingModeRTEFloat64, boolean shaderRoundingModeRTZFloat16, boolean shaderRoundingModeRTZFloat32, boolean shaderRoundingModeRTZFloat64, int maxUpdateAfterBindDescriptorsInAllPools, boolean shaderUniformBufferArrayNonUniformIndexingNative, boolean shaderSampledImageArrayNonUniformIndexingNative, boolean shaderStorageBufferArrayNonUniformIndexingNative, boolean shaderStorageImageArrayNonUniformIndexingNative, boolean shaderInputAttachmentArrayNonUniformIndexingNative, boolean robustBufferAccessUpdateAfterBind, boolean quadDivergentImplicitLod, int maxPerStageDescriptorUpdateAfterBindSamplers, int maxPerStageDescriptorUpdateAfterBindUniformBuffers, int maxPerStageDescriptorUpdateAfterBindStorageBuffers, int maxPerStageDescriptorUpdateAfterBindSampledImages, int maxPerStageDescriptorUpdateAfterBindStorageImages, int maxPerStageDescriptorUpdateAfterBindInputAttachments, int maxPerStageUpdateAfterBindResources, int maxDescriptorSetUpdateAfterBindSamplers, int maxDescriptorSetUpdateAfterBindUniformBuffers, int maxDescriptorSetUpdateAfterBindUniformBuffersDynamic, int maxDescriptorSetUpdateAfterBindStorageBuffers, int maxDescriptorSetUpdateAfterBindStorageBuffersDynamic, int maxDescriptorSetUpdateAfterBindSampledImages, int maxDescriptorSetUpdateAfterBindStorageImages, int maxDescriptorSetUpdateAfterBindInputAttachments, int supportedDepthResolveModes, int supportedStencilResolveModes, boolean independentResolveNone, boolean independentResolve, boolean filterMinmaxSingleComponentFormats, boolean filterMinmaxImageComponentMapping, long maxTimelineSemaphoreValueDifference, int framebufferIntegerColorSampleCounts) {
        this.sType(sType);
        this.pNext(pNext);
        this.driverID(driverID);
        this.driverName(driverName);
        this.driverInfo(driverInfo);
        this.conformanceVersion(conformanceVersion);
        this.denormBehaviorIndependence(denormBehaviorIndependence);
        this.roundingModeIndependence(roundingModeIndependence);
        this.shaderSignedZeroInfNanPreserveFloat16(shaderSignedZeroInfNanPreserveFloat16);
        this.shaderSignedZeroInfNanPreserveFloat32(shaderSignedZeroInfNanPreserveFloat32);
        this.shaderSignedZeroInfNanPreserveFloat64(shaderSignedZeroInfNanPreserveFloat64);
        this.shaderDenormPreserveFloat16(shaderDenormPreserveFloat16);
        this.shaderDenormPreserveFloat32(shaderDenormPreserveFloat32);
        this.shaderDenormPreserveFloat64(shaderDenormPreserveFloat64);
        this.shaderDenormFlushToZeroFloat16(shaderDenormFlushToZeroFloat16);
        this.shaderDenormFlushToZeroFloat32(shaderDenormFlushToZeroFloat32);
        this.shaderDenormFlushToZeroFloat64(shaderDenormFlushToZeroFloat64);
        this.shaderRoundingModeRTEFloat16(shaderRoundingModeRTEFloat16);
        this.shaderRoundingModeRTEFloat32(shaderRoundingModeRTEFloat32);
        this.shaderRoundingModeRTEFloat64(shaderRoundingModeRTEFloat64);
        this.shaderRoundingModeRTZFloat16(shaderRoundingModeRTZFloat16);
        this.shaderRoundingModeRTZFloat32(shaderRoundingModeRTZFloat32);
        this.shaderRoundingModeRTZFloat64(shaderRoundingModeRTZFloat64);
        this.maxUpdateAfterBindDescriptorsInAllPools(maxUpdateAfterBindDescriptorsInAllPools);
        this.shaderUniformBufferArrayNonUniformIndexingNative(shaderUniformBufferArrayNonUniformIndexingNative);
        this.shaderSampledImageArrayNonUniformIndexingNative(shaderSampledImageArrayNonUniformIndexingNative);
        this.shaderStorageBufferArrayNonUniformIndexingNative(shaderStorageBufferArrayNonUniformIndexingNative);
        this.shaderStorageImageArrayNonUniformIndexingNative(shaderStorageImageArrayNonUniformIndexingNative);
        this.shaderInputAttachmentArrayNonUniformIndexingNative(shaderInputAttachmentArrayNonUniformIndexingNative);
        this.robustBufferAccessUpdateAfterBind(robustBufferAccessUpdateAfterBind);
        this.quadDivergentImplicitLod(quadDivergentImplicitLod);
        this.maxPerStageDescriptorUpdateAfterBindSamplers(maxPerStageDescriptorUpdateAfterBindSamplers);
        this.maxPerStageDescriptorUpdateAfterBindUniformBuffers(maxPerStageDescriptorUpdateAfterBindUniformBuffers);
        this.maxPerStageDescriptorUpdateAfterBindStorageBuffers(maxPerStageDescriptorUpdateAfterBindStorageBuffers);
        this.maxPerStageDescriptorUpdateAfterBindSampledImages(maxPerStageDescriptorUpdateAfterBindSampledImages);
        this.maxPerStageDescriptorUpdateAfterBindStorageImages(maxPerStageDescriptorUpdateAfterBindStorageImages);
        this.maxPerStageDescriptorUpdateAfterBindInputAttachments(maxPerStageDescriptorUpdateAfterBindInputAttachments);
        this.maxPerStageUpdateAfterBindResources(maxPerStageUpdateAfterBindResources);
        this.maxDescriptorSetUpdateAfterBindSamplers(maxDescriptorSetUpdateAfterBindSamplers);
        this.maxDescriptorSetUpdateAfterBindUniformBuffers(maxDescriptorSetUpdateAfterBindUniformBuffers);
        this.maxDescriptorSetUpdateAfterBindUniformBuffersDynamic(maxDescriptorSetUpdateAfterBindUniformBuffersDynamic);
        this.maxDescriptorSetUpdateAfterBindStorageBuffers(maxDescriptorSetUpdateAfterBindStorageBuffers);
        this.maxDescriptorSetUpdateAfterBindStorageBuffersDynamic(maxDescriptorSetUpdateAfterBindStorageBuffersDynamic);
        this.maxDescriptorSetUpdateAfterBindSampledImages(maxDescriptorSetUpdateAfterBindSampledImages);
        this.maxDescriptorSetUpdateAfterBindStorageImages(maxDescriptorSetUpdateAfterBindStorageImages);
        this.maxDescriptorSetUpdateAfterBindInputAttachments(maxDescriptorSetUpdateAfterBindInputAttachments);
        this.supportedDepthResolveModes(supportedDepthResolveModes);
        this.supportedStencilResolveModes(supportedStencilResolveModes);
        this.independentResolveNone(independentResolveNone);
        this.independentResolve(independentResolve);
        this.filterMinmaxSingleComponentFormats(filterMinmaxSingleComponentFormats);
        this.filterMinmaxImageComponentMapping(filterMinmaxImageComponentMapping);
        this.maxTimelineSemaphoreValueDifference(maxTimelineSemaphoreValueDifference);
        this.framebufferIntegerColorSampleCounts(framebufferIntegerColorSampleCounts);
        return this;
    }

    public VkPhysicalDeviceVulkan12Properties set(VkPhysicalDeviceVulkan12Properties src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkPhysicalDeviceVulkan12Properties malloc() {
        return (VkPhysicalDeviceVulkan12Properties)VkPhysicalDeviceVulkan12Properties.wrap(VkPhysicalDeviceVulkan12Properties.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkPhysicalDeviceVulkan12Properties calloc() {
        return (VkPhysicalDeviceVulkan12Properties)VkPhysicalDeviceVulkan12Properties.wrap(VkPhysicalDeviceVulkan12Properties.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkPhysicalDeviceVulkan12Properties create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkPhysicalDeviceVulkan12Properties)VkPhysicalDeviceVulkan12Properties.wrap(VkPhysicalDeviceVulkan12Properties.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkPhysicalDeviceVulkan12Properties create(long address) {
        return (VkPhysicalDeviceVulkan12Properties)VkPhysicalDeviceVulkan12Properties.wrap(VkPhysicalDeviceVulkan12Properties.class, (long)address);
    }

    @Nullable
    public static VkPhysicalDeviceVulkan12Properties createSafe(long address) {
        return address == 0L ? null : (VkPhysicalDeviceVulkan12Properties)VkPhysicalDeviceVulkan12Properties.wrap(VkPhysicalDeviceVulkan12Properties.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkPhysicalDeviceVulkan12Properties.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkPhysicalDeviceVulkan12Properties.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkPhysicalDeviceVulkan12Properties.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPhysicalDeviceVulkan12Properties.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkPhysicalDeviceVulkan12Properties.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkPhysicalDeviceVulkan12Properties.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkPhysicalDeviceVulkan12Properties.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkPhysicalDeviceVulkan12Properties mallocStack() {
        return VkPhysicalDeviceVulkan12Properties.mallocStack(MemoryStack.stackGet());
    }

    public static VkPhysicalDeviceVulkan12Properties callocStack() {
        return VkPhysicalDeviceVulkan12Properties.callocStack(MemoryStack.stackGet());
    }

    public static VkPhysicalDeviceVulkan12Properties mallocStack(MemoryStack stack) {
        return (VkPhysicalDeviceVulkan12Properties)VkPhysicalDeviceVulkan12Properties.wrap(VkPhysicalDeviceVulkan12Properties.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPhysicalDeviceVulkan12Properties callocStack(MemoryStack stack) {
        return (VkPhysicalDeviceVulkan12Properties)VkPhysicalDeviceVulkan12Properties.wrap(VkPhysicalDeviceVulkan12Properties.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkPhysicalDeviceVulkan12Properties.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkPhysicalDeviceVulkan12Properties.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkPhysicalDeviceVulkan12Properties.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkPhysicalDeviceVulkan12Properties.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int ndriverID(long struct) {
        return UNSAFE.getInt(null, struct + (long)DRIVERID);
    }

    public static ByteBuffer ndriverName(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)DRIVERNAME), (int)256);
    }

    public static String ndriverNameString(long struct) {
        return MemoryUtil.memUTF8((long)(struct + (long)DRIVERNAME));
    }

    public static ByteBuffer ndriverInfo(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)DRIVERINFO), (int)256);
    }

    public static String ndriverInfoString(long struct) {
        return MemoryUtil.memUTF8((long)(struct + (long)DRIVERINFO));
    }

    public static VkConformanceVersion nconformanceVersion(long struct) {
        return VkConformanceVersion.create(struct + (long)CONFORMANCEVERSION);
    }

    public static int ndenormBehaviorIndependence(long struct) {
        return UNSAFE.getInt(null, struct + (long)DENORMBEHAVIORINDEPENDENCE);
    }

    public static int nroundingModeIndependence(long struct) {
        return UNSAFE.getInt(null, struct + (long)ROUNDINGMODEINDEPENDENCE);
    }

    public static int nshaderSignedZeroInfNanPreserveFloat16(long struct) {
        return UNSAFE.getInt(null, struct + (long)SHADERSIGNEDZEROINFNANPRESERVEFLOAT16);
    }

    public static int nshaderSignedZeroInfNanPreserveFloat32(long struct) {
        return UNSAFE.getInt(null, struct + (long)SHADERSIGNEDZEROINFNANPRESERVEFLOAT32);
    }

    public static int nshaderSignedZeroInfNanPreserveFloat64(long struct) {
        return UNSAFE.getInt(null, struct + (long)SHADERSIGNEDZEROINFNANPRESERVEFLOAT64);
    }

    public static int nshaderDenormPreserveFloat16(long struct) {
        return UNSAFE.getInt(null, struct + (long)SHADERDENORMPRESERVEFLOAT16);
    }

    public static int nshaderDenormPreserveFloat32(long struct) {
        return UNSAFE.getInt(null, struct + (long)SHADERDENORMPRESERVEFLOAT32);
    }

    public static int nshaderDenormPreserveFloat64(long struct) {
        return UNSAFE.getInt(null, struct + (long)SHADERDENORMPRESERVEFLOAT64);
    }

    public static int nshaderDenormFlushToZeroFloat16(long struct) {
        return UNSAFE.getInt(null, struct + (long)SHADERDENORMFLUSHTOZEROFLOAT16);
    }

    public static int nshaderDenormFlushToZeroFloat32(long struct) {
        return UNSAFE.getInt(null, struct + (long)SHADERDENORMFLUSHTOZEROFLOAT32);
    }

    public static int nshaderDenormFlushToZeroFloat64(long struct) {
        return UNSAFE.getInt(null, struct + (long)SHADERDENORMFLUSHTOZEROFLOAT64);
    }

    public static int nshaderRoundingModeRTEFloat16(long struct) {
        return UNSAFE.getInt(null, struct + (long)SHADERROUNDINGMODERTEFLOAT16);
    }

    public static int nshaderRoundingModeRTEFloat32(long struct) {
        return UNSAFE.getInt(null, struct + (long)SHADERROUNDINGMODERTEFLOAT32);
    }

    public static int nshaderRoundingModeRTEFloat64(long struct) {
        return UNSAFE.getInt(null, struct + (long)SHADERROUNDINGMODERTEFLOAT64);
    }

    public static int nshaderRoundingModeRTZFloat16(long struct) {
        return UNSAFE.getInt(null, struct + (long)SHADERROUNDINGMODERTZFLOAT16);
    }

    public static int nshaderRoundingModeRTZFloat32(long struct) {
        return UNSAFE.getInt(null, struct + (long)SHADERROUNDINGMODERTZFLOAT32);
    }

    public static int nshaderRoundingModeRTZFloat64(long struct) {
        return UNSAFE.getInt(null, struct + (long)SHADERROUNDINGMODERTZFLOAT64);
    }

    public static int nmaxUpdateAfterBindDescriptorsInAllPools(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXUPDATEAFTERBINDDESCRIPTORSINALLPOOLS);
    }

    public static int nshaderUniformBufferArrayNonUniformIndexingNative(long struct) {
        return UNSAFE.getInt(null, struct + (long)SHADERUNIFORMBUFFERARRAYNONUNIFORMINDEXINGNATIVE);
    }

    public static int nshaderSampledImageArrayNonUniformIndexingNative(long struct) {
        return UNSAFE.getInt(null, struct + (long)SHADERSAMPLEDIMAGEARRAYNONUNIFORMINDEXINGNATIVE);
    }

    public static int nshaderStorageBufferArrayNonUniformIndexingNative(long struct) {
        return UNSAFE.getInt(null, struct + (long)SHADERSTORAGEBUFFERARRAYNONUNIFORMINDEXINGNATIVE);
    }

    public static int nshaderStorageImageArrayNonUniformIndexingNative(long struct) {
        return UNSAFE.getInt(null, struct + (long)SHADERSTORAGEIMAGEARRAYNONUNIFORMINDEXINGNATIVE);
    }

    public static int nshaderInputAttachmentArrayNonUniformIndexingNative(long struct) {
        return UNSAFE.getInt(null, struct + (long)SHADERINPUTATTACHMENTARRAYNONUNIFORMINDEXINGNATIVE);
    }

    public static int nrobustBufferAccessUpdateAfterBind(long struct) {
        return UNSAFE.getInt(null, struct + (long)ROBUSTBUFFERACCESSUPDATEAFTERBIND);
    }

    public static int nquadDivergentImplicitLod(long struct) {
        return UNSAFE.getInt(null, struct + (long)QUADDIVERGENTIMPLICITLOD);
    }

    public static int nmaxPerStageDescriptorUpdateAfterBindSamplers(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXPERSTAGEDESCRIPTORUPDATEAFTERBINDSAMPLERS);
    }

    public static int nmaxPerStageDescriptorUpdateAfterBindUniformBuffers(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXPERSTAGEDESCRIPTORUPDATEAFTERBINDUNIFORMBUFFERS);
    }

    public static int nmaxPerStageDescriptorUpdateAfterBindStorageBuffers(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXPERSTAGEDESCRIPTORUPDATEAFTERBINDSTORAGEBUFFERS);
    }

    public static int nmaxPerStageDescriptorUpdateAfterBindSampledImages(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXPERSTAGEDESCRIPTORUPDATEAFTERBINDSAMPLEDIMAGES);
    }

    public static int nmaxPerStageDescriptorUpdateAfterBindStorageImages(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXPERSTAGEDESCRIPTORUPDATEAFTERBINDSTORAGEIMAGES);
    }

    public static int nmaxPerStageDescriptorUpdateAfterBindInputAttachments(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXPERSTAGEDESCRIPTORUPDATEAFTERBINDINPUTATTACHMENTS);
    }

    public static int nmaxPerStageUpdateAfterBindResources(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXPERSTAGEUPDATEAFTERBINDRESOURCES);
    }

    public static int nmaxDescriptorSetUpdateAfterBindSamplers(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXDESCRIPTORSETUPDATEAFTERBINDSAMPLERS);
    }

    public static int nmaxDescriptorSetUpdateAfterBindUniformBuffers(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXDESCRIPTORSETUPDATEAFTERBINDUNIFORMBUFFERS);
    }

    public static int nmaxDescriptorSetUpdateAfterBindUniformBuffersDynamic(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXDESCRIPTORSETUPDATEAFTERBINDUNIFORMBUFFERSDYNAMIC);
    }

    public static int nmaxDescriptorSetUpdateAfterBindStorageBuffers(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXDESCRIPTORSETUPDATEAFTERBINDSTORAGEBUFFERS);
    }

    public static int nmaxDescriptorSetUpdateAfterBindStorageBuffersDynamic(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXDESCRIPTORSETUPDATEAFTERBINDSTORAGEBUFFERSDYNAMIC);
    }

    public static int nmaxDescriptorSetUpdateAfterBindSampledImages(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXDESCRIPTORSETUPDATEAFTERBINDSAMPLEDIMAGES);
    }

    public static int nmaxDescriptorSetUpdateAfterBindStorageImages(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXDESCRIPTORSETUPDATEAFTERBINDSTORAGEIMAGES);
    }

    public static int nmaxDescriptorSetUpdateAfterBindInputAttachments(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAXDESCRIPTORSETUPDATEAFTERBINDINPUTATTACHMENTS);
    }

    public static int nsupportedDepthResolveModes(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUPPORTEDDEPTHRESOLVEMODES);
    }

    public static int nsupportedStencilResolveModes(long struct) {
        return UNSAFE.getInt(null, struct + (long)SUPPORTEDSTENCILRESOLVEMODES);
    }

    public static int nindependentResolveNone(long struct) {
        return UNSAFE.getInt(null, struct + (long)INDEPENDENTRESOLVENONE);
    }

    public static int nindependentResolve(long struct) {
        return UNSAFE.getInt(null, struct + (long)INDEPENDENTRESOLVE);
    }

    public static int nfilterMinmaxSingleComponentFormats(long struct) {
        return UNSAFE.getInt(null, struct + (long)FILTERMINMAXSINGLECOMPONENTFORMATS);
    }

    public static int nfilterMinmaxImageComponentMapping(long struct) {
        return UNSAFE.getInt(null, struct + (long)FILTERMINMAXIMAGECOMPONENTMAPPING);
    }

    public static long nmaxTimelineSemaphoreValueDifference(long struct) {
        return UNSAFE.getLong(null, struct + (long)MAXTIMELINESEMAPHOREVALUEDIFFERENCE);
    }

    public static int nframebufferIntegerColorSampleCounts(long struct) {
        return UNSAFE.getInt(null, struct + (long)FRAMEBUFFERINTEGERCOLORSAMPLECOUNTS);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void ndriverID(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DRIVERID, value);
    }

    public static void ndriverName(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
            Checks.checkGT((java.nio.Buffer)value, (int)256);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)DRIVERNAME), (long)value.remaining());
    }

    public static void ndriverInfo(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
            Checks.checkGT((java.nio.Buffer)value, (int)256);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)DRIVERINFO), (long)value.remaining());
    }

    public static void nconformanceVersion(long struct, VkConformanceVersion value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)CONFORMANCEVERSION), (long)VkConformanceVersion.SIZEOF);
    }

    public static void ndenormBehaviorIndependence(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DENORMBEHAVIORINDEPENDENCE, value);
    }

    public static void nroundingModeIndependence(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ROUNDINGMODEINDEPENDENCE, value);
    }

    public static void nshaderSignedZeroInfNanPreserveFloat16(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SHADERSIGNEDZEROINFNANPRESERVEFLOAT16, value);
    }

    public static void nshaderSignedZeroInfNanPreserveFloat32(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SHADERSIGNEDZEROINFNANPRESERVEFLOAT32, value);
    }

    public static void nshaderSignedZeroInfNanPreserveFloat64(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SHADERSIGNEDZEROINFNANPRESERVEFLOAT64, value);
    }

    public static void nshaderDenormPreserveFloat16(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SHADERDENORMPRESERVEFLOAT16, value);
    }

    public static void nshaderDenormPreserveFloat32(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SHADERDENORMPRESERVEFLOAT32, value);
    }

    public static void nshaderDenormPreserveFloat64(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SHADERDENORMPRESERVEFLOAT64, value);
    }

    public static void nshaderDenormFlushToZeroFloat16(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SHADERDENORMFLUSHTOZEROFLOAT16, value);
    }

    public static void nshaderDenormFlushToZeroFloat32(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SHADERDENORMFLUSHTOZEROFLOAT32, value);
    }

    public static void nshaderDenormFlushToZeroFloat64(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SHADERDENORMFLUSHTOZEROFLOAT64, value);
    }

    public static void nshaderRoundingModeRTEFloat16(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SHADERROUNDINGMODERTEFLOAT16, value);
    }

    public static void nshaderRoundingModeRTEFloat32(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SHADERROUNDINGMODERTEFLOAT32, value);
    }

    public static void nshaderRoundingModeRTEFloat64(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SHADERROUNDINGMODERTEFLOAT64, value);
    }

    public static void nshaderRoundingModeRTZFloat16(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SHADERROUNDINGMODERTZFLOAT16, value);
    }

    public static void nshaderRoundingModeRTZFloat32(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SHADERROUNDINGMODERTZFLOAT32, value);
    }

    public static void nshaderRoundingModeRTZFloat64(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SHADERROUNDINGMODERTZFLOAT64, value);
    }

    public static void nmaxUpdateAfterBindDescriptorsInAllPools(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAXUPDATEAFTERBINDDESCRIPTORSINALLPOOLS, value);
    }

    public static void nshaderUniformBufferArrayNonUniformIndexingNative(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SHADERUNIFORMBUFFERARRAYNONUNIFORMINDEXINGNATIVE, value);
    }

    public static void nshaderSampledImageArrayNonUniformIndexingNative(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SHADERSAMPLEDIMAGEARRAYNONUNIFORMINDEXINGNATIVE, value);
    }

    public static void nshaderStorageBufferArrayNonUniformIndexingNative(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SHADERSTORAGEBUFFERARRAYNONUNIFORMINDEXINGNATIVE, value);
    }

    public static void nshaderStorageImageArrayNonUniformIndexingNative(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SHADERSTORAGEIMAGEARRAYNONUNIFORMINDEXINGNATIVE, value);
    }

    public static void nshaderInputAttachmentArrayNonUniformIndexingNative(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SHADERINPUTATTACHMENTARRAYNONUNIFORMINDEXINGNATIVE, value);
    }

    public static void nrobustBufferAccessUpdateAfterBind(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ROBUSTBUFFERACCESSUPDATEAFTERBIND, value);
    }

    public static void nquadDivergentImplicitLod(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)QUADDIVERGENTIMPLICITLOD, value);
    }

    public static void nmaxPerStageDescriptorUpdateAfterBindSamplers(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAXPERSTAGEDESCRIPTORUPDATEAFTERBINDSAMPLERS, value);
    }

    public static void nmaxPerStageDescriptorUpdateAfterBindUniformBuffers(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAXPERSTAGEDESCRIPTORUPDATEAFTERBINDUNIFORMBUFFERS, value);
    }

    public static void nmaxPerStageDescriptorUpdateAfterBindStorageBuffers(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAXPERSTAGEDESCRIPTORUPDATEAFTERBINDSTORAGEBUFFERS, value);
    }

    public static void nmaxPerStageDescriptorUpdateAfterBindSampledImages(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAXPERSTAGEDESCRIPTORUPDATEAFTERBINDSAMPLEDIMAGES, value);
    }

    public static void nmaxPerStageDescriptorUpdateAfterBindStorageImages(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAXPERSTAGEDESCRIPTORUPDATEAFTERBINDSTORAGEIMAGES, value);
    }

    public static void nmaxPerStageDescriptorUpdateAfterBindInputAttachments(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAXPERSTAGEDESCRIPTORUPDATEAFTERBINDINPUTATTACHMENTS, value);
    }

    public static void nmaxPerStageUpdateAfterBindResources(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAXPERSTAGEUPDATEAFTERBINDRESOURCES, value);
    }

    public static void nmaxDescriptorSetUpdateAfterBindSamplers(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAXDESCRIPTORSETUPDATEAFTERBINDSAMPLERS, value);
    }

    public static void nmaxDescriptorSetUpdateAfterBindUniformBuffers(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAXDESCRIPTORSETUPDATEAFTERBINDUNIFORMBUFFERS, value);
    }

    public static void nmaxDescriptorSetUpdateAfterBindUniformBuffersDynamic(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAXDESCRIPTORSETUPDATEAFTERBINDUNIFORMBUFFERSDYNAMIC, value);
    }

    public static void nmaxDescriptorSetUpdateAfterBindStorageBuffers(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAXDESCRIPTORSETUPDATEAFTERBINDSTORAGEBUFFERS, value);
    }

    public static void nmaxDescriptorSetUpdateAfterBindStorageBuffersDynamic(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAXDESCRIPTORSETUPDATEAFTERBINDSTORAGEBUFFERSDYNAMIC, value);
    }

    public static void nmaxDescriptorSetUpdateAfterBindSampledImages(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAXDESCRIPTORSETUPDATEAFTERBINDSAMPLEDIMAGES, value);
    }

    public static void nmaxDescriptorSetUpdateAfterBindStorageImages(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAXDESCRIPTORSETUPDATEAFTERBINDSTORAGEIMAGES, value);
    }

    public static void nmaxDescriptorSetUpdateAfterBindInputAttachments(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAXDESCRIPTORSETUPDATEAFTERBINDINPUTATTACHMENTS, value);
    }

    public static void nsupportedDepthResolveModes(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SUPPORTEDDEPTHRESOLVEMODES, value);
    }

    public static void nsupportedStencilResolveModes(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)SUPPORTEDSTENCILRESOLVEMODES, value);
    }

    public static void nindependentResolveNone(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)INDEPENDENTRESOLVENONE, value);
    }

    public static void nindependentResolve(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)INDEPENDENTRESOLVE, value);
    }

    public static void nfilterMinmaxSingleComponentFormats(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FILTERMINMAXSINGLECOMPONENTFORMATS, value);
    }

    public static void nfilterMinmaxImageComponentMapping(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FILTERMINMAXIMAGECOMPONENTMAPPING, value);
    }

    public static void nmaxTimelineSemaphoreValueDifference(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)MAXTIMELINESEMAPHOREVALUEDIFFERENCE, value);
    }

    public static void nframebufferIntegerColorSampleCounts(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FRAMEBUFFERINTEGERCOLORSAMPLECOUNTS, value);
    }

    static {
        Struct.Layout layout = VkPhysicalDeviceVulkan12Properties.__struct((Struct.Member[])new Struct.Member[]{VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)POINTER_SIZE), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__array((int)1, (int)256), VkPhysicalDeviceVulkan12Properties.__array((int)1, (int)256), VkPhysicalDeviceVulkan12Properties.__member((int)VkConformanceVersion.SIZEOF, (int)VkConformanceVersion.ALIGNOF), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)4), VkPhysicalDeviceVulkan12Properties.__member((int)8), VkPhysicalDeviceVulkan12Properties.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        DRIVERID = layout.offsetof(2);
        DRIVERNAME = layout.offsetof(3);
        DRIVERINFO = layout.offsetof(4);
        CONFORMANCEVERSION = layout.offsetof(5);
        DENORMBEHAVIORINDEPENDENCE = layout.offsetof(6);
        ROUNDINGMODEINDEPENDENCE = layout.offsetof(7);
        SHADERSIGNEDZEROINFNANPRESERVEFLOAT16 = layout.offsetof(8);
        SHADERSIGNEDZEROINFNANPRESERVEFLOAT32 = layout.offsetof(9);
        SHADERSIGNEDZEROINFNANPRESERVEFLOAT64 = layout.offsetof(10);
        SHADERDENORMPRESERVEFLOAT16 = layout.offsetof(11);
        SHADERDENORMPRESERVEFLOAT32 = layout.offsetof(12);
        SHADERDENORMPRESERVEFLOAT64 = layout.offsetof(13);
        SHADERDENORMFLUSHTOZEROFLOAT16 = layout.offsetof(14);
        SHADERDENORMFLUSHTOZEROFLOAT32 = layout.offsetof(15);
        SHADERDENORMFLUSHTOZEROFLOAT64 = layout.offsetof(16);
        SHADERROUNDINGMODERTEFLOAT16 = layout.offsetof(17);
        SHADERROUNDINGMODERTEFLOAT32 = layout.offsetof(18);
        SHADERROUNDINGMODERTEFLOAT64 = layout.offsetof(19);
        SHADERROUNDINGMODERTZFLOAT16 = layout.offsetof(20);
        SHADERROUNDINGMODERTZFLOAT32 = layout.offsetof(21);
        SHADERROUNDINGMODERTZFLOAT64 = layout.offsetof(22);
        MAXUPDATEAFTERBINDDESCRIPTORSINALLPOOLS = layout.offsetof(23);
        SHADERUNIFORMBUFFERARRAYNONUNIFORMINDEXINGNATIVE = layout.offsetof(24);
        SHADERSAMPLEDIMAGEARRAYNONUNIFORMINDEXINGNATIVE = layout.offsetof(25);
        SHADERSTORAGEBUFFERARRAYNONUNIFORMINDEXINGNATIVE = layout.offsetof(26);
        SHADERSTORAGEIMAGEARRAYNONUNIFORMINDEXINGNATIVE = layout.offsetof(27);
        SHADERINPUTATTACHMENTARRAYNONUNIFORMINDEXINGNATIVE = layout.offsetof(28);
        ROBUSTBUFFERACCESSUPDATEAFTERBIND = layout.offsetof(29);
        QUADDIVERGENTIMPLICITLOD = layout.offsetof(30);
        MAXPERSTAGEDESCRIPTORUPDATEAFTERBINDSAMPLERS = layout.offsetof(31);
        MAXPERSTAGEDESCRIPTORUPDATEAFTERBINDUNIFORMBUFFERS = layout.offsetof(32);
        MAXPERSTAGEDESCRIPTORUPDATEAFTERBINDSTORAGEBUFFERS = layout.offsetof(33);
        MAXPERSTAGEDESCRIPTORUPDATEAFTERBINDSAMPLEDIMAGES = layout.offsetof(34);
        MAXPERSTAGEDESCRIPTORUPDATEAFTERBINDSTORAGEIMAGES = layout.offsetof(35);
        MAXPERSTAGEDESCRIPTORUPDATEAFTERBINDINPUTATTACHMENTS = layout.offsetof(36);
        MAXPERSTAGEUPDATEAFTERBINDRESOURCES = layout.offsetof(37);
        MAXDESCRIPTORSETUPDATEAFTERBINDSAMPLERS = layout.offsetof(38);
        MAXDESCRIPTORSETUPDATEAFTERBINDUNIFORMBUFFERS = layout.offsetof(39);
        MAXDESCRIPTORSETUPDATEAFTERBINDUNIFORMBUFFERSDYNAMIC = layout.offsetof(40);
        MAXDESCRIPTORSETUPDATEAFTERBINDSTORAGEBUFFERS = layout.offsetof(41);
        MAXDESCRIPTORSETUPDATEAFTERBINDSTORAGEBUFFERSDYNAMIC = layout.offsetof(42);
        MAXDESCRIPTORSETUPDATEAFTERBINDSAMPLEDIMAGES = layout.offsetof(43);
        MAXDESCRIPTORSETUPDATEAFTERBINDSTORAGEIMAGES = layout.offsetof(44);
        MAXDESCRIPTORSETUPDATEAFTERBINDINPUTATTACHMENTS = layout.offsetof(45);
        SUPPORTEDDEPTHRESOLVEMODES = layout.offsetof(46);
        SUPPORTEDSTENCILRESOLVEMODES = layout.offsetof(47);
        INDEPENDENTRESOLVENONE = layout.offsetof(48);
        INDEPENDENTRESOLVE = layout.offsetof(49);
        FILTERMINMAXSINGLECOMPONENTFORMATS = layout.offsetof(50);
        FILTERMINMAXIMAGECOMPONENTMAPPING = layout.offsetof(51);
        MAXTIMELINESEMAPHOREVALUEDIFFERENCE = layout.offsetof(52);
        FRAMEBUFFERINTEGERCOLORSAMPLECOUNTS = layout.offsetof(53);
    }

    public static class Buffer
    extends StructBuffer<VkPhysicalDeviceVulkan12Properties, Buffer>
    implements NativeResource {
        private static final VkPhysicalDeviceVulkan12Properties ELEMENT_FACTORY = VkPhysicalDeviceVulkan12Properties.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkPhysicalDeviceVulkan12Properties getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkPhysicalDeviceVulkan12Properties.nsType(this.address());
        }

        @NativeType(value="void *")
        public long pNext() {
            return VkPhysicalDeviceVulkan12Properties.npNext(this.address());
        }

        @NativeType(value="VkDriverId")
        public int driverID() {
            return VkPhysicalDeviceVulkan12Properties.ndriverID(this.address());
        }

        @NativeType(value="char[VK_MAX_DRIVER_NAME_SIZE]")
        public ByteBuffer driverName() {
            return VkPhysicalDeviceVulkan12Properties.ndriverName(this.address());
        }

        @NativeType(value="char[VK_MAX_DRIVER_NAME_SIZE]")
        public String driverNameString() {
            return VkPhysicalDeviceVulkan12Properties.ndriverNameString(this.address());
        }

        @NativeType(value="char[VK_MAX_DRIVER_INFO_SIZE]")
        public ByteBuffer driverInfo() {
            return VkPhysicalDeviceVulkan12Properties.ndriverInfo(this.address());
        }

        @NativeType(value="char[VK_MAX_DRIVER_INFO_SIZE]")
        public String driverInfoString() {
            return VkPhysicalDeviceVulkan12Properties.ndriverInfoString(this.address());
        }

        public VkConformanceVersion conformanceVersion() {
            return VkPhysicalDeviceVulkan12Properties.nconformanceVersion(this.address());
        }

        @NativeType(value="VkShaderFloatControlsIndependence")
        public int denormBehaviorIndependence() {
            return VkPhysicalDeviceVulkan12Properties.ndenormBehaviorIndependence(this.address());
        }

        @NativeType(value="VkShaderFloatControlsIndependence")
        public int roundingModeIndependence() {
            return VkPhysicalDeviceVulkan12Properties.nroundingModeIndependence(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean shaderSignedZeroInfNanPreserveFloat16() {
            return VkPhysicalDeviceVulkan12Properties.nshaderSignedZeroInfNanPreserveFloat16(this.address()) != 0;
        }

        @NativeType(value="VkBool32")
        public boolean shaderSignedZeroInfNanPreserveFloat32() {
            return VkPhysicalDeviceVulkan12Properties.nshaderSignedZeroInfNanPreserveFloat32(this.address()) != 0;
        }

        @NativeType(value="VkBool32")
        public boolean shaderSignedZeroInfNanPreserveFloat64() {
            return VkPhysicalDeviceVulkan12Properties.nshaderSignedZeroInfNanPreserveFloat64(this.address()) != 0;
        }

        @NativeType(value="VkBool32")
        public boolean shaderDenormPreserveFloat16() {
            return VkPhysicalDeviceVulkan12Properties.nshaderDenormPreserveFloat16(this.address()) != 0;
        }

        @NativeType(value="VkBool32")
        public boolean shaderDenormPreserveFloat32() {
            return VkPhysicalDeviceVulkan12Properties.nshaderDenormPreserveFloat32(this.address()) != 0;
        }

        @NativeType(value="VkBool32")
        public boolean shaderDenormPreserveFloat64() {
            return VkPhysicalDeviceVulkan12Properties.nshaderDenormPreserveFloat64(this.address()) != 0;
        }

        @NativeType(value="VkBool32")
        public boolean shaderDenormFlushToZeroFloat16() {
            return VkPhysicalDeviceVulkan12Properties.nshaderDenormFlushToZeroFloat16(this.address()) != 0;
        }

        @NativeType(value="VkBool32")
        public boolean shaderDenormFlushToZeroFloat32() {
            return VkPhysicalDeviceVulkan12Properties.nshaderDenormFlushToZeroFloat32(this.address()) != 0;
        }

        @NativeType(value="VkBool32")
        public boolean shaderDenormFlushToZeroFloat64() {
            return VkPhysicalDeviceVulkan12Properties.nshaderDenormFlushToZeroFloat64(this.address()) != 0;
        }

        @NativeType(value="VkBool32")
        public boolean shaderRoundingModeRTEFloat16() {
            return VkPhysicalDeviceVulkan12Properties.nshaderRoundingModeRTEFloat16(this.address()) != 0;
        }

        @NativeType(value="VkBool32")
        public boolean shaderRoundingModeRTEFloat32() {
            return VkPhysicalDeviceVulkan12Properties.nshaderRoundingModeRTEFloat32(this.address()) != 0;
        }

        @NativeType(value="VkBool32")
        public boolean shaderRoundingModeRTEFloat64() {
            return VkPhysicalDeviceVulkan12Properties.nshaderRoundingModeRTEFloat64(this.address()) != 0;
        }

        @NativeType(value="VkBool32")
        public boolean shaderRoundingModeRTZFloat16() {
            return VkPhysicalDeviceVulkan12Properties.nshaderRoundingModeRTZFloat16(this.address()) != 0;
        }

        @NativeType(value="VkBool32")
        public boolean shaderRoundingModeRTZFloat32() {
            return VkPhysicalDeviceVulkan12Properties.nshaderRoundingModeRTZFloat32(this.address()) != 0;
        }

        @NativeType(value="VkBool32")
        public boolean shaderRoundingModeRTZFloat64() {
            return VkPhysicalDeviceVulkan12Properties.nshaderRoundingModeRTZFloat64(this.address()) != 0;
        }

        @NativeType(value="uint32_t")
        public int maxUpdateAfterBindDescriptorsInAllPools() {
            return VkPhysicalDeviceVulkan12Properties.nmaxUpdateAfterBindDescriptorsInAllPools(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean shaderUniformBufferArrayNonUniformIndexingNative() {
            return VkPhysicalDeviceVulkan12Properties.nshaderUniformBufferArrayNonUniformIndexingNative(this.address()) != 0;
        }

        @NativeType(value="VkBool32")
        public boolean shaderSampledImageArrayNonUniformIndexingNative() {
            return VkPhysicalDeviceVulkan12Properties.nshaderSampledImageArrayNonUniformIndexingNative(this.address()) != 0;
        }

        @NativeType(value="VkBool32")
        public boolean shaderStorageBufferArrayNonUniformIndexingNative() {
            return VkPhysicalDeviceVulkan12Properties.nshaderStorageBufferArrayNonUniformIndexingNative(this.address()) != 0;
        }

        @NativeType(value="VkBool32")
        public boolean shaderStorageImageArrayNonUniformIndexingNative() {
            return VkPhysicalDeviceVulkan12Properties.nshaderStorageImageArrayNonUniformIndexingNative(this.address()) != 0;
        }

        @NativeType(value="VkBool32")
        public boolean shaderInputAttachmentArrayNonUniformIndexingNative() {
            return VkPhysicalDeviceVulkan12Properties.nshaderInputAttachmentArrayNonUniformIndexingNative(this.address()) != 0;
        }

        @NativeType(value="VkBool32")
        public boolean robustBufferAccessUpdateAfterBind() {
            return VkPhysicalDeviceVulkan12Properties.nrobustBufferAccessUpdateAfterBind(this.address()) != 0;
        }

        @NativeType(value="VkBool32")
        public boolean quadDivergentImplicitLod() {
            return VkPhysicalDeviceVulkan12Properties.nquadDivergentImplicitLod(this.address()) != 0;
        }

        @NativeType(value="uint32_t")
        public int maxPerStageDescriptorUpdateAfterBindSamplers() {
            return VkPhysicalDeviceVulkan12Properties.nmaxPerStageDescriptorUpdateAfterBindSamplers(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxPerStageDescriptorUpdateAfterBindUniformBuffers() {
            return VkPhysicalDeviceVulkan12Properties.nmaxPerStageDescriptorUpdateAfterBindUniformBuffers(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxPerStageDescriptorUpdateAfterBindStorageBuffers() {
            return VkPhysicalDeviceVulkan12Properties.nmaxPerStageDescriptorUpdateAfterBindStorageBuffers(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxPerStageDescriptorUpdateAfterBindSampledImages() {
            return VkPhysicalDeviceVulkan12Properties.nmaxPerStageDescriptorUpdateAfterBindSampledImages(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxPerStageDescriptorUpdateAfterBindStorageImages() {
            return VkPhysicalDeviceVulkan12Properties.nmaxPerStageDescriptorUpdateAfterBindStorageImages(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxPerStageDescriptorUpdateAfterBindInputAttachments() {
            return VkPhysicalDeviceVulkan12Properties.nmaxPerStageDescriptorUpdateAfterBindInputAttachments(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxPerStageUpdateAfterBindResources() {
            return VkPhysicalDeviceVulkan12Properties.nmaxPerStageUpdateAfterBindResources(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxDescriptorSetUpdateAfterBindSamplers() {
            return VkPhysicalDeviceVulkan12Properties.nmaxDescriptorSetUpdateAfterBindSamplers(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxDescriptorSetUpdateAfterBindUniformBuffers() {
            return VkPhysicalDeviceVulkan12Properties.nmaxDescriptorSetUpdateAfterBindUniformBuffers(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxDescriptorSetUpdateAfterBindUniformBuffersDynamic() {
            return VkPhysicalDeviceVulkan12Properties.nmaxDescriptorSetUpdateAfterBindUniformBuffersDynamic(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxDescriptorSetUpdateAfterBindStorageBuffers() {
            return VkPhysicalDeviceVulkan12Properties.nmaxDescriptorSetUpdateAfterBindStorageBuffers(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxDescriptorSetUpdateAfterBindStorageBuffersDynamic() {
            return VkPhysicalDeviceVulkan12Properties.nmaxDescriptorSetUpdateAfterBindStorageBuffersDynamic(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxDescriptorSetUpdateAfterBindSampledImages() {
            return VkPhysicalDeviceVulkan12Properties.nmaxDescriptorSetUpdateAfterBindSampledImages(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxDescriptorSetUpdateAfterBindStorageImages() {
            return VkPhysicalDeviceVulkan12Properties.nmaxDescriptorSetUpdateAfterBindStorageImages(this.address());
        }

        @NativeType(value="uint32_t")
        public int maxDescriptorSetUpdateAfterBindInputAttachments() {
            return VkPhysicalDeviceVulkan12Properties.nmaxDescriptorSetUpdateAfterBindInputAttachments(this.address());
        }

        @NativeType(value="VkResolveModeFlags")
        public int supportedDepthResolveModes() {
            return VkPhysicalDeviceVulkan12Properties.nsupportedDepthResolveModes(this.address());
        }

        @NativeType(value="VkResolveModeFlags")
        public int supportedStencilResolveModes() {
            return VkPhysicalDeviceVulkan12Properties.nsupportedStencilResolveModes(this.address());
        }

        @NativeType(value="VkBool32")
        public boolean independentResolveNone() {
            return VkPhysicalDeviceVulkan12Properties.nindependentResolveNone(this.address()) != 0;
        }

        @NativeType(value="VkBool32")
        public boolean independentResolve() {
            return VkPhysicalDeviceVulkan12Properties.nindependentResolve(this.address()) != 0;
        }

        @NativeType(value="VkBool32")
        public boolean filterMinmaxSingleComponentFormats() {
            return VkPhysicalDeviceVulkan12Properties.nfilterMinmaxSingleComponentFormats(this.address()) != 0;
        }

        @NativeType(value="VkBool32")
        public boolean filterMinmaxImageComponentMapping() {
            return VkPhysicalDeviceVulkan12Properties.nfilterMinmaxImageComponentMapping(this.address()) != 0;
        }

        @NativeType(value="uint64_t")
        public long maxTimelineSemaphoreValueDifference() {
            return VkPhysicalDeviceVulkan12Properties.nmaxTimelineSemaphoreValueDifference(this.address());
        }

        @NativeType(value="VkSampleCountFlags")
        public int framebufferIntegerColorSampleCounts() {
            return VkPhysicalDeviceVulkan12Properties.nframebufferIntegerColorSampleCounts(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkPhysicalDeviceVulkan12Properties.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void *") long value) {
            VkPhysicalDeviceVulkan12Properties.npNext(this.address(), value);
            return this;
        }

        public Buffer driverID(@NativeType(value="VkDriverId") int value) {
            VkPhysicalDeviceVulkan12Properties.ndriverID(this.address(), value);
            return this;
        }

        public Buffer driverName(@NativeType(value="char[VK_MAX_DRIVER_NAME_SIZE]") ByteBuffer value) {
            VkPhysicalDeviceVulkan12Properties.ndriverName(this.address(), value);
            return this;
        }

        public Buffer driverInfo(@NativeType(value="char[VK_MAX_DRIVER_INFO_SIZE]") ByteBuffer value) {
            VkPhysicalDeviceVulkan12Properties.ndriverInfo(this.address(), value);
            return this;
        }

        public Buffer conformanceVersion(VkConformanceVersion value) {
            VkPhysicalDeviceVulkan12Properties.nconformanceVersion(this.address(), value);
            return this;
        }

        public Buffer conformanceVersion(Consumer<VkConformanceVersion> consumer) {
            consumer.accept(this.conformanceVersion());
            return this;
        }

        public Buffer denormBehaviorIndependence(@NativeType(value="VkShaderFloatControlsIndependence") int value) {
            VkPhysicalDeviceVulkan12Properties.ndenormBehaviorIndependence(this.address(), value);
            return this;
        }

        public Buffer roundingModeIndependence(@NativeType(value="VkShaderFloatControlsIndependence") int value) {
            VkPhysicalDeviceVulkan12Properties.nroundingModeIndependence(this.address(), value);
            return this;
        }

        public Buffer shaderSignedZeroInfNanPreserveFloat16(@NativeType(value="VkBool32") boolean value) {
            VkPhysicalDeviceVulkan12Properties.nshaderSignedZeroInfNanPreserveFloat16(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer shaderSignedZeroInfNanPreserveFloat32(@NativeType(value="VkBool32") boolean value) {
            VkPhysicalDeviceVulkan12Properties.nshaderSignedZeroInfNanPreserveFloat32(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer shaderSignedZeroInfNanPreserveFloat64(@NativeType(value="VkBool32") boolean value) {
            VkPhysicalDeviceVulkan12Properties.nshaderSignedZeroInfNanPreserveFloat64(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer shaderDenormPreserveFloat16(@NativeType(value="VkBool32") boolean value) {
            VkPhysicalDeviceVulkan12Properties.nshaderDenormPreserveFloat16(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer shaderDenormPreserveFloat32(@NativeType(value="VkBool32") boolean value) {
            VkPhysicalDeviceVulkan12Properties.nshaderDenormPreserveFloat32(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer shaderDenormPreserveFloat64(@NativeType(value="VkBool32") boolean value) {
            VkPhysicalDeviceVulkan12Properties.nshaderDenormPreserveFloat64(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer shaderDenormFlushToZeroFloat16(@NativeType(value="VkBool32") boolean value) {
            VkPhysicalDeviceVulkan12Properties.nshaderDenormFlushToZeroFloat16(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer shaderDenormFlushToZeroFloat32(@NativeType(value="VkBool32") boolean value) {
            VkPhysicalDeviceVulkan12Properties.nshaderDenormFlushToZeroFloat32(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer shaderDenormFlushToZeroFloat64(@NativeType(value="VkBool32") boolean value) {
            VkPhysicalDeviceVulkan12Properties.nshaderDenormFlushToZeroFloat64(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer shaderRoundingModeRTEFloat16(@NativeType(value="VkBool32") boolean value) {
            VkPhysicalDeviceVulkan12Properties.nshaderRoundingModeRTEFloat16(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer shaderRoundingModeRTEFloat32(@NativeType(value="VkBool32") boolean value) {
            VkPhysicalDeviceVulkan12Properties.nshaderRoundingModeRTEFloat32(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer shaderRoundingModeRTEFloat64(@NativeType(value="VkBool32") boolean value) {
            VkPhysicalDeviceVulkan12Properties.nshaderRoundingModeRTEFloat64(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer shaderRoundingModeRTZFloat16(@NativeType(value="VkBool32") boolean value) {
            VkPhysicalDeviceVulkan12Properties.nshaderRoundingModeRTZFloat16(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer shaderRoundingModeRTZFloat32(@NativeType(value="VkBool32") boolean value) {
            VkPhysicalDeviceVulkan12Properties.nshaderRoundingModeRTZFloat32(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer shaderRoundingModeRTZFloat64(@NativeType(value="VkBool32") boolean value) {
            VkPhysicalDeviceVulkan12Properties.nshaderRoundingModeRTZFloat64(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer maxUpdateAfterBindDescriptorsInAllPools(@NativeType(value="uint32_t") int value) {
            VkPhysicalDeviceVulkan12Properties.nmaxUpdateAfterBindDescriptorsInAllPools(this.address(), value);
            return this;
        }

        public Buffer shaderUniformBufferArrayNonUniformIndexingNative(@NativeType(value="VkBool32") boolean value) {
            VkPhysicalDeviceVulkan12Properties.nshaderUniformBufferArrayNonUniformIndexingNative(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer shaderSampledImageArrayNonUniformIndexingNative(@NativeType(value="VkBool32") boolean value) {
            VkPhysicalDeviceVulkan12Properties.nshaderSampledImageArrayNonUniformIndexingNative(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer shaderStorageBufferArrayNonUniformIndexingNative(@NativeType(value="VkBool32") boolean value) {
            VkPhysicalDeviceVulkan12Properties.nshaderStorageBufferArrayNonUniformIndexingNative(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer shaderStorageImageArrayNonUniformIndexingNative(@NativeType(value="VkBool32") boolean value) {
            VkPhysicalDeviceVulkan12Properties.nshaderStorageImageArrayNonUniformIndexingNative(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer shaderInputAttachmentArrayNonUniformIndexingNative(@NativeType(value="VkBool32") boolean value) {
            VkPhysicalDeviceVulkan12Properties.nshaderInputAttachmentArrayNonUniformIndexingNative(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer robustBufferAccessUpdateAfterBind(@NativeType(value="VkBool32") boolean value) {
            VkPhysicalDeviceVulkan12Properties.nrobustBufferAccessUpdateAfterBind(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer quadDivergentImplicitLod(@NativeType(value="VkBool32") boolean value) {
            VkPhysicalDeviceVulkan12Properties.nquadDivergentImplicitLod(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer maxPerStageDescriptorUpdateAfterBindSamplers(@NativeType(value="uint32_t") int value) {
            VkPhysicalDeviceVulkan12Properties.nmaxPerStageDescriptorUpdateAfterBindSamplers(this.address(), value);
            return this;
        }

        public Buffer maxPerStageDescriptorUpdateAfterBindUniformBuffers(@NativeType(value="uint32_t") int value) {
            VkPhysicalDeviceVulkan12Properties.nmaxPerStageDescriptorUpdateAfterBindUniformBuffers(this.address(), value);
            return this;
        }

        public Buffer maxPerStageDescriptorUpdateAfterBindStorageBuffers(@NativeType(value="uint32_t") int value) {
            VkPhysicalDeviceVulkan12Properties.nmaxPerStageDescriptorUpdateAfterBindStorageBuffers(this.address(), value);
            return this;
        }

        public Buffer maxPerStageDescriptorUpdateAfterBindSampledImages(@NativeType(value="uint32_t") int value) {
            VkPhysicalDeviceVulkan12Properties.nmaxPerStageDescriptorUpdateAfterBindSampledImages(this.address(), value);
            return this;
        }

        public Buffer maxPerStageDescriptorUpdateAfterBindStorageImages(@NativeType(value="uint32_t") int value) {
            VkPhysicalDeviceVulkan12Properties.nmaxPerStageDescriptorUpdateAfterBindStorageImages(this.address(), value);
            return this;
        }

        public Buffer maxPerStageDescriptorUpdateAfterBindInputAttachments(@NativeType(value="uint32_t") int value) {
            VkPhysicalDeviceVulkan12Properties.nmaxPerStageDescriptorUpdateAfterBindInputAttachments(this.address(), value);
            return this;
        }

        public Buffer maxPerStageUpdateAfterBindResources(@NativeType(value="uint32_t") int value) {
            VkPhysicalDeviceVulkan12Properties.nmaxPerStageUpdateAfterBindResources(this.address(), value);
            return this;
        }

        public Buffer maxDescriptorSetUpdateAfterBindSamplers(@NativeType(value="uint32_t") int value) {
            VkPhysicalDeviceVulkan12Properties.nmaxDescriptorSetUpdateAfterBindSamplers(this.address(), value);
            return this;
        }

        public Buffer maxDescriptorSetUpdateAfterBindUniformBuffers(@NativeType(value="uint32_t") int value) {
            VkPhysicalDeviceVulkan12Properties.nmaxDescriptorSetUpdateAfterBindUniformBuffers(this.address(), value);
            return this;
        }

        public Buffer maxDescriptorSetUpdateAfterBindUniformBuffersDynamic(@NativeType(value="uint32_t") int value) {
            VkPhysicalDeviceVulkan12Properties.nmaxDescriptorSetUpdateAfterBindUniformBuffersDynamic(this.address(), value);
            return this;
        }

        public Buffer maxDescriptorSetUpdateAfterBindStorageBuffers(@NativeType(value="uint32_t") int value) {
            VkPhysicalDeviceVulkan12Properties.nmaxDescriptorSetUpdateAfterBindStorageBuffers(this.address(), value);
            return this;
        }

        public Buffer maxDescriptorSetUpdateAfterBindStorageBuffersDynamic(@NativeType(value="uint32_t") int value) {
            VkPhysicalDeviceVulkan12Properties.nmaxDescriptorSetUpdateAfterBindStorageBuffersDynamic(this.address(), value);
            return this;
        }

        public Buffer maxDescriptorSetUpdateAfterBindSampledImages(@NativeType(value="uint32_t") int value) {
            VkPhysicalDeviceVulkan12Properties.nmaxDescriptorSetUpdateAfterBindSampledImages(this.address(), value);
            return this;
        }

        public Buffer maxDescriptorSetUpdateAfterBindStorageImages(@NativeType(value="uint32_t") int value) {
            VkPhysicalDeviceVulkan12Properties.nmaxDescriptorSetUpdateAfterBindStorageImages(this.address(), value);
            return this;
        }

        public Buffer maxDescriptorSetUpdateAfterBindInputAttachments(@NativeType(value="uint32_t") int value) {
            VkPhysicalDeviceVulkan12Properties.nmaxDescriptorSetUpdateAfterBindInputAttachments(this.address(), value);
            return this;
        }

        public Buffer supportedDepthResolveModes(@NativeType(value="VkResolveModeFlags") int value) {
            VkPhysicalDeviceVulkan12Properties.nsupportedDepthResolveModes(this.address(), value);
            return this;
        }

        public Buffer supportedStencilResolveModes(@NativeType(value="VkResolveModeFlags") int value) {
            VkPhysicalDeviceVulkan12Properties.nsupportedStencilResolveModes(this.address(), value);
            return this;
        }

        public Buffer independentResolveNone(@NativeType(value="VkBool32") boolean value) {
            VkPhysicalDeviceVulkan12Properties.nindependentResolveNone(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer independentResolve(@NativeType(value="VkBool32") boolean value) {
            VkPhysicalDeviceVulkan12Properties.nindependentResolve(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer filterMinmaxSingleComponentFormats(@NativeType(value="VkBool32") boolean value) {
            VkPhysicalDeviceVulkan12Properties.nfilterMinmaxSingleComponentFormats(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer filterMinmaxImageComponentMapping(@NativeType(value="VkBool32") boolean value) {
            VkPhysicalDeviceVulkan12Properties.nfilterMinmaxImageComponentMapping(this.address(), value ? 1 : 0);
            return this;
        }

        public Buffer maxTimelineSemaphoreValueDifference(@NativeType(value="uint64_t") long value) {
            VkPhysicalDeviceVulkan12Properties.nmaxTimelineSemaphoreValueDifference(this.address(), value);
            return this;
        }

        public Buffer framebufferIntegerColorSampleCounts(@NativeType(value="VkSampleCountFlags") int value) {
            VkPhysicalDeviceVulkan12Properties.nframebufferIntegerColorSampleCounts(this.address(), value);
            return this;
        }
    }
}

