/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkFramebufferCreateInfo
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int RENDERPASS;
    public static final int ATTACHMENTCOUNT;
    public static final int PATTACHMENTS;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int LAYERS;

    public VkFramebufferCreateInfo(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkFramebufferCreateInfo.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkFramebufferCreateInfo.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkFramebufferCreateInfo.npNext(this.address());
    }

    @NativeType(value="VkFramebufferCreateFlags")
    public int flags() {
        return VkFramebufferCreateInfo.nflags(this.address());
    }

    @NativeType(value="VkRenderPass")
    public long renderPass() {
        return VkFramebufferCreateInfo.nrenderPass(this.address());
    }

    @NativeType(value="uint32_t")
    public int attachmentCount() {
        return VkFramebufferCreateInfo.nattachmentCount(this.address());
    }

    @Nullable
    @NativeType(value="VkImageView const *")
    public LongBuffer pAttachments() {
        return VkFramebufferCreateInfo.npAttachments(this.address());
    }

    @NativeType(value="uint32_t")
    public int width() {
        return VkFramebufferCreateInfo.nwidth(this.address());
    }

    @NativeType(value="uint32_t")
    public int height() {
        return VkFramebufferCreateInfo.nheight(this.address());
    }

    @NativeType(value="uint32_t")
    public int layers() {
        return VkFramebufferCreateInfo.nlayers(this.address());
    }

    public VkFramebufferCreateInfo sType(@NativeType(value="VkStructureType") int value) {
        VkFramebufferCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkFramebufferCreateInfo pNext(@NativeType(value="void const *") long value) {
        VkFramebufferCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkFramebufferCreateInfo flags(@NativeType(value="VkFramebufferCreateFlags") int value) {
        VkFramebufferCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkFramebufferCreateInfo renderPass(@NativeType(value="VkRenderPass") long value) {
        VkFramebufferCreateInfo.nrenderPass(this.address(), value);
        return this;
    }

    public VkFramebufferCreateInfo pAttachments(@Nullable @NativeType(value="VkImageView const *") LongBuffer value) {
        VkFramebufferCreateInfo.npAttachments(this.address(), value);
        return this;
    }

    public VkFramebufferCreateInfo width(@NativeType(value="uint32_t") int value) {
        VkFramebufferCreateInfo.nwidth(this.address(), value);
        return this;
    }

    public VkFramebufferCreateInfo height(@NativeType(value="uint32_t") int value) {
        VkFramebufferCreateInfo.nheight(this.address(), value);
        return this;
    }

    public VkFramebufferCreateInfo layers(@NativeType(value="uint32_t") int value) {
        VkFramebufferCreateInfo.nlayers(this.address(), value);
        return this;
    }

    public VkFramebufferCreateInfo set(int sType, long pNext, int flags, long renderPass, @Nullable LongBuffer pAttachments, int width, int height, int layers) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.renderPass(renderPass);
        this.pAttachments(pAttachments);
        this.width(width);
        this.height(height);
        this.layers(layers);
        return this;
    }

    public VkFramebufferCreateInfo set(VkFramebufferCreateInfo src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkFramebufferCreateInfo malloc() {
        return (VkFramebufferCreateInfo)VkFramebufferCreateInfo.wrap(VkFramebufferCreateInfo.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkFramebufferCreateInfo calloc() {
        return (VkFramebufferCreateInfo)VkFramebufferCreateInfo.wrap(VkFramebufferCreateInfo.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkFramebufferCreateInfo create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkFramebufferCreateInfo)VkFramebufferCreateInfo.wrap(VkFramebufferCreateInfo.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkFramebufferCreateInfo create(long address) {
        return (VkFramebufferCreateInfo)VkFramebufferCreateInfo.wrap(VkFramebufferCreateInfo.class, (long)address);
    }

    @Nullable
    public static VkFramebufferCreateInfo createSafe(long address) {
        return address == 0L ? null : (VkFramebufferCreateInfo)VkFramebufferCreateInfo.wrap(VkFramebufferCreateInfo.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkFramebufferCreateInfo.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkFramebufferCreateInfo.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkFramebufferCreateInfo.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkFramebufferCreateInfo.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkFramebufferCreateInfo.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkFramebufferCreateInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkFramebufferCreateInfo.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static VkFramebufferCreateInfo mallocStack() {
        return VkFramebufferCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkFramebufferCreateInfo callocStack() {
        return VkFramebufferCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkFramebufferCreateInfo mallocStack(MemoryStack stack) {
        return (VkFramebufferCreateInfo)VkFramebufferCreateInfo.wrap(VkFramebufferCreateInfo.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkFramebufferCreateInfo callocStack(MemoryStack stack) {
        return (VkFramebufferCreateInfo)VkFramebufferCreateInfo.wrap(VkFramebufferCreateInfo.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkFramebufferCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkFramebufferCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkFramebufferCreateInfo.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)VkFramebufferCreateInfo.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nflags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static long nrenderPass(long struct) {
        return UNSAFE.getLong(null, struct + (long)RENDERPASS);
    }

    public static int nattachmentCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)ATTACHMENTCOUNT);
    }

    @Nullable
    public static LongBuffer npAttachments(long struct) {
        return MemoryUtil.memLongBufferSafe((long)MemoryUtil.memGetAddress((long)(struct + (long)PATTACHMENTS)), (int)VkFramebufferCreateInfo.nattachmentCount(struct));
    }

    public static int nwidth(long struct) {
        return UNSAFE.getInt(null, struct + (long)WIDTH);
    }

    public static int nheight(long struct) {
        return UNSAFE.getInt(null, struct + (long)HEIGHT);
    }

    public static int nlayers(long struct) {
        return UNSAFE.getInt(null, struct + (long)LAYERS);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nflags(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)FLAGS, value);
    }

    public static void nrenderPass(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)RENDERPASS, value);
    }

    public static void nattachmentCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ATTACHMENTCOUNT, value);
    }

    public static void npAttachments(long struct, @Nullable LongBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PATTACHMENTS), (long)MemoryUtil.memAddressSafe((LongBuffer)value));
        VkFramebufferCreateInfo.nattachmentCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nwidth(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)HEIGHT, value);
    }

    public static void nlayers(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)LAYERS, value);
    }

    public static void validate(long struct) {
        if (VkFramebufferCreateInfo.nattachmentCount(struct) != 0) {
            Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PATTACHMENTS)));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkFramebufferCreateInfo.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = VkFramebufferCreateInfo.__struct((Struct.Member[])new Struct.Member[]{VkFramebufferCreateInfo.__member((int)4), VkFramebufferCreateInfo.__member((int)POINTER_SIZE), VkFramebufferCreateInfo.__member((int)4), VkFramebufferCreateInfo.__member((int)8), VkFramebufferCreateInfo.__member((int)4), VkFramebufferCreateInfo.__member((int)POINTER_SIZE), VkFramebufferCreateInfo.__member((int)4), VkFramebufferCreateInfo.__member((int)4), VkFramebufferCreateInfo.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        RENDERPASS = layout.offsetof(3);
        ATTACHMENTCOUNT = layout.offsetof(4);
        PATTACHMENTS = layout.offsetof(5);
        WIDTH = layout.offsetof(6);
        HEIGHT = layout.offsetof(7);
        LAYERS = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<VkFramebufferCreateInfo, Buffer>
    implements NativeResource {
        private static final VkFramebufferCreateInfo ELEMENT_FACTORY = VkFramebufferCreateInfo.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkFramebufferCreateInfo getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkFramebufferCreateInfo.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkFramebufferCreateInfo.npNext(this.address());
        }

        @NativeType(value="VkFramebufferCreateFlags")
        public int flags() {
            return VkFramebufferCreateInfo.nflags(this.address());
        }

        @NativeType(value="VkRenderPass")
        public long renderPass() {
            return VkFramebufferCreateInfo.nrenderPass(this.address());
        }

        @NativeType(value="uint32_t")
        public int attachmentCount() {
            return VkFramebufferCreateInfo.nattachmentCount(this.address());
        }

        @Nullable
        @NativeType(value="VkImageView const *")
        public LongBuffer pAttachments() {
            return VkFramebufferCreateInfo.npAttachments(this.address());
        }

        @NativeType(value="uint32_t")
        public int width() {
            return VkFramebufferCreateInfo.nwidth(this.address());
        }

        @NativeType(value="uint32_t")
        public int height() {
            return VkFramebufferCreateInfo.nheight(this.address());
        }

        @NativeType(value="uint32_t")
        public int layers() {
            return VkFramebufferCreateInfo.nlayers(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkFramebufferCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkFramebufferCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(@NativeType(value="VkFramebufferCreateFlags") int value) {
            VkFramebufferCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer renderPass(@NativeType(value="VkRenderPass") long value) {
            VkFramebufferCreateInfo.nrenderPass(this.address(), value);
            return this;
        }

        public Buffer pAttachments(@Nullable @NativeType(value="VkImageView const *") LongBuffer value) {
            VkFramebufferCreateInfo.npAttachments(this.address(), value);
            return this;
        }

        public Buffer width(@NativeType(value="uint32_t") int value) {
            VkFramebufferCreateInfo.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(@NativeType(value="uint32_t") int value) {
            VkFramebufferCreateInfo.nheight(this.address(), value);
            return this;
        }

        public Buffer layers(@NativeType(value="uint32_t") int value) {
            VkFramebufferCreateInfo.nlayers(this.address(), value);
            return this;
        }
    }
}

