/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { get } from 'lodash';
import React, { useEffect, useCallback } from 'react';
import { EuiFieldNumber, EuiFormRow, EuiIconTip } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { FormattedMessage } from '@kbn/i18n/react';
import { UI_SETTINGS } from '../../../../data/public';
var label = /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(FormattedMessage, {
  id: "visDefaultEditor.controls.numberInterval.minimumIntervalLabel",
  defaultMessage: "Minimum interval"
}), ' ', /*#__PURE__*/React.createElement(EuiIconTip, {
  position: "right",
  content: /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "visDefaultEditor.controls.numberInterval.minimumIntervalTooltip",
    defaultMessage: "Interval will be automatically scaled in the event that the provided value creates more buckets than specified by Advanced Setting's {histogramMaxBars}",
    values: {
      histogramMaxBars: UI_SETTINGS.HISTOGRAM_MAX_BARS
    }
  }),
  type: "questionInCircle"
}));

function NumberIntervalParamEditor(_ref) {
  var agg = _ref.agg,
      editorConfig = _ref.editorConfig,
      showValidation = _ref.showValidation,
      value = _ref.value,
      setTouched = _ref.setTouched,
      setValidity = _ref.setValidity,
      setValue = _ref.setValue;
  var base = get(editorConfig, 'interval.base');
  var min = base || 0;
  var isValid = value !== undefined && value >= min;
  useEffect(function () {
    setValidity(isValid);
  }, [isValid, setValidity]);
  var onChange = useCallback(function (_ref2) {
    var target = _ref2.target;
    return setValue(isNaN(target.valueAsNumber) ? undefined : target.valueAsNumber);
  }, [setValue]);
  return /*#__PURE__*/React.createElement(EuiFormRow, {
    compressed: true,
    label: label,
    fullWidth: true,
    isInvalid: showValidation && !isValid,
    helpText: get(editorConfig, 'interval.help')
  }, /*#__PURE__*/React.createElement(EuiFieldNumber, {
    value: value === undefined ? '' : value,
    min: min,
    step: base,
    "data-test-subj": "visEditorInterval".concat(agg.id),
    isInvalid: showValidation && !isValid,
    onChange: onChange,
    onBlur: setTouched,
    fullWidth: true,
    compressed: true,
    placeholder: i18n.translate('visDefaultEditor.controls.numberInterval.selectIntervalPlaceholder', {
      defaultMessage: 'Enter an interval'
    })
  }));
}

export { NumberIntervalParamEditor };