function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { FormattedMessage } from '@kbn/i18n/react';
import { EuiEmptyPrompt, EuiFlexGroup, EuiFlexItem, EuiLoadingChart, EuiPanel, EuiSpacer, EuiText } from '@elastic/eui';
import { DataTableFormat } from './data_table';
export var DataViewComponent = /*#__PURE__*/function (_Component) {
  _inherits(DataViewComponent, _Component);

  var _super = _createSuper(DataViewComponent);

  function DataViewComponent() {
    var _this;

    _classCallCheck(this, DataViewComponent);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "state", {});

    _defineProperty(_assertThisInitialized(_this), "_isMounted", false);

    _defineProperty(_assertThisInitialized(_this), "onUpdateData", function (type) {
      if (type === 'tabular') {
        _this.setState({
          tabularData: null,
          tabularOptions: {},
          tabularPromise: _this.props.adapters.data.getTabular()
        });
      }
    });

    return _this;
  }

  _createClass(DataViewComponent, [{
    key: "finishLoadingData",
    value: function () {
      var _finishLoadingData = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
        var tabularPromise, tabularData;
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                tabularPromise = this.state.tabularPromise;

                if (!tabularPromise) {
                  _context.next = 6;
                  break;
                }

                _context.next = 4;
                return tabularPromise;

              case 4:
                tabularData = _context.sent;

                if (this._isMounted) {
                  this.setState({
                    tabularData: tabularData.data,
                    tabularOptions: tabularData.options,
                    tabularPromise: null
                  });
                }

              case 6:
              case "end":
                return _context.stop();
            }
          }
        }, _callee, this);
      }));

      function finishLoadingData() {
        return _finishLoadingData.apply(this, arguments);
      }

      return finishLoadingData;
    }()
  }, {
    key: "componentDidMount",
    value: function componentDidMount() {
      this._isMounted = true;
      this.props.adapters.data.on('change', this.onUpdateData);
      this.finishLoadingData();
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this._isMounted = false;
      this.props.adapters.data.removeListener('change', this.onUpdateData);
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate() {
      this.finishLoadingData();
    }
  }, {
    key: "render",
    value: function render() {
      if (this.state.tabularPromise) {
        return DataViewComponent.renderLoading();
      } else if (!this.state.tabularData) {
        return DataViewComponent.renderNoData();
      }

      return /*#__PURE__*/React.createElement(DataTableFormat, {
        data: this.state.tabularData,
        isFormatted: this.state.tabularOptions.returnsFormattedValues,
        exportTitle: this.props.title,
        uiSettings: this.props.uiSettings
      });
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps, state) {
      if (state && nextProps.adapters === state.adapters) {
        return null;
      }

      return {
        adapters: nextProps.adapters,
        tabularData: null,
        tabularOptions: {},
        tabularPromise: nextProps.adapters.data.getTabular()
      };
    }
  }, {
    key: "renderNoData",
    value: function renderNoData() {
      return /*#__PURE__*/React.createElement(EuiEmptyPrompt, {
        title: /*#__PURE__*/React.createElement("h2", null, /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "inspector.data.noDataAvailableTitle",
          defaultMessage: "No data available"
        })),
        body: /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
          id: "inspector.data.noDataAvailableDescription",
          defaultMessage: "The element did not provide any data."
        })))
      });
    }
  }, {
    key: "renderLoading",
    value: function renderLoading() {
      return /*#__PURE__*/React.createElement(EuiFlexGroup, {
        justifyContent: "center",
        alignItems: "center",
        style: {
          height: '100%'
        }
      }, /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/React.createElement(EuiPanel, {
        className: "eui-textCenter"
      }, /*#__PURE__*/React.createElement(EuiLoadingChart, {
        size: "m"
      }), /*#__PURE__*/React.createElement(EuiSpacer, {
        size: "s"
      }), /*#__PURE__*/React.createElement(EuiText, null, /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "inspector.data.gatheringDataLabel",
        defaultMessage: "Gathering data"
      }))))));
    }
  }]);

  return DataViewComponent;
}(Component);

_defineProperty(DataViewComponent, "propTypes", {
  uiSettings: PropTypes.object.isRequired,
  adapters: PropTypes.object.isRequired,
  title: PropTypes.string.isRequired
});