function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { PureComponent } from 'react';
import { injectI18n, FormattedMessage } from '@kbn/i18n/react';
import { EuiButton, EuiFlexGroup, EuiFlexItem, EuiFormRow, EuiPanel, EuiSelect } from '@elastic/eui';
import { ControlEditor } from './control_editor';
import { addControl, moveControl, newControl, removeControl, setControl, CONTROL_TYPES } from '../../editor_utils';
import { getLineageMap, getParentCandidates } from '../../lineage';

var ControlsTabUi = /*#__PURE__*/function (_PureComponent) {
  _inherits(ControlsTabUi, _PureComponent);

  var _super = _createSuper(ControlsTabUi);

  function ControlsTabUi() {
    var _this;

    _classCallCheck(this, ControlsTabUi);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "state", {
      type: CONTROL_TYPES.LIST
    });

    _defineProperty(_assertThisInitialized(_this), "getIndexPattern", /*#__PURE__*/function () {
      var _ref = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(indexPatternId) {
        var _yield$_this$props$de, _yield$_this$props$de2, startDeps;

        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _context.next = 2;
                return _this.props.deps.core.getStartServices();

              case 2:
                _yield$_this$props$de = _context.sent;
                _yield$_this$props$de2 = _slicedToArray(_yield$_this$props$de, 2);
                startDeps = _yield$_this$props$de2[1];
                _context.next = 7;
                return startDeps.data.indexPatterns.get(indexPatternId);

              case 7:
                return _context.abrupt("return", _context.sent);

              case 8:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      }));

      return function (_x) {
        return _ref.apply(this, arguments);
      };
    }());

    _defineProperty(_assertThisInitialized(_this), "onChange", function (value) {
      return _this.props.setValue('controls', value);
    });

    _defineProperty(_assertThisInitialized(_this), "handleLabelChange", function (controlIndex, label) {
      var updatedControl = _objectSpread(_objectSpread({}, _this.props.stateParams.controls[controlIndex]), {}, {
        label: label
      });

      _this.onChange(setControl(_this.props.stateParams.controls, controlIndex, updatedControl));
    });

    _defineProperty(_assertThisInitialized(_this), "handleIndexPatternChange", function (controlIndex, indexPattern) {
      var updatedControl = _objectSpread(_objectSpread({}, _this.props.stateParams.controls[controlIndex]), {}, {
        indexPattern: indexPattern,
        fieldName: ''
      });

      _this.onChange(setControl(_this.props.stateParams.controls, controlIndex, updatedControl));
    });

    _defineProperty(_assertThisInitialized(_this), "handleFieldNameChange", function (controlIndex, fieldName) {
      var updatedControl = _objectSpread(_objectSpread({}, _this.props.stateParams.controls[controlIndex]), {}, {
        fieldName: fieldName
      });

      _this.onChange(setControl(_this.props.stateParams.controls, controlIndex, updatedControl));
    });

    _defineProperty(_assertThisInitialized(_this), "handleOptionsChange", function (controlIndex, optionName, value) {
      var control = _this.props.stateParams.controls[controlIndex];

      var updatedControl = _objectSpread(_objectSpread({}, control), {}, {
        options: _objectSpread(_objectSpread({}, control.options), {}, _defineProperty({}, optionName, value))
      });

      _this.onChange(setControl(_this.props.stateParams.controls, controlIndex, updatedControl));
    });

    _defineProperty(_assertThisInitialized(_this), "handleRemoveControl", function (controlIndex) {
      _this.onChange(removeControl(_this.props.stateParams.controls, controlIndex));
    });

    _defineProperty(_assertThisInitialized(_this), "moveControl", function (controlIndex, direction) {
      _this.onChange(moveControl(_this.props.stateParams.controls, controlIndex, direction));
    });

    _defineProperty(_assertThisInitialized(_this), "handleAddControl", function () {
      _this.onChange(addControl(_this.props.stateParams.controls, newControl(_this.state.type)));
    });

    _defineProperty(_assertThisInitialized(_this), "handleParentChange", function (controlIndex, parent) {
      var updatedControl = _objectSpread(_objectSpread({}, _this.props.stateParams.controls[controlIndex]), {}, {
        parent: parent
      });

      _this.onChange(setControl(_this.props.stateParams.controls, controlIndex, updatedControl));
    });

    return _this;
  }

  _createClass(ControlsTabUi, [{
    key: "renderControls",
    value: function renderControls() {
      var _this2 = this;

      var lineageMap = getLineageMap(this.props.stateParams.controls);
      return this.props.stateParams.controls.map(function (controlParams, controlIndex) {
        var parentCandidates = getParentCandidates(_this2.props.stateParams.controls, controlParams.id, lineageMap);
        return /*#__PURE__*/React.createElement(ControlEditor, {
          key: controlParams.id,
          controlIndex: controlIndex,
          controlParams: controlParams,
          handleLabelChange: _this2.handleLabelChange,
          moveControl: _this2.moveControl,
          handleRemoveControl: _this2.handleRemoveControl,
          handleIndexPatternChange: _this2.handleIndexPatternChange,
          handleFieldNameChange: _this2.handleFieldNameChange,
          getIndexPattern: _this2.getIndexPattern,
          handleOptionsChange: _this2.handleOptionsChange,
          parentCandidates: parentCandidates,
          handleParentChange: _this2.handleParentChange,
          deps: _this2.props.deps
        });
      });
    }
  }, {
    key: "render",
    value: function render() {
      var _this3 = this;

      var intl = this.props.intl;
      return /*#__PURE__*/React.createElement("div", null, this.renderControls(), /*#__PURE__*/React.createElement(EuiPanel, {
        grow: false
      }, /*#__PURE__*/React.createElement(EuiFlexGroup, null, /*#__PURE__*/React.createElement(EuiFlexItem, null, /*#__PURE__*/React.createElement(EuiFormRow, {
        id: "selectControlType"
      }, /*#__PURE__*/React.createElement(EuiSelect, {
        "data-test-subj": "selectControlType",
        options: [{
          value: CONTROL_TYPES.RANGE,
          text: intl.formatMessage({
            id: 'inputControl.editor.controlsTab.select.rangeDropDownOptionLabel',
            defaultMessage: 'Range slider'
          })
        }, {
          value: CONTROL_TYPES.LIST,
          text: intl.formatMessage({
            id: 'inputControl.editor.controlsTab.select.listDropDownOptionLabel',
            defaultMessage: 'Options list'
          })
        }],
        value: this.state.type,
        onChange: function onChange(event) {
          return _this3.setState({
            type: event.target.value
          });
        },
        "aria-label": intl.formatMessage({
          id: 'inputControl.editor.controlsTab.select.controlTypeAriaLabel',
          defaultMessage: 'Select control type'
        })
      }))), /*#__PURE__*/React.createElement(EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/React.createElement(EuiFormRow, {
        id: "addControl"
      }, /*#__PURE__*/React.createElement(EuiButton, {
        fill: true,
        onClick: this.handleAddControl,
        iconType: "plusInCircle",
        "data-test-subj": "inputControlEditorAddBtn",
        "aria-label": intl.formatMessage({
          id: 'inputControl.editor.controlsTab.select.addControlAriaLabel',
          defaultMessage: 'Add control'
        })
      }, /*#__PURE__*/React.createElement(FormattedMessage, {
        id: "inputControl.editor.controlsTab.addButtonLabel",
        defaultMessage: "Add"
      })))))));
    }
  }]);

  return ControlsTabUi;
}(PureComponent);

export var ControlsTab = injectI18n(ControlsTabUi);
export var getControlsTab = function getControlsTab(deps) {
  return function (props) {
    return /*#__PURE__*/React.createElement(ControlsTab, _extends({}, props, {
      deps: deps
    }));
  };
};