function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import ReactDOM from 'react-dom';
import { Router, Switch, Route } from 'react-router-dom';
import { i18n } from '@kbn/i18n';
import { I18nProvider } from '@kbn/i18n/react';
import { KibanaContextProvider } from '../../../kibana_react/public';
import { IndexPatternTableWithRouter, EditIndexPatternContainer, CreateEditFieldContainer, CreateIndexPatternWizardWithRouter } from '../components';
var readOnlyBadge = {
  text: i18n.translate('indexPatternManagement.indexPatterns.badge.readOnly.text', {
    defaultMessage: 'Read only'
  }),
  tooltip: i18n.translate('indexPatternManagement.indexPatterns.badge.readOnly.tooltip', {
    defaultMessage: 'Unable to save index patterns'
  }),
  iconType: 'glasses'
};
export function mountManagementSection(_x, _x2) {
  return _mountManagementSection.apply(this, arguments);
}

function _mountManagementSection() {
  _mountManagementSection = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(getStartServices, params) {
    var _yield$getStartServic, _yield$getStartServic2, _yield$getStartServic3, chrome, application, savedObjects, uiSettings, notifications, overlays, http, docLinks, data, indexPatternManagementStart, canSave, deps;

    return regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            _context.next = 2;
            return getStartServices();

          case 2:
            _yield$getStartServic = _context.sent;
            _yield$getStartServic2 = _slicedToArray(_yield$getStartServic, 3);
            _yield$getStartServic3 = _yield$getStartServic2[0];
            chrome = _yield$getStartServic3.chrome;
            application = _yield$getStartServic3.application;
            savedObjects = _yield$getStartServic3.savedObjects;
            uiSettings = _yield$getStartServic3.uiSettings;
            notifications = _yield$getStartServic3.notifications;
            overlays = _yield$getStartServic3.overlays;
            http = _yield$getStartServic3.http;
            docLinks = _yield$getStartServic3.docLinks;
            data = _yield$getStartServic2[1].data;
            indexPatternManagementStart = _yield$getStartServic2[2];
            canSave = Boolean(application.capabilities.indexPatterns.save);

            if (!canSave) {
              chrome.setBadge(readOnlyBadge);
            }

            deps = {
              chrome: chrome,
              application: application,
              savedObjects: savedObjects,
              uiSettings: uiSettings,
              notifications: notifications,
              overlays: overlays,
              http: http,
              docLinks: docLinks,
              data: data,
              indexPatternManagementStart: indexPatternManagementStart,
              setBreadcrumbs: params.setBreadcrumbs
            };
            ReactDOM.render( /*#__PURE__*/React.createElement(KibanaContextProvider, {
              services: deps
            }, /*#__PURE__*/React.createElement(I18nProvider, null, /*#__PURE__*/React.createElement(Router, {
              history: params.history
            }, /*#__PURE__*/React.createElement(Switch, null, /*#__PURE__*/React.createElement(Route, {
              path: ['/create']
            }, /*#__PURE__*/React.createElement(CreateIndexPatternWizardWithRouter, null)), /*#__PURE__*/React.createElement(Route, {
              path: ['/patterns/:id/field/:fieldName', '/patterns/:id/create-field/']
            }, /*#__PURE__*/React.createElement(CreateEditFieldContainer, null)), /*#__PURE__*/React.createElement(Route, {
              path: ['/patterns/:id']
            }, /*#__PURE__*/React.createElement(EditIndexPatternContainer, null)), /*#__PURE__*/React.createElement(Route, {
              path: ['/']
            }, /*#__PURE__*/React.createElement(IndexPatternTableWithRouter, {
              canSave: canSave
            })))))), params.element);
            return _context.abrupt("return", function () {
              ReactDOM.unmountComponentAtNode(params.element);
            });

          case 20:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));
  return _mountManagementSection.apply(this, arguments);
}