/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { withRouter } from 'react-router-dom';
import { EuiFlexGroup, EuiFlexItem, EuiPanel } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import { useKibana } from '../../../../../../plugins/kibana_react/public';
import { IndexHeader } from '../index_header';
import { TAB_SCRIPTED_FIELDS, TAB_INDEXED_FIELDS } from '../constants';
import { FieldEditor } from '../../field_editor';
var newFieldPlaceholder = i18n.translate('indexPatternManagement.editIndexPattern.scripted.newFieldPlaceholder', {
  defaultMessage: 'New Scripted Field'
});
export var CreateEditField = withRouter(function (_ref) {
  var indexPattern = _ref.indexPattern,
      mode = _ref.mode,
      fieldName = _ref.fieldName,
      history = _ref.history;
  var _useKibana$services = useKibana().services,
      data = _useKibana$services.data,
      uiSettings = _useKibana$services.uiSettings,
      chrome = _useKibana$services.chrome,
      notifications = _useKibana$services.notifications;
  var field = mode === 'edit' && fieldName ? indexPattern.fields.getByName(fieldName) : data.indexPatterns.createField(indexPattern, {
    scripted: true,
    type: 'number'
  }, false);
  var url = "/patterns/".concat(indexPattern.id);

  if (mode === 'edit' && !field) {
    var message = i18n.translate('indexPatternManagement.editIndexPattern.scripted.noFieldLabel', {
      defaultMessage: "'{indexPatternTitle}' index pattern doesn't have a scripted field called '{fieldName}'",
      values: {
        indexPatternTitle: indexPattern.title,
        fieldName: fieldName
      }
    });
    notifications.toasts.addWarning(message);
    history.push(url);
  }

  var docFieldName = (field === null || field === void 0 ? void 0 : field.name) || newFieldPlaceholder;
  chrome.docTitle.change([docFieldName, indexPattern.title]);

  var redirectAway = function redirectAway() {
    history.push("".concat(url, "#/?_a=(tab:").concat((field === null || field === void 0 ? void 0 : field.scripted) ? TAB_SCRIPTED_FIELDS : TAB_INDEXED_FIELDS, ")"));
  };

  if (field) {
    return /*#__PURE__*/React.createElement(EuiPanel, {
      paddingSize: 'l'
    }, /*#__PURE__*/React.createElement(EuiFlexGroup, {
      direction: "column"
    }, /*#__PURE__*/React.createElement(EuiFlexItem, null, /*#__PURE__*/React.createElement(IndexHeader, {
      indexPattern: indexPattern,
      defaultIndex: uiSettings.get('defaultIndex')
    })), /*#__PURE__*/React.createElement(EuiFlexItem, null, /*#__PURE__*/React.createElement(FieldEditor, {
      indexPattern: indexPattern,
      field: field,
      services: {
        redirectAway: redirectAway
      }
    }))));
  } else {
    return /*#__PURE__*/React.createElement(React.Fragment, null);
  }
});