function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { render } from 'react-dom';
import angular from 'angular';
import { DocViewerError } from '../components/doc_viewer/doc_viewer_render_error';
/**
 * Compiles and injects the give angular template into the given dom node
 * returns a function to cleanup the injected angular element
 */

export function injectAngularElement(_x, _x2, _x3, _x4, _x5) {
  return _injectAngularElement.apply(this, arguments);
}
/**
 * Converts a given legacy angular directive to a render function
 * for usage in a react component. Note that the rendering is async
 */

function _injectAngularElement() {
  _injectAngularElement = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(domNode, template, scopeProps, Controller, getInjector) {
    var $injector, rootScope, $compile, newScope, $target, $element;
    return regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) {
        switch (_context.prev = _context.next) {
          case 0:
            _context.next = 2;
            return getInjector();

          case 2:
            $injector = _context.sent;
            rootScope = $injector.get('$rootScope');
            $compile = $injector.get('$compile');
            newScope = Object.assign(rootScope.$new(), scopeProps);

            if (typeof Controller === 'function') {
              // when a controller is defined, expose the value it produces to the view as `$ctrl`
              // see: https://docs.angularjs.org/api/ng/provider/$compileProvider#component
              newScope.$ctrl = $injector.instantiate(Controller, {
                $scope: newScope
              });
            }

            $target = angular.element(domNode);
            $element = angular.element(template);
            newScope.$apply(function () {
              var linkFn = $compile($element);
              $target.empty().append($element);
              linkFn(newScope);
            });
            return _context.abrupt("return", function () {
              newScope.$destroy();
            });

          case 11:
          case "end":
            return _context.stop();
        }
      }
    }, _callee);
  }));
  return _injectAngularElement.apply(this, arguments);
}

export function convertDirectiveToRenderFn(directive, getInjector) {
  return function (domNode, props) {
    var rejected = false;
    var cleanupFnPromise = injectAngularElement(domNode, directive.template, props, directive.controller, getInjector);
    cleanupFnPromise.catch(function (e) {
      rejected = true;
      render( /*#__PURE__*/React.createElement(DocViewerError, {
        error: e
      }), domNode);
    });
    return function () {
      if (!rejected) {
        // for cleanup
        // http://roubenmeschian.com/rubo/?p=51
        cleanupFnPromise.then(function (cleanup) {
          return cleanup();
        });
      }
    };
  };
}