function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import uuid from 'uuid/v4';
import rison from 'rison-node';
import { parse, stringify } from 'query-string';
import { KBN_FIELD_TYPES } from '../../../../../../data/public';
import { AGGS_TERMS_SIZE_SETTING } from '../../../../../common';
export function isMapsAppRegistered(visualizations) {
  return visualizations.getAliases().some(function (_ref) {
    var name = _ref.name;
    return name === 'maps';
  });
}
export function isFieldVisualizable(field, visualizations) {
  if (field.name === '_id') {
    // Else you'd get a 'Fielddata access on the _id field is disallowed' error on ES side.
    return false;
  }

  if ((field.type === KBN_FIELD_TYPES.GEO_POINT || field.type === KBN_FIELD_TYPES.GEO_SHAPE) && isMapsAppRegistered(visualizations)) {
    return true;
  }

  return field.visualizable;
}
export function getMapsAppUrl(field, indexPattern, appState, columns) {
  var mapAppParams = new URLSearchParams(); // Copy global state

  var locationSplit = window.location.hash.split('?');

  if (locationSplit.length > 1) {
    var discoverParams = new URLSearchParams(locationSplit[1]);
    var globalStateUrlValue = discoverParams.get('_g');

    if (globalStateUrlValue) {
      mapAppParams.set('_g', globalStateUrlValue);
    }
  } // Copy filters and query in app state


  var mapsAppState = {
    filters: appState.filters || []
  };

  if (appState.query) {
    mapsAppState.query = appState.query;
  } // @ts-ignore


  mapAppParams.set('_a', rison.encode(mapsAppState)); // create initial layer descriptor

  var hasColumns = columns && columns.length && columns[0] !== '_source';
  var supportsClustering = field.aggregatable;
  mapAppParams.set('initialLayers', // @ts-ignore
  rison.encode_array([{
    id: uuid(),
    label: indexPattern.title,
    sourceDescriptor: {
      id: uuid(),
      type: 'ES_SEARCH',
      geoField: field.name,
      tooltipProperties: hasColumns ? columns : [],
      indexPatternId: indexPattern.id,
      scalingType: supportsClustering ? 'CLUSTERS' : 'LIMIT'
    },
    visible: true,
    type: supportsClustering ? 'BLENDED_VECTOR' : 'VECTOR'
  }]));
  return {
    app: 'maps',
    path: "/map#?".concat(mapAppParams.toString())
  };
}
export function getVisualizeUrl(field, indexPattern, state, columns, services) {
  var aggsTermSize = services.uiSettings.get(AGGS_TERMS_SIZE_SETTING);
  var urlParams = parse(services.history().location.search);

  if ((field.type === KBN_FIELD_TYPES.GEO_POINT || field.type === KBN_FIELD_TYPES.GEO_SHAPE) && isMapsAppRegistered(services.visualizations)) {
    return getMapsAppUrl(field, indexPattern, state, columns);
  }

  var agg;
  var isGeoPoint = field.type === KBN_FIELD_TYPES.GEO_POINT;
  var type = isGeoPoint ? 'tile_map' : 'histogram'; // If we're visualizing a date field, and our index is time based (and thus has a time filter),
  // then run a date histogram

  if (field.type === 'date' && indexPattern.timeFieldName === field.name) {
    agg = {
      type: 'date_histogram',
      schema: 'segment',
      params: {
        field: field.name,
        interval: 'auto'
      }
    };
  } else if (isGeoPoint) {
    agg = {
      type: 'geohash_grid',
      schema: 'segment',
      params: {
        field: field.name,
        precision: 3
      }
    };
  } else {
    agg = {
      type: 'terms',
      schema: 'segment',
      params: {
        field: field.name,
        size: parseInt(aggsTermSize, 10),
        orderBy: '1'
      }
    };
  }

  var linkUrlParams = _objectSpread(_objectSpread({}, urlParams), {
    indexPattern: state.index,
    type: type,
    _a: rison.encode({
      filters: state.filters || [],
      query: state.query,
      vis: {
        type: type,
        aggs: [{
          schema: 'metric',
          type: 'count',
          id: '1'
        }, agg]
      }
    })
  });

  return {
    app: 'visualize',
    path: "#/create?".concat(stringify(linkUrlParams))
  };
}