function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { useEffect, useState } from 'react';
import React from 'react';
import { EuiButtonEmpty, EuiText, EuiTourStep } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
var NO_DATA_POPOVER_STORAGE_KEY = 'data.noDataPopover';
export function NoDataPopover(_ref) {
  var showNoDataPopover = _ref.showNoDataPopover,
      storage = _ref.storage,
      children = _ref.children;

  var _useState = useState(function () {
    return Boolean(storage.get(NO_DATA_POPOVER_STORAGE_KEY));
  }),
      _useState2 = _slicedToArray(_useState, 2),
      noDataPopoverDismissed = _useState2[0],
      setNoDataPopoverDismissed = _useState2[1];

  var _useState3 = useState(false),
      _useState4 = _slicedToArray(_useState3, 2),
      noDataPopoverVisible = _useState4[0],
      setNoDataPopoverVisible = _useState4[1];

  useEffect(function () {
    if (showNoDataPopover && !noDataPopoverDismissed) {
      setNoDataPopoverVisible(true);
    }
  }, [noDataPopoverDismissed, showNoDataPopover]);
  return /*#__PURE__*/React.createElement(EuiTourStep, {
    onFinish: function onFinish() {},
    closePopover: function closePopover() {
      setNoDataPopoverVisible(false);
    },
    content: /*#__PURE__*/React.createElement(EuiText, {
      size: "s"
    }, /*#__PURE__*/React.createElement("p", {
      style: {
        maxWidth: 300
      }
    }, i18n.translate('data.noDataPopover.content', {
      defaultMessage: "This time range doesn't contain any data. Increase or adjust the time range to see more fields and create charts."
    }))),
    minWidth: 300,
    anchorPosition: "downCenter",
    step: 1,
    stepsTotal: 1,
    isStepOpen: noDataPopoverVisible,
    subtitle: i18n.translate('data.noDataPopover.subtitle', {
      defaultMessage: 'Tip'
    }),
    title: i18n.translate('data.noDataPopover.title', {
      defaultMessage: 'Empty dataset'
    }),
    footerAction: /*#__PURE__*/React.createElement(EuiButtonEmpty, {
      size: "xs",
      flush: "right",
      color: "text",
      "data-test-subj": "noDataPopoverDismissButton",
      onClick: function onClick() {
        storage.set(NO_DATA_POPOVER_STORAGE_KEY, true);
        setNoDataPopoverDismissed(true);
        setNoDataPopoverVisible(false);
      }
    }, i18n.translate('data.noDataPopover.dismissAction', {
      defaultMessage: "Don't show again"
    }))
  }, /*#__PURE__*/React.createElement("div", {
    onFocus: function onFocus() {
      setNoDataPopoverVisible(false);
    }
  }, children));
}