function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { EuiBadge, useInnerText } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import React from 'react';
import { FilterLabel } from '../filter_editor/lib/filter_label';
import { isFilterPinned } from '../../../../common';
export var FilterView = function FilterView(_ref) {
  var filter = _ref.filter,
      iconOnClick = _ref.iconOnClick,
      onClick = _ref.onClick,
      valueLabel = _ref.valueLabel,
      errorMessage = _ref.errorMessage,
      rest = _objectWithoutProperties(_ref, ["filter", "iconOnClick", "onClick", "valueLabel", "errorMessage"]);

  var _useInnerText = useInnerText(),
      _useInnerText2 = _slicedToArray(_useInnerText, 2),
      ref = _useInnerText2[0],
      innerText = _useInnerText2[1];

  var title = errorMessage || i18n.translate('data.filter.filterBar.moreFilterActionsMessage', {
    defaultMessage: 'Filter: {innerText}. Select for more filter actions.',
    values: {
      innerText: innerText
    }
  });

  if (isFilterPinned(filter)) {
    title = "".concat(i18n.translate('data.filter.filterBar.pinnedFilterPrefix', {
      defaultMessage: 'Pinned'
    }), " ").concat(title);
  }

  if (filter.meta.disabled) {
    title = "".concat(i18n.translate('data.filter.filterBar.disabledFilterPrefix', {
      defaultMessage: 'Disabled'
    }), " ").concat(title);
  }

  return /*#__PURE__*/React.createElement(EuiBadge, _extends({
    title: title,
    color: "hollow",
    iconType: "cross",
    iconSide: "right",
    closeButtonProps: {
      // Removing tab focus on close button because the same option can be optained through the context menu
      // Also, we may want to add a `DEL` keyboard press functionality
      tabIndex: -1
    },
    iconOnClick: iconOnClick,
    iconOnClickAriaLabel: i18n.translate('data.filter.filterBar.filterItemBadgeIconAriaLabel', {
      defaultMessage: 'Delete'
    }),
    onClick: onClick,
    onClickAriaLabel: i18n.translate('data.filter.filterBar.filterItemBadgeAriaLabel', {
      defaultMessage: 'Filter actions'
    })
  }, rest), /*#__PURE__*/React.createElement("span", {
    ref: ref
  }, /*#__PURE__*/React.createElement(FilterLabel, {
    filter: filter,
    valueLabel: valueLabel
  })));
};