function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { i18n } from '@kbn/i18n';
import React from 'react';
import _ from 'lodash';
import { EuiFlyout, EuiFlyoutBody, EuiFlyoutHeader, EuiTitle } from '@elastic/eui';
export var ReplacePanelFlyout = /*#__PURE__*/function (_React$Component) {
  _inherits(ReplacePanelFlyout, _React$Component);

  var _super = _createSuper(ReplacePanelFlyout);

  function ReplacePanelFlyout(props) {
    var _this;

    _classCallCheck(this, ReplacePanelFlyout);

    _this = _super.call(this, props);

    _defineProperty(_assertThisInitialized(_this), "lastToast", {
      id: 'panelReplaceToast'
    });

    _defineProperty(_assertThisInitialized(_this), "showToast", function (name) {
      // To avoid the clutter of having toast messages cover flyout
      // close previous toast message before creating a new one
      if (_this.lastToast) {
        _this.props.notifications.toasts.remove(_this.lastToast);
      }

      _this.lastToast = _this.props.notifications.toasts.addSuccess({
        title: i18n.translate('dashboard.addPanel.savedObjectAddedToContainerSuccessMessageTitle', {
          defaultMessage: '{savedObjectName} was added',
          values: {
            savedObjectName: name
          }
        }),
        'data-test-subj': 'addObjectToContainerSuccess'
      });
    });

    _defineProperty(_assertThisInitialized(_this), "onReplacePanel", /*#__PURE__*/function () {
      var _ref = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee(savedObjectId, type, name) {
        var originalPanels, filteredPanels, nnw, nnh, nnx, nny, newObj, finalPanels;
        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                originalPanels = _this.props.container.getInput().panels;
                filteredPanels = _objectSpread({}, originalPanels);
                nnw = filteredPanels[_this.props.panelToRemove.id].gridData.w;
                nnh = filteredPanels[_this.props.panelToRemove.id].gridData.h;
                nnx = filteredPanels[_this.props.panelToRemove.id].gridData.x;
                nny = filteredPanels[_this.props.panelToRemove.id].gridData.y; // add the new view

                _context.next = 8;
                return _this.props.container.addNewEmbeddable(type, {
                  savedObjectId: savedObjectId
                });

              case 8:
                newObj = _context.sent;
                finalPanels = _.cloneDeep(_this.props.container.getInput().panels);
                finalPanels[newObj.id].gridData.w = nnw;
                finalPanels[newObj.id].gridData.h = nnh;
                finalPanels[newObj.id].gridData.x = nnx;
                finalPanels[newObj.id].gridData.y = nny; // delete the old view

                delete finalPanels[_this.props.panelToRemove.id]; // apply changes

                _this.props.container.updateInput({
                  panels: finalPanels
                });

                _this.props.container.reload();

                _this.showToast(name);

                _this.props.onClose();

              case 19:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      }));

      return function (_x, _x2, _x3) {
        return _ref.apply(this, arguments);
      };
    }());

    return _this;
  }

  _createClass(ReplacePanelFlyout, [{
    key: "render",
    value: function render() {
      var SavedObjectFinder = this.props.savedObjectsFinder;
      var savedObjectsFinder = /*#__PURE__*/React.createElement(SavedObjectFinder, {
        noItemsMessage: i18n.translate('dashboard.addPanel.noMatchingObjectsMessage', {
          defaultMessage: 'No matching objects found.'
        }),
        savedObjectMetaData: _toConsumableArray(this.props.getEmbeddableFactories()).filter(function (embeddableFactory) {
          return Boolean(embeddableFactory.savedObjectMetaData) && !embeddableFactory.isContainerType;
        }).map(function (_ref2) {
          var savedObjectMetaData = _ref2.savedObjectMetaData;
          return savedObjectMetaData;
        }),
        showFilter: true,
        onChoose: this.onReplacePanel
      });
      var panelToReplace = 'Replace panel ' + this.props.panelToRemove.getTitle() + ' with:';
      return /*#__PURE__*/React.createElement(EuiFlyout, {
        ownFocus: true,
        onClose: this.props.onClose,
        "data-test-subj": "dashboardReplacePanel"
      }, /*#__PURE__*/React.createElement(EuiFlyoutHeader, {
        hasBorder: true
      }, /*#__PURE__*/React.createElement(EuiTitle, {
        size: "m"
      }, /*#__PURE__*/React.createElement("h2", null, /*#__PURE__*/React.createElement("span", null, panelToReplace)))), /*#__PURE__*/React.createElement(EuiFlyoutBody, null, savedObjectsFinder));
    }
  }]);

  return ReplacePanelFlyout;
}(React.Component);