function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { transform, keys as _keys, startsWith } from 'lodash';
export var StorageKeys;

(function (StorageKeys) {
  StorageKeys["WIDTH"] = "widths";
})(StorageKeys || (StorageKeys = {}));

export var Storage = /*#__PURE__*/function () {
  function Storage(engine, prefix) {
    _classCallCheck(this, Storage);

    this.engine = engine;
    this.prefix = prefix;
  }

  _createClass(Storage, [{
    key: "encode",
    value: function encode(val) {
      return JSON.stringify(val);
    }
  }, {
    key: "decode",
    value: function decode(val) {
      if (typeof val === 'string') {
        return JSON.parse(val);
      }
    }
  }, {
    key: "encodeKey",
    value: function encodeKey(key) {
      return "".concat(this.prefix).concat(key);
    }
  }, {
    key: "decodeKey",
    value: function decodeKey(key) {
      if (startsWith(key, this.prefix)) {
        return "".concat(key.slice(this.prefix.length));
      }
    }
  }, {
    key: "set",
    value: function set(key, val) {
      this.engine.setItem(this.encodeKey(key), this.encode(val));
      return val;
    }
  }, {
    key: "has",
    value: function has(key) {
      return this.engine.getItem(this.encodeKey(key)) != null;
    }
  }, {
    key: "get",
    value: function get(key, _default) {
      if (this.has(key)) {
        return this.decode(this.engine.getItem(this.encodeKey(key)));
      } else {
        return _default;
      }
    }
  }, {
    key: "delete",
    value: function _delete(key) {
      return this.engine.removeItem(this.encodeKey(key));
    }
  }, {
    key: "keys",
    value: function keys() {
      var _this = this;

      return transform(_keys(this.engine), function (ours, key) {
        var ourKey = _this.decodeKey(key);

        if (ourKey != null) ours.push(ourKey);
      });
    }
  }]);

  return Storage;
}();
export function createStorage(deps) {
  return new Storage(deps.engine, deps.prefix);
}