/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useCallback } from 'react';
import { last } from 'lodash';
import { i18n } from '@kbn/i18n';
import { RangesParamEditor } from '../../../../vis_default_editor/public';

function ColorRanges(_ref) {
  var dataTestSubj = _ref['data-test-subj'],
      colorsRange = _ref.colorsRange,
      setValue = _ref.setValue,
      setValidity = _ref.setValidity,
      setTouched = _ref.setTouched;
  var addRangeValues = useCallback(function () {
    var previousRange = last(colorsRange) || {};
    var from = previousRange.to ? previousRange.to : 0;
    var to = previousRange.to ? from + (previousRange.to - (previousRange.from || 0)) : 100;
    return {
      from: from,
      to: to
    };
  }, [colorsRange]);
  var validateRange = useCallback(function (_ref2, index) {
    var from = _ref2.from,
        to = _ref2.to;

    if (!colorsRange[index]) {
      return [false, false];
    }

    var leftBound = index === 0 ? -Infinity : colorsRange[index - 1].to || 0;
    var isFromValid = from >= leftBound;
    var isToValid = to >= from;
    return [isFromValid, isToValid];
  }, [colorsRange]);
  var setColorRanges = useCallback(function (value) {
    return setValue('colorsRange', value);
  }, [setValue]);
  return /*#__PURE__*/React.createElement(RangesParamEditor, {
    "data-test-subj": dataTestSubj,
    error: i18n.translate('charts.controls.colorRanges.errorText', {
      defaultMessage: 'Each range should be greater than previous.'
    }),
    hidePlaceholders: true,
    value: colorsRange,
    setValue: setColorRanges,
    setValidity: setValidity,
    setTouched: setTouched,
    addRangeValues: addRangeValues,
    validateRange: validateRange
  });
}

export { ColorRanges };