function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { BehaviorSubject } from 'rxjs';
import { map } from 'rxjs/operators';
import { PriorityMap } from './priority_map';
import { BannersList } from './banners_list';
import { UserBannerService } from './user_banner_service';
/** @public */

/** @internal */
export var OverlayBannersService = /*#__PURE__*/function () {
  function OverlayBannersService() {
    _classCallCheck(this, OverlayBannersService);

    _defineProperty(this, "userBanner", new UserBannerService());
  }

  _createClass(OverlayBannersService, [{
    key: "start",
    value: function start(_ref) {
      var i18n = _ref.i18n,
          uiSettings = _ref.uiSettings;
      var uniqueId = 0;

      var genId = function genId() {
        return "".concat(uniqueId++);
      };

      var banners$ = new BehaviorSubject(new PriorityMap());
      var service = {
        add: function add(mount) {
          var priority = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
          var id = genId();
          var nextBanner = {
            id: id,
            mount: mount,
            priority: priority
          };
          banners$.next(banners$.value.add(id, nextBanner));
          return id;
        },
        remove: function remove(id) {
          if (!banners$.value.has(id)) {
            return false;
          }

          banners$.next(banners$.value.remove(id));
          return true;
        },
        replace: function replace(id, mount) {
          var priority = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;

          if (!id || !banners$.value.has(id)) {
            return this.add(mount, priority);
          }

          var nextId = genId();
          var nextBanner = {
            id: nextId,
            mount: mount,
            priority: priority
          };
          banners$.next(banners$.value.remove(id).add(nextId, nextBanner));
          return nextId;
        },
        get$: function get$() {
          return banners$.pipe(map(function (bannerMap) {
            return _toConsumableArray(bannerMap.values());
          }));
        },
        getComponent: function getComponent() {
          return /*#__PURE__*/React.createElement(BannersList, {
            banners$: this.get$()
          });
        }
      };
      this.userBanner.start({
        banners: service,
        i18n: i18n,
        uiSettings: uiSettings
      });
      return service;
    }
  }, {
    key: "stop",
    value: function stop() {
      this.userBanner.stop();
    }
  }]);

  return OverlayBannersService;
}();